/*
 * Decompiled with CFR 0.152.
 */
package sharry.backend.auth;

import cats.data.Kleisli;
import cats.data.Kleisli$;
import cats.effect.kernel.Async;
import cats.implicits$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.ApplyOps$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.Tuple2$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sharry.backend.PasswordCrypt$;
import sharry.backend.account.OAccount;
import sharry.backend.auth.AuthConfig;
import sharry.backend.auth.AuthToken;
import sharry.backend.auth.AuthToken$;
import sharry.backend.auth.InternalAuth$;
import sharry.backend.auth.LoginModule$;
import sharry.backend.auth.LoginResult;
import sharry.backend.auth.LoginResult$;
import sharry.backend.auth.UserPassData;
import sharry.common.AccountId;
import sharry.common.AccountSource$;
import sharry.common.AccountState;
import sharry.common.Ident;
import sharry.common.Ident$;
import sharry.logging.Logger;
import sharry.logging.package$;
import sharry.store.records.RAccount;
import sourcecode.Enclosing$;
import sourcecode.FileName$;
import sourcecode.Line$;
import sourcecode.Name$;
import sourcecode.Pkg$;

public final class InternalAuth<F> {
    private final AuthConfig cfg;
    private final OAccount<F> op;
    private final Async<F> evidence$1;
    private final Logger<F> logger;

    public static <F> InternalAuth<F> apply(AuthConfig authConfig, OAccount<F> oAccount, Async<F> async) {
        return InternalAuth$.MODULE$.apply(authConfig, oAccount, async);
    }

    public InternalAuth(AuthConfig cfg, OAccount<F> op, Async<F> evidence$1) {
        this.cfg = cfg;
        this.op = op;
        this.evidence$1 = evidence$1;
        this.logger = package$.MODULE$.getLogger(evidence$1, Enclosing$.MODULE$.apply("sharry.backend.auth.InternalAuth#logger"));
    }

    public Kleisli<F, UserPassData, Option<LoginResult>> login() {
        return LoginModule$.MODULE$.enabledState(this.cfg.internal().enabled(), this.op, AccountSource$.MODULE$.intern(), Kleisli$.MODULE$.apply((Function1 & Serializable)up -> {
            Either either = Ident$.MODULE$.fromString(up.user());
            if (either instanceof Right) {
                Ident login = (Ident)((Right)either).value();
                return implicits$.MODULE$.toFlatMapOps(this.logger.trace(() -> InternalAuth.login$$anonfun$1$$anonfun$1(login), Pkg$.MODULE$.apply("sharry.backend.auth"), FileName$.MODULE$.apply("InternalAuth.scala"), Name$.MODULE$.apply("login"), Line$.MODULE$.apply(26)), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return implicits$.MODULE$.toFlatMapOps(this.op.findByLogin(login), this.evidence$1).flatMap((Function1 & Serializable)data2 -> implicits$.MODULE$.toFlatMapOps(this.logger.trace(() -> InternalAuth.login$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(data2), Pkg$.MODULE$.apply("sharry.backend.auth"), FileName$.MODULE$.apply("InternalAuth.scala"), Name$.MODULE$.apply("login"), Line$.MODULE$.apply(28)), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return implicits$.MODULE$.toFunctorOps(data2.filter((Function1 & Serializable)data2 -> this.check(up.pass(), (RAccount)data2)).map((Function1 & Serializable)record -> this.okResult$1(record.accountId((Option)None$.MODULE$))).getOrElse(this::login$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$3), this.evidence$1).map((Function1 & Serializable)res -> res);
                    }));
                });
            }
            if (either instanceof Left) {
                Object object = implicits$.MODULE$.catsSyntaxApplyOps(this.logger.debug(InternalAuth::login$$anonfun$1$$anonfun$3, Pkg$.MODULE$.apply("sharry.backend.auth"), FileName$.MODULE$.apply("InternalAuth.scala"), Name$.MODULE$.apply("login"), Line$.MODULE$.apply(36)));
                LoginResult loginResult = (LoginResult)implicits$.MODULE$.catsSyntaxApplicativeId((Object)LoginResult$.MODULE$.invalidAuth());
                return ApplyOps$.MODULE$.$times$greater$extension(object, ApplicativeIdOps$.MODULE$.pure$extension((Object)loginResult, this.evidence$1), this.evidence$1);
            }
            throw new MatchError((Object)either);
        }), this.evidence$1);
    }

    public Tuple2<Object, Kleisli<F, UserPassData, Option<LoginResult>>> withPosition() {
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.cfg.internal().order()), this.login());
    }

    private boolean check(String givenPw, RAccount data2) {
        AccountState accountState = data2.state();
        AccountState.Active$ active$ = AccountState.Active$.MODULE$;
        boolean userOk = !(accountState != null ? !accountState.equals(active$) : active$ != null);
        boolean passOk = PasswordCrypt$.MODULE$.check(givenPw, data2.password());
        return userOk && passOk;
    }

    private final Object okResult$1(AccountId accId) {
        Object object = implicits$.MODULE$.catsSyntaxApplyOps(this.op.updateLoginStats(accId));
        return ApplyOps$.MODULE$.$times$greater$extension(object, implicits$.MODULE$.toFunctorOps(AuthToken$.MODULE$.user(accId, this.cfg.serverSecret(), this.evidence$1), this.evidence$1).map((Function1 & Serializable)session -> LoginResult$.MODULE$.ok((AuthToken)session)), this.evidence$1);
    }

    private static final String login$$anonfun$1$$anonfun$1(Ident login$1) {
        return new StringBuilder(37).append("Internal auth: doing account lookup: ").append(login$1.id()).toString();
    }

    private static final String login$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(Option data$1) {
        return new StringBuilder(31).append("Internal auth: Account lookup: ").append(data$1).toString();
    }

    private final Object login$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$3() {
        LoginResult loginResult = (LoginResult)implicits$.MODULE$.catsSyntaxApplicativeId((Object)LoginResult$.MODULE$.invalidAuth());
        return ApplicativeIdOps$.MODULE$.pure$extension((Object)loginResult, this.evidence$1);
    }

    private static final String login$$anonfun$1$$anonfun$3() {
        return "Internal auth: failed.";
    }
}

