/*
 * Decompiled with CFR 0.152.
 */
package sharry.backend.auth;

import cats.data.Kleisli;
import cats.data.Kleisli$;
import cats.effect.kernel.Async;
import cats.effect.kernel.Sync;
import cats.implicits$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.ApplyOps$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.Tuple2$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sharry.backend.auth.AddAccount;
import sharry.backend.auth.AddAccount$;
import sharry.backend.auth.AuthConfig;
import sharry.backend.auth.AuthToken;
import sharry.backend.auth.AuthToken$;
import sharry.backend.auth.HttpBasicAuth$;
import sharry.backend.auth.HttpBasicAuth$RunRequest$;
import sharry.backend.auth.LoginModule$;
import sharry.backend.auth.LoginResult;
import sharry.backend.auth.LoginResult$;
import sharry.backend.auth.UserPassData;
import sharry.common.AccountId;
import sharry.common.Ident;
import sharry.common.Ident$;
import sharry.logging.Logger;
import sharry.logging.package$;
import sourcecode.Enclosing$;
import sourcecode.FileName$;
import sourcecode.Line$;
import sourcecode.Name$;
import sourcecode.Pkg$;

public final class HttpBasicAuth<F> {
    private final AuthConfig cfg;
    private final AddAccount.AccountOps<F> ops;
    private final RunRequest<F> runner;
    private final Async<F> evidence$1;
    private final Logger<F> logger;

    public static <F> HttpBasicAuth<F> apply(AuthConfig authConfig, AddAccount.AccountOps<F> accountOps, RunRequest<F> runRequest, Async<F> async) {
        return HttpBasicAuth$.MODULE$.apply(authConfig, accountOps, runRequest, async);
    }

    public HttpBasicAuth(AuthConfig cfg, AddAccount.AccountOps<F> ops, RunRequest<F> runner, Async<F> evidence$1) {
        this.cfg = cfg;
        this.ops = ops;
        this.runner = runner;
        this.evidence$1 = evidence$1;
        this.logger = package$.MODULE$.getLogger(evidence$1, Enclosing$.MODULE$.apply("sharry.backend.auth.HttpBasicAuth#logger"));
    }

    public Kleisli<F, UserPassData, Option<LoginResult>> login() {
        return LoginModule$.MODULE$.whenEnabled(this.cfg.httpBasic().enabled(), Kleisli$.MODULE$.apply((Function1 & Serializable)up -> {
            Either either = Ident$.MODULE$.fromString(up.user());
            if (either instanceof Right) {
                Ident login = (Ident)((Right)either).value();
                return implicits$.MODULE$.toFlatMapOps(this.logger.debug(() -> HttpBasicAuth.login$$anonfun$1$$anonfun$1(up), Pkg$.MODULE$.apply("sharry.backend.auth"), FileName$.MODULE$.apply("HttpBasicAuth.scala"), Name$.MODULE$.apply("login"), Line$.MODULE$.apply(32)), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return implicits$.MODULE$.toFlatMapOps(this.executeReq((UserPassData)up, this.cfg.httpBasic()), this.evidence$1).flatMap((Function1 & Serializable)res -> this.login$$anonfun$1$$anonfun$2$$anonfun$1((UserPassData)up, login, BoxesRunTime.unboxToBoolean((Object)res)));
                });
            }
            if (either instanceof Left) {
                Object object = implicits$.MODULE$.catsSyntaxApplyOps(this.logger.debug(HttpBasicAuth::login$$anonfun$1$$anonfun$3, Pkg$.MODULE$.apply("sharry.backend.auth"), FileName$.MODULE$.apply("HttpBasicAuth.scala"), Name$.MODULE$.apply("login"), Line$.MODULE$.apply(39)));
                LoginResult loginResult = (LoginResult)implicits$.MODULE$.catsSyntaxApplicativeId((Object)LoginResult$.MODULE$.invalidAuth());
                return ApplyOps$.MODULE$.$times$greater$extension(object, ApplicativeIdOps$.MODULE$.pure$extension((Object)loginResult, this.evidence$1), this.evidence$1);
            }
            throw new MatchError((Object)either);
        }), this.evidence$1);
    }

    private F executeReq(UserPassData up, AuthConfig.HttpBasic cfg) {
        return this.runner.exec(up, cfg);
    }

    public Tuple2<Object, Kleisli<F, UserPassData, Option<LoginResult>>> withPosition() {
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.cfg.httpBasic().order()), this.login());
    }

    private final Object okResult$1(Ident login$1) {
        return implicits$.MODULE$.toFlatMapOps(AddAccount$.MODULE$.apply(login$1, false, this.ops, this.evidence$1), this.evidence$1).flatMap((Function1 & Serializable)accId -> implicits$.MODULE$.toFunctorOps(AuthToken$.MODULE$.user((AccountId)accId, this.cfg.serverSecret(), this.evidence$1), this.evidence$1).map((Function1 & Serializable)session -> LoginResult$.MODULE$.ok((AuthToken)session)));
    }

    private static final String login$$anonfun$1$$anonfun$1(UserPassData up$1) {
        return new StringBuilder(30).append("HttpBasicAuth: starting login ").append(up$1).toString();
    }

    private static final String login$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(UserPassData up$5, LoginResult resp$1) {
        return new StringBuilder(19).append("HttpBasicAuth: ").append(up$5).append(" => ").append(resp$1).toString();
    }

    private final /* synthetic */ Object login$$anonfun$1$$anonfun$2$$anonfun$1(UserPassData up$3, Ident login$3, boolean res) {
        Object object;
        if (res) {
            object = this.okResult$1(login$3);
        } else {
            LoginResult loginResult = (LoginResult)implicits$.MODULE$.catsSyntaxApplicativeId((Object)LoginResult$.MODULE$.invalidAuth());
            object = ApplicativeIdOps$.MODULE$.pure$extension((Object)loginResult, this.evidence$1);
        }
        return implicits$.MODULE$.toFlatMapOps(object, this.evidence$1).flatMap((Function1 & Serializable)resp -> implicits$.MODULE$.toFunctorOps(this.logger.debug(() -> HttpBasicAuth.login$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(up$3, resp), Pkg$.MODULE$.apply("sharry.backend.auth"), FileName$.MODULE$.apply("HttpBasicAuth.scala"), Name$.MODULE$.apply("login"), Line$.MODULE$.apply(35)), this.evidence$1).map((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return resp;
        }));
    }

    private static final String login$$anonfun$1$$anonfun$3() {
        return "HttpBasicAuth: failed.";
    }

    public static interface RunRequest<F> {
        public static <F> RunRequest<F> apply(Function2<UserPassData, AuthConfig.HttpBasic, Object> function2) {
            return HttpBasicAuth$RunRequest$.MODULE$.apply(function2);
        }

        public static <F> RunRequest<F> javaConn(Sync<F> sync) {
            return HttpBasicAuth$RunRequest$.MODULE$.javaConn(sync);
        }

        public F exec(UserPassData var1, AuthConfig.HttpBasic var2);
    }
}

