/*
 * Decompiled with CFR 0.152.
 */
package sharry.backend.auth;

import cats.effect.kernel.Sync;
import java.io.Serializable;
import java.time.Instant;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scodec.bits.ByteVector;
import sharry.backend.auth.AuthToken$;
import sharry.common.AccountId;
import sharry.common.Duration$;

public class AuthToken
implements Product,
Serializable {
    private final long millis;
    private final AccountId account;
    private final String salt;
    private final String sig;

    public static AuthToken apply(long l, AccountId accountId, String string, String string2) {
        return AuthToken$.MODULE$.apply(l, accountId, string, string2);
    }

    public static AuthToken fromProduct(Product product) {
        return AuthToken$.MODULE$.fromProduct(product);
    }

    public static Either<String, AuthToken> fromString(String string) {
        return AuthToken$.MODULE$.fromString(string);
    }

    public static AuthToken unapply(AuthToken authToken) {
        return AuthToken$.MODULE$.unapply(authToken);
    }

    public static <F> Object user(AccountId accountId, ByteVector byteVector, Sync<F> sync) {
        return AuthToken$.MODULE$.user(accountId, byteVector, sync);
    }

    public AuthToken(long millis, AccountId account, String salt, String sig) {
        this.millis = millis;
        this.account = account;
        this.salt = salt;
        this.sig = sig;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.longHash((long)this.millis()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.account()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.salt()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.sig()));
        return Statics.finalizeHash((int)n, (int)4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof AuthToken)) return false;
        AuthToken authToken = (AuthToken)object;
        if (this.millis() != authToken.millis()) return false;
        AccountId accountId = this.account();
        AccountId accountId2 = authToken.account();
        if (accountId == null) {
            if (accountId2 != null) {
                return false;
            }
        } else if (!accountId.equals(accountId2)) return false;
        String string = this.salt();
        String string2 = authToken.salt();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.sig();
        String string4 = authToken.sig();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        if (!authToken.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof AuthToken;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "AuthToken";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return BoxesRunTime.boxToLong((long)this._1());
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "millis";
            }
            case 1: {
                return "account";
            }
            case 2: {
                return "salt";
            }
            case 3: {
                return "sig";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public long millis() {
        return this.millis;
    }

    public AccountId account() {
        return this.account;
    }

    public String salt() {
        return this.salt;
    }

    public String sig() {
        return this.sig;
    }

    public String asString() {
        return new StringBuilder(3).append(this.millis()).append("-").append(AuthToken$.MODULE$.sharry$backend$auth$AuthToken$$$b64enc(this.account().asString())).append("-").append(this.salt()).append("-").append(this.sig()).toString();
    }

    public boolean sigValid(ByteVector key) {
        String newSig = AuthToken$.MODULE$.sharry$backend$auth$AuthToken$$$sign(this, key);
        return AuthToken$.MODULE$.sharry$backend$auth$AuthToken$$$constTimeEq(this.sig(), newSig);
    }

    public boolean sigInvalid(ByteVector key) {
        return !this.sigValid(key);
    }

    public boolean notExpired(long validity) {
        return !this.isExpired(validity);
    }

    public boolean isExpired(long validity) {
        Instant ends = Instant.ofEpochMilli(this.millis()).plusMillis(Duration$.MODULE$.millis$extension(validity));
        return Instant.now().isAfter(ends);
    }

    public boolean validate(ByteVector key, long validity) {
        return this.sigValid(key) && this.notExpired(validity);
    }

    public AuthToken copy(long millis, AccountId account, String salt, String sig) {
        return new AuthToken(millis, account, salt, sig);
    }

    public long copy$default$1() {
        return this.millis();
    }

    public AccountId copy$default$2() {
        return this.account();
    }

    public String copy$default$3() {
        return this.salt();
    }

    public String copy$default$4() {
        return this.sig();
    }

    public long _1() {
        return this.millis();
    }

    public AccountId _2() {
        return this.account();
    }

    public String _3() {
        return this.salt();
    }

    public String _4() {
        return this.sig();
    }
}

