/*
 * Decompiled with CFR 0.152.
 */
package binny.fs;

import binny.BinaryId$;
import binny.ContentTypeDetect;
import binny.fs.DirectoryMapping;
import binny.fs.FsChunkedBinaryStore$;
import binny.fs.FsChunkedStoreConfig$;
import binny.fs.FsStoreConfig;
import binny.fs.FsStoreConfig$;
import binny.fs.OverwriteMode;
import fs2.io.file.Path;
import java.io.Serializable;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class FsChunkedStoreConfig
implements Product,
Serializable {
    private final Path baseDir;
    private final ContentTypeDetect detect;
    private final OverwriteMode overwriteMode;
    private final DirectoryMapping mapping;
    private final int chunkSize;
    private final int readChunkSize;

    public static FsChunkedStoreConfig apply(Path path, ContentTypeDetect contentTypeDetect, OverwriteMode overwriteMode, DirectoryMapping directoryMapping, int n, int n2) {
        return FsChunkedStoreConfig$.MODULE$.apply(path, contentTypeDetect, overwriteMode, directoryMapping, n, n2);
    }

    public static FsChunkedStoreConfig defaults(Path path) {
        return FsChunkedStoreConfig$.MODULE$.defaults(path);
    }

    public static FsChunkedStoreConfig fromProduct(Product product) {
        return FsChunkedStoreConfig$.MODULE$.fromProduct(product);
    }

    public static FsChunkedStoreConfig unapply(FsChunkedStoreConfig fsChunkedStoreConfig) {
        return FsChunkedStoreConfig$.MODULE$.unapply(fsChunkedStoreConfig);
    }

    public FsChunkedStoreConfig(Path baseDir, ContentTypeDetect detect, OverwriteMode overwriteMode, DirectoryMapping mapping, int chunkSize, int readChunkSize) {
        this.baseDir = baseDir;
        this.detect = detect;
        this.overwriteMode = overwriteMode;
        this.mapping = mapping;
        this.chunkSize = chunkSize;
        this.readChunkSize = readChunkSize;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.baseDir()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.detect()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.overwriteMode()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.mapping()));
        n = Statics.mix((int)n, (int)this.chunkSize());
        n = Statics.mix((int)n, (int)this.readChunkSize());
        return Statics.finalizeHash((int)n, (int)6);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof FsChunkedStoreConfig)) return false;
        FsChunkedStoreConfig fsChunkedStoreConfig = (FsChunkedStoreConfig)object;
        if (this.chunkSize() != fsChunkedStoreConfig.chunkSize()) return false;
        if (this.readChunkSize() != fsChunkedStoreConfig.readChunkSize()) return false;
        Path path = this.baseDir();
        Path path2 = fsChunkedStoreConfig.baseDir();
        if (path == null) {
            if (path2 != null) {
                return false;
            }
        } else if (!path.equals(path2)) return false;
        ContentTypeDetect contentTypeDetect = this.detect();
        ContentTypeDetect contentTypeDetect2 = fsChunkedStoreConfig.detect();
        if (contentTypeDetect == null) {
            if (contentTypeDetect2 != null) {
                return false;
            }
        } else if (!contentTypeDetect.equals(contentTypeDetect2)) return false;
        OverwriteMode overwriteMode = this.overwriteMode();
        OverwriteMode overwriteMode2 = fsChunkedStoreConfig.overwriteMode();
        if (overwriteMode == null) {
            if (overwriteMode2 != null) {
                return false;
            }
        } else if (!overwriteMode.equals(overwriteMode2)) return false;
        DirectoryMapping directoryMapping = this.mapping();
        DirectoryMapping directoryMapping2 = fsChunkedStoreConfig.mapping();
        if (directoryMapping == null) {
            if (directoryMapping2 != null) {
                return false;
            }
        } else if (!directoryMapping.equals(directoryMapping2)) return false;
        if (!fsChunkedStoreConfig.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof FsChunkedStoreConfig;
    }

    public int productArity() {
        return 6;
    }

    public String productPrefix() {
        return "FsChunkedStoreConfig";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return BoxesRunTime.boxToInteger((int)this._5());
            }
            case 5: {
                return BoxesRunTime.boxToInteger((int)this._6());
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "baseDir";
            }
            case 1: {
                return "detect";
            }
            case 2: {
                return "overwriteMode";
            }
            case 3: {
                return "mapping";
            }
            case 4: {
                return "chunkSize";
            }
            case 5: {
                return "readChunkSize";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Path baseDir() {
        return this.baseDir;
    }

    public ContentTypeDetect detect() {
        return this.detect;
    }

    public OverwriteMode overwriteMode() {
        return this.overwriteMode;
    }

    public DirectoryMapping mapping() {
        return this.mapping;
    }

    public int chunkSize() {
        return this.chunkSize;
    }

    public int readChunkSize() {
        return this.readChunkSize;
    }

    public FsChunkedStoreConfig withContentTypeDetect(ContentTypeDetect dt) {
        return this.copy(this.copy$default$1(), dt, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
    }

    public Path targetDir(String id) {
        return this.mapping().targetDir(this.baseDir(), id);
    }

    public int targetDirDepth() {
        return this.targetDir(BinaryId$.MODULE$.apply("dummy")).relativize(this.baseDir()).names().size();
    }

    public FsChunkedStoreConfig withMapping(DirectoryMapping dm) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), dm, this.copy$default$5(), this.copy$default$6());
    }

    public FsStoreConfig toStoreConfig() {
        return FsStoreConfig$.MODULE$.apply(this.baseDir(), this.detect(), this.overwriteMode(), this.mapping().toPathMapping(FsChunkedBinaryStore$.MODULE$.fileName(0)), this.chunkSize());
    }

    public FsChunkedStoreConfig copy(Path baseDir, ContentTypeDetect detect, OverwriteMode overwriteMode, DirectoryMapping mapping, int chunkSize, int readChunkSize) {
        return new FsChunkedStoreConfig(baseDir, detect, overwriteMode, mapping, chunkSize, readChunkSize);
    }

    public Path copy$default$1() {
        return this.baseDir();
    }

    public ContentTypeDetect copy$default$2() {
        return this.detect();
    }

    public OverwriteMode copy$default$3() {
        return this.overwriteMode();
    }

    public DirectoryMapping copy$default$4() {
        return this.mapping();
    }

    public int copy$default$5() {
        return this.chunkSize();
    }

    public int copy$default$6() {
        return this.readChunkSize();
    }

    public Path _1() {
        return this.baseDir();
    }

    public ContentTypeDetect _2() {
        return this.detect();
    }

    public OverwriteMode _3() {
        return this.overwriteMode();
    }

    public DirectoryMapping _4() {
        return this.mapping();
    }

    public int _5() {
        return this.chunkSize();
    }

    public int _6() {
        return this.readChunkSize();
    }
}

