/*
 * Decompiled with CFR 0.152.
 */
package binny.fs;

import binny.BinaryAttributes;
import binny.ByteRange;
import binny.ChunkDef;
import binny.ChunkedBinaryStore;
import binny.Hint;
import binny.fs.EmptyDirectoryRemove;
import binny.fs.EmptyDirectoryRemove$;
import binny.fs.FsChunkedBinaryStore;
import binny.fs.FsChunkedBinaryStoreWithCleanup$;
import binny.fs.FsChunkedStoreConfig;
import binny.fs.InsertDeleteSync;
import binny.util.Logger;
import cats.data.Kleisli;
import cats.data.OptionT;
import cats.effect.kernel.Async;
import cats.syntax.ApplyOps$;
import cats.syntax.package;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Stream;
import fs2.Stream$;
import fs2.io.file.Files;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.runtime.Nothing$;
import scodec.bits.ByteVector;

public final class FsChunkedBinaryStoreWithCleanup<F>
implements ChunkedBinaryStore<F> {
    private final FsChunkedBinaryStore underlying;
    private final InsertDeleteSync sync;
    private final Async<F> evidence$1;
    private final EmptyDirectoryRemove<F> directoryRemove;

    public static <F> Object apply(FsChunkedBinaryStore<F> fsChunkedBinaryStore, Async<F> async, Files<F> files, Logger<F> logger) {
        return FsChunkedBinaryStoreWithCleanup$.MODULE$.apply(fsChunkedBinaryStore, async, files, logger);
    }

    public static <F> Object apply(FsChunkedStoreConfig fsChunkedStoreConfig, Async<F> async, Files<F> files, Logger<F> logger) {
        return FsChunkedBinaryStoreWithCleanup$.MODULE$.apply(fsChunkedStoreConfig, async, files, logger);
    }

    public FsChunkedBinaryStoreWithCleanup(FsChunkedBinaryStore<F> underlying, InsertDeleteSync<F> sync, Async<F> evidence$1, Files<F> evidence$2, Logger<F> evidence$3) {
        this.underlying = underlying;
        this.sync = sync;
        this.evidence$1 = evidence$1;
        this.directoryRemove = EmptyDirectoryRemove$.MODULE$.apply(underlying.config(), evidence$2, evidence$1, evidence$3);
    }

    public FsChunkedBinaryStore<F> underlying() {
        return this.underlying;
    }

    public InsertDeleteSync<F> sync() {
        return this.sync;
    }

    public Stream<F, String> listIds(Option<String> prefix, int chunkSize) {
        return this.underlying().listIds(prefix, chunkSize);
    }

    public Function1<Stream<F, Object>, Stream<F, String>> insert() {
        return (Function1 & Serializable)in -> Stream$.MODULE$.eval(this.sync().insertResource().use((Function1 & Serializable)_$2 -> ((Stream)this.underlying().insert().apply(in)).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.evidence$1))).lastOrError(this.evidence$1), this.evidence$1));
    }

    public Function1<Stream<F, Object>, Stream<F, Nothing$>> insertWith(String id) {
        return (Function1 & Serializable)in -> Stream$.MODULE$.eval(this.sync().insertResource().use((Function1 & Serializable)_$3 -> ((Stream)this.underlying().insertWith(id).apply(in)).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.evidence$1))).drain(), this.evidence$1)).drain();
    }

    public F insertChunk(String id, ChunkDef chunkDef, Hint hint, ByteVector data) {
        return (F)this.sync().insertResource().use((Function1 & Serializable)_$4 -> this.underlying().insertChunk(id, chunkDef, hint, data), this.evidence$1);
    }

    public OptionT<F, Stream<F, Object>> findBinary(String id, ByteRange range) {
        return this.underlying().findBinary(id, range);
    }

    public F exists(String id) {
        return this.underlying().exists(id);
    }

    public F delete(String id) {
        return (F)this.sync().deleteResource().use((Function1 & Serializable)_$5 -> {
            Object object = package.all$.MODULE$.catsSyntaxApplyOps(this.underlying().delete(id));
            return ApplyOps$.MODULE$.$times$greater$extension(object, this.directoryRemove.removeEmptyDirs(id), this.evidence$1);
        }, this.evidence$1);
    }

    public Kleisli<?, Object, BinaryAttributes> computeAttr(String id, Hint hint) {
        return this.underlying().computeAttr(id, hint);
    }
}

