/*
 * Decompiled with CFR 0.152.
 */
package binny.fs;

import binny.AttributeName;
import binny.BinaryAttributes;
import binny.BinaryAttributes$;
import binny.BinaryId;
import binny.ByteRange;
import binny.ChunkDef;
import binny.ChunkedBinaryStore;
import binny.Hint;
import binny.InsertChunkResult;
import binny.InsertChunkResult$;
import binny.SimpleContentType;
import binny.fs.FsBinaryStore;
import binny.fs.FsBinaryStore$;
import binny.fs.FsChunkedBinaryStore$;
import binny.fs.FsChunkedStoreConfig;
import binny.fs.Impl$;
import binny.package;
import binny.util.Logger;
import binny.util.RangeCalc;
import binny.util.RangeCalc$;
import binny.util.StreamUtil$;
import cats.Functor;
import cats.data.Kleisli;
import cats.data.Kleisli$;
import cats.data.OptionT;
import cats.data.OptionT$;
import cats.effect.kernel.Async;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.package;
import fs2.Chunk$;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Stream;
import fs2.Stream$;
import fs2.io.file.Files;
import fs2.io.file.Files$;
import fs2.io.file.Flags$;
import fs2.io.file.Path;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;
import scala.util.NotGiven$;
import scodec.bits.ByteVector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FsChunkedBinaryStore<F>
implements ChunkedBinaryStore<F> {
    private final FsChunkedStoreConfig config;
    private final Logger<F> logger;
    private final Async<F> evidence$1;
    private final Files<F> evidence$2;
    private final FsBinaryStore<F> fsStore;

    public static <F> FsChunkedBinaryStore<F> apply(Logger<F> logger, FsChunkedStoreConfig fsChunkedStoreConfig, Async<F> async, Files<F> files) {
        return FsChunkedBinaryStore$.MODULE$.apply(logger, fsChunkedStoreConfig, async, files);
    }

    public static <F> FsChunkedBinaryStore<F> default(Logger<F> logger, Path path, Async<F> async, Files<F> files) {
        return FsChunkedBinaryStore$.MODULE$.default(logger, path, async, files);
    }

    public static String fileName(int n) {
        return FsChunkedBinaryStore$.MODULE$.fileName(n);
    }

    public FsChunkedBinaryStore(FsChunkedStoreConfig config, Logger<F> logger, Async<F> evidence$1, Files<F> evidence$2) {
        this.config = config;
        this.logger = logger;
        this.evidence$1 = evidence$1;
        this.evidence$2 = evidence$2;
        this.fsStore = FsBinaryStore$.MODULE$.apply(config.toStoreConfig(), logger, evidence$1, evidence$2);
    }

    public FsChunkedStoreConfig config() {
        return this.config;
    }

    public F insertChunk(String id, ChunkDef chunkDef, Hint hint, ByteVector data) {
        Option option = InsertChunkResult$.MODULE$.validateChunk(chunkDef, this.config().chunkSize(), (int)data.length());
        if (option instanceof Some) {
            InsertChunkResult bad = (InsertChunkResult)((Some)option).value();
            InsertChunkResult insertChunkResult = (InsertChunkResult)package.all$.MODULE$.catsSyntaxApplicativeId((Object)bad);
            return (F)ApplicativeIdOps$.MODULE$.pure$extension((Object)insertChunkResult, this.evidence$1);
        }
        if (None$.MODULE$.equals(option)) {
            ChunkDef.Total ch = (ChunkDef.Total)chunkDef.fold((Function1 & Serializable)x -> (ChunkDef.Total)Predef$.MODULE$.identity(x), (Function1 & Serializable)_$2 -> _$2.toTotal(this.config().chunkSize()));
            String chunkFileName = FsChunkedBinaryStore$.MODULE$.fileName(ch.index());
            Path file = this.config().targetDir(id).$div(chunkFileName);
            Object insert = Stream$.MODULE$.chunk(Chunk$.MODULE$.byteVector(data)).through(Impl$.MODULE$.write(file, this.config().overwriteMode(), this.evidence$1, this.evidence$2)).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.evidence$1))).drain();
            Object checkComplete = package.all$.MODULE$.toFunctorOps(Files$.MODULE$.apply(this.evidence$2).list(this.config().targetDir(id)).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.evidence$1))).count(), this.evidence$1).map((Function1 & Serializable)chunks -> FsChunkedBinaryStore.$anonfun$3(ch, BoxesRunTime.unboxToLong((Object)chunks)));
            return (F)package.all$.MODULE$.toFlatMapOps(insert, this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return package.all$.MODULE$.toFlatMapOps(checkComplete, this.evidence$1).flatMap((Function1 & Serializable)r -> package.all$.MODULE$.toFunctorOps(this.logger.trace(() -> FsChunkedBinaryStore.insertChunk$$anonfun$1$$anonfun$1$$anonfun$1(data, ch)), this.evidence$1).map((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return r;
                }));
            });
        }
        throw new MatchError((Object)option);
    }

    public Kleisli<?, Object, BinaryAttributes> computeAttr(String id, Hint hint) {
        return Kleisli$.MODULE$.apply((Function1 & Serializable)select -> {
            Path chunk0 = this.makeFile(id, 0);
            Object ct = Impl$.MODULE$.detectContentType(chunk0, this.config().detect(), hint, this.evidence$1, this.evidence$2);
            return ((OptionT)package.all$.MODULE$.toFunctorOps((Object)OptionT$.MODULE$.liftF(this.exists(id), this.evidence$1).filter((Function1 & Serializable)x -> FsChunkedBinaryStore.computeAttr$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)x)), this.evidence$1), (Functor)OptionT$.MODULE$.catsDataMonadErrorForOptionT(this.evidence$1)).as(select)).semiflatMap((Function1 & Serializable)x$1 -> {
                Object object = x$1;
                if (object != null) {
                    Option option = AttributeName.ContainsSha256$.MODULE$.unapply(object);
                    if (!option.isEmpty()) {
                        AttributeName.Sha256$ sha256$ = (AttributeName.Sha256$)option.get();
                        return this.listChunkFiles(id, RangeCalc.Offsets$.MODULE$.none()).map((Function1 & Serializable)_$3 -> (Path)_$3._1()).flatMap((Function1 & Serializable)p -> Files$.MODULE$.apply(this.evidence$2).readAll(p, this.config().readChunkSize(), Flags$.MODULE$.Read()), NotGiven$.MODULE$.value()).through(package.ComputeAttr$.MODULE$.computeAll(this.config().detect(), hint)).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.evidence$1))).lastOrError(this.evidence$1);
                    }
                    Option option2 = AttributeName.ContainsLength$.MODULE$.unapply(object);
                    if (!option2.isEmpty()) {
                        AttributeName.Length$ length$ = (AttributeName.Length$)option2.get();
                        Files files = Files$.MODULE$.apply(this.evidence$2);
                        Object len = this.listChunkFiles(id, RangeCalc.Offsets$.MODULE$.none()).map((Function1 & Serializable)_$4 -> (Path)_$4._1()).evalMap((Function1 & Serializable)path -> files.size(path)).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.evidence$1))).fold((Object)BoxesRunTime.boxToLong((long)0L), (Function2)(JFunction2.mcJJJ.sp & Serializable)(_$5, _$6) -> _$5 + _$6);
                        return package.all$.MODULE$.catsSyntaxTuple2Semigroupal(Tuple2$.MODULE$.apply(ct, len)).mapN((Function2 & Serializable)(contentType, length) -> BinaryAttributes$.MODULE$.apply(contentType == null ? null : ((SimpleContentType)contentType).contentType(), BoxesRunTime.unboxToLong((Object)length)), this.evidence$1, this.evidence$1);
                    }
                }
                return package.all$.MODULE$.toFunctorOps(ct, this.evidence$1).map((Function1 & Serializable)c -> FsChunkedBinaryStore.computeAttr$$anonfun$1$$anonfun$2$$anonfun$4(c == null ? null : ((SimpleContentType)c).contentType()));
            }, this.evidence$1);
        });
    }

    public OptionT<F, Stream<F, Object>> findBinary(String id, ByteRange range) {
        Object listing = this.listChunkFiles(id, RangeCalc.Offsets$.MODULE$.chunks(2)).take(2L).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.evidence$1))).toList();
        return OptionT$.MODULE$.liftF(listing, this.evidence$1).flatMap((Function1 & Serializable)x$12 -> {
            List list = x$12;
            Nil$ nil$ = package$.MODULE$.Nil();
            List list2 = list;
            if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                return OptionT$.MODULE$.none(this.evidence$1);
            }
            if (list instanceof .colon.colon) {
                List list3 = ((.colon.colon)list).next$access$1();
                Nil$ nil$2 = package$.MODULE$.Nil();
                List list4 = list3;
                if (!(nil$2 != null ? !nil$2.equals(list4) : list4 != null)) {
                    return this.fsStore.findBinary(id, range);
                }
            }
            RangeCalc.Offsets offsets = RangeCalc$.MODULE$.calcOffset(range, this.config().chunkSize());
            Stream<?, Tuple2<Path, Object>> allChunks = this.listChunkFiles(id, offsets);
            if (offsets.isNone()) {
                Stream contents = allChunks.map((Function1 & Serializable)_$7 -> (Path)_$7._1()).flatMap((Function1 & Serializable)p -> Files$.MODULE$.apply(this.evidence$2).readAll(p, this.config().readChunkSize(), Flags$.MODULE$.Read()), NotGiven$.MODULE$.value());
                boolean bl = OptionT$.MODULE$.pure();
                return OptionT.PurePartiallyApplied$.MODULE$.apply$extension(bl, (Object)contents, this.evidence$1);
            }
            boolean bl = OptionT$.MODULE$.pure();
            return OptionT.PurePartiallyApplied$.MODULE$.apply$extension(bl, (Object)allChunks.flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Path chunkFile = (Path)tuple2._1();
                    long index = BoxesRunTime.unboxToLong((Object)tuple2._2());
                    Tuple2 tuple22 = RangeCalc$.MODULE$.chopOffsets(offsets, (int)index);
                    if (tuple22 != null) {
                        Option option = (Option)tuple22._1();
                        Option option2 = (Option)tuple22._2();
                        if (option instanceof Some) {
                            int n;
                            int start = n = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                            if (option2 instanceof Some) {
                                int end = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                                return Files$.MODULE$.apply(this.evidence$2).readRange(chunkFile, this.config().readChunkSize(), (long)start, (long)(start + end));
                            }
                            int start2 = n;
                            if (None$.MODULE$.equals(option2)) {
                                return Files$.MODULE$.apply(this.evidence$2).readRange(chunkFile, this.config().readChunkSize(), (long)start2, Long.MAX_VALUE);
                            }
                        }
                        if (None$.MODULE$.equals(option)) {
                            if (option2 instanceof Some) {
                                int end = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                                return Files$.MODULE$.apply(this.evidence$2).readRange(chunkFile, this.config().readChunkSize(), 0L, (long)end);
                            }
                            if (None$.MODULE$.equals(option2)) {
                                return Files$.MODULE$.apply(this.evidence$2).readAll(chunkFile, this.config().readChunkSize(), Flags$.MODULE$.Read());
                            }
                        }
                    }
                    throw new MatchError((Object)tuple22);
                }
                throw new MatchError((Object)tuple2);
            }, NotGiven$.MODULE$.value()), this.evidence$1);
        }, this.evidence$1);
    }

    public Stream<F, String> listIds(Option<String> prefix, int chunkSize) {
        String firstChunkName = FsChunkedBinaryStore$.MODULE$.fileName(0);
        int directoryDepth = this.config().targetDirDepth();
        Stream all = (Stream)package.all$.MODULE$.toFunctorFilterOps((Object)Files$.MODULE$.apply(this.evidence$2).walk(this.config().baseDir(), directoryDepth, false).evalFilter((Function1 & Serializable)p -> Files$.MODULE$.apply(this.evidence$2).isRegularFile(p.$div(firstChunkName))), Stream$.MODULE$.functorFilterInstance()).mapFilter((Function1 & Serializable)p -> this.config().mapping().idFromDir((Path)p));
        return (Stream)prefix.map((Function1 & Serializable)p -> all.filter((Function1 & Serializable)_$8 -> (_$8 == null ? null : ((BinaryId)_$8).id()).startsWith(p))).getOrElse(() -> FsChunkedBinaryStore.listIds$$anonfun$2(all));
    }

    public Function1<Stream<F, Object>, Stream<F, String>> insert() {
        return this.fsStore.insert();
    }

    public Function1<Stream<F, Object>, Stream<F, Nothing$>> insertWith(String id) {
        return this.fsStore.insertWith(id);
    }

    public F exists(String id) {
        return (F)package.all$.MODULE$.toFunctorOps(this.listChunkFiles(id, RangeCalc.Offsets$.MODULE$.oneChunk()).take(1L).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.evidence$1))).last(), this.evidence$1).map((Function1 & Serializable)_$9 -> _$9.isDefined());
    }

    public F delete(String id) {
        Path target = this.config().targetDir(id);
        return (F)Impl$.MODULE$.deleteDir(target, this.evidence$1, this.evidence$2);
    }

    private Path makeFile(String id, int chunkIndex) {
        return this.config().targetDir(id).$div(FsChunkedBinaryStore$.MODULE$.fileName(chunkIndex));
    }

    private Stream<F, Path> takeWhileExists(Stream<F, Path> files) {
        Stream stream = files.evalMap((Function1 & Serializable)p -> package.all$.MODULE$.toFunctorOps(Files$.MODULE$.apply(this.evidence$2).exists(p), this.evidence$1).map((Function1 & Serializable)_$10 -> FsChunkedBinaryStore.$anonfun$11$$anonfun$1(p, BoxesRunTime.unboxToBoolean((Object)_$10))));
        return stream.takeWhile((Function1 & Serializable)_$11 -> BoxesRunTime.unboxToBoolean((Object)_$11._1()), stream.takeWhile$default$2()).map((Function1 & Serializable)_$12 -> (Path)_$12._2());
    }

    private Stream<?, Tuple2<Path, Object>> listChunkFiles(String id, RangeCalc.Offsets offsets) {
        if (offsets.isNone()) {
            return Stream$.MODULE$.iterate((Object)BoxesRunTime.boxToInteger((int)0), (Function1)(JFunction1.mcII.sp & Serializable)_$13 -> _$13 + 1).map((Function1 & Serializable)n -> this.listChunkFiles$$anonfun$2(id, BoxesRunTime.unboxToInt((Object)n))).through((Function1 & Serializable)files -> this.takeWhileExists((Stream<F, Path>)files)).zipWithIndex();
        }
        return Stream$.MODULE$.iterate((Object)BoxesRunTime.boxToInteger((int)offsets.firstChunk()), (Function1)(JFunction1.mcII.sp & Serializable)_$14 -> _$14 + 1).take(Int$.MODULE$.int2long(offsets.takeChunks())).map((Function1 & Serializable)n -> this.listChunkFiles$$anonfun$5(id, BoxesRunTime.unboxToInt((Object)n))).through((Function1 & Serializable)files -> this.takeWhileExists((Stream<F, Path>)files)).through(StreamUtil$.MODULE$.zipWithIndexFrom(offsets.firstChunk()));
    }

    private static final /* synthetic */ InsertChunkResult $anonfun$3(ChunkDef.Total ch$1, long chunks) {
        if (chunks >= (long)ch$1.total()) {
            return InsertChunkResult$.MODULE$.complete();
        }
        return InsertChunkResult$.MODULE$.incomplete();
    }

    private static final String insertChunk$$anonfun$1$$anonfun$1$$anonfun$1(ByteVector data$3, ChunkDef.Total ch$4) {
        return new StringBuilder(25).append("Inserted chunk ").append(ch$4.index() + 1).append("/").append(ch$4.total()).append(" of size ").append(data$3.length()).toString();
    }

    private static final /* synthetic */ boolean computeAttr$$anonfun$1$$anonfun$1(boolean x) {
        return BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToBoolean((boolean)x)));
    }

    private static final /* synthetic */ BinaryAttributes computeAttr$$anonfun$1$$anonfun$2$$anonfun$4(String c) {
        return BinaryAttributes$.MODULE$.empty().copy(BinaryAttributes$.MODULE$.empty().copy$default$1(), c, BinaryAttributes$.MODULE$.empty().copy$default$3());
    }

    private static final Stream listIds$$anonfun$2(Stream all$2) {
        return all$2;
    }

    private static final /* synthetic */ Tuple2 $anonfun$11$$anonfun$1(Path p$2, boolean _$10) {
        Boolean bl = (Boolean)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToBoolean((boolean)_$10));
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)bl, (Object)p$2);
    }

    private final /* synthetic */ Path listChunkFiles$$anonfun$2(String id$4, int n) {
        return this.makeFile(id$4, n);
    }

    private final /* synthetic */ Path listChunkFiles$$anonfun$5(String id$5, int n) {
        return this.makeFile(id$5, n);
    }
}

