/*
 * Decompiled with CFR 0.152.
 */
package sharry.logging;

import cats.data.NonEmptyList;
import io.circe.Decoder;
import io.circe.Encoder;
import java.io.Serializable;
import scala.Predef$;
import scala.Product;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import sharry.logging.Level;
import sharry.logging.LogConfig$;
import sharry.logging.LogConfig$Format$;

public final class LogConfig
implements Product,
Serializable {
    private final Level minimumLevel;
    private final Format format;
    private final Map<String, Level> levels;

    public static LogConfig apply(Level level, Format format, Map<String, Level> map) {
        return LogConfig$.MODULE$.apply(level, format, map);
    }

    public static LogConfig fromProduct(Product product) {
        return LogConfig$.MODULE$.fromProduct(product);
    }

    public static Decoder<LogConfig> jsonDecoder() {
        return LogConfig$.MODULE$.jsonDecoder();
    }

    public static Encoder<LogConfig> jsonEncoder() {
        return LogConfig$.MODULE$.jsonEncoder();
    }

    public static LogConfig unapply(LogConfig logConfig) {
        return LogConfig$.MODULE$.unapply(logConfig);
    }

    public LogConfig(Level minimumLevel, Format format, Map<String, Level> levels) {
        this.minimumLevel = minimumLevel;
        this.format = format;
        this.levels = levels;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof LogConfig)) return false;
        LogConfig logConfig = (LogConfig)object;
        Level level = this.minimumLevel();
        Level level2 = logConfig.minimumLevel();
        if (level == null) {
            if (level2 != null) {
                return false;
            }
        } else if (!level.equals(level2)) return false;
        Format format = this.format();
        Format format2 = logConfig.format();
        if (format == null) {
            if (format2 != null) {
                return false;
            }
        } else if (!format.equals(format2)) return false;
        Map<String, Level> map = this.levels();
        Map<String, Level> map2 = logConfig.levels();
        if (map == null) {
            if (map2 == null) return true;
            return false;
        } else {
            if (!map.equals(map2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof LogConfig;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "LogConfig";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "minimumLevel";
            }
            case 1: {
                return "format";
            }
            case 2: {
                return "levels";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Level minimumLevel() {
        return this.minimumLevel;
    }

    public Format format() {
        return this.format;
    }

    public Map<String, Level> levels() {
        return this.levels;
    }

    public LogConfig clearLevels() {
        Map map = Predef$.MODULE$.Map().empty();
        Level level = this.copy$default$1();
        Format format = this.copy$default$2();
        return this.copy(level, format, (Map<String, Level>)map);
    }

    public LogConfig withLevel(String logger, Level level) {
        Map map = (Map)this.levels().updated((Object)logger, (Object)level);
        Level level2 = this.copy$default$1();
        Format format = this.copy$default$2();
        return this.copy(level2, format, (Map<String, Level>)map);
    }

    public LogConfig sharryLevel(Level level) {
        return this.withLevel("sharry", level);
    }

    public LogConfig copy(Level minimumLevel, Format format, Map<String, Level> levels) {
        return new LogConfig(minimumLevel, format, levels);
    }

    public Level copy$default$1() {
        return this.minimumLevel();
    }

    public Format copy$default$2() {
        return this.format();
    }

    public Map<String, Level> copy$default$3() {
        return this.levels();
    }

    public Level _1() {
        return this.minimumLevel();
    }

    public Format _2() {
        return this.format();
    }

    public Map<String, Level> _3() {
        return this.levels();
    }

    public static interface Format {
        public static NonEmptyList<Format> all() {
            return LogConfig$Format$.MODULE$.all();
        }

        public static Either<String, Format> fromString(String string) {
            return LogConfig$Format$.MODULE$.fromString(string);
        }

        public static Decoder<Format> jsonDecoder() {
            return LogConfig$Format$.MODULE$.jsonDecoder();
        }

        public static Encoder<Format> jsonEncoder() {
            return LogConfig$Format$.MODULE$.jsonEncoder();
        }

        public static int ordinal(Format format) {
            return LogConfig$Format$.MODULE$.ordinal(format);
        }

        public static String name$(Format $this) {
            return $this.name();
        }

        default public String name() {
            return ((Product)this).productPrefix().toLowerCase();
        }
    }
}

