/*
 * Decompiled with CFR 0.152.
 */
package binny.jdbc.impl;

import binny.BinaryAttributes;
import binny.BinaryAttributes$;
import binny.BinaryId;
import binny.BinaryId$;
import binny.ByteRange;
import binny.ContentTypeDetect;
import binny.Hint;
import binny.InsertChunkResult;
import binny.InsertChunkResult$;
import binny.SimpleContentType;
import binny.SimpleContentType$;
import binny.jdbc.impl.DbRunApi;
import binny.jdbc.impl.DbRunApi$ChunkInfo$;
import binny.jdbc.impl.DbRunApi$ChunkInfo$Multiple$;
import binny.jdbc.impl.DbRunApi$ChunkInfo$None$;
import binny.jdbc.impl.DbRunApi$ChunkInfo$Single$;
import binny.jdbc.impl.Implicits$;
import binny.jdbc.impl.package$DbRun$;
import binny.package;
import binny.util.Logger;
import binny.util.RangeCalc;
import binny.util.RangeCalc$;
import cats.Apply;
import cats.FlatMap;
import cats.data.Kleisli;
import cats.data.Kleisli$;
import cats.data.OptionT$;
import cats.effect.kernel.Resource$;
import cats.effect.kernel.Sync;
import cats.effect.package$;
import cats.implicits$;
import cats.syntax.ApplyOps$;
import cats.syntax.FlatMapOps$;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.Stream;
import fs2.Stream$;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.sql.DataSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.util.NotGiven$;
import scala.util.Using;
import scala.util.Using$;
import scodec.bits.ByteVector$;

public final class DbRunApi<F> {
    private final String table;
    private final Logger<F> logger;
    private final Sync<F> evidence$1;
    private final Logger<F> log;

    public DbRunApi(String table, Logger<F> logger, Sync<F> evidence$1) {
        this.table = table;
        this.logger = logger;
        this.evidence$1 = evidence$1;
        this.log = logger;
    }

    public Kleisli<F, Connection, InsertChunkResult> insertNextChunk(String id, int chunkIndex, int chunksTotal, Chunk<Object> bytes) {
        Kleisli kleisli = (Kleisli)implicits$.MODULE$.catsSyntaxApplyOps(Implicits$.MODULE$.DbRunSyncOps(this.removeChunk(id, chunkIndex), this.evidence$1).inTX(this.log));
        Kleisli insert = (Kleisli)ApplyOps$.MODULE$.$times$greater$extension((Object)kleisli, Implicits$.MODULE$.DbRunSyncOps(this.insertChunk(id, chunkIndex, bytes), this.evidence$1).inTX(this.log), (Apply)Kleisli$.MODULE$.catsDataMonadErrorForKleisli(this.evidence$1));
        Kleisli kleisli2 = (Kleisli)implicits$.MODULE$.catsSyntaxApplyOps((Object)insert);
        return (Kleisli)ApplyOps$.MODULE$.$times$greater$extension((Object)kleisli2, (Object)this.count(id).map((Function1 & Serializable)currentChunks -> DbRunApi.insertNextChunk$$anonfun$1(chunksTotal, BoxesRunTime.unboxToLong((Object)currentChunks)), this.evidence$1), (Apply)Kleisli$.MODULE$.catsDataMonadErrorForKleisli(this.evidence$1));
    }

    public Kleisli<F, Connection, Object> removeChunk(String id, int chunkIndex) {
        return package$DbRun$.MODULE$.update(new StringBuilder(47).append("DELETE FROM ").append(this.table).append(" WHERE file_id = ? AND chunk_nr = ?").toString(), (Function1<PreparedStatement, BoxedUnit>)(JProcedure1 & Serializable)ps -> {
            ps.setString(1, id);
            ps.setInt(2, chunkIndex);
        }, this.evidence$1, this.log);
    }

    public Kleisli<F, Connection, Object> countAll() {
        return Implicits$.MODULE$.DbRunIOResourceOps(package$DbRun$.MODULE$.query(new StringBuilder(21).append("SELECT COUNT(*) FROM ").append(this.table).toString(), (Function1<PreparedStatement, BoxedUnit>)(JProcedure1 & Serializable)_$2 -> {}, this.evidence$1, this.log)).use((Function1 & Serializable)rs -> package$DbRun$.MODULE$.readOpt((Function1 & Serializable)_$3 -> _$3.getLong(1), (ResultSet)rs, this.evidence$1), this.evidence$1).map((Function1 & Serializable)_$4 -> BoxesRunTime.unboxToLong((Object)_$4.getOrElse(DbRunApi::countAll$$anonfun$3$$anonfun$1)), this.evidence$1);
    }

    public Kleisli<F, Connection, Object> count(String id) {
        return Implicits$.MODULE$.DbRunIOResourceOps(package$DbRun$.MODULE$.query(new StringBuilder(39).append("SELECT COUNT(*) FROM ").append(this.table).append(" WHERE file_id = ?").toString(), (Function1<PreparedStatement, BoxedUnit>)(JProcedure1 & Serializable)_$5 -> _$5.setString(1, id), this.evidence$1, this.log)).use((Function1 & Serializable)rs -> package$DbRun$.MODULE$.readOpt((Function1 & Serializable)_$6 -> _$6.getLong(1), (ResultSet)rs, this.evidence$1), this.evidence$1).map((Function1 & Serializable)_$7 -> BoxesRunTime.unboxToLong((Object)_$7.getOrElse(DbRunApi::count$$anonfun$3$$anonfun$1)), this.evidence$1);
    }

    public Kleisli<?, Connection, BoxedUnit> exists(String id) {
        return Implicits$.MODULE$.DbRunIOResourceOps(package$DbRun$.MODULE$.query(new StringBuilder(46).append("SELECT file_id FROM ").append(this.table).append(" WHERE file_id = ? LIMIT ?").toString(), (Function1<PreparedStatement, BoxedUnit>)(JProcedure1 & Serializable)ps -> {
            ps.setString(1, id);
            ps.setInt(2, 1);
        }, this.evidence$1, this.log)).use((Function1 & Serializable)rs -> package$DbRun$.MODULE$.readOpt((JProcedure1 & Serializable)_$9 -> {}, (ResultSet)rs, this.evidence$1), this.evidence$1).mapF((Function1 & Serializable)value -> OptionT$.MODULE$.apply(value));
    }

    public Kleisli<F, Connection, Chunk<String>> listIdsChunk(String start, Option<String> prefix, int chunkSize) {
        String clause = (String)prefix.map((Function1 & Serializable)_$10 -> "AND file_id like ?").getOrElse(DbRunApi::$anonfun$2);
        Kleisli<?, Connection, ResultSet> select = package$DbRun$.MODULE$.query(new StringBuilder(65).append("SELECT DISTINCT file_id FROM ").append(this.table).append(" WHERE file_id > ? ").append(clause).append(" ORDER BY file_id").toString(), (Function1<PreparedStatement, BoxedUnit>)(JProcedure1 & Serializable)ps -> {
            ps.setString(1, start);
            prefix.map((Function1)(JProcedure1 & Serializable)p -> ps.setString(2, new StringBuilder(1).append((String)p).append("%").toString())).getOrElse((Function0 & Serializable)() -> {
                DbRunApi.$anonfun$3$$anonfun$2();
                return BoxedUnit.UNIT;
            });
        }, this.evidence$1, this.log);
        return package$DbRun$.MODULE$.makeTX(this.evidence$1, this.log).flatMap((Function1 & Serializable)_$11 -> select, (FlatMap)Resource$.MODULE$.catsEffectSyncForResource(this.evidence$1)).mapF((Function1 & Serializable)_$12 -> _$12.use((Function1 & Serializable)resultSet -> this.readRows$1(chunkSize, (ResultSet)resultSet), this.evidence$1));
    }

    public Stream<F, String> listAllIds(Option<String> prefix, int chunkSize, DataSource ds) {
        return this.selectNext$1(prefix, chunkSize, ds, "");
    }

    public Kleisli<F, Connection, Object> insertEmptyAttr(String id) {
        return package$DbRun$.MODULE$.update(new StringBuilder(69).append("INSERT INTO ").append(this.table).append(" (file_id, sha256, content_type, length) VALUES (?,?,?,?)").toString(), (Function1<PreparedStatement, BoxedUnit>)(JProcedure1 & Serializable)ps -> {
            ps.setString(1, id);
            ps.setString(2, "");
            ps.setString(3, "");
            ps.setLong(4, 0L);
        }, this.evidence$1, this.log);
    }

    public Kleisli<F, Connection, Object> insertAttr(String id, BinaryAttributes attr) {
        return package$DbRun$.MODULE$.update(new StringBuilder(69).append("INSERT INTO ").append(this.table).append(" (file_id, sha256, content_type, length) VALUES (?,?,?,?)").toString(), (Function1<PreparedStatement, BoxedUnit>)(JProcedure1 & Serializable)ps -> {
            ps.setString(1, id);
            ps.setString(2, attr.sha256().toHex());
            ps.setString(3, attr.contentType());
            ps.setLong(4, attr.length());
        }, this.evidence$1, this.log);
    }

    public Kleisli<F, Connection, Object> updateAttr(String id, BinaryAttributes attr) {
        return package$DbRun$.MODULE$.update(new StringBuilder(62).append("UPDATE ").append(this.table).append(" SET sha256=?,content_type=?,length=? WHERE file_id = ?").toString(), (Function1<PreparedStatement, BoxedUnit>)(JProcedure1 & Serializable)ps -> {
            ps.setString(1, attr.sha256().toHex());
            ps.setString(2, attr.contentType());
            ps.setLong(3, attr.length());
            ps.setString(4, id);
        }, this.evidence$1, this.log);
    }

    public Kleisli<F, Connection, Object> insertChunk(String id, int index, Chunk<Object> bytes) {
        Kleisli kleisli = (Kleisli)implicits$.MODULE$.catsSyntaxFlatMapOps(package$DbRun$.MODULE$.apply((Function1<Connection, Object>)(Function1 & Serializable)_$13 -> this.logger.trace(() -> DbRunApi.insertChunk$$anonfun$1$$anonfun$1(index, bytes))), (FlatMap)Kleisli$.MODULE$.catsDataMonadErrorForKleisli(this.evidence$1));
        return (Kleisli)FlatMapOps$.MODULE$.$greater$greater$extension((Object)kleisli, () -> this.insertChunk$$anonfun$2(id, index, bytes), (FlatMap)Kleisli$.MODULE$.catsDataMonadErrorForKleisli(this.evidence$1));
    }

    public Stream<F, Kleisli<F, Connection, Object>> insertAllData(String id, Stream<F, Chunk<Object>> data) {
        return data.ifEmpty(DbRunApi::insertAllData$$anonfun$1).zipWithIndex().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Chunk chunk = (Chunk)tuple2._1();
                long index = BoxesRunTime.unboxToLong((Object)tuple2._2());
                return this.insertChunk(id, (int)index, (Chunk<Object>)chunk);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Kleisli<F, Connection, Object> delete(String id) {
        return package$DbRun$.MODULE$.update(new StringBuilder(30).append("DELETE FROM ").append(this.table).append(" WHERE file_id = ?").toString(), (Function1<PreparedStatement, BoxedUnit>)(JProcedure1 & Serializable)ps -> ps.setString(1, id), this.evidence$1, this.log);
    }

    public Kleisli<F, Connection, Object> deleteChunk(String id, int chunkNr) {
        return package$DbRun$.MODULE$.update(new StringBuilder(47).append("DELETE FROM ").append(this.table).append(" WHERE file_id = ? and chunk_nr = ?").toString(), (Function1<PreparedStatement, BoxedUnit>)(JProcedure1 & Serializable)ps -> {
            ps.setString(1, id);
            ps.setInt(2, chunkNr);
        }, this.evidence$1, this.log);
    }

    public Kleisli<F, Connection, Option<Chunk<Object>>> queryChunk(String id, int chunkNr) {
        return Implicits$.MODULE$.DbRunSyncOps(Implicits$.MODULE$.DbRunIOResourceOps(package$DbRun$.MODULE$.query(new StringBuilder(58).append("SELECT chunk_data FROM ").append(this.table).append(" WHERE file_id = ? AND chunk_nr = ?").toString(), (Function1<PreparedStatement, BoxedUnit>)(JProcedure1 & Serializable)ps -> {
            ps.setString(1, id);
            ps.setInt(2, chunkNr);
            ps.setMaxRows(1);
            ps.setFetchSize(1);
        }, this.evidence$1, this.log)).use((Function1 & Serializable)rs2 -> package$DbRun$.MODULE$.readOpt((Function1 & Serializable)rs -> Chunk$.MODULE$.array((Object)rs.getBytes(1), ClassTag$.MODULE$.apply(Byte.TYPE)), (ResultSet)rs2, this.evidence$1), this.evidence$1), this.evidence$1).inTX(this.log);
    }

    public Kleisli<?, Connection, Object> queryAll(String id, ByteRange range) {
        return this.getChunkSize(id).mapF((Function1 & Serializable)fo -> Stream$.MODULE$.eval(fo)).flatMap((Function1 & Serializable)x$12 -> {
            ChunkInfo chunkInfo = x$12;
            if (DbRunApi$ChunkInfo$None$.MODULE$.equals(chunkInfo)) {
                return package$DbRun$.MODULE$.apply((Function1<Connection, Object>)(Function1 & Serializable)_$15 -> package.Binary$.MODULE$.empty());
            }
            if (DbRunApi$ChunkInfo$Single$.MODULE$.equals(chunkInfo)) {
                return this.queryChunk(id, 0).map((Function1 & Serializable)x$1 -> {
                    Option option = x$1;
                    if (option instanceof Some) {
                        Chunk c = (Chunk)((Some)option).value();
                        ByteRange byteRange = range;
                        if (ByteRange.All$.MODULE$.equals(byteRange)) {
                            return c;
                        }
                        if (byteRange instanceof ByteRange.Chunk) {
                            ByteRange.Chunk chunk = ByteRange.Chunk$.MODULE$.unapply((ByteRange.Chunk)byteRange);
                            long l = chunk._1();
                            int n = chunk._2();
                            long offset = l;
                            int length = n;
                            RangeCalc.Offsets offsets = RangeCalc.Offsets$.MODULE$.apply(0, 1, (int)offset, length);
                            return RangeCalc$.MODULE$.chop(c, offsets, 0);
                        }
                        throw new MatchError((Object)byteRange);
                    }
                    if (None$.MODULE$.equals(option)) {
                        return Chunk$.MODULE$.empty();
                    }
                    throw new MatchError((Object)option);
                }, this.evidence$1).mapF((Function1 & Serializable)fo -> Stream$.MODULE$.eval(fo)).mapF((Function1 & Serializable)_$16 -> _$16.flatMap((Function1 & Serializable)os -> Stream$.MODULE$.chunk(os), NotGiven$.MODULE$.value()));
            }
            if (chunkInfo instanceof ChunkInfo.Multiple) {
                int n;
                ChunkInfo.Multiple multiple = DbRunApi$ChunkInfo$Multiple$.MODULE$.unapply((ChunkInfo.Multiple)chunkInfo);
                int chunkSize = n = multiple._1();
                return this.queryAllMultiple(id, range, chunkSize);
            }
            throw new MatchError((Object)chunkInfo);
        }, (FlatMap)Stream$.MODULE$.monadErrorInstance(this.evidence$1));
    }

    private Kleisli<?, Connection, Object> queryAllMultiple(String id, ByteRange range, int chunkSize) {
        Kleisli<?, Connection, ResultSet> kleisli;
        RangeCalc.Offsets offsets = RangeCalc$.MODULE$.calcOffset(range, chunkSize);
        ByteRange byteRange = range;
        if (ByteRange.All$.MODULE$.equals(byteRange)) {
            kleisli = package$DbRun$.MODULE$.query(new StringBuilder(63).append("SELECT chunk_data FROM ").append(this.table).append(" WHERE file_id = ? ORDER BY chunk_nr ASC").toString(), (Function1<PreparedStatement, BoxedUnit>)(JProcedure1 & Serializable)ps -> {
                ps.setString(1, id);
                ps.setFetchSize(1);
            }, this.evidence$1, this.log);
        } else if (byteRange instanceof ByteRange.Chunk) {
            ByteRange.Chunk chunk = ByteRange.Chunk$.MODULE$.unapply((ByteRange.Chunk)byteRange);
            long l = chunk._1();
            int n = chunk._2();
            kleisli = package$DbRun$.MODULE$.query(new StringBuilder(108).append("SELECT chunk_data,chunk_nr FROM ").append(this.table).append(" WHERE file_id = ? AND chunk_nr >= ? AND chunk_nr <= ? ORDER BY chunk_nr ASC").toString(), (Function1<PreparedStatement, BoxedUnit>)(JProcedure1 & Serializable)ps -> {
                ps.setString(1, id);
                ps.setInt(2, offsets.firstChunk());
                ps.setInt(3, offsets.lastChunk());
                ps.setFetchSize(1);
            }, this.evidence$1, this.log);
        } else {
            throw new MatchError((Object)byteRange);
        }
        Kleisli<?, Connection, ResultSet> all = kleisli;
        return package$DbRun$.MODULE$.makeTX(this.evidence$1, this.log).mapF((Function1 & Serializable)r -> Stream$.MODULE$.resource(r, this.evidence$1)).flatMap((Function1 & Serializable)_$19 -> all.mapF((Function1 & Serializable)rsRes -> Stream$.MODULE$.resource(rsRes, this.evidence$1).flatMap((Function1 & Serializable)_$20 -> this.useResultSet$1((ResultSet)_$20, offsets), NotGiven$.MODULE$.value())), (FlatMap)Stream$.MODULE$.monadErrorInstance(this.evidence$1));
    }

    public Kleisli<F, Connection, BinaryAttributes> computeAttrAll(String id, ContentTypeDetect detect, Hint hint) {
        return Implicits$.MODULE$.DbRunSyncOps(package$DbRun$.MODULE$.delay((Function1 & Serializable)conn -> {
            String sql = new StringBuilder(63).append("SELECT chunk_data FROM ").append(this.table).append(" WHERE file_id = ? ORDER BY chunk_nr ASC").toString();
            return (BinaryAttributes)Using$.MODULE$.resource((Object)conn.prepareStatement(sql), (Function1 & Serializable)ps -> {
                ps.setString(1, id);
                ps.setFetchSize(1);
                return (BinaryAttributes)Using$.MODULE$.resource((Object)ps.executeQuery(), (Function1 & Serializable)rs -> {
                    Object object;
                    long len = 0L;
                    MessageDigest md = MessageDigest.getInstance("SHA-256");
                    None$ ct = None$.MODULE$;
                    rs.setFetchSize(1);
                    while (rs.next()) {
                        byte[] data = rs.getBytes(1);
                        md.update(data);
                        len += (long)data.length;
                        if (!ct.isEmpty()) continue;
                        ct = Some$.MODULE$.apply((Object)new SimpleContentType(detect.detect(ByteVector$.MODULE$.view(data), hint)));
                    }
                    return BinaryAttributes$.MODULE$.apply(ByteVector$.MODULE$.view(md.digest()), (object = ct.getOrElse((Function0 & Serializable)() -> new SimpleContentType(DbRunApi.computeAttrAll$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1()))) == null ? null : ((SimpleContentType)object).contentType(), len);
                }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        }, this.evidence$1), this.evidence$1).inTX(this.log);
    }

    public Kleisli<F, Connection, Object> computeAttrLen(String id) {
        return package$DbRun$.MODULE$.delay((Function1 & Serializable)conn -> {
            String sql = new StringBuilder(54).append("SELECT sum(length(chunk_data)) FROM ").append(this.table).append(" WHERE file_id = ?").toString();
            return BoxesRunTime.unboxToLong((Object)Using$.MODULE$.resource((Object)conn.prepareStatement(sql), (Function1 & Serializable)ps -> {
                ps.setString(1, id);
                return BoxesRunTime.unboxToLong((Object)Using$.MODULE$.resource((Object)ps.executeQuery(), (Function1 & Serializable)rs -> {
                    if (rs.next()) {
                        return rs.getLong(1);
                    }
                    return -1L;
                }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$));
            }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$));
        }, this.evidence$1);
    }

    public Kleisli<F, Connection, String> computeAttrDetect(String id, ContentTypeDetect detect, Hint hint) {
        return package$DbRun$.MODULE$.delay((Function1 & Serializable)conn -> new SimpleContentType(this.computeAttrDetect$$anonfun$1(id, detect, hint, (Connection)conn)), this.evidence$1);
    }

    public Kleisli<F, Connection, Option<BinaryAttributes>> queryAttr(String id) {
        return Implicits$.MODULE$.DbRunIOResourceOps(package$DbRun$.MODULE$.query(new StringBuilder(75).append("SELECT sha256, content_type, length FROM ").append(this.table).append(" WHERE file_id = ? AND sha256 <> ?").toString(), (Function1<PreparedStatement, BoxedUnit>)(JProcedure1 & Serializable)ps -> {
            ps.setString(1, id);
            ps.setString(2, "");
        }, this.evidence$1, this.log)).use((Function1 & Serializable)rs2 -> package$DbRun$.MODULE$.readOpt((Function1 & Serializable)rs -> BinaryAttributes$.MODULE$.apply(ByteVector$.MODULE$.fromValidHex(rs.getString(1), ByteVector$.MODULE$.fromValidHex$default$2()), SimpleContentType$.MODULE$.apply(rs.getString(2)), rs.getLong(3)), (ResultSet)rs2, this.evidence$1), this.evidence$1);
    }

    public Kleisli<F, Connection, ChunkInfo> getChunkSize(String id) {
        Kleisli<?, Connection, ResultSet> q = package$DbRun$.MODULE$.query(new StringBuilder(48).append("SELECT chunk_len FROM ").append(this.table).append(" WHERE file_id = ? LIMIT ?").toString(), (Function1<PreparedStatement, BoxedUnit>)(JProcedure1 & Serializable)ps -> {
            ps.setString(1, id);
            ps.setInt(2, 2);
        }, this.evidence$1, this.log);
        return Implicits$.MODULE$.DbRunIOResourceOps(q).use((Function1 & Serializable)rs -> package$.MODULE$.Sync().apply(this.evidence$1).blocking(() -> DbRunApi.getChunkSize$$anonfun$1$$anonfun$1(rs)), this.evidence$1);
    }

    private static final /* synthetic */ InsertChunkResult insertNextChunk$$anonfun$1(int chunksTotal$1, long currentChunks) {
        if (currentChunks == (long)chunksTotal$1) {
            return InsertChunkResult$.MODULE$.complete();
        }
        return InsertChunkResult$.MODULE$.incomplete();
    }

    private static final long countAll$$anonfun$3$$anonfun$1() {
        return 0L;
    }

    private static final long count$$anonfun$3$$anonfun$1() {
        return 0L;
    }

    private static final String $anonfun$2() {
        return "";
    }

    private static final void $anonfun$3$$anonfun$2() {
    }

    private static final Chunk readRows$1$$anonfun$1(int chunkSize$1, ResultSet resultSet$1) {
        ListBuffer buffer = ListBuffer$.MODULE$.empty();
        while (resultSet$1.next() && buffer.size() < chunkSize$1) {
            buffer.$plus$eq((Object)new BinaryId(BinaryId$.MODULE$.apply(resultSet$1.getString(1))));
        }
        return Chunk$.MODULE$.from((Iterable)buffer);
    }

    private final Object readRows$1(int chunkSize$2, ResultSet resultSet) {
        return package$.MODULE$.Sync().apply(this.evidence$1).blocking(() -> DbRunApi.readRows$1$$anonfun$1(chunkSize$2, resultSet));
    }

    private final Stream selectNext$1$$anonfun$1$$anonfun$1(Option prefix$4, int chunkSize$5, DataSource ds$3, String lastId$1) {
        return this.selectNext$1(prefix$4, chunkSize$5, ds$3, lastId$1);
    }

    private final Stream selectNext$1(Option prefix$2, int chunkSize$3, DataSource ds$1, String start) {
        return Stream$.MODULE$.eval(Implicits$.MODULE$.DbRunSyncOps(this.listIdsChunk(start, (Option<String>)prefix$2, chunkSize$3), this.evidence$1).execute(ds$1)).flatMap((Function1 & Serializable)chunk -> {
            Option option = chunk.last();
            if (option instanceof Some) {
                String lastId;
                Object object = ((Some)option).value();
                String string = lastId = object == null ? null : ((BinaryId)object).id();
                if (chunk.size() == chunkSize$3) {
                    return Stream$.MODULE$.chunk(chunk).$plus$plus(() -> this.selectNext$1$$anonfun$1$$anonfun$1(prefix$2, chunkSize$3, ds$1, lastId));
                }
            }
            return Stream$.MODULE$.chunk(chunk);
        }, NotGiven$.MODULE$.value());
    }

    private static final String insertChunk$$anonfun$1$$anonfun$1(int index$2, Chunk bytes$2) {
        return new StringBuilder(22).append("Insert chunk ").append(index$2).append(" of size ").append(bytes$2.size()).toString();
    }

    private final Kleisli insertChunk$$anonfun$2(String id$7, int index$3, Chunk bytes$3) {
        return package$DbRun$.MODULE$.update(new StringBuilder(72).append("INSERT INTO ").append(this.table).append(" (file_id, chunk_nr, chunk_len, chunk_data) VALUES (?,?,?,?)").toString(), (Function1<PreparedStatement, BoxedUnit>)(JProcedure1 & Serializable)ps -> {
            ps.setString(1, id$7);
            ps.setInt(2, index$3);
            ps.setInt(3, bytes$3.size());
            Chunk.ArraySlice bs = bytes$3.toArraySlice(ClassTag$.MODULE$.apply(Byte.TYPE));
            ps.setBinaryStream(4, new ByteArrayInputStream((byte[])bs.values(), bs.offset(), bs.size()));
        }, this.evidence$1, this.log);
    }

    private static final Stream insertAllData$$anonfun$1() {
        return Stream$.MODULE$.emit((Object)Chunk$.MODULE$.empty());
    }

    private static final Option readRow$1$$anonfun$1(ResultSet rs$1) {
        if (rs$1.next()) {
            return Option$.MODULE$.apply((Object)rs$1.getBytes(1));
        }
        return None$.MODULE$;
    }

    private final Object readRow$1(ResultSet rs, RangeCalc.Offsets offsets) {
        return implicits$.MODULE$.toFunctorOps(package$.MODULE$.Sync().apply(this.evidence$1).blocking(() -> DbRunApi.readRow$1$$anonfun$1(rs)), this.evidence$1).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (None$.MODULE$.equals(option)) {
                return Chunk$.MODULE$.empty();
            }
            if (option instanceof Some) {
                byte[] buf = (byte[])((Some)option).value();
                Chunk ch = Chunk$.MODULE$.array((Object)buf, ClassTag$.MODULE$.apply(Byte.TYPE));
                if (offsets.isNone()) {
                    return ch;
                }
                return RangeCalc$.MODULE$.chop(ch, offsets, rs.getInt(2));
            }
            throw new MatchError((Object)option);
        });
    }

    private final Stream useResultSet$1(ResultSet rs, RangeCalc.Offsets offsets) {
        return Stream$.MODULE$.eval(this.readRow$1(rs, offsets)).repeat().takeThrough((Function1 & Serializable)_$18 -> _$18.nonEmpty()).flatMap((Function1 & Serializable)os -> Stream$.MODULE$.chunk(os), NotGiven$.MODULE$.value());
    }

    private static final String computeAttrAll$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1() {
        return SimpleContentType$.MODULE$.octetStream();
    }

    private static final String computeAttrDetect$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1() {
        return SimpleContentType$.MODULE$.octetStream();
    }

    private static final /* synthetic */ String computeAttrDetect$$anonfun$1$$anonfun$1$$anonfun$1(ContentTypeDetect detect$6, Hint hint$6, ResultSet rs) {
        Object object;
        None$ ct = None$.MODULE$;
        rs.setFetchSize(1);
        if (rs.next()) {
            byte[] data = rs.getBytes(1);
            if (ct.isEmpty()) {
                ct = Some$.MODULE$.apply((Object)new SimpleContentType(detect$6.detect(ByteVector$.MODULE$.view(data), hint$6)));
            }
        }
        if ((object = ct.getOrElse((Function0 & Serializable)() -> new SimpleContentType(DbRunApi.computeAttrDetect$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1()))) == null) {
            return null;
        }
        return ((SimpleContentType)object).contentType();
    }

    private static final /* synthetic */ String computeAttrDetect$$anonfun$1$$anonfun$1(String id$21, ContentTypeDetect detect$5, Hint hint$5, PreparedStatement ps) {
        ps.setString(1, id$21);
        Object object = Using$.MODULE$.resource((Object)ps.executeQuery(), (Function1 & Serializable)rs -> new SimpleContentType(DbRunApi.computeAttrDetect$$anonfun$1$$anonfun$1$$anonfun$1(detect$5, hint$5, rs)), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        if (object == null) {
            return null;
        }
        return ((SimpleContentType)object).contentType();
    }

    private final /* synthetic */ String computeAttrDetect$$anonfun$1(String id$20, ContentTypeDetect detect$4, Hint hint$4, Connection conn) {
        String sql = new StringBuilder(58).append("SELECT chunk_data FROM ").append(this.table).append(" WHERE file_id = ? and chunk_nr = 0").toString();
        Object object = Using$.MODULE$.resource((Object)conn.prepareStatement(sql), (Function1 & Serializable)ps -> new SimpleContentType(DbRunApi.computeAttrDetect$$anonfun$1$$anonfun$1(id$20, detect$4, hint$4, ps)), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        if (object == null) {
            return null;
        }
        return ((SimpleContentType)object).contentType();
    }

    private static final ChunkInfo getChunkSize$$anonfun$1$$anonfun$1(ResultSet rs$3) {
        if (rs$3.next()) {
            int size = rs$3.getInt(1);
            return rs$3.next() ? DbRunApi$ChunkInfo$Multiple$.MODULE$.apply(size) : DbRunApi$ChunkInfo$Single$.MODULE$;
        }
        return DbRunApi$ChunkInfo$None$.MODULE$;
    }

    public static interface ChunkInfo {
        public static int ordinal(ChunkInfo chunkInfo) {
            return DbRunApi$ChunkInfo$.MODULE$.ordinal(chunkInfo);
        }
    }
}

