/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.std;

import cats.effect.std.FailureSignal$;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.runtime.BoxedUnit;

public final class UnsafeUnbounded<A> {
    private final AtomicReference<Cell> first = new AtomicReference();
    private final AtomicReference<Cell> last = new AtomicReference();
    private final FailureSignal$ FailureSignal = FailureSignal$.MODULE$;

    public int size() {
        int count = 0;
        for (Cell current = this.first.get(); current != null; current = (Cell)current.get()) {
            ++count;
        }
        return count;
    }

    public Function0<BoxedUnit> put(A data) {
        Cell cell = new Cell(data);
        Cell prevLast = this.last.getAndSet(cell);
        if (prevLast == null) {
            this.first.set(cell);
        } else {
            prevLast.set(cell);
        }
        return cell;
    }

    public A take() {
        while (true) {
            Cell taken;
            if ((taken = this.first.get()) != null) {
                Cell next = (Cell)taken.get();
                if (!this.first.compareAndSet(taken, next)) continue;
                if (next == null && !this.last.compareAndSet(taken, null)) {
                    Cell next2 = (Cell)taken.get();
                    while (next2 == null) {
                        next2 = (Cell)taken.get();
                    }
                    this.first.set(next2);
                }
                Object ret = taken.data();
                taken.apply$mcV$sp();
                return ret;
            }
            if (this.last.get() == null) break;
        }
        throw this.FailureSignal;
    }

    public String debug() {
        Cell f = this.first.get();
        if (f == null) {
            return "[]";
        }
        return f.debug();
    }

    public final class Cell
    extends AtomicReference<Cell>
    implements Function0<BoxedUnit> {
        private A _data;

        public Cell(A _data) {
            this._data = _data;
        }

        public A data() {
            return this._data;
        }

        public final void apply() {
            this.apply$mcV$sp();
        }

        public final void apply$mcV$sp() {
            this._data = null;
        }

        public String debug() {
            Cell tail = (Cell)this.get();
            return new StringBuilder(4).append(this._data).append(" -> ").append(tail == null ? "[]" : tail.debug()).toString();
        }
    }
}

