/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.std;

import cats.Applicative;
import cats.Applicative$;
import cats.Functor;
import cats.Monad$;
import cats.MonadError;
import cats.arrow.FunctionK;
import cats.effect.kernel.Ref;
import cats.effect.kernel.Ref$;
import cats.effect.kernel.Sync;
import cats.effect.kernel.Sync$;
import cats.effect.std.Random$;
import cats.kernel.Monoid;
import cats.syntax.ApplicativeErrorIdOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.package;
import java.io.Serializable;
import java.util.NoSuchElementException;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Vector;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public interface Random<F> {
    public static <F> Random<F> apply(Random<F> random) {
        return Random$.MODULE$.apply(random);
    }

    public static <F, L> Random<?> catsEitherTRandom(Random<F> random, Functor<F> functor) {
        return Random$.MODULE$.catsEitherTRandom(random, functor);
    }

    public static <F, E, L, S> Random<?> catsIndexedReaderWriterStateTRandom(Random<F> random, Applicative<F> applicative, Monoid<L> monoid) {
        return Random$.MODULE$.catsIndexedReaderWriterStateTRandom(random, applicative, monoid);
    }

    public static <F, S> Random<?> catsIndexedStateTRandom(Random<F> random, Applicative<F> applicative) {
        return Random$.MODULE$.catsIndexedStateTRandom(random, applicative);
    }

    public static <F, L> Random<?> catsIorTRandom(Random<F> random, Functor<F> functor) {
        return Random$.MODULE$.catsIorTRandom(random, functor);
    }

    public static <F, R> Random<?> catsKleisliRandom(Random<F> random) {
        return Random$.MODULE$.catsKleisliRandom(random);
    }

    public static <F> Random<?> catsOptionTRandom(Random<F> random, Functor<F> functor) {
        return Random$.MODULE$.catsOptionTRandom(random, functor);
    }

    public static <F, L> Random<?> catsWriterTRandom(Random<F> random, Applicative<F> applicative, Monoid<L> monoid) {
        return Random$.MODULE$.catsWriterTRandom(random, applicative, monoid);
    }

    public static <F> Object javaSecuritySecureRandom(int n, Sync<F> sync) {
        return Random$.MODULE$.javaSecuritySecureRandom(n, sync);
    }

    public static <F> Object javaSecuritySecureRandom(Sync<F> sync) {
        return Random$.MODULE$.javaSecuritySecureRandom(sync);
    }

    public static <F> Random<F> javaUtilConcurrentThreadLocalRandom(Sync<F> sync) {
        return Random$.MODULE$.javaUtilConcurrentThreadLocalRandom(sync);
    }

    public static <F> Object javaUtilRandom(java.util.Random random, Sync<F> sync) {
        return Random$.MODULE$.javaUtilRandom(random, sync);
    }

    public static <F> Object scalaUtilRandom(Sync<F> sync) {
        return Random$.MODULE$.scalaUtilRandom(sync);
    }

    public static <F> Object scalaUtilRandomN(int n, Sync<F> sync) {
        return Random$.MODULE$.scalaUtilRandomN(n, sync);
    }

    public static <F> Object scalaUtilRandomSeedInt(int n, Sync<F> sync) {
        return Random$.MODULE$.scalaUtilRandomSeedInt(n, sync);
    }

    public static <F> Object scalaUtilRandomSeedLong(long l, Sync<F> sync) {
        return Random$.MODULE$.scalaUtilRandomSeedLong(l, sync);
    }

    public F betweenDouble(double var1, double var3);

    public F betweenFloat(float var1, float var2);

    public F betweenInt(int var1, int var2);

    public F betweenLong(long var1, long var3);

    public F nextAlphaNumeric();

    public F nextBoolean();

    public F nextBytes(int var1);

    public F nextDouble();

    public F nextFloat();

    public F nextGaussian();

    public F nextInt();

    public F nextIntBounded(int var1);

    public F nextLong();

    public F nextLongBounded(long var1);

    public F nextPrintableChar();

    public F nextString(int var1);

    public <A> F shuffleList(List<A> var1);

    public <A> F shuffleVector(Vector<A> var1);

    public static Object oneOf$(Random $this, Object x, scala.collection.immutable.Seq xs, Applicative ev) {
        return $this.oneOf(x, xs, ev);
    }

    default public <A> F oneOf(A x, scala.collection.immutable.Seq<A> xs, Applicative<F> ev) {
        if (xs.isEmpty()) {
            Object object = package.all$.MODULE$.catsSyntaxApplicativeId(x);
            return (F)ApplicativeIdOps$.MODULE$.pure$extension(object, ev);
        }
        return (F)package.all$.MODULE$.toFunctorOps(this.nextIntBounded(1 + xs.size()), ev).map((Function1 & Serializable)x$1 -> Random.oneOf$$anonfun$1(x, xs, BoxesRunTime.unboxToInt((Object)x$1)));
    }

    public static Object elementOf$(Random $this, Iterable xs, MonadError ev) {
        return $this.elementOf(xs, ev);
    }

    default public <A> F elementOf(Iterable<A> xs, MonadError<F, Throwable> ev) {
        Object object;
        if (xs.nonEmpty()) {
            BoxedUnit boxedUnit = (BoxedUnit)package.all$.MODULE$.catsSyntaxApplicativeId((Object)BoxedUnit.UNIT);
            object = ApplicativeIdOps$.MODULE$.pure$extension((Object)boxedUnit, ev);
        } else {
            NoSuchElementException noSuchElementException = (NoSuchElementException)package.all$.MODULE$.catsSyntaxApplicativeErrorId((Object)new NoSuchElementException("Cannot choose a random element of an empty collection"));
            object = ApplicativeErrorIdOps$.MODULE$.raiseError$extension((Object)noSuchElementException, ev);
        }
        Object requireNonEmpty = object;
        return (F)package.all$.MODULE$.catsSyntaxApply(requireNonEmpty, ev).$times$greater(package.all$.MODULE$.toFunctorOps(this.nextIntBounded(xs.size()), ev).map((Function1 & Serializable)i -> Random.elementOf$$anonfun$1(xs, BoxesRunTime.unboxToInt((Object)i))));
    }

    public static Random mapK$(Random $this, FunctionK f) {
        return $this.mapK(f);
    }

    default public <G> Random<G> mapK(FunctionK<F, G> f) {
        return new TranslatedRandom<F, G>(f, this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super($outer, f$1);
            }
        };
    }

    private static /* synthetic */ Object oneOf$$anonfun$1(Object x$1, scala.collection.immutable.Seq xs$1, int x$12) {
        int n = x$12;
        if (0 == n) {
            return x$1;
        }
        int i = n;
        return xs$1.apply(i - 1);
    }

    private static Object loop$1(int i$1, Iterator it, int n) {
        while (true) {
            Object next = it.next();
            if (n == i$1) {
                return next;
            }
            ++n;
        }
    }

    private static /* synthetic */ Object elementOf$$anonfun$1(Iterable xs$2, int i) {
        Iterable iterable = xs$2;
        if (iterable instanceof Seq) {
            Seq seq = (Seq)iterable;
            return seq.apply(i);
        }
        return Random.loop$1(i, xs$2.iterator(), 0);
    }

    public static abstract class RandomCommon<F>
    implements Random<F> {
        private final Sync<F> evidence$24;

        public RandomCommon(Sync<F> evidence$24) {
            this.evidence$24 = evidence$24;
        }

        @Override
        public F betweenDouble(double minInclusive, double maxExclusive) {
            return (F)package.all$.MODULE$.toFlatMapOps(this.require(minInclusive < maxExclusive, (Function0<String>)((Function0 & Serializable)this::betweenDouble$$anonfun$1)), this.evidence$24).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = x$1;
                return package.all$.MODULE$.toFunctorOps(this.nextDouble(), this.evidence$24).map((Function1)(JFunction1.mcDD.sp & Serializable)d -> {
                    double next = d * (maxExclusive - minInclusive) + minInclusive;
                    if (next < maxExclusive) {
                        return next;
                    }
                    return Math.nextAfter(maxExclusive, Double.NEGATIVE_INFINITY);
                });
            });
        }

        @Override
        public F betweenFloat(float minInclusive, float maxExclusive) {
            return (F)package.all$.MODULE$.toFlatMapOps(this.require(minInclusive < maxExclusive, (Function0<String>)((Function0 & Serializable)this::betweenFloat$$anonfun$1)), this.evidence$24).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = x$1;
                return package.all$.MODULE$.toFunctorOps(this.nextFloat(), this.evidence$24).map((Function1)(JFunction1.mcFF.sp & Serializable)f -> {
                    float next = f * (maxExclusive - minInclusive) + minInclusive;
                    if (next < maxExclusive) {
                        return next;
                    }
                    return Math.nextAfter(maxExclusive, Double.NEGATIVE_INFINITY);
                });
            });
        }

        @Override
        public F betweenInt(int minInclusive, int maxExclusive) {
            int difference = maxExclusive - minInclusive;
            return (F)package.all$.MODULE$.catsSyntaxApply(this.require(minInclusive < maxExclusive, (Function0<String>)((Function0 & Serializable)this::betweenInt$$anonfun$1)), this.evidence$24).$times$greater(package.all$.MODULE$.toFunctorOps(difference >= 0 ? package.all$.MODULE$.toFunctorOps(this.nextIntBounded(difference), this.evidence$24).map((Function1)(JFunction1.mcII.sp & Serializable)_$28 -> _$28 + minInclusive) : this.loop$2(minInclusive, maxExclusive), this.evidence$24).map((Function1)(JFunction1.mcII.sp & Serializable)out -> out));
        }

        @Override
        public F betweenLong(long minInclusive, long maxExclusive) {
            long difference = maxExclusive - minInclusive;
            return (F)package.all$.MODULE$.catsSyntaxApply(this.require(minInclusive < maxExclusive, (Function0<String>)((Function0 & Serializable)this::betweenLong$$anonfun$1)), this.evidence$24).$times$greater(package.all$.MODULE$.toFunctorOps(difference >= 0L ? package.all$.MODULE$.toFunctorOps(this.nextLongBounded(difference), this.evidence$24).map((Function1)(JFunction1.mcJJ.sp & Serializable)_$29 -> _$29 + minInclusive) : this.loop$3(minInclusive, maxExclusive), this.evidence$24).map((Function1)(JFunction1.mcJJ.sp & Serializable)out -> out));
        }

        @Override
        public F nextAlphaNumeric() {
            String chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
            return (F)package.all$.MODULE$.toFunctorOps(this.nextIntBounded(chars.length()), this.evidence$24).map((Function1 & Serializable)_$30 -> this.nextAlphaNumeric$$anonfun$1(chars, BoxesRunTime.unboxToInt((Object)_$30)));
        }

        @Override
        public F nextLongBounded(long n) {
            return (F)package.all$.MODULE$.toFlatMapOps(this.require(n > 0L, (Function0<String>)((Function0 & Serializable)() -> this.nextLongBounded$$anonfun$1(n))), this.evidence$24).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = x$1;
                Ref.Make make = Ref$.MODULE$.apply(Ref.Make$.MODULE$.syncInstance(this.evidence$24));
                return package.all$.MODULE$.toFlatMapOps(Ref.ApplyBuilders$.MODULE$.of$extension(make, (Object)BoxesRunTime.boxToLong((long)0L)), this.evidence$24).flatMap((Function1 & Serializable)offset -> {
                    Ref.Make make = Ref$.MODULE$.apply(Ref.Make$.MODULE$.syncInstance(this.evidence$24));
                    return package.all$.MODULE$.toFlatMapOps(Ref.ApplyBuilders$.MODULE$.of$extension(make, (Object)BoxesRunTime.boxToLong((long)n)), this.evidence$24).flatMap((Function1 & Serializable)_n -> package.all$.MODULE$.toFlatMapOps(Monad$.MODULE$.apply(this.evidence$24).whileM_(package.all$.MODULE$.toFunctorOps(_n.get(), this.evidence$24).map((Function1)(JFunction1.mcZJ.sp & Serializable)_$31 -> _$31 >= Integer.MAX_VALUE), () -> this.nextLongBounded$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2(offset, _n)), this.evidence$24).flatMap((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = x$1;
                        return package.all$.MODULE$.toFlatMapOps(offset.get(), this.evidence$24).flatMap((Function1 & Serializable)finalOffset -> this.nextLongBounded$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$1((Ref)_n, BoxesRunTime.unboxToLong((Object)finalOffset)));
                    }));
                });
            });
        }

        private F require(boolean condition, Function0<String> errorMessage) {
            if (condition) {
                BoxedUnit boxedUnit = (BoxedUnit)package.all$.MODULE$.catsSyntaxApplicativeId((Object)BoxedUnit.UNIT);
                return (F)ApplicativeIdOps$.MODULE$.pure$extension((Object)boxedUnit, this.evidence$24);
            }
            IllegalArgumentException illegalArgumentException = (IllegalArgumentException)package.all$.MODULE$.catsSyntaxApplicativeErrorId((Object)new IllegalArgumentException((String)errorMessage.apply()));
            return (F)ApplicativeErrorIdOps$.MODULE$.raiseError$extension((Object)illegalArgumentException, this.evidence$24);
        }

        private final String betweenDouble$$anonfun$1() {
            return "Invalid bounds";
        }

        private final String betweenFloat$$anonfun$1() {
            return "Invalid bounds";
        }

        private final String betweenInt$$anonfun$1() {
            return "Invalid bounds";
        }

        private final /* synthetic */ Object loop$2$$anonfun$1(int minInclusive$7, int maxExclusive$6, int n) {
            if (n >= minInclusive$7 && n < maxExclusive$6) {
                Integer n2 = (Integer)package.all$.MODULE$.catsSyntaxApplicativeId((Object)BoxesRunTime.boxToInteger((int)n));
                return ApplicativeIdOps$.MODULE$.pure$extension((Object)n2, this.evidence$24);
            }
            return this.loop$2(minInclusive$7, maxExclusive$6);
        }

        private final Object loop$2(int minInclusive$6, int maxExclusive$5) {
            return package.all$.MODULE$.toFlatMapOps(this.nextInt(), this.evidence$24).flatMap((Function1 & Serializable)n -> this.loop$2$$anonfun$1(minInclusive$6, maxExclusive$5, BoxesRunTime.unboxToInt((Object)n)));
        }

        private final String betweenLong$$anonfun$1() {
            return "Invalid bounds";
        }

        private final /* synthetic */ Object loop$3$$anonfun$1(long minInclusive$10, long maxExclusive$8, long n) {
            if (n >= minInclusive$10 && n < maxExclusive$8) {
                Long l = (Long)package.all$.MODULE$.catsSyntaxApplicativeId((Object)BoxesRunTime.boxToLong((long)n));
                return ApplicativeIdOps$.MODULE$.pure$extension((Object)l, this.evidence$24);
            }
            return this.loop$3(minInclusive$10, maxExclusive$8);
        }

        private final Object loop$3(long minInclusive$9, long maxExclusive$7) {
            return package.all$.MODULE$.toFlatMapOps(this.nextLong(), this.evidence$24).flatMap((Function1 & Serializable)n -> this.loop$3$$anonfun$1(minInclusive$9, maxExclusive$7, BoxesRunTime.unboxToLong((Object)n)));
        }

        private final /* synthetic */ char nextAlphaNumeric$$anonfun$1(String chars$1, int _$30) {
            return chars$1.charAt(_$30);
        }

        private final String nextLongBounded$$anonfun$1(long n$8) {
            return new StringBuilder(28).append("n must be positive, but was ").append(n$8).toString();
        }

        private final /* synthetic */ Object nextLongBounded$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1(Ref offset$6, long nextN$1, long n) {
            return offset$6.update((Function1)(JFunction1.mcJJ.sp & Serializable)_$34 -> _$34 + (n - nextN$1));
        }

        private final /* synthetic */ Object nextLongBounded$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2(Ref offset$4, Ref _n$4, int bits$2, long nextN) {
            return package.all$.MODULE$.toFlatMapOps((bits$2 & 1) == 0 ? package.all$.MODULE$.toFlatMapOps(_n$4.get(), this.evidence$24).flatMap((Function1 & Serializable)n -> this.nextLongBounded$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1(offset$4, nextN, BoxesRunTime.unboxToLong((Object)n))) : Applicative$.MODULE$.apply(this.evidence$24).unit(), this.evidence$24).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = x$12;
                return package.all$.MODULE$.toFunctorOps(_n$4.set((Object)BoxesRunTime.boxToLong((long)nextN)), this.evidence$24).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = x$1;
                });
            });
        }

        private final /* synthetic */ Object nextLongBounded$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2(Ref offset$3, Ref _n$3, int bits$1, long halfn) {
            Object object;
            if ((bits$1 & 2) == 0) {
                Long l = (Long)package.all$.MODULE$.catsSyntaxApplicativeId((Object)BoxesRunTime.boxToLong((long)halfn));
                object = ApplicativeIdOps$.MODULE$.pure$extension((Object)l, this.evidence$24);
            } else {
                object = package.all$.MODULE$.toFunctorOps(_n$3.get(), this.evidence$24).map((Function1)(JFunction1.mcJJ.sp & Serializable)_$33 -> _$33 - halfn);
            }
            return package.all$.MODULE$.toFlatMapOps(object, this.evidence$24).flatMap((Function1 & Serializable)nextN -> this.nextLongBounded$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2(offset$3, _n$3, bits$1, BoxesRunTime.unboxToLong((Object)nextN)));
        }

        private final /* synthetic */ Object nextLongBounded$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(Ref offset$2, Ref _n$2, int bits) {
            return package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(_n$2.get(), this.evidence$24).map((Function1)(JFunction1.mcJJ.sp & Serializable)_$32 -> _$32 >>> 1), this.evidence$24).flatMap((Function1 & Serializable)halfn -> this.nextLongBounded$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2(offset$2, _n$2, bits, BoxesRunTime.unboxToLong((Object)halfn)));
        }

        private final Object nextLongBounded$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2(Ref offset$1, Ref _n$1) {
            return package.all$.MODULE$.toFlatMapOps(this.nextIntBounded(2), this.evidence$24).flatMap((Function1 & Serializable)bits -> this.nextLongBounded$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(offset$1, _n$1, BoxesRunTime.unboxToInt((Object)bits)));
        }

        private final /* synthetic */ Object nextLongBounded$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$1$$anonfun$1(long l) {
            return this.nextIntBounded((int)l);
        }

        private final /* synthetic */ Object nextLongBounded$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$1(Ref _n$7, long finalOffset) {
            return package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(_n$7.get(), this.evidence$24).flatMap((Function1 & Serializable)l -> this.nextLongBounded$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToLong((Object)l))), this.evidence$24).map((Function1)(JFunction1.mcJI.sp & Serializable)n -> finalOffset + (long)n);
        }
    }

    public static abstract class ScalaRandom<F>
    extends RandomCommon<F> {
        private final F f;
        private final Sync<F> evidence$25;

        public ScalaRandom(Object f, Sync<F> evidence$25) {
            this.f = f;
            this.evidence$25 = evidence$25;
            super(evidence$25);
        }

        @Override
        public F nextBoolean() {
            return (F)package.all$.MODULE$.toFlatMapOps(this.f, this.evidence$25).flatMap((Function1 & Serializable)r -> package.all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$25).delay(() -> this.nextBoolean$$anonfun$1$$anonfun$1(r)), this.evidence$25).map((Function1 & Serializable)out -> this.nextBoolean$$anonfun$1$$anonfun$2(BoxesRunTime.unboxToBoolean((Object)out))));
        }

        @Override
        public F nextBytes(int n) {
            return (F)package.all$.MODULE$.toFlatMapOps(this.f, this.evidence$25).flatMap((Function1 & Serializable)r -> package.all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$25).delay(() -> this.nextBytes$$anonfun$1$$anonfun$1(n, r)), this.evidence$25).map((Function1 & Serializable)out -> out));
        }

        @Override
        public F nextDouble() {
            return (F)package.all$.MODULE$.toFlatMapOps(this.f, this.evidence$25).flatMap((Function1 & Serializable)r -> package.all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$25).delay(() -> this.nextDouble$$anonfun$1$$anonfun$1(r)), this.evidence$25).map((Function1)(JFunction1.mcDD.sp & Serializable)out -> out));
        }

        @Override
        public F nextFloat() {
            return (F)package.all$.MODULE$.toFlatMapOps(this.f, this.evidence$25).flatMap((Function1 & Serializable)r -> package.all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$25).delay(() -> this.nextFloat$$anonfun$1$$anonfun$1(r)), this.evidence$25).map((Function1)(JFunction1.mcFF.sp & Serializable)out -> out));
        }

        @Override
        public F nextGaussian() {
            return (F)package.all$.MODULE$.toFlatMapOps(this.f, this.evidence$25).flatMap((Function1 & Serializable)r -> package.all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$25).delay(() -> this.nextGaussian$$anonfun$1$$anonfun$1(r)), this.evidence$25).map((Function1)(JFunction1.mcDD.sp & Serializable)out -> out));
        }

        @Override
        public F nextInt() {
            return (F)package.all$.MODULE$.toFlatMapOps(this.f, this.evidence$25).flatMap((Function1 & Serializable)r -> package.all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$25).delay(() -> this.nextInt$$anonfun$1$$anonfun$1(r)), this.evidence$25).map((Function1)(JFunction1.mcII.sp & Serializable)out -> out));
        }

        @Override
        public F nextIntBounded(int n) {
            return (F)package.all$.MODULE$.toFlatMapOps(this.f, this.evidence$25).flatMap((Function1 & Serializable)r -> package.all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$25).delay(() -> this.nextIntBounded$$anonfun$1$$anonfun$1(n, r)), this.evidence$25).map((Function1)(JFunction1.mcII.sp & Serializable)out -> out));
        }

        @Override
        public F nextLong() {
            return (F)package.all$.MODULE$.toFlatMapOps(this.f, this.evidence$25).flatMap((Function1 & Serializable)r -> package.all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$25).delay(() -> this.nextLong$$anonfun$1$$anonfun$1(r)), this.evidence$25).map((Function1)(JFunction1.mcJJ.sp & Serializable)out -> out));
        }

        @Override
        public F nextPrintableChar() {
            return (F)package.all$.MODULE$.toFlatMapOps(this.f, this.evidence$25).flatMap((Function1 & Serializable)r -> package.all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$25).delay(() -> this.nextPrintableChar$$anonfun$1$$anonfun$1(r)), this.evidence$25).map((Function1 & Serializable)out -> this.nextPrintableChar$$anonfun$1$$anonfun$2(BoxesRunTime.unboxToChar((Object)out))));
        }

        @Override
        public F nextString(int length) {
            return (F)package.all$.MODULE$.toFlatMapOps(this.f, this.evidence$25).flatMap((Function1 & Serializable)r -> package.all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$25).delay(() -> this.nextString$$anonfun$1$$anonfun$1(length, r)), this.evidence$25).map((Function1 & Serializable)out -> out));
        }

        @Override
        public <A> F shuffleList(List<A> l) {
            return (F)package.all$.MODULE$.toFlatMapOps(this.f, this.evidence$25).flatMap((Function1 & Serializable)r -> package.all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$25).delay(() -> this.shuffleList$$anonfun$1$$anonfun$1(l, r)), this.evidence$25).map((Function1 & Serializable)out -> out));
        }

        @Override
        public <A> F shuffleVector(Vector<A> v) {
            return (F)package.all$.MODULE$.toFlatMapOps(this.f, this.evidence$25).flatMap((Function1 & Serializable)r -> package.all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.evidence$25).delay(() -> this.shuffleVector$$anonfun$1$$anonfun$1(v, r)), this.evidence$25).map((Function1 & Serializable)out -> out));
        }

        private final boolean nextBoolean$$anonfun$1$$anonfun$1(scala.util.Random r$1) {
            return r$1.nextBoolean();
        }

        private final /* synthetic */ boolean nextBoolean$$anonfun$1$$anonfun$2(boolean out) {
            return out;
        }

        private final byte[] nextBytes$$anonfun$1$$anonfun$1(int n$13, scala.util.Random r$2) {
            byte[] bytes = new byte[RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(0), n$13)];
            r$2.nextBytes(bytes);
            return bytes;
        }

        private final double nextDouble$$anonfun$1$$anonfun$1(scala.util.Random r$3) {
            return r$3.nextDouble();
        }

        private final float nextFloat$$anonfun$1$$anonfun$1(scala.util.Random r$4) {
            return r$4.nextFloat();
        }

        private final double nextGaussian$$anonfun$1$$anonfun$1(scala.util.Random r$5) {
            return r$5.nextGaussian();
        }

        private final int nextInt$$anonfun$1$$anonfun$1(scala.util.Random r$6) {
            return r$6.nextInt();
        }

        private final int nextIntBounded$$anonfun$1$$anonfun$1(int n$14, scala.util.Random r$7) {
            return r$7.self().nextInt(n$14);
        }

        private final long nextLong$$anonfun$1$$anonfun$1(scala.util.Random r$8) {
            return r$8.nextLong();
        }

        private final char nextPrintableChar$$anonfun$1$$anonfun$1(scala.util.Random r$9) {
            return r$9.nextPrintableChar();
        }

        private final /* synthetic */ char nextPrintableChar$$anonfun$1$$anonfun$2(char out) {
            return out;
        }

        private final String nextString$$anonfun$1$$anonfun$1(int length$1, scala.util.Random r$10) {
            return r$10.nextString(length$1);
        }

        private final List shuffleList$$anonfun$1$$anonfun$1(List l$1, scala.util.Random r$11) {
            return (List)r$11.shuffle((IterableOnce)l$1, BuildFrom$.MODULE$.buildFromIterableOps());
        }

        private final Vector shuffleVector$$anonfun$1$$anonfun$1(Vector v$1, scala.util.Random r$12) {
            return (Vector)r$12.shuffle((IterableOnce)v$1, BuildFrom$.MODULE$.buildFromIterableOps());
        }
    }

    public static abstract class ThreadLocalRandom<F>
    extends RandomCommon<F> {
        private final Sync<F> evidence$26;

        public ThreadLocalRandom(Sync<F> evidence$26) {
            this.evidence$26 = evidence$26;
            super(evidence$26);
        }

        @Override
        public F nextBoolean() {
            return (F)Sync$.MODULE$.apply(this.evidence$26).delay(this::nextBoolean$$anonfun$2);
        }

        @Override
        public F nextBytes(int n) {
            return (F)Sync$.MODULE$.apply(this.evidence$26).delay(() -> this.nextBytes$$anonfun$2(n));
        }

        @Override
        public F nextDouble() {
            return (F)Sync$.MODULE$.apply(this.evidence$26).delay(this::nextDouble$$anonfun$2);
        }

        @Override
        public F nextFloat() {
            return (F)Sync$.MODULE$.apply(this.evidence$26).delay(this::nextFloat$$anonfun$2);
        }

        @Override
        public F nextGaussian() {
            return (F)Sync$.MODULE$.apply(this.evidence$26).delay(this::nextGaussian$$anonfun$2);
        }

        @Override
        public F nextInt() {
            return (F)Sync$.MODULE$.apply(this.evidence$26).delay(this::nextInt$$anonfun$2);
        }

        @Override
        public F nextIntBounded(int n) {
            return (F)Sync$.MODULE$.apply(this.evidence$26).delay(() -> this.nextIntBounded$$anonfun$2(n));
        }

        @Override
        public F nextLong() {
            return (F)Sync$.MODULE$.apply(this.evidence$26).delay(this::nextLong$$anonfun$2);
        }

        @Override
        public F nextPrintableChar() {
            return (F)Sync$.MODULE$.apply(this.evidence$26).delay(this::nextPrintableChar$$anonfun$2);
        }

        @Override
        public F nextString(int length) {
            return (F)Sync$.MODULE$.apply(this.evidence$26).delay(() -> this.nextString$$anonfun$2(length));
        }

        @Override
        public <A> F shuffleList(List<A> l) {
            return (F)Sync$.MODULE$.apply(this.evidence$26).delay(() -> this.shuffleList$$anonfun$2(l));
        }

        @Override
        public <A> F shuffleVector(Vector<A> v) {
            return (F)Sync$.MODULE$.apply(this.evidence$26).delay(() -> this.shuffleVector$$anonfun$2(v));
        }

        private final boolean nextBoolean$$anonfun$2() {
            return Random$.MODULE$.cats$effect$std$Random$$$localRandom().nextBoolean();
        }

        private final byte[] nextBytes$$anonfun$2(int n$16) {
            byte[] bytes = new byte[RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(0), n$16)];
            Random$.MODULE$.cats$effect$std$Random$$$localRandom().nextBytes(bytes);
            return bytes;
        }

        private final double nextDouble$$anonfun$2() {
            return Random$.MODULE$.cats$effect$std$Random$$$localRandom().nextDouble();
        }

        private final float nextFloat$$anonfun$2() {
            return Random$.MODULE$.cats$effect$std$Random$$$localRandom().nextFloat();
        }

        private final double nextGaussian$$anonfun$2() {
            return Random$.MODULE$.cats$effect$std$Random$$$localRandom().nextGaussian();
        }

        private final int nextInt$$anonfun$2() {
            return Random$.MODULE$.cats$effect$std$Random$$$localRandom().nextInt();
        }

        private final int nextIntBounded$$anonfun$2(int n$17) {
            return Random$.MODULE$.cats$effect$std$Random$$$localRandom().self().nextInt(n$17);
        }

        private final long nextLong$$anonfun$2() {
            return Random$.MODULE$.cats$effect$std$Random$$$localRandom().nextLong();
        }

        private final char nextPrintableChar$$anonfun$2() {
            return Random$.MODULE$.cats$effect$std$Random$$$localRandom().nextPrintableChar();
        }

        private final String nextString$$anonfun$2(int length$3) {
            return Random$.MODULE$.cats$effect$std$Random$$$localRandom().nextString(length$3);
        }

        private final List shuffleList$$anonfun$2(List l$3) {
            return (List)Random$.MODULE$.cats$effect$std$Random$$$localRandom().shuffle((IterableOnce)l$3, BuildFrom$.MODULE$.buildFromIterableOps());
        }

        private final Vector shuffleVector$$anonfun$2(Vector v$3) {
            return (Vector)Random$.MODULE$.cats$effect$std$Random$$$localRandom().shuffle((IterableOnce)v$3, BuildFrom$.MODULE$.buildFromIterableOps());
        }
    }

    public static abstract class TranslatedRandom<F, G>
    implements Random<G> {
        private final Random<F> self;
        private final FunctionK<F, G> f;

        public TranslatedRandom(Random<F> self, FunctionK<F, G> f) {
            this.self = self;
            this.f = f;
        }

        @Override
        public G betweenDouble(double minInclusive, double maxExclusive) {
            return (G)this.f.apply(this.self.betweenDouble(minInclusive, maxExclusive));
        }

        @Override
        public G betweenFloat(float minInclusive, float maxExclusive) {
            return (G)this.f.apply(this.self.betweenFloat(minInclusive, maxExclusive));
        }

        @Override
        public G betweenInt(int minInclusive, int maxExclusive) {
            return (G)this.f.apply(this.self.betweenInt(minInclusive, maxExclusive));
        }

        @Override
        public G betweenLong(long minInclusive, long maxExclusive) {
            return (G)this.f.apply(this.self.betweenLong(minInclusive, maxExclusive));
        }

        @Override
        public G nextAlphaNumeric() {
            return (G)this.f.apply(this.self.nextAlphaNumeric());
        }

        @Override
        public G nextBoolean() {
            return (G)this.f.apply(this.self.nextBoolean());
        }

        @Override
        public G nextBytes(int n) {
            return (G)this.f.apply(this.self.nextBytes(n));
        }

        @Override
        public G nextDouble() {
            return (G)this.f.apply(this.self.nextDouble());
        }

        @Override
        public G nextFloat() {
            return (G)this.f.apply(this.self.nextFloat());
        }

        @Override
        public G nextGaussian() {
            return (G)this.f.apply(this.self.nextGaussian());
        }

        @Override
        public G nextInt() {
            return (G)this.f.apply(this.self.nextInt());
        }

        @Override
        public G nextIntBounded(int n) {
            return (G)this.f.apply(this.self.nextIntBounded(n));
        }

        @Override
        public G nextLong() {
            return (G)this.f.apply(this.self.nextLong());
        }

        @Override
        public G nextLongBounded(long n) {
            return (G)this.f.apply(this.self.nextLongBounded(n));
        }

        @Override
        public G nextPrintableChar() {
            return (G)this.f.apply(this.self.nextPrintableChar());
        }

        @Override
        public G nextString(int length) {
            return (G)this.f.apply(this.self.nextString(length));
        }

        @Override
        public <A> G shuffleList(List<A> l) {
            return (G)this.f.apply(this.self.shuffleList(l));
        }

        @Override
        public <A> G shuffleVector(Vector<A> v) {
            return (G)this.f.apply(this.self.shuffleVector(v));
        }
    }
}

