/*
 * Decompiled with CFR 0.152.
 */
package com.comcast.ip4s;

import cats.kernel.Order;
import com.comcast.ip4s.Cidr;
import com.comcast.ip4s.Cidr$;
import com.comcast.ip4s.Dns;
import com.comcast.ip4s.Host;
import com.comcast.ip4s.IpAddress$;
import com.comcast.ip4s.IpAddressPlatform;
import com.comcast.ip4s.IpVersion;
import com.comcast.ip4s.IpVersion$V4$;
import com.comcast.ip4s.IpVersion$V6$;
import com.comcast.ip4s.Ipv4Address;
import com.comcast.ip4s.Ipv6Address;
import com.comcast.ip4s.Ipv6Address$;
import com.comcast.ip4s.Multicast;
import com.comcast.ip4s.Multicast$;
import com.comcast.ip4s.SourceSpecificMulticast;
import com.comcast.ip4s.SourceSpecificMulticast$;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Arrays;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.math.Ordered;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;

public abstract class IpAddress
implements IpAddressPlatform,
Ordered,
Host,
Serializable {
    public static int compareBytes(IpAddress ipAddress, IpAddress ipAddress2) {
        return IpAddress$.MODULE$.compareBytes(ipAddress, ipAddress2);
    }

    public static Option<IpAddress> fromBytes(byte[] byArray) {
        return IpAddress$.MODULE$.fromBytes(byArray);
    }

    public static IpAddress fromInetAddress(InetAddress inetAddress) {
        return IpAddress$.MODULE$.fromInetAddress(inetAddress);
    }

    public static Option<IpAddress> fromString(String string) {
        return IpAddress$.MODULE$.fromString(string);
    }

    public static <F> Object loopback(Dns<F> dns) {
        return IpAddress$.MODULE$.loopback(dns);
    }

    public static <A extends IpAddress> Order<A> order() {
        return IpAddress$.MODULE$.order();
    }

    public static <A extends IpAddress> Ordering<A> ordering() {
        return IpAddress$.MODULE$.ordering();
    }

    public IpAddress() {
        Ordered.$init$((Ordered)this);
    }

    public abstract byte[] bytes();

    public byte[] toBytes() {
        return (byte[])this.bytes().clone();
    }

    public abstract <A> A fold(Function1<Ipv4Address, A> var1, Function1<Ipv6Address, A> var2);

    public abstract IpAddress transform(Function1<Ipv4Address, Ipv4Address> var1, Function1<Ipv6Address, Ipv6Address> var2);

    public abstract boolean isMulticast();

    public Option<Multicast<IpAddress>> asMulticast() {
        return Multicast$.MODULE$.fromIpAddress(this);
    }

    public abstract boolean isSourceSpecificMulticast();

    public Option<SourceSpecificMulticast.Strict<IpAddress>> asSourceSpecificMulticast() {
        return SourceSpecificMulticast$.MODULE$.fromIpAddress(this);
    }

    public Option<SourceSpecificMulticast<IpAddress>> asSourceSpecificMulticastLenient() {
        return SourceSpecificMulticast$.MODULE$.fromIpAddressLenient(this);
    }

    public abstract boolean isLoopback();

    public abstract boolean isLinkLocal();

    public abstract boolean isPrivate();

    public Option<Ipv4Address> asIpv4() {
        return (Option)this.collapseMappedV4().fold((Function1 & Serializable)_$8 -> Some$.MODULE$.apply(_$8), (Function1 & Serializable)_$9 -> None$.MODULE$);
    }

    public Option<Ipv6Address> asIpv6() {
        return (Option)this.fold((Function1 & Serializable)_$10 -> None$.MODULE$, (Function1 & Serializable)_$11 -> Some$.MODULE$.apply(_$11));
    }

    public IpVersion version() {
        return (IpVersion)this.fold((Function1 & Serializable)_$12 -> IpVersion$V4$.MODULE$, (Function1 & Serializable)_$13 -> IpVersion$V6$.MODULE$);
    }

    public boolean isMappedV4() {
        return BoxesRunTime.unboxToBoolean((Object)this.fold((Function1 & Serializable)_$14 -> false, Ipv6Address$.MODULE$.MappedV4Block().contains()));
    }

    public IpAddress collapseMappedV4() {
        return (IpAddress)this.fold((Function1 & Serializable)x -> (IpAddress)Predef$.MODULE$.identity(x), (Function1 & Serializable)v6 -> {
            if (v6.isMappedV4()) {
                Object object = Predef$.MODULE$.byteArrayOps(v6.toBytes());
                return (IpAddress)IpAddress$.MODULE$.fromBytes((byte[])ArrayOps$.MODULE$.takeRight$extension(object, 4)).get();
            }
            return v6;
        });
    }

    public Cidr<IpAddress> $div(int prefixBits) {
        return Cidr$.MODULE$.apply(this, prefixBits);
    }

    public int prefixBits() {
        return BoxesRunTime.unboxToInt(this.fold((Function1 & Serializable)m -> Long.numberOfLeadingZeros((m.toLong() | 0xFFFFFFFF00000000L) ^ 0xFFFFFFFFFFFFFFFFL) - 32, (Function1 & Serializable)m -> {
            long upper = m.toBigInt().$greater$greater(64).toLong();
            int upperNum = Long.numberOfLeadingZeros(upper ^ 0xFFFFFFFFFFFFFFFFL);
            if (upperNum == 64) {
                return upperNum + Long.numberOfLeadingZeros(m.toBigInt().toLong() ^ 0xFFFFFFFFFFFFFFFFL);
            }
            return upperNum;
        }));
    }

    public abstract IpAddress next();

    public abstract IpAddress previous();

    public abstract String toDefaultString();

    public abstract String toUriString();

    public final String toString() {
        return this.toDefaultString();
    }

    public boolean equals(Object other) {
        Object object = other;
        if (object instanceof IpAddress) {
            IpAddress that = (IpAddress)object;
            return Arrays.equals(this.bytes(), that.bytes());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes());
    }
}

