/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.ember.core.h2;

import cats.data.NonEmptyList;
import cats.effect.kernel.Async;
import cats.effect.std.Mutex;
import com.twitter.hpack.Decoder;
import com.twitter.hpack.Encoder;
import java.io.ByteArrayOutputStream;
import org.http4s.ember.core.h2.Hpack$;
import scala.Tuple3;
import scala.collection.immutable.List;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public interface Hpack<F> {
    public static <F> Object create(Async<F> async) {
        return Hpack$.MODULE$.create(async);
    }

    public F encodeHeaders(NonEmptyList<Tuple3<String, String, Object>> var1);

    public F decodeHeaders(ByteVector var1);

    public static final class ByteVectorOutputStream
    extends ByteArrayOutputStream {
        public ByteVectorOutputStream(int size) {
            super(size);
        }

        public ByteVector toByteVector() {
            return ByteVector$.MODULE$.view(this.buf, 0, this.count);
        }
    }

    public static class Impl<F>
    implements Hpack<F> {
        private final Mutex<F> encodeLock;
        private final Encoder tEncoder;
        private final Mutex<F> decodeLock;
        private final Decoder tDecoder;
        private final Async<F> evidence$1;

        public Impl(Mutex<F> encodeLock, Encoder tEncoder, Mutex<F> decodeLock, Decoder tDecoder, Async<F> evidence$1) {
            this.encodeLock = encodeLock;
            this.tEncoder = tEncoder;
            this.decodeLock = decodeLock;
            this.tDecoder = tDecoder;
            this.evidence$1 = evidence$1;
        }

        @Override
        public F encodeHeaders(NonEmptyList<Tuple3<String, String, Object>> headers) {
            return (F)this.encodeLock.lock().surround(Hpack$.MODULE$.encodeHeaders(this.tEncoder, (List<Tuple3<String, String, Object>>)headers.toList(), this.evidence$1), this.evidence$1);
        }

        @Override
        public F decodeHeaders(ByteVector bv) {
            return (F)this.decodeLock.lock().surround(Hpack$.MODULE$.decodeHeaders(this.tDecoder, bv, this.evidence$1), this.evidence$1);
        }
    }
}

