/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.ember.core.h2;

import cats.Applicative$;
import cats.Foldable;
import cats.Monad;
import cats.UnorderedFoldable$;
import cats.data.NonEmptyList;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.Ref;
import cats.effect.package$;
import cats.effect.std.Queue;
import cats.kernel.Eq;
import cats.kernel.Eq$;
import cats.syntax.ApplicativeByNameOps$;
import cats.syntax.ApplicativeErrorIdOps$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplyOps$;
import cats.syntax.EitherObjectOps$;
import cats.syntax.FlatMapOps$;
import cats.syntax.ListOps$;
import cats.syntax.MonadErrorRethrowOps$;
import cats.syntax.package;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import fs2.concurrent.Channel;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.CancellationException;
import org.http4s.Header;
import org.http4s.Headers;
import org.http4s.Headers$;
import org.http4s.Message;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.ember.core.h2.H2Connection;
import org.http4s.ember.core.h2.H2Connection$ConnectionType$Client$;
import org.http4s.ember.core.h2.H2Connection$ConnectionType$Server$;
import org.http4s.ember.core.h2.H2Error;
import org.http4s.ember.core.h2.H2Error$CompressionError$;
import org.http4s.ember.core.h2.H2Error$FlowControlError$;
import org.http4s.ember.core.h2.H2Error$InternalError$;
import org.http4s.ember.core.h2.H2Error$ProtocolError$;
import org.http4s.ember.core.h2.H2Error$StreamClosed$;
import org.http4s.ember.core.h2.H2Frame;
import org.http4s.ember.core.h2.H2Frame$Data$;
import org.http4s.ember.core.h2.H2Frame$Headers$;
import org.http4s.ember.core.h2.H2Frame$PushPromise$;
import org.http4s.ember.core.h2.H2Frame$WindowUpdate$;
import org.http4s.ember.core.h2.H2Keys$;
import org.http4s.ember.core.h2.H2Stream$State$;
import org.http4s.ember.core.h2.H2Stream$StreamState$;
import org.http4s.ember.core.h2.H2Stream$StreamState$Closed$;
import org.http4s.ember.core.h2.H2Stream$StreamState$HalfClosedLocal$;
import org.http4s.ember.core.h2.H2Stream$StreamState$HalfClosedRemote$;
import org.http4s.ember.core.h2.H2Stream$StreamState$Idle$;
import org.http4s.ember.core.h2.H2Stream$StreamState$Open$;
import org.http4s.ember.core.h2.H2Stream$StreamState$ReservedLocal$;
import org.http4s.ember.core.h2.H2Stream$StreamState$ReservedRemote$;
import org.http4s.ember.core.h2.Hpack;
import org.http4s.ember.core.h2.PseudoHeaders$;
import org.typelevel.log4cats.Logger;
import org.typelevel.vault.DeleteKey;
import org.typelevel.vault.LookupKey;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.NotGiven$;
import scala.util.Right;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public class H2Stream<F> {
    private final int id;
    private final H2Frame.Settings.ConnectionSettings localSettings;
    private final H2Connection.ConnectionType connectionType;
    private final Object remoteSettings;
    private final Ref state;
    private final Hpack hpack;
    private final Queue enqueue;
    private final Object onClosed;
    private final Function1 goAway;
    public final Logger<F> org$http4s$ember$core$h2$H2Stream$$logger;
    public final GenConcurrent<F, Throwable> org$http4s$ember$core$h2$H2Stream$$evidence$1;

    public H2Stream(int id, H2Frame.Settings.ConnectionSettings localSettings, H2Connection.ConnectionType connectionType, Object remoteSettings, Ref<F, State<F>> state, Hpack<F> hpack, Queue<F, Chunk<H2Frame>> enqueue, Object onClosed, Function1<H2Error, Object> goAway, Logger<F> logger, GenConcurrent<F, Throwable> evidence$1) {
        this.id = id;
        this.localSettings = localSettings;
        this.connectionType = connectionType;
        this.remoteSettings = remoteSettings;
        this.state = state;
        this.hpack = hpack;
        this.enqueue = enqueue;
        this.onClosed = onClosed;
        this.goAway = goAway;
        this.org$http4s$ember$core$h2$H2Stream$$logger = logger;
        this.org$http4s$ember$core$h2$H2Stream$$evidence$1 = evidence$1;
    }

    public int id() {
        return this.id;
    }

    public F remoteSettings() {
        return (F)this.remoteSettings;
    }

    public Ref<F, State<F>> state() {
        return this.state;
    }

    public Hpack<F> hpack() {
        return this.hpack;
    }

    public Queue<F, Chunk<H2Frame>> enqueue() {
        return this.enqueue;
    }

    public F onClosed() {
        return (F)this.onClosed;
    }

    public Function1<H2Error, F> goAway() {
        return this.goAway;
    }

    public F sendPushPromise(int originating, NonEmptyList<Tuple3<String, String, Object>> headers) {
        H2Connection.ConnectionType connectionType = this.connectionType;
        if (H2Connection$ConnectionType$Server$.MODULE$.equals(connectionType)) {
            return (F)package.all$.MODULE$.toFlatMapOps(this.state().get(), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).flatMap((Function1 & Serializable)s -> {
                StreamState streamState = s.state();
                if (H2Stream$StreamState$Idle$.MODULE$.equals(streamState)) {
                    return package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(this.hpack().encodeHeaders(headers), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).map((Function1 & Serializable)h -> {
                        H2Frame.PushPromise frame = H2Frame$PushPromise$.MODULE$.apply(originating, true, this.id(), (ByteVector)h, (Option<ByteVector>)None$.MODULE$);
                        return Tuple2$.MODULE$.apply(h, (Object)frame);
                    }), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).flatMap((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            ByteVector h = (ByteVector)tuple2._1();
                            H2Frame.PushPromise frame = (H2Frame.PushPromise)tuple2._2();
                            return package.all$.MODULE$.toFlatMapOps(this.state().update((Function1 & Serializable)s -> s.copy(H2Stream$StreamState$ReservedLocal$.MODULE$, s.copy$default$2(), s.copy$default$3(), s.copy$default$4(), s.copy$default$5(), s.copy$default$6(), s.copy$default$7(), s.copy$default$8(), s.copy$default$9())), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).flatMap((Function1 & Serializable)x$12 -> {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return package.all$.MODULE$.toFunctorOps(this.enqueue().offer((Object)Chunk$.MODULE$.singleton((Object)frame)), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                });
                            });
                        }
                        throw new MatchError((Object)tuple2);
                    });
                }
                IllegalStateException illegalStateException = (IllegalStateException)package.all$.MODULE$.catsSyntaxApplicativeErrorId((Object)new IllegalStateException("Push Promises are only allowed on an idle Stream"));
                return ApplicativeErrorIdOps$.MODULE$.raiseError$extension((Object)illegalStateException, this.org$http4s$ember$core$h2$H2Stream$$evidence$1);
            });
        }
        if (H2Connection$ConnectionType$Client$.MODULE$.equals(connectionType)) {
            IllegalStateException illegalStateException = (IllegalStateException)package.all$.MODULE$.catsSyntaxApplicativeErrorId((Object)new IllegalStateException("Clients Are Not Allowed To Send PushPromises"));
            return (F)ApplicativeErrorIdOps$.MODULE$.raiseError$extension((Object)illegalStateException, this.org$http4s$ember$core$h2$H2Stream$$evidence$1);
        }
        throw new MatchError((Object)connectionType);
    }

    public F sendMessageBody(Message<F> mess) {
        boolean noTrailers = !mess.attributes().contains((DeleteKey)Message.Keys$.MODULE$.TrailerHeaders());
        Object maxFrameSize2 = package.all$.MODULE$.toFunctorOps(this.remoteSettings(), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).map((Function1 & Serializable)_$2 -> _$2.maxFrameSize().frameSize());
        return (F)package.all$.MODULE$.toFlatMapOps(maxFrameSize2, this.org$http4s$ember$core$h2$H2Stream$$evidence$1).flatMap((Function1 & Serializable)maxFrameSize -> this.sendMessageBody$$anonfun$1(mess, noTrailers, BoxesRunTime.unboxToInt((Object)maxFrameSize)));
    }

    public F sendTrailerHeaders(Message<F> mess) {
        Option option = mess.attributes().lookup((LookupKey)Message.Keys$.MODULE$.TrailerHeaders());
        if (None$.MODULE$.equals(option)) {
            return (F)Applicative$.MODULE$.apply(this.org$http4s$ember$core$h2$H2Stream$$evidence$1).unit();
        }
        if (option instanceof Some) {
            Object fhs = ((Some)option).value();
            return (F)package.all$.MODULE$.toFlatMapOps(fhs, this.org$http4s$ember$core$h2$H2Stream$$evidence$1).flatMap((Function1 & Serializable)hs -> this.sendTrailerHeaders$$anonfun$1(hs == null ? null : ((Headers)hs).headers()));
        }
        throw new MatchError((Object)option);
    }

    public F sendHeaders(NonEmptyList<Tuple3<String, String, Object>> headers, boolean endStream) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.state().get(), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).flatMap((Function1 & Serializable)s -> {
            StreamState streamState = s.state();
            if (H2Stream$StreamState$Idle$.MODULE$.equals(streamState) || H2Stream$StreamState$HalfClosedRemote$.MODULE$.equals(streamState) || H2Stream$StreamState$Open$.MODULE$.equals(streamState) || H2Stream$StreamState$ReservedLocal$.MODULE$.equals(streamState)) {
                Object object = package.all$.MODULE$.catsSyntaxApplyOps(package.all$.MODULE$.toFlatMapOps(this.hpack().encodeHeaders(headers), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).flatMap((Function1 & Serializable)bv -> {
                    H2Frame.Headers f = H2Frame$Headers$.MODULE$.apply(this.id(), (Option<H2Frame.Headers.StreamDependency>)None$.MODULE$, endStream, true, (ByteVector)bv, (Option<ByteVector>)None$.MODULE$);
                    return this.enqueue().offer((Object)Chunk$.MODULE$.singleton((Object)f));
                }));
                return ApplyOps$.MODULE$.$less$times$extension(object, package.all$.MODULE$.toFlatMapOps(this.state().modify(arg_0 -> H2Stream.sendHeaders$$anonfun$1$$anonfun$2(endStream, arg_0)), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).flatMap((Function1 & Serializable)state -> {
                    StreamState streamState = state;
                    H2Stream$StreamState$Closed$ h2Stream$StreamState$Closed$ = H2Stream$StreamState$Closed$.MODULE$;
                    if (!(streamState != null ? !streamState.equals(h2Stream$StreamState$Closed$) : h2Stream$StreamState$Closed$ != null)) {
                        return this.onClosed();
                    }
                    return Applicative$.MODULE$.apply(this.org$http4s$ember$core$h2$H2Stream$$evidence$1).unit();
                }), this.org$http4s$ember$core$h2$H2Stream$$evidence$1);
            }
            IllegalStateException illegalStateException = (IllegalStateException)package.all$.MODULE$.catsSyntaxApplicativeErrorId((Object)new IllegalStateException("Stream Was Closed"));
            return ApplicativeErrorIdOps$.MODULE$.raiseError$extension((Object)illegalStateException, this.org$http4s$ember$core$h2$H2Stream$$evidence$1);
        });
    }

    public F sendData(ByteVector bv, boolean endStream) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.state().get(), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).flatMap((Function1 & Serializable)s2 -> {
            StreamState streamState = s2.state();
            if (H2Stream$StreamState$Open$.MODULE$.equals(streamState) || H2Stream$StreamState$HalfClosedRemote$.MODULE$.equals(streamState)) {
                if ((int)bv.size() <= s2.writeWindow() && s2.writeWindow() > 0) {
                    Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(this.enqueue().offer((Object)Chunk$.MODULE$.singleton((Object)H2Frame$Data$.MODULE$.apply(this.id(), bv, (Option<ByteVector>)None$.MODULE$, endStream))), this.org$http4s$ember$core$h2$H2Stream$$evidence$1);
                    return FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.sendData$$anonfun$1$$anonfun$1(endStream, bv), this.org$http4s$ember$core$h2$H2Stream$$evidence$1);
                }
                if (s2.writeWindow() > 0) {
                    return package.all$.MODULE$.toFlatMapOps(this.state().modify((Function1 & Serializable)s -> {
                        ByteVector head = bv.take(Int$.MODULE$.int2long(s.writeWindow()));
                        ByteVector tail = bv.drop(Int$.MODULE$.int2long(s.writeWindow()));
                        int n = s.writeWindow() - (int)head.size();
                        StreamState streamState = s.copy$default$1();
                        Deferred deferred = s.copy$default$3();
                        int n2 = s.copy$default$4();
                        Deferred deferred2 = s.copy$default$5();
                        Deferred deferred3 = s.copy$default$6();
                        Deferred deferred4 = s.copy$default$7();
                        Channel channel = s.copy$default$8();
                        Option<Tuple2<Object, Object>> option = s.copy$default$9();
                        return Tuple2$.MODULE$.apply(s.copy(streamState, n, deferred, n2, deferred2, deferred3, deferred4, channel, option), (Object)Tuple2$.MODULE$.apply((Object)head, (Object)tail));
                    }), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).flatMap((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            ByteVector head = (ByteVector)tuple2._1();
                            ByteVector tail = (ByteVector)tuple2._2();
                            H2Frame.Data frame = H2Frame$Data$.MODULE$.apply(this.id(), head, (Option<ByteVector>)None$.MODULE$, false);
                            Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(this.enqueue().offer((Object)Chunk$.MODULE$.singleton((Object)frame)), this.org$http4s$ember$core$h2$H2Stream$$evidence$1);
                            return FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.sendData$$anonfun$1$$anonfun$3$$anonfun$1(tail, endStream), this.org$http4s$ember$core$h2$H2Stream$$evidence$1);
                        }
                        throw new MatchError((Object)tuple2);
                    });
                }
                Object object = package.all$.MODULE$.catsSyntaxMonadErrorRethrow(s2.writeBlock().get(), this.org$http4s$ember$core$h2$H2Stream$$evidence$1);
                Object object2 = package.all$.MODULE$.catsSyntaxFlatMapOps(MonadErrorRethrowOps$.MODULE$.rethrow$extension(object, this.org$http4s$ember$core$h2$H2Stream$$evidence$1), this.org$http4s$ember$core$h2$H2Stream$$evidence$1);
                return FlatMapOps$.MODULE$.$greater$greater$extension(object2, () -> this.sendData$$anonfun$1$$anonfun$4(bv, endStream), this.org$http4s$ember$core$h2$H2Stream$$evidence$1);
            }
            IllegalStateException illegalStateException = (IllegalStateException)package.all$.MODULE$.catsSyntaxApplicativeErrorId((Object)new IllegalStateException("Stream Was Closed"));
            return ApplicativeErrorIdOps$.MODULE$.raiseError$extension((Object)illegalStateException, this.org$http4s$ember$core$h2$H2Stream$$evidence$1);
        });
    }

    public F receiveHeaders(H2Frame.Headers headers, Seq<H2Frame.Continuation> continuations) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.state().get(), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).flatMap((Function1 & Serializable)s -> {
            StreamState streamState = s.state();
            if (H2Stream$StreamState$Open$.MODULE$.equals(streamState) || H2Stream$StreamState$HalfClosedLocal$.MODULE$.equals(streamState) || H2Stream$StreamState$Idle$.MODULE$.equals(streamState) || H2Stream$StreamState$ReservedRemote$.MODULE$.equals(streamState)) {
                ByteVector block = headers.headerBlock().$plus$plus((ByteVector)continuations.foldLeft((Object)ByteVector$.MODULE$.empty(), (Function2 & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 != null) {
                        ByteVector acc = (ByteVector)tuple2._1();
                        H2Frame.Continuation cont = (H2Frame.Continuation)tuple2._2();
                        return acc.$plus$plus(cont.headerBlockFragment());
                    }
                    throw new MatchError((Object)tuple2);
                }));
                Object object = package.all$.MODULE$.catsSyntaxApplicativeError(this.hpack().decodeHeaders(block), this.org$http4s$ember$core$h2$H2Stream$$evidence$1);
                return package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.onError$extension(object, (PartialFunction)new Serializable(this){
                    private final /* synthetic */ H2Stream $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public final boolean isDefinedAt(Throwable x) {
                        Throwable throwable;
                        Throwable e = throwable = x;
                        return true;
                    }

                    public final Object applyOrElse(Throwable x, Function1 function1) {
                        Throwable throwable;
                        Throwable e = throwable = x;
                        Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(this.$outer.org$http4s$ember$core$h2$H2Stream$$logger.error(e, H2Stream::org$http4s$ember$core$h2$H2Stream$$anon$2$$_$applyOrElse$$anonfun$1), this.$outer.org$http4s$ember$core$h2$H2Stream$$evidence$1);
                        return FlatMapOps$.MODULE$.$greater$greater$extension(object, this::applyOrElse$$anonfun$2, this.$outer.org$http4s$ember$core$h2$H2Stream$$evidence$1);
                    }

                    private final Object applyOrElse$$anonfun$2() {
                        return this.$outer.goAway().apply((Object)H2Error$CompressionError$.MODULE$);
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$http4s$ember$core$h2$H2Stream$$anon$2$$_$applyOrElse$$anonfun$1(), applyOrElse$$anonfun$2()}, serializedLambda);
                    }
                }, this.org$http4s$ember$core$h2$H2Stream$$evidence$1), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).map((Function1 & Serializable)h -> {
                    StreamState streamState;
                    if (headers.endStream()) {
                        StreamState streamState2 = s.state();
                        if (H2Stream$StreamState$Open$.MODULE$.equals(streamState2)) {
                            streamState = H2Stream$StreamState$HalfClosedRemote$.MODULE$;
                        } else if (H2Stream$StreamState$Idle$.MODULE$.equals(streamState2)) {
                            streamState = H2Stream$StreamState$HalfClosedRemote$.MODULE$;
                        } else if (H2Stream$StreamState$HalfClosedLocal$.MODULE$.equals(streamState2)) {
                            streamState = H2Stream$StreamState$Closed$.MODULE$;
                        } else if (H2Stream$StreamState$ReservedRemote$.MODULE$.equals(streamState2)) {
                            streamState = H2Stream$StreamState$Closed$.MODULE$;
                        } else {
                            StreamState s = streamState2;
                            streamState = s;
                        }
                    } else {
                        StreamState streamState3 = s.state();
                        if (H2Stream$StreamState$Idle$.MODULE$.equals(streamState3)) {
                            streamState = H2Stream$StreamState$Open$.MODULE$;
                        } else if (H2Stream$StreamState$ReservedRemote$.MODULE$.equals(streamState3)) {
                            streamState = H2Stream$StreamState$HalfClosedLocal$.MODULE$;
                        } else {
                            StreamState s = streamState3;
                            streamState = s;
                        }
                    }
                    StreamState newstate = streamState;
                    return Tuple2$.MODULE$.apply(h, (Object)newstate);
                }), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).flatMap((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        NonEmptyList h = (NonEmptyList)tuple2._1();
                        StreamState newstate = (StreamState)tuple2._2();
                        return package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(this.state().modify((Function1 & Serializable)s -> Tuple2$.MODULE$.apply(s.copy(newstate, s.copy$default$2(), s.copy$default$3(), s.copy$default$4(), s.copy$default$5(), s.copy$default$6(), s.copy$default$7(), s.copy$default$8(), s.copy$default$9()), (Object)Tuple2$.MODULE$.apply(s.request(), s.response()))), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).map((Function1 & Serializable)t -> {
                            Tuple2 tuple2 = t;
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            Deferred request = (Deferred)tuple2._1();
                            Deferred response = (Deferred)tuple2._2();
                            Tuple2 $1$ = tuple2;
                            Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)$1$, (Object)request, (Object)response);
                            Tuple2 $1$2 = (Tuple2)tuple3._1();
                            Deferred request2 = (Deferred)tuple3._2();
                            Deferred response2 = (Deferred)tuple3._3();
                            return Tuple2$.MODULE$.apply(t, (Object)$1$2);
                        }), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).flatMap((Function1 & Serializable)x$12 -> {
                            Tuple2 tuple2 = x$12;
                            if (tuple2 != null) {
                                Tuple2 tuple22 = (Tuple2)tuple2._2();
                                Tuple2 t = (Tuple2)tuple2._1();
                                if (tuple22 != null) {
                                    Object object;
                                    Deferred request = (Deferred)tuple22._1();
                                    Deferred response = (Deferred)tuple22._2();
                                    H2Connection.ConnectionType connectionType = this.connectionType;
                                    if (H2Connection$ConnectionType$Client$.MODULE$.equals(connectionType)) {
                                        object = package.all$.MODULE$.toFlatMapOps(response.tryGet(), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).flatMap((Function1 & Serializable)x$1 -> {
                                            Option option = x$1;
                                            Option x = option;
                                            if (x.isEmpty()) {
                                                Option<Response<Nothing$>> option2 = PseudoHeaders$.MODULE$.headersToResponseNoBody((NonEmptyList<Tuple2<String, String>>)h);
                                                if (option2 instanceof Some) {
                                                    Response resp = (Response)((Some)option2).value();
                                                    Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(response.complete((Object)EitherObjectOps$.MODULE$.right$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), (Object)this.attribute$1((State)s, (Message)resp))), this.org$http4s$ember$core$h2$H2Stream$$evidence$1);
                                                    Object object2 = package.all$.MODULE$.catsSyntaxFlatMapOps(FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.receiveHeaders$$anonfun$1$$anonfun$2$$anonfun$3$$anonfun$1$$anonfun$1(resp), this.org$http4s$ember$core$h2$H2Stream$$evidence$1), this.org$http4s$ember$core$h2$H2Stream$$evidence$1);
                                                    Object object3 = package.all$.MODULE$.catsSyntaxFlatMapOps(FlatMapOps$.MODULE$.$greater$greater$extension(object2, () -> this.receiveHeaders$$anonfun$1$$anonfun$2$$anonfun$3$$anonfun$1$$anonfun$2(headers, s), this.org$http4s$ember$core$h2$H2Stream$$evidence$1), this.org$http4s$ember$core$h2$H2Stream$$evidence$1);
                                                    return FlatMapOps$.MODULE$.$greater$greater$extension(object3, () -> this.receiveHeaders$$anonfun$1$$anonfun$2$$anonfun$3$$anonfun$1$$anonfun$3(newstate), this.org$http4s$ember$core$h2$H2Stream$$evidence$1);
                                                }
                                                if (None$.MODULE$.equals(option2)) {
                                                    Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(this.org$http4s$ember$core$h2$H2Stream$$logger.error(H2Stream::receiveHeaders$$anonfun$1$$anonfun$2$$anonfun$3$$anonfun$1$$anonfun$4), this.org$http4s$ember$core$h2$H2Stream$$evidence$1);
                                                    return FlatMapOps$.MODULE$.$greater$greater$extension(object, this::receiveHeaders$$anonfun$1$$anonfun$2$$anonfun$3$$anonfun$1$$anonfun$5, this.org$http4s$ember$core$h2$H2Stream$$evidence$1);
                                                }
                                                throw new MatchError(option2);
                                            }
                                            return package.all$.MODULE$.toFunctorOps(s.trailWith((List<Tuple2<String, String>>)h.toList()), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).void();
                                        });
                                    } else if (H2Connection$ConnectionType$Server$.MODULE$.equals(connectionType)) {
                                        object = package.all$.MODULE$.toFlatMapOps(request.tryGet(), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).flatMap((Function1 & Serializable)x$1 -> {
                                            Option option = x$1;
                                            Option x = option;
                                            if (x.isEmpty()) {
                                                Option<Request<Nothing$>> option2 = PseudoHeaders$.MODULE$.headersToRequestNoBody((NonEmptyList<Tuple2<String, String>>)h);
                                                if (option2 instanceof Some) {
                                                    Request req = (Request)((Some)option2).value();
                                                    Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(request.complete((Object)EitherObjectOps$.MODULE$.right$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), (Object)this.attribute$1((State)s, (Message)req))), this.org$http4s$ember$core$h2$H2Stream$$evidence$1);
                                                    Object object2 = package.all$.MODULE$.catsSyntaxFlatMapOps(FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.receiveHeaders$$anonfun$1$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$1(req), this.org$http4s$ember$core$h2$H2Stream$$evidence$1), this.org$http4s$ember$core$h2$H2Stream$$evidence$1);
                                                    Object object3 = package.all$.MODULE$.catsSyntaxFlatMapOps(FlatMapOps$.MODULE$.$greater$greater$extension(object2, () -> this.receiveHeaders$$anonfun$1$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$2(headers, s), this.org$http4s$ember$core$h2$H2Stream$$evidence$1), this.org$http4s$ember$core$h2$H2Stream$$evidence$1);
                                                    return FlatMapOps$.MODULE$.$greater$greater$extension(object3, () -> this.receiveHeaders$$anonfun$1$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$3(newstate), this.org$http4s$ember$core$h2$H2Stream$$evidence$1);
                                                }
                                                if (None$.MODULE$.equals(option2)) {
                                                    Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(this.org$http4s$ember$core$h2$H2Stream$$logger.error(H2Stream::receiveHeaders$$anonfun$1$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$4), this.org$http4s$ember$core$h2$H2Stream$$evidence$1);
                                                    return FlatMapOps$.MODULE$.$greater$greater$extension(object, this::receiveHeaders$$anonfun$1$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$5, this.org$http4s$ember$core$h2$H2Stream$$evidence$1);
                                                }
                                                throw new MatchError(option2);
                                            }
                                            return package.all$.MODULE$.toFunctorOps(s.trailWith((List<Tuple2<String, String>>)h.toList()), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).void();
                                        });
                                    } else {
                                        throw new MatchError((Object)connectionType);
                                    }
                                    return package.all$.MODULE$.toFunctorOps(object, this.org$http4s$ember$core$h2$H2Stream$$evidence$1).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    });
                                }
                            }
                            throw new MatchError((Object)tuple2);
                        });
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
            if (H2Stream$StreamState$HalfClosedRemote$.MODULE$.equals(streamState) || H2Stream$StreamState$Closed$.MODULE$.equals(streamState)) {
                return this.goAway().apply((Object)H2Error$StreamClosed$.MODULE$);
            }
            if (H2Stream$StreamState$ReservedLocal$.MODULE$.equals(streamState)) {
                return this.goAway().apply((Object)H2Error$ProtocolError$.MODULE$);
            }
            throw new MatchError((Object)streamState);
        });
    }

    public F receivePushPromise(H2Frame.PushPromise headers, Seq<H2Frame.Continuation> continuations) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.state().get(), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).flatMap((Function1 & Serializable)s -> {
            H2Connection.ConnectionType connectionType = this.connectionType;
            if (H2Connection$ConnectionType$Client$.MODULE$.equals(connectionType)) {
                StreamState streamState = s.state();
                if (H2Stream$StreamState$Idle$.MODULE$.equals(streamState)) {
                    ByteVector block = headers.headerBlock().$plus$plus((ByteVector)continuations.foldLeft((Object)ByteVector$.MODULE$.empty(), (Function2 & Serializable)(x$1, x$2) -> {
                        Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                        if (tuple2 != null) {
                            ByteVector acc = (ByteVector)tuple2._1();
                            H2Frame.Continuation cont = (H2Frame.Continuation)tuple2._2();
                            return acc.$plus$plus(cont.headerBlockFragment());
                        }
                        throw new MatchError((Object)tuple2);
                    }));
                    Object object = package.all$.MODULE$.catsSyntaxApplicativeError(this.hpack().decodeHeaders(block), this.org$http4s$ember$core$h2$H2Stream$$evidence$1);
                    return package.all$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.onError$extension(object, (PartialFunction)new Serializable(this){
                        private final /* synthetic */ H2Stream $outer;
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }

                        public final boolean isDefinedAt(Throwable x) {
                            Throwable throwable;
                            Throwable e = throwable = x;
                            return true;
                        }

                        public final Object applyOrElse(Throwable x, Function1 function1) {
                            Throwable throwable;
                            Throwable e = throwable = x;
                            this.$outer.org$http4s$ember$core$h2$H2Stream$$logger.error(e, H2Stream::org$http4s$ember$core$h2$H2Stream$$anon$3$$_$applyOrElse$$anonfun$3);
                            return this.$outer.goAway().apply((Object)H2Error$CompressionError$.MODULE$);
                        }

                        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$http4s$ember$core$h2$H2Stream$$anon$3$$_$applyOrElse$$anonfun$3()}, serializedLambda);
                        }
                    }, this.org$http4s$ember$core$h2$H2Stream$$evidence$1), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).flatMap((Function1 & Serializable)h -> package.all$.MODULE$.toFlatMapOps(this.state().update((Function1 & Serializable)s -> s.copy(H2Stream$StreamState$ReservedRemote$.MODULE$, s.copy$default$2(), s.copy$default$3(), s.copy$default$4(), s.copy$default$5(), s.copy$default$6(), s.copy$default$7(), s.copy$default$8(), s.copy$default$9())), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).flatMap((Function1 & Serializable)x$12 -> {
                        Object object;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        Option<Request<Nothing$>> option = PseudoHeaders$.MODULE$.headersToRequestNoBody((NonEmptyList<Tuple2<String, String>>)h);
                        if (option instanceof Some) {
                            Request req = (Request)((Some)option).value();
                            Request attributed = (Request)req.withAttribute(H2Keys$.MODULE$.StreamIdentifier(), (Object)BoxesRunTime.boxToInteger((int)this.id())).withAttribute(H2Keys$.MODULE$.PushPromiseInitialStreamIdentifier(), (Object)BoxesRunTime.boxToInteger((int)headers.identifier()));
                            object = package.all$.MODULE$.toFunctorOps(s.request().complete((Object)EitherObjectOps$.MODULE$.right$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), (Object)attributed)), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).void();
                        } else if (None$.MODULE$.equals(option)) {
                            object = this.rstStream(H2Error$ProtocolError$.MODULE$);
                        } else {
                            throw new MatchError(option);
                        }
                        return package.all$.MODULE$.toFunctorOps(object, this.org$http4s$ember$core$h2$H2Stream$$evidence$1).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        });
                    }));
                }
                return this.goAway().apply((Object)H2Error$ProtocolError$.MODULE$);
            }
            if (H2Connection$ConnectionType$Server$.MODULE$.equals(connectionType)) {
                return this.goAway().apply((Object)H2Error$ProtocolError$.MODULE$);
            }
            throw new MatchError((Object)connectionType);
        });
    }

    public F receiveData(H2Frame.Data data) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.state().get(), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).flatMap((Function1 & Serializable)s2 -> {
            StreamState streamState = s2.state();
            if (H2Stream$StreamState$Open$.MODULE$.equals(streamState) || H2Stream$StreamState$HalfClosedLocal$.MODULE$.equals(streamState)) {
                StreamState s3;
                StreamState streamState2;
                int newSize = s2.readWindow() - (int)data.data().size();
                StreamState newState = data.endStream() ? (H2Stream$StreamState$Open$.MODULE$.equals(streamState2 = s2.state()) ? H2Stream$StreamState$HalfClosedRemote$.MODULE$ : (H2Stream$StreamState$HalfClosedLocal$.MODULE$.equals(streamState2) ? H2Stream$StreamState$Closed$.MODULE$ : (s3 = streamState2))) : s2.state();
                boolean sizeReadOk = !data.endStream() || s2.contentLengthCheck().forall((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        long max = tuple2._1$mcJ$sp();
                        long current = tuple2._2$mcJ$sp();
                        return package.all$.MODULE$.catsSyntaxEq((Object)BoxesRunTime.boxToLong((long)max), (Eq)Eq$.MODULE$.catsKernelInstancesForLong()).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)(current + data.data().size())));
                    }
                    throw new MatchError((Object)tuple2);
                });
                StreamState streamState3 = newState;
                H2Stream$StreamState$Closed$ h2Stream$StreamState$Closed$ = H2Stream$StreamState$Closed$.MODULE$;
                boolean isClosed = !(streamState3 != null ? !streamState3.equals(h2Stream$StreamState$Closed$) : h2Stream$StreamState$Closed$ != null);
                boolean needsWindowUpdate = newSize <= Predef$.MODULE$.Integer2int(this.localSettings.initialWindowSize().windowSize()) / 2;
                return package.all$.MODULE$.toFlatMapOps(this.state().update((Function1 & Serializable)s -> {
                    int n = needsWindowUpdate ? Predef$.MODULE$.Integer2int(this.localSettings.initialWindowSize().windowSize()) : newSize;
                    Option option = s.contentLengthCheck().map((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            long max = tuple2._1$mcJ$sp();
                            long current = tuple2._2$mcJ$sp();
                            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)max), (Object)BoxesRunTime.boxToLong((long)(current + data.data().size())));
                        }
                        throw new MatchError((Object)tuple2);
                    });
                    int n2 = s.copy$default$2();
                    Deferred deferred = s.copy$default$3();
                    Deferred deferred2 = s.copy$default$5();
                    Deferred deferred3 = s.copy$default$6();
                    Deferred deferred4 = s.copy$default$7();
                    Channel channel = s.copy$default$8();
                    return s.copy(newState, n2, deferred, n, deferred2, deferred3, deferred4, channel, (Option<Tuple2<Object, Object>>)option);
                }), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return package.all$.MODULE$.toFlatMapOps(sizeReadOk ? package.all$.MODULE$.toFunctorOps(s2.readBuffer().send((Object)scala.package$.MODULE$.Right().apply((Object)data.data())), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).void() : this.rstStream(H2Error$ProtocolError$.MODULE$), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).flatMap((Function1 & Serializable)x$12 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return package.all$.MODULE$.toFlatMapOps(needsWindowUpdate && !isClosed && sizeReadOk ? this.enqueue().offer((Object)Chunk$.MODULE$.singleton((Object)H2Frame$WindowUpdate$.MODULE$.apply(this.id(), Predef$.MODULE$.Integer2int(this.localSettings.initialWindowSize().windowSize()) - newSize))) : Applicative$.MODULE$.apply(this.org$http4s$ember$core$h2$H2Stream$$evidence$1).unit(), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).flatMap((Function1 & Serializable)x$1 -> {
                            Object object;
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            if (data.endStream()) {
                                Object object2 = package.all$.MODULE$.catsSyntaxApplyOps(s2.readBuffer().close());
                                object = ApplyOps$.MODULE$.$times$greater$extension(object2, package.all$.MODULE$.toFunctorOps(s2.trailWith((List<Tuple2<String, String>>)scala.package$.MODULE$.List().empty()), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).void(), this.org$http4s$ember$core$h2$H2Stream$$evidence$1);
                            } else {
                                object = Applicative$.MODULE$.apply(this.org$http4s$ember$core$h2$H2Stream$$evidence$1).unit();
                            }
                            return package.all$.MODULE$.toFlatMapOps(object, this.org$http4s$ember$core$h2$H2Stream$$evidence$1).flatMap((Function1 & Serializable)x$12 -> {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return package.all$.MODULE$.toFunctorOps(isClosed && sizeReadOk ? this.onClosed() : Applicative$.MODULE$.apply(this.org$http4s$ember$core$h2$H2Stream$$evidence$1).unit(), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                });
                            });
                        });
                    });
                });
            }
            if (H2Stream$StreamState$Idle$.MODULE$.equals(streamState)) {
                return this.goAway().apply((Object)H2Error$ProtocolError$.MODULE$);
            }
            if (H2Stream$StreamState$HalfClosedRemote$.MODULE$.equals(streamState) || H2Stream$StreamState$Closed$.MODULE$.equals(streamState)) {
                return this.rstStream(H2Error$StreamClosed$.MODULE$);
            }
            if (H2Stream$StreamState$ReservedLocal$.MODULE$.equals(streamState) || H2Stream$StreamState$ReservedRemote$.MODULE$.equals(streamState)) {
                return this.goAway().apply((Object)H2Error$InternalError$.MODULE$);
            }
            throw new MatchError((Object)streamState);
        });
    }

    public F rstStream(H2Error error) {
        H2Frame.RstStream rst = error.toRst(this.id());
        return (F)package.all$.MODULE$.toFlatMapOps(this.state().modify((Function1 & Serializable)s -> Tuple2$.MODULE$.apply(s.copy(H2Stream$StreamState$Closed$.MODULE$, s.copy$default$2(), s.copy$default$3(), s.copy$default$4(), s.copy$default$5(), s.copy$default$6(), s.copy$default$7(), s.copy$default$8(), s.copy$default$9()), s)), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).flatMap((Function1 & Serializable)s -> package.all$.MODULE$.toFlatMapOps(this.enqueue().offer((Object)Chunk$.MODULE$.singleton((Object)rst)), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return package.all$.MODULE$.toFlatMapOps(s.cancelWith(new StringBuilder(31).append("Sending RstStream, cancelling: ").append(rst).toString(), this.org$http4s$ember$core$h2$H2Stream$$evidence$1), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return package.all$.MODULE$.toFunctorOps(this.onClosed(), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                });
            });
        }));
    }

    public F receiveGoAway(H2Frame.GoAway goAway) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.state().modify((Function1 & Serializable)s -> Tuple2$.MODULE$.apply(s.copy(H2Stream$StreamState$Closed$.MODULE$, s.copy$default$2(), s.copy$default$3(), s.copy$default$4(), s.copy$default$5(), s.copy$default$6(), s.copy$default$7(), s.copy$default$8(), s.copy$default$9()), s)), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).flatMap((Function1 & Serializable)s -> package.all$.MODULE$.toFlatMapOps(s.cancelWith(new StringBuilder(29).append("Received GoAway, cancelling: ").append(goAway).toString(), this.org$http4s$ember$core$h2$H2Stream$$evidence$1), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return package.all$.MODULE$.toFunctorOps(this.onClosed(), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            });
        }));
    }

    public F receiveRstStream(H2Frame.RstStream rst) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.state().modify((Function1 & Serializable)s -> Tuple2$.MODULE$.apply(s.copy(H2Stream$StreamState$Closed$.MODULE$, s.copy$default$2(), s.copy$default$3(), s.copy$default$4(), s.copy$default$5(), s.copy$default$6(), s.copy$default$7(), s.copy$default$8(), s.copy$default$9()), s)), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).flatMap((Function1 & Serializable)s -> package.all$.MODULE$.toFlatMapOps(s.cancelWith(new StringBuilder(32).append("Received RstStream, cancelling: ").append(rst).toString(), this.org$http4s$ember$core$h2$H2Stream$$evidence$1), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return package.all$.MODULE$.toFunctorOps(this.onClosed(), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            });
        }));
    }

    public F receiveWindowUpdate(H2Frame.WindowUpdate window) {
        return (F)package.all$.MODULE$.toFlatMapOps(package$.MODULE$.Deferred().apply(this.org$http4s$ember$core$h2$H2Stream$$evidence$1), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).flatMap((Function1 & Serializable)newWriteBlock -> package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(this.state().modify((Function1 & Serializable)s -> {
            int oldSize = s.writeWindow();
            int newSize = oldSize + window.windowSizeIncrement();
            boolean sizeValid = s.writeWindow() >= 0 && newSize >= 0 || s.writeWindow() < 0;
            State newS = s.copy(s.copy$default$1(), newSize, newWriteBlock, s.copy$default$4(), s.copy$default$5(), s.copy$default$6(), s.copy$default$7(), s.copy$default$8(), s.copy$default$9());
            return Tuple2$.MODULE$.apply(newS, (Object)Tuple2$.MODULE$.apply(s.writeBlock(), (Object)BoxesRunTime.boxToBoolean((boolean)sizeValid)));
        }), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).map((Function1 & Serializable)t -> {
            Tuple2 tuple2 = t;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Deferred oldWriteBlock = (Deferred)tuple2._1();
            boolean valid = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
            Tuple2 $3$ = tuple2;
            Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)$3$, (Object)oldWriteBlock, (Object)BoxesRunTime.boxToBoolean((boolean)valid));
            Tuple2 $3$2 = (Tuple2)tuple3._1();
            Deferred oldWriteBlock2 = (Deferred)tuple3._2();
            boolean valid2 = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
            return Tuple2$.MODULE$.apply(t, (Object)$3$2);
        }), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).flatMap((Function1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                Tuple2 t = (Tuple2)tuple2._1();
                if (tuple22 != null) {
                    Deferred oldWriteBlock = (Deferred)tuple22._1();
                    boolean valid = BoxesRunTime.unboxToBoolean((Object)tuple22._2());
                    return package.all$.MODULE$.toFunctorOps(!valid ? this.rstStream(H2Error$FlowControlError$.MODULE$) : package.all$.MODULE$.toFunctorOps(oldWriteBlock.complete((Object)EitherObjectOps$.MODULE$.unit$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()))), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).void(), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    });
                }
            }
            throw new MatchError((Object)tuple2);
        }));
    }

    public F modifyWriteWindow(int amount) {
        return (F)package.all$.MODULE$.toFlatMapOps(package$.MODULE$.Deferred().apply(this.org$http4s$ember$core$h2$H2Stream$$evidence$1), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).flatMap((Function1 & Serializable)newWriteBlock -> package.all$.MODULE$.toFlatMapOps(this.state().modify((Function1 & Serializable)s -> {
            int newSize = s.writeWindow() + amount;
            State newS = s.copy(s.copy$default$1(), newSize, newWriteBlock, s.copy$default$4(), s.copy$default$5(), s.copy$default$6(), s.copy$default$7(), s.copy$default$8(), s.copy$default$9());
            return Tuple2$.MODULE$.apply(newS, s.writeBlock());
        }), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).flatMap((Function1 & Serializable)oldWriteBlock -> package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFunctorOps(oldWriteBlock.complete((Object)EitherObjectOps$.MODULE$.unit$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()))), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).void(), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        })));
    }

    public F getRequest() {
        return (F)package.all$.MODULE$.toFlatMapOps(this.state().get(), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).flatMap((Function1 & Serializable)_$4 -> {
            Object object = package.all$.MODULE$.catsSyntaxMonadErrorRethrow(_$4.request().get(), this.org$http4s$ember$core$h2$H2Stream$$evidence$1);
            return MonadErrorRethrowOps$.MODULE$.rethrow$extension(object, this.org$http4s$ember$core$h2$H2Stream$$evidence$1);
        });
    }

    public F getResponse() {
        return (F)package.all$.MODULE$.toFlatMapOps(this.state().get(), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).flatMap((Function1 & Serializable)_$5 -> {
            Object object = package.all$.MODULE$.catsSyntaxMonadErrorRethrow(_$5.response().get(), this.org$http4s$ember$core$h2$H2Stream$$evidence$1);
            return MonadErrorRethrowOps$.MODULE$.rethrow$extension(object, this.org$http4s$ember$core$h2$H2Stream$$evidence$1);
        });
    }

    public Stream<F, Object> readBody() {
        return Stream$.MODULE$.force(package.all$.MODULE$.toFunctorOps(this.state().get(), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).map((Function1 & Serializable)_$6 -> _$6.readBuffer().stream())).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                ByteVector bv = (ByteVector)((Right)either).value();
                return Stream$.MODULE$.chunk(Chunk$.MODULE$.byteVector(bv));
            }
            if (either instanceof Left) {
                Throwable ex = (Throwable)((Left)either).value();
                return Stream$.MODULE$.raiseError(ex, RaiseThrowable$.MODULE$.fromApplicativeError(this.org$http4s$ember$core$h2$H2Stream$$evidence$1));
            }
            throw new MatchError((Object)either);
        }, NotGiven$.MODULE$.value());
    }

    private final Object sendMessageBody$$anonfun$1$$anonfun$1$$anonfun$1() {
        return this.sendData(ByteVector$.MODULE$.empty(), true);
    }

    private final Stream sendMessageBody$$anonfun$1$$anonfun$1(boolean noTrailers$2) {
        Function0 function0 = package.all$.MODULE$.catsSyntaxApplicativeByName(this::sendMessageBody$$anonfun$1$$anonfun$1$$anonfun$1);
        return Stream$.MODULE$.exec(ApplicativeByNameOps$.MODULE$.whenA$extension(function0, noTrailers$2, this.org$http4s$ember$core$h2$H2Stream$$evidence$1));
    }

    private final /* synthetic */ Object sendMessageBody$$anonfun$1(Message mess$1, boolean noTrailers$1, int maxFrameSize) {
        Object object = package.all$.MODULE$.catsSyntaxApplicativeError(mess$1.body().ifEmpty(() -> this.sendMessageBody$$anonfun$1$$anonfun$1(noTrailers$1)).chunkLimit(maxFrameSize).zipWithNext().foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Chunk c = (Chunk)tuple2._1();
                Option nextChunk = (Option)tuple2._2();
                boolean isEndStream = nextChunk.isEmpty() && noTrailers$1;
                return this.sendData(c.toByteVector($less$colon$less$.MODULE$.refl()), isEndStream);
            }
            throw new MatchError((Object)tuple2);
        }).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.org$http4s$ember$core$h2$H2Stream$$evidence$1))).drain(), this.org$http4s$ember$core$h2$H2Stream$$evidence$1);
        return ApplicativeErrorOps$.MODULE$.onError$extension(object, (PartialFunction)new Serializable(this){
            private final /* synthetic */ H2Stream $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                return this.$outer.rstStream(H2Error$InternalError$.MODULE$);
            }
        }, this.org$http4s$ember$core$h2$H2Stream$$evidence$1);
    }

    private final /* synthetic */ Object sendTrailerHeaders$$anonfun$1(List hs) {
        List list = package.all$.MODULE$.catsSyntaxList(hs.map((Function1 & Serializable)a -> Tuple3$.MODULE$.apply((Object)a.name().toString().toLowerCase(), (Object)a.value(), (Object)BoxesRunTime.boxToBoolean((boolean)false))));
        return package.all$.MODULE$.toFoldableOps((Object)ListOps$.MODULE$.toNel$extension(list), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForOption()).traverse_((Function1 & Serializable)_$3 -> this.sendHeaders((NonEmptyList<Tuple3<String, String, Object>>)_$3, true), this.org$http4s$ember$core$h2$H2Stream$$evidence$1);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static final /* synthetic */ Tuple2 sendHeaders$$anonfun$1$$anonfun$2(boolean endStream$3, State b) {
        block7: {
            block4: {
                block10: {
                    block11: {
                        block8: {
                            block9: {
                                block5: {
                                    block6: {
                                        var3_2 = Tuple2$.MODULE$.apply((Object)b.state(), (Object)BoxesRunTime.boxToBoolean((boolean)endStream$3));
                                        if (var3_2 == null) break block4;
                                        var4_3 = (StreamState)var3_2._1();
                                        var5_4 = BoxesRunTime.unboxToBoolean((Object)var3_2._2());
                                        if (!H2Stream$StreamState$Idle$.MODULE$.equals(var4_3)) break block5;
                                        if (var5_4) break block6;
                                        v0 /* !! */  = H2Stream$StreamState$Open$.MODULE$;
                                        break block7;
                                    }
                                    if (!var5_4) break block5;
                                    v0 /* !! */  = H2Stream$StreamState$HalfClosedLocal$.MODULE$;
                                    break block7;
                                }
                                if (!H2Stream$StreamState$HalfClosedRemote$.MODULE$.equals(var4_3)) break block8;
                                if (var5_4) break block9;
                                v0 /* !! */  = H2Stream$StreamState$HalfClosedRemote$.MODULE$;
                                break block7;
                            }
                            if (!var5_4) break block8;
                            v0 /* !! */  = H2Stream$StreamState$Closed$.MODULE$;
                            break block7;
                        }
                        if (!H2Stream$StreamState$Open$.MODULE$.equals(var4_3)) break block10;
                        if (var5_4) break block11;
                        v0 /* !! */  = H2Stream$StreamState$Open$.MODULE$;
                        break block7;
                    }
                    if (!var5_4) break block10;
                    v0 /* !! */  = H2Stream$StreamState$HalfClosedLocal$.MODULE$;
                    break block7;
                }
                if (!H2Stream$StreamState$ReservedLocal$.MODULE$.equals(var4_3)) ** GOTO lbl-1000
                if (var5_4) {
                    v0 /* !! */  = H2Stream$StreamState$Closed$.MODULE$;
                } else if (!var5_4) {
                    v0 /* !! */  = H2Stream$StreamState$HalfClosedRemote$.MODULE$;
                } else lbl-1000:
                // 2 sources

                {
                    st = var4_3;
                    v0 /* !! */  = st;
                }
                break block7;
            }
            throw new MatchError((Object)var3_2);
        }
        newState = v0 /* !! */ ;
        return Tuple2$.MODULE$.apply(b.copy(newState, b.copy$default$2(), b.copy$default$3(), b.copy$default$4(), b.copy$default$5(), b.copy$default$6(), b.copy$default$7(), b.copy$default$8(), b.copy$default$9()), (Object)newState);
    }

    private final Object sendData$$anonfun$1$$anonfun$1(boolean endStream$5, ByteVector bv$2) {
        return package.all$.MODULE$.toFlatMapOps(this.state().modify((Function1 & Serializable)s -> {
            StreamState st;
            StreamState streamState;
            StreamState newState = endStream$5 ? (H2Stream$StreamState$Open$.MODULE$.equals(streamState = s.state()) ? H2Stream$StreamState$HalfClosedLocal$.MODULE$ : (H2Stream$StreamState$HalfClosedRemote$.MODULE$.equals(streamState) ? H2Stream$StreamState$Closed$.MODULE$ : (st = streamState))) : s.state();
            return Tuple2$.MODULE$.apply(s.copy(newState, s.writeWindow() - (int)bv$2.size(), s.copy$default$3(), s.copy$default$4(), s.copy$default$5(), s.copy$default$6(), s.copy$default$7(), s.copy$default$8(), s.copy$default$9()), (Object)newState);
        }), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).flatMap((Function1 & Serializable)state -> {
            StreamState streamState = state;
            H2Stream$StreamState$Closed$ h2Stream$StreamState$Closed$ = H2Stream$StreamState$Closed$.MODULE$;
            if (!(streamState != null ? !streamState.equals(h2Stream$StreamState$Closed$) : h2Stream$StreamState$Closed$ != null)) {
                return this.onClosed();
            }
            return Applicative$.MODULE$.apply(this.org$http4s$ember$core$h2$H2Stream$$evidence$1).unit();
        });
    }

    private final Object sendData$$anonfun$1$$anonfun$3$$anonfun$1(ByteVector tail$1, boolean endStream$7) {
        return this.sendData(tail$1, endStream$7);
    }

    private final Object sendData$$anonfun$1$$anonfun$4(ByteVector bv$5, boolean endStream$9) {
        return this.sendData(bv$5, endStream$9);
    }

    private final /* synthetic */ Object checkLengthOf$1$$anonfun$1(long length) {
        return this.state().update((Function1 & Serializable)s -> {
            Some some = Some$.MODULE$.apply((Object)new Tuple2.mcJJ.sp(length, 0L));
            StreamState streamState = s.copy$default$1();
            int n = s.copy$default$2();
            Deferred deferred = s.copy$default$3();
            int n2 = s.copy$default$4();
            Deferred deferred2 = s.copy$default$5();
            Deferred deferred3 = s.copy$default$6();
            Deferred deferred4 = s.copy$default$7();
            Channel channel = s.copy$default$8();
            return s.copy(streamState, n, deferred, n2, deferred2, deferred3, deferred4, channel, (Option<Tuple2<Object, Object>>)some);
        });
    }

    private final Object checkLengthOf$1(Message mess) {
        return package.all$.MODULE$.toFoldableOps((Object)mess.contentLength(), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForOption()).traverse_((Function1 & Serializable)length -> this.checkLengthOf$1$$anonfun$1(BoxesRunTime.unboxToLong((Object)length)), this.org$http4s$ember$core$h2$H2Stream$$evidence$1);
    }

    private final Message attribute$1(State s$1, Message mess) {
        Message iMess = mess.withAttribute(H2Keys$.MODULE$.StreamIdentifier(), (Object)BoxesRunTime.boxToInteger((int)this.id()));
        Object object = package.all$.MODULE$.catsSyntaxMonadErrorRethrow(s$1.trailers().get(), this.org$http4s$ember$core$h2$H2Stream$$evidence$1);
        Object trailerF = MonadErrorRethrowOps$.MODULE$.rethrow$extension(object, this.org$http4s$ember$core$h2$H2Stream$$evidence$1);
        return iMess.withAttribute(Message.Keys$.MODULE$.TrailerHeaders(), trailerF);
    }

    public static final String org$http4s$ember$core$h2$H2Stream$$anon$2$$_$applyOrElse$$anonfun$1() {
        return "Issue in headers";
    }

    private final Object receiveHeaders$$anonfun$1$$anonfun$2$$anonfun$3$$anonfun$1$$anonfun$1(Response resp$1) {
        return this.checkLengthOf$1((Message)resp$1);
    }

    private final Object receiveHeaders$$anonfun$1$$anonfun$2$$anonfun$3$$anonfun$1$$anonfun$2(H2Frame.Headers headers$8, State s$6) {
        if (headers$8.endStream()) {
            Object object = package.all$.MODULE$.catsSyntaxApplyOps(s$6.readBuffer().close());
            return ApplyOps$.MODULE$.$times$greater$extension(object, package.all$.MODULE$.toFunctorOps(s$6.trailWith((List<Tuple2<String, String>>)scala.package$.MODULE$.List().empty()), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).void(), this.org$http4s$ember$core$h2$H2Stream$$evidence$1);
        }
        return Applicative$.MODULE$.apply(this.org$http4s$ember$core$h2$H2Stream$$evidence$1).unit();
    }

    private final Object receiveHeaders$$anonfun$1$$anonfun$2$$anonfun$3$$anonfun$1$$anonfun$3(StreamState newstate$4) {
        StreamState streamState = newstate$4;
        H2Stream$StreamState$Closed$ h2Stream$StreamState$Closed$ = H2Stream$StreamState$Closed$.MODULE$;
        if (!(streamState != null ? !streamState.equals(h2Stream$StreamState$Closed$) : h2Stream$StreamState$Closed$ != null)) {
            return this.onClosed();
        }
        return Applicative$.MODULE$.apply(this.org$http4s$ember$core$h2$H2Stream$$evidence$1).unit();
    }

    private static final String receiveHeaders$$anonfun$1$$anonfun$2$$anonfun$3$$anonfun$1$$anonfun$4() {
        return "Headers Unable to be parsed";
    }

    private final Object receiveHeaders$$anonfun$1$$anonfun$2$$anonfun$3$$anonfun$1$$anonfun$5() {
        return this.rstStream(H2Error$ProtocolError$.MODULE$);
    }

    private final Object receiveHeaders$$anonfun$1$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$1(Request req$1) {
        return this.checkLengthOf$1((Message)req$1);
    }

    private final Object receiveHeaders$$anonfun$1$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$2(H2Frame.Headers headers$10, State s$8) {
        if (headers$10.endStream()) {
            Object object = package.all$.MODULE$.catsSyntaxApplyOps(s$8.readBuffer().close());
            return ApplyOps$.MODULE$.$times$greater$extension(object, package.all$.MODULE$.toFunctorOps(s$8.trailWith((List<Tuple2<String, String>>)scala.package$.MODULE$.List().empty()), this.org$http4s$ember$core$h2$H2Stream$$evidence$1).void(), this.org$http4s$ember$core$h2$H2Stream$$evidence$1);
        }
        return Applicative$.MODULE$.apply(this.org$http4s$ember$core$h2$H2Stream$$evidence$1).unit();
    }

    private final Object receiveHeaders$$anonfun$1$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$3(StreamState newstate$6) {
        StreamState streamState = newstate$6;
        H2Stream$StreamState$Closed$ h2Stream$StreamState$Closed$ = H2Stream$StreamState$Closed$.MODULE$;
        if (!(streamState != null ? !streamState.equals(h2Stream$StreamState$Closed$) : h2Stream$StreamState$Closed$ != null)) {
            return this.onClosed();
        }
        return Applicative$.MODULE$.apply(this.org$http4s$ember$core$h2$H2Stream$$evidence$1).unit();
    }

    private static final String receiveHeaders$$anonfun$1$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$4() {
        return "Headers Unable to be parsed";
    }

    private final Object receiveHeaders$$anonfun$1$$anonfun$2$$anonfun$3$$anonfun$2$$anonfun$5() {
        return this.rstStream(H2Error$ProtocolError$.MODULE$);
    }

    public static final String org$http4s$ember$core$h2$H2Stream$$anon$3$$_$applyOrElse$$anonfun$3() {
        return "Issue in headers";
    }

    public static final class State<F>
    implements Product,
    Serializable {
        private final StreamState state;
        private final int writeWindow;
        private final Deferred writeBlock;
        private final int readWindow;
        private final Deferred request;
        private final Deferred response;
        private final Deferred trailers;
        private final Channel readBuffer;
        private final Option contentLengthCheck;

        public static <F> State<F> apply(StreamState streamState, int n, Deferred<F, Either<Throwable, BoxedUnit>> deferred, int n2, Deferred<F, Either<Throwable, Request<Nothing$>>> deferred2, Deferred<F, Either<Throwable, Response<Nothing$>>> deferred3, Deferred<F, Either<Throwable, List>> deferred4, Channel<F, Either<Throwable, ByteVector>> channel, Option<Tuple2<Object, Object>> option) {
            return H2Stream$State$.MODULE$.apply(streamState, n, deferred, n2, deferred2, deferred3, deferred4, channel, option);
        }

        public static State<?> fromProduct(Product product) {
            return H2Stream$State$.MODULE$.fromProduct(product);
        }

        public static <F> State<F> unapply(State<F> state) {
            return H2Stream$State$.MODULE$.unapply(state);
        }

        public State(StreamState state, int writeWindow, Deferred<F, Either<Throwable, BoxedUnit>> writeBlock, int readWindow, Deferred<F, Either<Throwable, Request<Nothing$>>> request, Deferred<F, Either<Throwable, Response<Nothing$>>> response, Deferred<F, Either<Throwable, List>> trailers, Channel<F, Either<Throwable, ByteVector>> readBuffer, Option<Tuple2<Object, Object>> contentLengthCheck) {
            this.state = state;
            this.writeWindow = writeWindow;
            this.writeBlock = writeBlock;
            this.readWindow = readWindow;
            this.request = request;
            this.response = response;
            this.trailers = trailers;
            this.readBuffer = readBuffer;
            this.contentLengthCheck = contentLengthCheck;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.state()));
            n = Statics.mix((int)n, (int)this.writeWindow());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.writeBlock()));
            n = Statics.mix((int)n, (int)this.readWindow());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.request()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.response()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.trailers()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.readBuffer()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.contentLengthCheck()));
            return Statics.finalizeHash((int)n, (int)9);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            State state = (State)object;
            if (this.writeWindow() != state.writeWindow()) return false;
            if (this.readWindow() != state.readWindow()) return false;
            StreamState streamState = this.state();
            StreamState streamState2 = state.state();
            if (streamState == null) {
                if (streamState2 != null) {
                    return false;
                }
            } else if (!streamState.equals(streamState2)) return false;
            Deferred<F, Either<Throwable, BoxedUnit>> deferred = this.writeBlock();
            Deferred<F, Either<Throwable, BoxedUnit>> deferred2 = state.writeBlock();
            if (deferred == null) {
                if (deferred2 != null) {
                    return false;
                }
            } else if (!deferred.equals(deferred2)) return false;
            Deferred<F, Either<Throwable, Request<Nothing$>>> deferred3 = this.request();
            Deferred<F, Either<Throwable, Request<Nothing$>>> deferred4 = state.request();
            if (deferred3 == null) {
                if (deferred4 != null) {
                    return false;
                }
            } else if (!deferred3.equals(deferred4)) return false;
            Deferred<F, Either<Throwable, Response<Nothing$>>> deferred5 = this.response();
            Deferred<F, Either<Throwable, Response<Nothing$>>> deferred6 = state.response();
            if (deferred5 == null) {
                if (deferred6 != null) {
                    return false;
                }
            } else if (!deferred5.equals(deferred6)) return false;
            Deferred<F, Either<Throwable, List>> deferred7 = this.trailers();
            Deferred<F, Either<Throwable, List>> deferred8 = state.trailers();
            if (deferred7 == null) {
                if (deferred8 != null) {
                    return false;
                }
            } else if (!deferred7.equals(deferred8)) return false;
            Channel<F, Either<Throwable, ByteVector>> channel = this.readBuffer();
            Channel<F, Either<Throwable, ByteVector>> channel2 = state.readBuffer();
            if (channel == null) {
                if (channel2 != null) {
                    return false;
                }
            } else if (!channel.equals(channel2)) return false;
            Option<Tuple2<Object, Object>> option = this.contentLengthCheck();
            Option<Tuple2<Object, Object>> option2 = state.contentLengthCheck();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 9;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this._2());
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return BoxesRunTime.boxToInteger((int)this._4());
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
                case 6: {
                    return this._7();
                }
                case 7: {
                    return this._8();
                }
                case 8: {
                    return this._9();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "state";
                }
                case 1: {
                    return "writeWindow";
                }
                case 2: {
                    return "writeBlock";
                }
                case 3: {
                    return "readWindow";
                }
                case 4: {
                    return "request";
                }
                case 5: {
                    return "response";
                }
                case 6: {
                    return "trailers";
                }
                case 7: {
                    return "readBuffer";
                }
                case 8: {
                    return "contentLengthCheck";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public StreamState state() {
            return this.state;
        }

        public int writeWindow() {
            return this.writeWindow;
        }

        public Deferred<F, Either<Throwable, BoxedUnit>> writeBlock() {
            return this.writeBlock;
        }

        public int readWindow() {
            return this.readWindow;
        }

        public Deferred<F, Either<Throwable, Request<Nothing$>>> request() {
            return this.request;
        }

        public Deferred<F, Either<Throwable, Response<Nothing$>>> response() {
            return this.response;
        }

        public Deferred<F, Either<Throwable, List>> trailers() {
            return this.trailers;
        }

        public Channel<F, Either<Throwable, ByteVector>> readBuffer() {
            return this.readBuffer;
        }

        public Option<Tuple2<Object, Object>> contentLengthCheck() {
            return this.contentLengthCheck;
        }

        public String toString() {
            return new StringBuilder(70).append("H2Stream.State(state=").append(this.state()).append(", writeWindow=").append(this.writeWindow()).append(", readWindow=").append(this.readWindow()).append(", contentLengthCheck=").append(this.contentLengthCheck()).append(")").toString();
        }

        public F trailWith(List<Tuple2<String, String>> rawHs) {
            List hs = Headers$.MODULE$.apply((Seq)rawHs.map((Function1 & Serializable)kv -> Header.ToRaw$.MODULE$.keyValuesToRaw(kv)));
            return (F)this.trailers().complete((Object)EitherObjectOps$.MODULE$.right$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), (Object)new Headers(hs)));
        }

        public F cancelWith(String msg, Monad<F> F) {
            Left ex = scala.package$.MODULE$.Left().apply((Object)new CancellationException(msg));
            Object object = package.all$.MODULE$.catsSyntaxApplyOps(this.writeBlock().complete((Object)ex));
            Object object2 = package.all$.MODULE$.catsSyntaxApplyOps(ApplyOps$.MODULE$.$times$greater$extension(object, this.request().complete((Object)ex), F));
            Object object3 = package.all$.MODULE$.catsSyntaxApplyOps(ApplyOps$.MODULE$.$times$greater$extension(object2, this.response().complete((Object)ex), F));
            Object object4 = package.all$.MODULE$.catsSyntaxApplyOps(ApplyOps$.MODULE$.$times$greater$extension(object3, this.readBuffer().send((Object)ex), F));
            return (F)ApplyOps$.MODULE$.$times$greater$extension(object4, package.all$.MODULE$.toFunctorOps(this.trailers().complete((Object)ex), F).void(), F);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isClosed() {
            StreamState streamState = this.state();
            H2Stream$StreamState$HalfClosedRemote$ h2Stream$StreamState$HalfClosedRemote$ = H2Stream$StreamState$HalfClosedRemote$.MODULE$;
            if (streamState == null) {
                if (h2Stream$StreamState$HalfClosedRemote$ == null) return true;
            } else if (streamState.equals(h2Stream$StreamState$HalfClosedRemote$)) return true;
            StreamState streamState2 = this.state();
            H2Stream$StreamState$Closed$ h2Stream$StreamState$Closed$ = H2Stream$StreamState$Closed$.MODULE$;
            if (streamState2 != null) {
                if (!streamState2.equals(h2Stream$StreamState$Closed$)) return false;
                return true;
            }
            if (h2Stream$StreamState$Closed$ == null) return true;
            return false;
        }

        public <F> State<F> copy(StreamState state, int writeWindow, Deferred<F, Either<Throwable, BoxedUnit>> writeBlock, int readWindow, Deferred<F, Either<Throwable, Request<Nothing$>>> request, Deferred<F, Either<Throwable, Response<Nothing$>>> response, Deferred<F, Either<Throwable, List>> trailers, Channel<F, Either<Throwable, ByteVector>> readBuffer, Option<Tuple2<Object, Object>> contentLengthCheck) {
            return new State<F>(state, writeWindow, writeBlock, readWindow, request, response, trailers, readBuffer, contentLengthCheck);
        }

        public <F> StreamState copy$default$1() {
            return this.state();
        }

        public int copy$default$2() {
            return this.writeWindow();
        }

        public <F> Deferred<F, Either<Throwable, BoxedUnit>> copy$default$3() {
            return this.writeBlock();
        }

        public int copy$default$4() {
            return this.readWindow();
        }

        public <F> Deferred<F, Either<Throwable, Request<Nothing$>>> copy$default$5() {
            return this.request();
        }

        public <F> Deferred<F, Either<Throwable, Response<Nothing$>>> copy$default$6() {
            return this.response();
        }

        public <F> Deferred<F, Either<Throwable, List>> copy$default$7() {
            return this.trailers();
        }

        public <F> Channel<F, Either<Throwable, ByteVector>> copy$default$8() {
            return this.readBuffer();
        }

        public <F> Option<Tuple2<Object, Object>> copy$default$9() {
            return this.contentLengthCheck();
        }

        public StreamState _1() {
            return this.state();
        }

        public int _2() {
            return this.writeWindow();
        }

        public Deferred<F, Either<Throwable, BoxedUnit>> _3() {
            return this.writeBlock();
        }

        public int _4() {
            return this.readWindow();
        }

        public Deferred<F, Either<Throwable, Request<Nothing$>>> _5() {
            return this.request();
        }

        public Deferred<F, Either<Throwable, Response<Nothing$>>> _6() {
            return this.response();
        }

        public Deferred<F, Either<Throwable, List>> _7() {
            return this.trailers();
        }

        public Channel<F, Either<Throwable, ByteVector>> _8() {
            return this.readBuffer();
        }

        public Option<Tuple2<Object, Object>> _9() {
            return this.contentLengthCheck();
        }
    }

    public static interface StreamState {
        public static int ordinal(StreamState streamState) {
            return H2Stream$StreamState$.MODULE$.ordinal(streamState);
        }
    }
}

