/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.ember.core.h2;

import cats.Applicative$;
import cats.ApplicativeError;
import cats.MonadError;
import cats.effect.kernel.Async;
import cats.effect.kernel.Outcome;
import cats.effect.kernel.Ref;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.effect.kernel.syntax.GenSpawnOps$;
import cats.effect.package$;
import cats.effect.std.Queue$;
import cats.effect.std.Semaphore$;
import cats.effect.syntax.package;
import cats.syntax.ApplicativeErrorIdOps$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.EitherObjectOps$;
import cats.syntax.EitherOps$;
import cats.syntax.FlatMapOps$;
import cats.syntax.OptionOps$;
import cats.syntax.package;
import com.comcast.ip4s.Host;
import com.comcast.ip4s.SocketAddress;
import fs2.Chunk$;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Stream$;
import fs2.io.net.Network;
import fs2.io.net.Socket;
import fs2.io.net.SocketGroup;
import fs2.io.net.tls.TLSContext;
import fs2.io.net.tls.TLSParameters;
import fs2.io.net.tls.TLSSocket;
import fs2.io.net.unixsocket.UnixSocketAddress;
import fs2.io.net.unixsocket.UnixSockets;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.ProtocolException;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Uri;
import org.http4s.ember.core.Util$;
import org.http4s.ember.core.h2.H2Client$;
import org.http4s.ember.core.h2.H2Client$Http1$;
import org.http4s.ember.core.h2.H2Client$Http2$;
import org.http4s.ember.core.h2.H2Client$InvalidSocketType$;
import org.http4s.ember.core.h2.H2Client$MissingHost$;
import org.http4s.ember.core.h2.H2Client$MissingPort$;
import org.http4s.ember.core.h2.H2Client$RequestKey$;
import org.http4s.ember.core.h2.H2Connection;
import org.http4s.ember.core.h2.H2Connection$;
import org.http4s.ember.core.h2.H2Connection$ConnectionType$Client$;
import org.http4s.ember.core.h2.H2Error$RefusedStream$;
import org.http4s.ember.core.h2.H2Frame;
import org.http4s.ember.core.h2.H2Frame$Settings$ConnectionSettings$;
import org.http4s.ember.core.h2.H2Stream;
import org.http4s.ember.core.h2.H2TLS$;
import org.http4s.ember.core.h2.Hpack$;
import org.http4s.ember.core.h2.Preface$;
import org.http4s.ember.core.h2.PseudoHeaders$;
import org.http4s.h2.H2Keys$;
import org.typelevel.log4cats.Logger;
import org.typelevel.vault.DeleteKey;
import scala.DummyImplicit$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public class H2Client<F> {
    private final SocketGroup<F> sg;
    private final Option<UnixSockets<F>> unix;
    private final H2Frame.Settings.ConnectionSettings localSettings;
    private final TLSContext<F> tls;
    private final Ref<F, Map<RequestKey, Tuple2<H2Connection<F>, F>>> connections;
    private final Function2<Request<Nothing$>, F, F> onPushPromise;
    public final Logger<F> org$http4s$ember$core$h2$H2Client$$logger;
    private final Async<F> F;

    public static <F> Resource<F, Function1<Function1<Request<F>, Resource<F, Response<F>>>, Function1<Request<F>, Resource<F, Response<F>>>>> impl(Function2<Request<Nothing$>, Object, Object> function2, TLSContext<F> tLSContext, Option<UnixSockets<F>> option, Logger<F> logger, H2Frame.Settings.ConnectionSettings connectionSettings, boolean bl, boolean bl2, Async<F> async, Network<F> network) {
        return H2Client$.MODULE$.impl(function2, tLSContext, option, logger, connectionSettings, bl, bl2, async, network);
    }

    public static <F> H2Frame.Settings.ConnectionSettings impl$default$5() {
        return H2Client$.MODULE$.impl$default$5();
    }

    public H2Client(SocketGroup<F> sg, Option<UnixSockets<F>> unix, H2Frame.Settings.ConnectionSettings localSettings, TLSContext<F> tls, Ref<F, Map<RequestKey, Tuple2<H2Connection<F>, Object>>> connections, Function2<Request<Nothing$>, Object, Object> onPushPromise, Logger<F> logger, Async<F> F) {
        this.sg = sg;
        this.unix = unix;
        this.localSettings = localSettings;
        this.tls = tls;
        this.connections = connections;
        this.onPushPromise = onPushPromise;
        this.org$http4s$ember$core$h2$H2Client$$logger = logger;
        this.F = F;
    }

    public F getOrCreate(RequestKey key, boolean useTLS, boolean priorKnowledge, boolean enableEndpointValidation, boolean enableServerNameIndication) {
        return (F)package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(this.connections.get(), this.F).map((Function1 & Serializable)_$2 -> _$2.get((Object)key).map((Function1 & Serializable)_$3 -> (H2Connection)_$3._1())), this.F).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                H2Connection connection = (H2Connection)((Some)option).value();
                return Applicative$.MODULE$.apply(this.F).pure((Object)connection);
            }
            if (None$.MODULE$.equals(option)) {
                return package.all$.MODULE$.toFlatMapOps(this.createConnection(key, useTLS, priorKnowledge, enableEndpointValidation, enableServerNameIndication).allocated(this.F), this.F).flatMap((Function1 & Serializable)tup -> package.all$.MODULE$.toFlatMapOps(this.connections.modify((Function1 & Serializable)map -> {
                    Option current = map.get((Object)key);
                    Map newMap = (Map)current.fold(() -> H2Client.$anonfun$1(map, key, tup), (Function1 & Serializable)_$4 -> map);
                    Either out = (Either)current.fold(() -> H2Client.$anonfun$3(tup), (Function1 & Serializable)r -> EitherObjectOps$.MODULE$.right$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), (Object)Tuple2$.MODULE$.apply(r._1(), tup._2())));
                    return Tuple2$.MODULE$.apply((Object)newMap, (Object)out);
                }), this.F).flatMap((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2;
                    Either either = x$1;
                    if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
                        H2Connection connection = (H2Connection)tuple2._1();
                        Object shutdown = tuple2._2();
                        return package.all$.MODULE$.toFunctorOps(shutdown, this.F).map((Function1 & Serializable)_$5 -> connection);
                    }
                    if (either instanceof Left) {
                        H2Connection connection = (H2Connection)((Left)either).value();
                        H2Connection h2Connection = (H2Connection)package.all$.MODULE$.catsSyntaxApplicativeId((Object)connection);
                        return ApplicativeIdOps$.MODULE$.pure$extension((Object)h2Connection, this.F);
                    }
                    throw new MatchError((Object)either);
                }));
            }
            throw new MatchError((Object)option);
        });
    }

    public Resource<F, H2Connection<F>> createConnection(RequestKey key, boolean useTLS, boolean priorKnowledge, boolean enableEndpointValidation, boolean enableServerNameIndication) {
        return this.createSocket(key, useTLS, priorKnowledge, enableEndpointValidation, enableServerNameIndication).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                SocketType socketType = (SocketType)tuple2._2();
                Socket socket = (Socket)tuple2._1();
                if (H2Client$Http2$.MODULE$.equals(socketType)) {
                    return this.fromSocket(ByteVector$.MODULE$.empty(), socket, key);
                }
                if (H2Client$Http1$.MODULE$.equals(socketType)) {
                    InvalidSocketType invalidSocketType = (InvalidSocketType)package.all$.MODULE$.catsSyntaxApplicativeErrorId((Object)H2Client$InvalidSocketType$.MODULE$.apply());
                    return package$.MODULE$.Resource().eval(ApplicativeErrorIdOps$.MODULE$.raiseError$extension((Object)invalidSocketType, this.F));
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Resource<F, Tuple2<Socket<F>, SocketType>> createSocket(RequestKey key, boolean useTLS, boolean priorKnowledge, boolean enableEndpointValidation, boolean enableServerNameIndication) {
        return package$.MODULE$.Resource().eval(H2Client$RequestKey$.MODULE$.getAddress(key, this.F)).flatMap((Function1 & Serializable)address -> {
            Resource resource;
            Either either = address;
            if (either instanceof Left) {
                UnixSocketAddress address2 = (UnixSocketAddress)((Left)either).value();
                Option option = package.all$.MODULE$.catsSyntaxOption(this.unix);
                resource = ((Resource)OptionOps$.MODULE$.liftTo$extension(option).apply(H2Client::createSocket$$anonfun$1$$anonfun$1, (ApplicativeError)Resource$.MODULE$.catsEffectAsyncForResource(this.F))).flatMap((Function1 & Serializable)_$7 -> _$7.client(address2));
            } else if (either instanceof Right) {
                SocketAddress address3 = (SocketAddress)((Right)either).value();
                resource = this.sg.client(address3, this.sg.client$default$2());
            } else {
                throw new MatchError((Object)either);
            }
            return resource.flatMap((Function1 & Serializable)baseSocket -> {
                Resource resource;
                if (useTLS) {
                    TLSParameters tlsParams = Util$.MODULE$.mkClientTLSParameters(address.toOption(), enableEndpointValidation, enableServerNameIndication);
                    resource = this.tls.clientBuilder(baseSocket).withParameters(H2TLS$.MODULE$.transform(tlsParams)).build().flatMap((Function1 & Serializable)tlsSocket -> package$.MODULE$.Resource().eval(tlsSocket.write(Chunk$.MODULE$.empty())).flatMap((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return package$.MODULE$.Resource().eval(this.parseSocketType((TLSSocket<F>)tlsSocket)).map((Function1 & Serializable)socketType -> Tuple2$.MODULE$.apply(tlsSocket, socketType));
                    }));
                } else {
                    SocketType socketType = (SocketType)(priorKnowledge ? H2Client$Http2$.MODULE$ : H2Client$Http1$.MODULE$);
                    Tuple2 out = Tuple2$.MODULE$.apply(baseSocket, (Object)socketType);
                    resource = package$.MODULE$.Resource().pure((Object)out);
                }
                return resource.map((Function1 & Serializable)socket -> socket);
            });
        });
    }

    private F parseSocketType(TLSSocket<F> tlsSocket) {
        return (F)package.all$.MODULE$.toFlatMapOps(H2TLS$.MODULE$.protocol(tlsSocket, this.F), this.F).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                String string = (String)((Some)option).value();
                if ("h2".equals(string)) {
                    return this.F.pure((Object)H2Client$Http2$.MODULE$);
                }
                if ("http/1.1".equals(string)) {
                    return this.F.pure((Object)H2Client$Http1$.MODULE$);
                }
                return this.F.raiseError((Object)new ProtocolException("Unknown protocol"));
            }
            if (None$.MODULE$.equals(option)) {
                return this.F.pure((Object)H2Client$Http1$.MODULE$);
            }
            throw new MatchError((Object)option);
        });
    }

    public Resource<F, H2Connection<F>> fromSocket(ByteVector acc, Socket<F> socket, RequestKey key) {
        return package$.MODULE$.Resource().eval(this.createH2Connection$1(key, socket, acc)).flatMap((Function1 & Serializable)h2 -> {
            Object object = package.all$.MODULE$.genSpawnOps(h2.readLoop(), this.F);
            return GenSpawnOps$.MODULE$.background$extension(object, this.F).flatMap((Function1 & Serializable)x$1 -> {
                Object object = x$1;
                Object object2 = package.all$.MODULE$.genSpawnOps(h2.writeLoop().compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.F))).drain(), this.F);
                return GenSpawnOps$.MODULE$.background$extension(object2, this.F).flatMap((Function1 & Serializable)x$12 -> {
                    Object object = x$12;
                    Object object2 = package.all$.MODULE$.genSpawnOps(this.clearClosed$1((H2Connection)h2), this.F);
                    return GenSpawnOps$.MODULE$.background$extension(object2, this.F).flatMap((Function1 & Serializable)x$1 -> {
                        Object object = x$1;
                        Object object2 = package.all$.MODULE$.genSpawnOps(this.pullCreatedStreams$1((H2Connection)h2), this.F);
                        return GenSpawnOps$.MODULE$.background$extension(object2, this.F).flatMap((Function1 & Serializable)x$12 -> {
                            Object object = x$12;
                            return package$.MODULE$.Resource().eval(this.processSettings$1((H2Connection)h2)).map((Function1 & Serializable)x$1 -> {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return h2;
                            });
                        });
                    });
                });
            });
        });
    }

    public Resource<F, Response<F>> runHttp2Only(Request<F> req, boolean enableEndpointValidation, boolean enableServerNameIndication) {
        boolean bl;
        RequestKey key = H2Client$RequestKey$.MODULE$.fromRequest(req);
        boolean priorKnowledge = req.attributes().contains((DeleteKey)H2Keys$.MODULE$.Http2PriorKnowledge());
        Option option = req.uri().scheme().map((Function1 & Serializable)_$10 -> _$10.value());
        if (option instanceof Some) {
            String string = (String)((Some)option).value();
            bl = "http".equals(string) ? false : ("https".equals(string) ? true : true);
        } else if (None$.MODULE$.equals(option)) {
            bl = !priorKnowledge;
        } else {
            throw new MatchError((Object)option);
        }
        boolean useTLS = bl;
        return package$.MODULE$.Resource().eval(this.getOrCreate(key, useTLS, priorKnowledge, enableEndpointValidation, enableServerNameIndication)).flatMap((Function1 & Serializable)connection -> package$.MODULE$.Resource().make(connection.streamCreateAndHeaders().use((Function1 & Serializable)_$11 -> package.all$.MODULE$.toFlatMapOps(connection.initiateLocalStream(), this.F).flatMap((Function1 & Serializable)stream -> package.all$.MODULE$.toFunctorOps(stream.sendHeaders(PseudoHeaders$.MODULE$.requestToHeaders(req), false), this.F).as(stream)), this.F), (Function1 & Serializable)stream -> connection.mapRef().update((Function1 & Serializable)m -> (Map)m.$minus((Object)BoxesRunTime.boxToInteger((int)stream.id()))), this.F).flatMap((Function1 & Serializable)stream -> {
            Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(stream.sendMessageBody(req), this.F);
            Object object2 = package.all$.MODULE$.genSpawnOps(FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> H2Client.runHttp2Only$$anonfun$1$$anonfun$3$$anonfun$1(stream, req), this.F), this.F);
            return GenSpawnOps$.MODULE$.background$extension(object2, this.F).flatMap((Function1 & Serializable)x$1 -> {
                Object object = x$1;
                return package$.MODULE$.Resource().eval(stream.getResponse()).map((Function1 & Serializable)_$12 -> (Response)_$12.covary().withBodyStream(stream.readBody())).map((Function1 & Serializable)resp -> resp);
            });
        }));
    }

    private static final Map $anonfun$1(Map map$1, RequestKey key$5, Tuple2 tup$2) {
        return (Map)map$1.$plus(Tuple2$.MODULE$.apply((Object)key$5, (Object)tup$2));
    }

    private static final Either $anonfun$3(Tuple2 tup$3) {
        return EitherObjectOps$.MODULE$.left$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), tup$3._1());
    }

    private static final RuntimeException createSocket$$anonfun$1$$anonfun$1() {
        return new RuntimeException("No UnixSockets implementation available; use .withUnixSockets(...) to provide one");
    }

    private final Object createH2Connection$1(RequestKey key$7, Socket socket$1, ByteVector acc$1) {
        return package.all$.MODULE$.toFlatMapOps(H2Client$RequestKey$.MODULE$.getAddress(key$7, this.F), this.F).flatMap((Function1 & Serializable)socketAdd -> package.all$.MODULE$.toFlatMapOps(socket$1.write(Chunk$.MODULE$.byteVector(Preface$.MODULE$.clientBV())), this.F).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return package.all$.MODULE$.toFlatMapOps(package$.MODULE$.Concurrent().apply(this.F, DummyImplicit$.MODULE$.dummyImplicit()).ref(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]))), this.F).flatMap((Function1 & Serializable)ref -> package.all$.MODULE$.toFlatMapOps(H2Connection$.MODULE$.initState(H2Frame$Settings$ConnectionSettings$.MODULE$.default(), H2Frame$Settings$ConnectionSettings$.MODULE$.default().initialWindowSize(), this.localSettings.initialWindowSize(), this.F), this.F).flatMap((Function1 & Serializable)stateRef -> package.all$.MODULE$.toFlatMapOps(Queue$.MODULE$.unbounded(this.F), this.F).flatMap((Function1 & Serializable)queue -> package.all$.MODULE$.toFlatMapOps(Hpack$.MODULE$.create(this.F), this.F).flatMap((Function1 & Serializable)hpack -> package.all$.MODULE$.toFlatMapOps(package$.MODULE$.Deferred().apply(this.F), this.F).flatMap((Function1 & Serializable)settingsAck -> package.all$.MODULE$.toFlatMapOps(Semaphore$.MODULE$.apply(1L, this.F), this.F).flatMap((Function1 & Serializable)streamCreationLock -> package.all$.MODULE$.toFlatMapOps(Queue$.MODULE$.unbounded(this.F), this.F).flatMap((Function1 & Serializable)created -> package.all$.MODULE$.toFunctorOps(Queue$.MODULE$.unbounded(this.F), this.F).map((Function1 & Serializable)closed -> new H2Connection<F>((Either<UnixSocketAddress, SocketAddress<Host>>)socketAdd, H2Connection$ConnectionType$Client$.MODULE$, this.localSettings, ref, stateRef, queue, created, closed, hpack, streamCreationLock.permit(), settingsAck, acc$1, socket$1, this.org$http4s$ember$core$h2$H2Client$$logger, this.F)))))))));
        }));
    }

    private final /* synthetic */ Object clearClosed$1$$anonfun$1(H2Connection h2$1, int i) {
        if (i % 2 != 0) {
            return h2$1.mapRef().update((Function1 & Serializable)m -> (Map)m.$minus((Object)BoxesRunTime.boxToInteger((int)i)));
        }
        return this.F.unit();
    }

    private final Object clearClosed$1(H2Connection h2) {
        return Stream$.MODULE$.fromQueueUnterminated(h2.closedStreams(), Stream$.MODULE$.fromQueueUnterminated$default$2(), this.F).repeat().foreach((Function1 & Serializable)i -> this.clearClosed$1$$anonfun$1(h2, BoxesRunTime.unboxToInt((Object)i))).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.F))).drain();
    }

    private static final ProtocolException processStream$1$$anonfun$1$$anonfun$1() {
        return new ProtocolException("Stream missing for push promise");
    }

    public static final String org$http4s$ember$core$h2$H2Client$$anon$1$$_$applyOrElse$$anonfun$1() {
        return "Error Handling Push Promise";
    }

    private final Object processStream$1(H2Connection h2$2, int i) {
        Object object = package.all$.MODULE$.catsSyntaxApplicativeError(package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFlatMapOps(h2$2.mapRef().get(), this.F).flatMap((Function1 & Serializable)streamMap -> {
            Option option = package.all$.MODULE$.catsSyntaxOption(streamMap.get((Object)BoxesRunTime.boxToInteger((int)i)));
            return OptionOps$.MODULE$.liftTo$extension(option).apply(H2Client::processStream$1$$anonfun$1$$anonfun$1, this.F);
        }), this.F).flatMap((Function1 & Serializable)stream -> package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(stream.getRequest(), this.F).map((Function1 & Serializable)req -> {
            Object resp = package.all$.MODULE$.toFunctorOps(stream.getResponse(), this.F).map((Function1 & Serializable)_$8 -> (Response)_$8.covary().withBodyStream(stream.readBody()));
            return Tuple2$.MODULE$.apply(req, resp);
        }), this.F).flatMap((Function1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                Request req = (Request)tuple2._1();
                Object resp = tuple2._2();
                Object object = package.all$.MODULE$.catsSyntaxApplicativeError(package.all$.MODULE$.toFlatMapOps(this.onPushPromise.apply((Object)req, resp), this.F).flatMap((Function1 & Serializable)x$1 -> {
                    Outcome outcome = x$1;
                    if (outcome instanceof Outcome.Canceled) {
                        package$.MODULE$.Outcome();
                        if (Outcome.Canceled$.MODULE$.unapply((Outcome.Canceled)outcome)) {
                            return stream.rstStream(H2Error$RefusedStream$.MODULE$);
                        }
                    }
                    if (outcome instanceof Outcome.Errored) {
                        package$.MODULE$.Outcome();
                        Outcome.Errored errored = Outcome.Errored$.MODULE$.unapply((Outcome.Errored)outcome);
                        Throwable throwable = (Throwable)errored._1();
                        return stream.rstStream(H2Error$RefusedStream$.MODULE$);
                    }
                    if (outcome instanceof Outcome.Succeeded) {
                        Object object;
                        package$.MODULE$.Outcome();
                        Outcome.Succeeded succeeded = Outcome.Succeeded$.MODULE$.unapply((Outcome.Succeeded)outcome);
                        Object f = object = succeeded._1();
                        return f;
                    }
                    throw new MatchError((Object)outcome);
                }), this.F);
                return package.all$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object, this.F), this.F).flatMap((Function1 & Serializable)outE -> package.all$.MODULE$.toFlatMapOps(h2$2.mapRef().update((Function1 & Serializable)_$9 -> (Map)_$9.$minus((Object)BoxesRunTime.boxToInteger((int)i))), this.F).flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    Either either = package.all$.MODULE$.catsSyntaxEither(outE);
                    return package.all$.MODULE$.toFunctorOps(EitherOps$.MODULE$.liftTo$extension(either, this.F), this.F).map((Function1)(JProcedure1 & Serializable)out -> {});
                }));
            }
            throw new MatchError((Object)tuple2);
        })), this.F);
        Object object2 = package.all$.MODULE$.catsSyntaxApplicativeError(ApplicativeErrorOps$.MODULE$.onError$extension(object, (PartialFunction)new Serializable(this){
            private final /* synthetic */ H2Client $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable e = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable e = throwable = x;
                return this.$outer.org$http4s$ember$core$h2$H2Client$$logger.warn(e, H2Client::org$http4s$ember$core$h2$H2Client$$anon$1$$_$applyOrElse$$anonfun$1);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$http4s$ember$core$h2$H2Client$$anon$1$$_$applyOrElse$$anonfun$1()}, serializedLambda);
            }
        }, this.F), this.F);
        return package.all$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object2, this.F), this.F).void();
    }

    private final /* synthetic */ Object pullCreatedStreams$1$$anonfun$1(H2Connection h2$15, int i) {
        if (i % 2 == 0) {
            return this.processStream$1(h2$15, i);
        }
        return this.F.unit();
    }

    public static final String org$http4s$ember$core$h2$H2Client$$anon$2$$_$applyOrElse$$anonfun$2() {
        return "Server Connection Processing Halted";
    }

    private final Object pullCreatedStreams$1(H2Connection h2) {
        Object object = package.all$.MODULE$.catsSyntaxApplicativeError(Stream$.MODULE$.fromQueueUnterminated(h2.createdStreams(), Stream$.MODULE$.fromQueueUnterminated$default$2(), this.F).parEvalMap(10, (Function1 & Serializable)i -> this.pullCreatedStreams$1$$anonfun$1(h2, BoxesRunTime.unboxToInt((Object)i)), this.F).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.F))).drain(), this.F);
        return ApplicativeErrorOps$.MODULE$.onError$extension(object, (PartialFunction)new Serializable(this){
            private final /* synthetic */ H2Client $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable e = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable e = throwable = x;
                return this.$outer.org$http4s$ember$core$h2$H2Client$$logger.info(e, H2Client::org$http4s$ember$core$h2$H2Client$$anon$2$$_$applyOrElse$$anonfun$2);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$http4s$ember$core$h2$H2Client$$anon$2$$_$applyOrElse$$anonfun$2()}, serializedLambda);
            }
        }, this.F);
    }

    private final Object processSettings$1(H2Connection h2) {
        H2Frame.Settings localSetts = H2Frame$Settings$ConnectionSettings$.MODULE$.toSettings(this.localSettings);
        return h2.outgoing().offer((Object)Chunk$.MODULE$.singleton((Object)localSetts));
    }

    private static final Object runHttp2Only$$anonfun$1$$anonfun$3$$anonfun$1(H2Stream stream$6, Request req$5) {
        return stream$6.sendTrailerHeaders(req$5);
    }

    public static class InvalidSocketType
    extends RuntimeException
    implements Product {
        public static InvalidSocketType apply() {
            return H2Client$InvalidSocketType$.MODULE$.apply();
        }

        public static InvalidSocketType fromProduct(Product product) {
            return H2Client$InvalidSocketType$.MODULE$.fromProduct(product);
        }

        public static boolean unapply(InvalidSocketType invalidSocketType) {
            return H2Client$InvalidSocketType$.MODULE$.unapply(invalidSocketType);
        }

        public InvalidSocketType() {
            super("createConnection only supports http2, and this is not available");
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof InvalidSocketType)) return false;
            InvalidSocketType invalidSocketType = (InvalidSocketType)object;
            boolean bl = invalidSocketType.canEqual(this);
            if (!bl) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof InvalidSocketType;
        }

        public int productArity() {
            return 0;
        }

        public String productPrefix() {
            return "InvalidSocketType";
        }

        public Object productElement(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public InvalidSocketType copy() {
            return new InvalidSocketType();
        }
    }

    public static class MissingHost
    extends RuntimeException
    implements Product {
        public static MissingHost apply() {
            return H2Client$MissingHost$.MODULE$.apply();
        }

        public static MissingHost fromProduct(Product product) {
            return H2Client$MissingHost$.MODULE$.fromProduct(product);
        }

        public static boolean unapply(MissingHost missingHost) {
            return H2Client$MissingHost$.MODULE$.unapply(missingHost);
        }

        public MissingHost() {
            super("Hostname missing");
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MissingHost)) return false;
            MissingHost missingHost = (MissingHost)object;
            boolean bl = missingHost.canEqual(this);
            if (!bl) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof MissingHost;
        }

        public int productArity() {
            return 0;
        }

        public String productPrefix() {
            return "MissingHost";
        }

        public Object productElement(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public MissingHost copy() {
            return new MissingHost();
        }
    }

    public static class MissingPort
    extends RuntimeException
    implements Product {
        public static MissingPort apply() {
            return H2Client$MissingPort$.MODULE$.apply();
        }

        public static MissingPort fromProduct(Product product) {
            return H2Client$MissingPort$.MODULE$.fromProduct(product);
        }

        public static boolean unapply(MissingPort missingPort) {
            return H2Client$MissingPort$.MODULE$.unapply(missingPort);
        }

        public MissingPort() {
            super("Port missing");
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MissingPort)) return false;
            MissingPort missingPort = (MissingPort)object;
            boolean bl = missingPort.canEqual(this);
            if (!bl) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof MissingPort;
        }

        public int productArity() {
            return 0;
        }

        public String productPrefix() {
            return "MissingPort";
        }

        public Object productElement(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public MissingPort copy() {
            return new MissingPort();
        }
    }

    public static final class RequestKey
    implements Product,
    Serializable {
        private final Uri.Scheme scheme;
        private final Either authorityOrAddress;

        public static RequestKey apply(Uri.Scheme scheme, Either<UnixSocketAddress, Uri.Authority> either) {
            return H2Client$RequestKey$.MODULE$.apply(scheme, either);
        }

        public static RequestKey fromProduct(Product product) {
            return H2Client$RequestKey$.MODULE$.fromProduct(product);
        }

        public static <F> RequestKey fromRequest(Request<F> request) {
            return H2Client$RequestKey$.MODULE$.fromRequest(request);
        }

        public static <F> Object getAddress(RequestKey requestKey, MonadError<F, Throwable> monadError) {
            return H2Client$RequestKey$.MODULE$.getAddress(requestKey, monadError);
        }

        public static RequestKey unapply(RequestKey requestKey) {
            return H2Client$RequestKey$.MODULE$.unapply(requestKey);
        }

        public RequestKey(Uri.Scheme scheme, Either<UnixSocketAddress, Uri.Authority> authorityOrAddress) {
            this.scheme = scheme;
            this.authorityOrAddress = authorityOrAddress;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RequestKey)) return false;
            RequestKey requestKey = (RequestKey)object;
            Uri.Scheme scheme = this.scheme();
            Uri.Scheme scheme2 = requestKey.scheme();
            if (scheme == null) {
                if (scheme2 != null) {
                    return false;
                }
            } else if (!scheme.equals(scheme2)) return false;
            Either<UnixSocketAddress, Uri.Authority> either = this.authorityOrAddress();
            Either<UnixSocketAddress, Uri.Authority> either2 = requestKey.authorityOrAddress();
            if (either == null) {
                if (either2 == null) return true;
                return false;
            } else {
                if (!either.equals(either2)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof RequestKey;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "RequestKey";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "scheme";
            }
            if (1 == n2) {
                return "authorityOrAddress";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Uri.Scheme scheme() {
            return this.scheme;
        }

        public Either<UnixSocketAddress, Uri.Authority> authorityOrAddress() {
            return this.authorityOrAddress;
        }

        public String toString() {
            return new StringBuilder(3).append(this.scheme().value()).append("://").append(this.authorityOrAddress().fold((Function1 & Serializable)_$18 -> _$18.toString(), (Function1 & Serializable)_$19 -> _$19.toString())).toString();
        }

        public RequestKey copy(Uri.Scheme scheme, Either<UnixSocketAddress, Uri.Authority> authorityOrAddress) {
            return new RequestKey(scheme, authorityOrAddress);
        }

        public Uri.Scheme copy$default$1() {
            return this.scheme();
        }

        public Either<UnixSocketAddress, Uri.Authority> copy$default$2() {
            return this.authorityOrAddress();
        }

        public Uri.Scheme _1() {
            return this.scheme();
        }

        public Either<UnixSocketAddress, Uri.Authority> _2() {
            return this.authorityOrAddress();
        }
    }

    public static interface SocketType
    extends Product,
    Serializable {
    }
}

