/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.ember.core;

import cats.ApplicativeError;
import cats.FlatMap;
import cats.data.NonEmptyList$;
import cats.effect.kernel.Clock;
import cats.effect.kernel.GenTemporal;
import cats.effect.kernel.syntax.ClockOps$;
import cats.effect.syntax.package;
import cats.syntax.IfMOps$;
import cats.syntax.package;
import fs2.Chunk;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import fs2.io.net.Socket;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Locale;
import org.http4s.Header;
import org.http4s.HttpVersion;
import org.http4s.HttpVersion$;
import org.http4s.ember.core.EmberException$Timeout$;
import org.http4s.ember.core.UtilPlatform;
import org.http4s.headers.Connection;
import org.http4s.headers.Connection$;
import org.typelevel.ci.CIString;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.StringContext$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.NotGiven$;

public final class Util$
implements UtilPlatform,
Serializable {
    private static final CIString closeCi;
    private static final CIString keepAliveCi;
    private static final CIString connectionCi;
    private static final Connection close;
    private static final Connection keepAlive;
    public static final Util$ MODULE$;

    private Util$() {
    }

    static {
        MODULE$ = new Util$();
        closeCi = org.typelevel.ci.package$.MODULE$.CIStringSyntax(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"close"}))).ci((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        keepAliveCi = org.typelevel.ci.package$.MODULE$.CIStringSyntax(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keep-alive"}))).ci((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        connectionCi = org.typelevel.ci.package$.MODULE$.CIStringSyntax(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"connection"}))).ci((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        close = Connection$.MODULE$.apply(NonEmptyList$.MODULE$.of((Object)closeCi, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CIString[0])));
        keepAlive = Connection$.MODULE$.apply(NonEmptyList$.MODULE$.one((Object)keepAliveCi));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Util$.class);
    }

    private <F> Stream<F, Object> streamCurrentTimeMillis(Clock<F> clock) {
        return Stream$.MODULE$.eval(clock.realTime()).map((Function1 & Serializable)_$2 -> _$2.toMillis());
    }

    public <F> Stream<F, Object> readWithTimeout(Socket<F> socket, long started, FiniteDuration timeout, Object shallTimeout, int chunkSize, ApplicativeError<F, Throwable> F, Clock<F> C) {
        return this.go$1(shallTimeout, F, C, started, socket, chunkSize, timeout);
    }

    public Option<FiniteDuration> durationToFinite(Duration duration) {
        Duration duration2 = duration;
        if (duration2 instanceof FiniteDuration) {
            FiniteDuration f = (FiniteDuration)duration2;
            return Some$.MODULE$.apply((Object)f);
        }
        return None$.MODULE$;
    }

    public <F, A> Object timeoutMaybe(Object fa, Duration d, GenTemporal<F, Throwable> F) {
        Duration duration = d;
        if (duration instanceof FiniteDuration) {
            FiniteDuration fd = (FiniteDuration)duration;
            return F.timeout(fa, (Duration)fd, (.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        return fa;
    }

    public <F, A> Object timeoutToMaybe(Object fa, Duration d, Object ft, GenTemporal<F, Throwable> F) {
        Duration duration = d;
        if (duration instanceof FiniteDuration) {
            FiniteDuration fd = (FiniteDuration)duration;
            return F.timeoutTo(fa, (Duration)fd, ft);
        }
        return fa;
    }

    public Connection connectionFor(HttpVersion httpVersion, List headers) {
        if (this.isKeepAlive(httpVersion, headers)) {
            return keepAlive;
        }
        return close;
    }

    public boolean isKeepAlive(HttpVersion httpVersion, List headers) {
        HttpVersion httpVersion2 = httpVersion;
        HttpVersion httpVersion3 = HttpVersion$.MODULE$.HTTP$div1$u002E0();
        HttpVersion httpVersion4 = httpVersion2;
        if (!(httpVersion3 != null ? !httpVersion3.equals(httpVersion4) : httpVersion4 != null)) {
            return this.hasConnection$1(headers, keepAliveCi.toString());
        }
        HttpVersion httpVersion5 = HttpVersion$.MODULE$.HTTP$div1$u002E1();
        HttpVersion httpVersion6 = httpVersion2;
        if (!(httpVersion5 != null ? !httpVersion5.equals(httpVersion6) : httpVersion6 != null)) {
            return !this.hasConnection$1(headers, closeCi.toString());
        }
        throw scala.sys.package$.MODULE$.error("unsupported http version");
    }

    public byte[] concatBytes(byte[] a1, Chunk<Object> a2) {
        if (a1.length == 0) {
            Chunk.ArraySlice slice;
            Chunk<Object> chunk = a2;
            if (chunk instanceof Chunk.ArraySlice && (slice = (Chunk.ArraySlice)chunk).values() instanceof byte[] && slice.offset() == 0 && ((byte[])slice.values()).length == slice.length()) {
                return (byte[])slice.values();
            }
            return (byte[])a2.toArray(ClassTag$.MODULE$.apply(Byte.TYPE));
        }
        byte[] res = Arrays.copyOf(a1, a1.length + a2.size());
        a2.copyToArray((Object)res, a1.length);
        return res;
    }

    private final Stream whenWontTimeout$1(Socket socket$1) {
        return socket$1.reads();
    }

    private final /* synthetic */ Stream whenMayTimeout$1$$anonfun$1(long started$2, ApplicativeError F$2, long now) {
        return Stream$.MODULE$.raiseError((Throwable)EmberException$Timeout$.MODULE$.apply(Instant.ofEpochMilli(started$2), Instant.ofEpochMilli(now)), RaiseThrowable$.MODULE$.fromApplicativeError(F$2));
    }

    private final Stream whenMayTimeout$1$$anonfun$3$$anonfun$1(FiniteDuration remains$2, FiniteDuration processingTime$1, Object shallTimeout$3, ApplicativeError F$4, Clock C$3, long started$4, Socket socket$4, int chunkSize$3) {
        return this.go$1(shallTimeout$3, F$4, C$3, started$4, socket$4, chunkSize$3, remains$2.$minus(processingTime$1));
    }

    private final /* synthetic */ byte whenMayTimeout$1$$anonfun$3$$anonfun$2(byte out) {
        return out;
    }

    private final Stream whenMayTimeout$1(Clock C$1, long started$1, ApplicativeError F$1, Socket socket$2, int chunkSize$1, Object shallTimeout$1, FiniteDuration remains) {
        if (remains.$less$eq((Object)new package.DurationInt(package$.MODULE$.DurationInt(0)).millis())) {
            return this.streamCurrentTimeMillis(C$1).flatMap((Function1 & Serializable)now -> this.whenMayTimeout$1$$anonfun$1(started$1, F$1, BoxesRunTime.unboxToLong((Object)now)), NotGiven$.MODULE$.value());
        }
        Object object = package.clock$.MODULE$.clockOps(socket$2.read(chunkSize$1));
        return Stream$.MODULE$.eval(ClockOps$.MODULE$.timed$extension(object, C$1)).withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                FiniteDuration processingTime = (FiniteDuration)tuple2._1();
                Option read = (Option)tuple2._2();
                return true;
            }
            return false;
        }).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Stream stream;
                FiniteDuration processingTime = (FiniteDuration)tuple2._1();
                Option read = (Option)tuple2._2();
                Option option = read;
                if (None$.MODULE$.equals(option)) {
                    stream = Stream$.MODULE$.empty();
                } else if (option instanceof Some) {
                    Chunk chunk = (Chunk)((Some)option).value();
                    stream = Stream$.MODULE$.chunk(chunk).$plus$plus(() -> this.whenMayTimeout$1$$anonfun$3$$anonfun$1(remains, processingTime, shallTimeout$1, F$1, C$1, started$1, socket$2, chunkSize$1));
                } else {
                    throw new MatchError((Object)option);
                }
                return stream.map((Function1 & Serializable)out -> this.whenMayTimeout$1$$anonfun$3$$anonfun$2(BoxesRunTime.unboxToByte((Object)out)));
            }
            throw new MatchError((Object)tuple2);
        }, NotGiven$.MODULE$.value());
    }

    private final Stream go$1$$anonfun$1(FiniteDuration remains$3, Clock C$5, long started$6, ApplicativeError F$6, Socket socket$6, int chunkSize$5, Object shallTimeout$5) {
        return this.whenMayTimeout$1(C$5, started$6, F$6, socket$6, chunkSize$5, shallTimeout$5, remains$3);
    }

    private final Stream go$1$$anonfun$2(Socket socket$7) {
        return this.whenWontTimeout$1(socket$7);
    }

    private final Stream go$1(Object shallTimeout$4, ApplicativeError F$5, Clock C$4, long started$5, Socket socket$5, int chunkSize$4, FiniteDuration remains) {
        Stream stream = (Stream)package.all$.MODULE$.catsSyntaxIfM((Object)Stream$.MODULE$.eval(shallTimeout$4), (FlatMap)Stream$.MODULE$.monadErrorInstance(F$5));
        return (Stream)IfMOps$.MODULE$.ifM$extension((Object)stream, () -> this.go$1$$anonfun$1(remains, C$4, started$5, F$5, socket$5, chunkSize$4, shallTimeout$4), () -> this.go$1$$anonfun$2(socket$5), (FlatMap)Stream$.MODULE$.monadErrorInstance(F$5));
    }

    private final boolean hasConnection$1(List headers$1, String expected) {
        return headers$1.exists((Function1 & Serializable)x$1 -> {
            Header.Raw raw = x$1;
            if (raw != null) {
                Header.Raw raw2 = Header.Raw$.MODULE$.unapply(raw);
                CIString cIString = raw2._1();
                String string = raw2._2();
                CIString name = cIString;
                String value = string;
                CIString cIString2 = name;
                CIString cIString3 = connectionCi;
                return !(cIString2 != null ? !cIString2.equals(cIString3) : cIString3 != null) && value.toLowerCase(Locale.ROOT).contains(expected);
            }
            throw new MatchError((Object)raw);
        });
    }
}

