/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.ember.core;

import cats.Show;
import cats.Show$;
import cats.syntax.package;
import java.io.Serializable;
import java.time.Instant;
import org.http4s.ember.core.EmberException$;
import org.http4s.ember.core.EmberException$ChunkedEncodingError$;
import org.http4s.ember.core.EmberException$EmptyStream$;
import org.http4s.ember.core.EmberException$IncompleteClientRequest$;
import org.http4s.ember.core.EmberException$MessageTooLong$;
import org.http4s.ember.core.EmberException$ParseError$;
import org.http4s.ember.core.EmberException$ReachedEndOfStream$;
import org.http4s.ember.core.EmberException$ReadTimeout$;
import org.http4s.ember.core.EmberException$RequestHeadersTimeout$;
import org.http4s.ember.core.EmberException$Timeout$;
import scala.Product;
import scala.StringContext$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NoStackTrace;

public interface EmberException
extends Product,
Serializable {
    public static int ordinal(EmberException emberException) {
        return EmberException$.MODULE$.ordinal(emberException);
    }

    public static final class ChunkedEncodingError
    extends RuntimeException
    implements Product,
    EmberException {
        private final String message;

        public static ChunkedEncodingError apply(String string) {
            return EmberException$ChunkedEncodingError$.MODULE$.apply(string);
        }

        public static ChunkedEncodingError fromProduct(Product product) {
            return EmberException$ChunkedEncodingError$.MODULE$.fromProduct(product);
        }

        public static ChunkedEncodingError unapply(ChunkedEncodingError chunkedEncodingError) {
            return EmberException$ChunkedEncodingError$.MODULE$.unapply(chunkedEncodingError);
        }

        public ChunkedEncodingError(String message) {
            this.message = message;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ChunkedEncodingError)) return false;
            ChunkedEncodingError chunkedEncodingError = (ChunkedEncodingError)object;
            String string = this.message();
            String string2 = chunkedEncodingError.message();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof ChunkedEncodingError;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ChunkedEncodingError";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "message";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String message() {
            return this.message;
        }

        @Override
        public String getMessage() {
            return this.message();
        }

        public ChunkedEncodingError copy(String message) {
            return new ChunkedEncodingError(message);
        }

        public String copy$default$1() {
            return this.message();
        }

        public String _1() {
            return this.message();
        }
    }

    public static final class EmptyStream
    extends RuntimeException
    implements Product,
    EmberException {
        public static EmptyStream apply() {
            return EmberException$EmptyStream$.MODULE$.apply();
        }

        public static EmptyStream fromProduct(Product product) {
            return EmberException$EmptyStream$.MODULE$.fromProduct(product);
        }

        public static boolean unapply(EmptyStream emptyStream) {
            return EmberException$EmptyStream$.MODULE$.unapply(emptyStream);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof EmptyStream)) return false;
            EmptyStream emptyStream = (EmptyStream)object;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof EmptyStream;
        }

        public int productArity() {
            return 0;
        }

        public String productPrefix() {
            return "EmptyStream";
        }

        public Object productElement(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String getMessage() {
            return "Cannot Parse Empty Stream";
        }

        public EmptyStream copy() {
            return new EmptyStream();
        }
    }

    public static final class IncompleteClientRequest
    extends IllegalArgumentException
    implements Product,
    EmberException {
        private final String missing;

        public static IncompleteClientRequest apply(String string) {
            return EmberException$IncompleteClientRequest$.MODULE$.apply(string);
        }

        public static IncompleteClientRequest fromProduct(Product product) {
            return EmberException$IncompleteClientRequest$.MODULE$.fromProduct(product);
        }

        public static IncompleteClientRequest unapply(IncompleteClientRequest incompleteClientRequest) {
            return EmberException$IncompleteClientRequest$.MODULE$.unapply(incompleteClientRequest);
        }

        public IncompleteClientRequest(String missing) {
            this.missing = missing;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof IncompleteClientRequest)) return false;
            IncompleteClientRequest incompleteClientRequest = (IncompleteClientRequest)object;
            String string = this.missing();
            String string2 = incompleteClientRequest.missing();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof IncompleteClientRequest;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "IncompleteClientRequest";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "missing";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String missing() {
            return this.missing;
        }

        @Override
        public String getMessage() {
            return Show.ShowInterpolator$.MODULE$.show$extension(package.all$.MODULE$.showInterpolator(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Incomplete Client Request: Mising ", ""}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Show.Shown[]{new Show.Shown(Show.Shown$.MODULE$.mat((Object)this.missing(), (Show.ContravariantShow)Show$.MODULE$.catsShowForString()))}));
        }

        public IncompleteClientRequest copy(String missing) {
            return new IncompleteClientRequest(missing);
        }

        public String copy$default$1() {
            return this.missing();
        }

        public String _1() {
            return this.missing();
        }
    }

    public static final class MessageTooLong
    extends RuntimeException
    implements Product,
    EmberException {
        private final int maxHeaderSize;

        public static MessageTooLong apply(int n) {
            return EmberException$MessageTooLong$.MODULE$.apply(n);
        }

        public static MessageTooLong fromProduct(Product product) {
            return EmberException$MessageTooLong$.MODULE$.fromProduct(product);
        }

        public static MessageTooLong unapply(MessageTooLong messageTooLong) {
            return EmberException$MessageTooLong$.MODULE$.unapply(messageTooLong);
        }

        public MessageTooLong(int maxHeaderSize) {
            this.maxHeaderSize = maxHeaderSize;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.maxHeaderSize());
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MessageTooLong)) return false;
            MessageTooLong messageTooLong = (MessageTooLong)object;
            if (this.maxHeaderSize() != messageTooLong.maxHeaderSize()) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof MessageTooLong;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "MessageTooLong";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToInteger((int)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "maxHeaderSize";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int maxHeaderSize() {
            return this.maxHeaderSize;
        }

        @Override
        public String getMessage() {
            return new StringBuilder(44).append("HTTP Header Section Exceeds Max Size: ").append(this.maxHeaderSize()).append(" Bytes").toString();
        }

        public MessageTooLong copy(int maxHeaderSize) {
            return new MessageTooLong(maxHeaderSize);
        }

        public int copy$default$1() {
            return this.maxHeaderSize();
        }

        public int _1() {
            return this.maxHeaderSize();
        }
    }

    public static final class ParseError
    extends RuntimeException
    implements Product,
    EmberException {
        private final String message;

        public static ParseError apply(String string) {
            return EmberException$ParseError$.MODULE$.apply(string);
        }

        public static ParseError fromProduct(Product product) {
            return EmberException$ParseError$.MODULE$.fromProduct(product);
        }

        public static ParseError unapply(ParseError parseError) {
            return EmberException$ParseError$.MODULE$.unapply(parseError);
        }

        public ParseError(String message) {
            this.message = message;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ParseError)) return false;
            ParseError parseError = (ParseError)object;
            String string = this.message();
            String string2 = parseError.message();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof ParseError;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ParseError";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "message";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String message() {
            return this.message;
        }

        @Override
        public String getMessage() {
            return this.message();
        }

        public ParseError copy(String message) {
            return new ParseError(message);
        }

        public String copy$default$1() {
            return this.message();
        }

        public String _1() {
            return this.message();
        }
    }

    public static final class ReachedEndOfStream
    extends RuntimeException
    implements Product,
    EmberException {
        public static ReachedEndOfStream apply() {
            return EmberException$ReachedEndOfStream$.MODULE$.apply();
        }

        public static ReachedEndOfStream fromProduct(Product product) {
            return EmberException$ReachedEndOfStream$.MODULE$.fromProduct(product);
        }

        public static boolean unapply(ReachedEndOfStream reachedEndOfStream) {
            return EmberException$ReachedEndOfStream$.MODULE$.unapply(reachedEndOfStream);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ReachedEndOfStream)) return false;
            ReachedEndOfStream reachedEndOfStream = (ReachedEndOfStream)object;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof ReachedEndOfStream;
        }

        public int productArity() {
            return 0;
        }

        public String productPrefix() {
            return "ReachedEndOfStream";
        }

        public Object productElement(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String getMessage() {
            return "Reached End Of Stream While Reading";
        }

        public ReachedEndOfStream copy() {
            return new ReachedEndOfStream();
        }
    }

    public static final class ReadTimeout
    extends RuntimeException
    implements Product,
    EmberException {
        private final Duration duration;

        public static ReadTimeout apply(Duration duration) {
            return EmberException$ReadTimeout$.MODULE$.apply(duration);
        }

        public static ReadTimeout fromProduct(Product product) {
            return EmberException$ReadTimeout$.MODULE$.fromProduct(product);
        }

        public static ReadTimeout unapply(ReadTimeout readTimeout) {
            return EmberException$ReadTimeout$.MODULE$.unapply(readTimeout);
        }

        public ReadTimeout(Duration duration) {
            this.duration = duration;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ReadTimeout)) return false;
            ReadTimeout readTimeout = (ReadTimeout)object;
            Duration duration = this.duration();
            Duration duration2 = readTimeout.duration();
            if (duration != null) {
                if (!duration.equals(duration2)) return false;
                return true;
            }
            if (duration2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof ReadTimeout;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ReadTimeout";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "duration";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Duration duration() {
            return this.duration;
        }

        @Override
        public String getMessage() {
            return new StringBuilder(19).append("Read timeout after ").append(this.duration()).toString();
        }

        public ReadTimeout copy(Duration duration) {
            return new ReadTimeout(duration);
        }

        public Duration copy$default$1() {
            return this.duration();
        }

        public Duration _1() {
            return this.duration();
        }
    }

    public static final class RequestHeadersTimeout
    extends RuntimeException
    implements Product,
    EmberException,
    NoStackTrace {
        private final Duration duration;

        public static RequestHeadersTimeout apply(Duration duration) {
            return EmberException$RequestHeadersTimeout$.MODULE$.apply(duration);
        }

        public static RequestHeadersTimeout fromProduct(Product product) {
            return EmberException$RequestHeadersTimeout$.MODULE$.fromProduct(product);
        }

        public static RequestHeadersTimeout unapply(RequestHeadersTimeout requestHeadersTimeout) {
            return EmberException$RequestHeadersTimeout$.MODULE$.unapply(requestHeadersTimeout);
        }

        public RequestHeadersTimeout(Duration duration) {
            this.duration = duration;
            NoStackTrace.$init$((NoStackTrace)this);
        }

        public Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RequestHeadersTimeout)) return false;
            RequestHeadersTimeout requestHeadersTimeout = (RequestHeadersTimeout)object;
            Duration duration = this.duration();
            Duration duration2 = requestHeadersTimeout.duration();
            if (duration != null) {
                if (!duration.equals(duration2)) return false;
                return true;
            }
            if (duration2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof RequestHeadersTimeout;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "RequestHeadersTimeout";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "duration";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Duration duration() {
            return this.duration;
        }

        @Override
        public String getMessage() {
            return new StringBuilder(44).append("Timed out waiting for request headers after ").append(this.duration()).toString();
        }

        public RequestHeadersTimeout copy(Duration duration) {
            return new RequestHeadersTimeout(duration);
        }

        public Duration copy$default$1() {
            return this.duration();
        }

        public Duration _1() {
            return this.duration();
        }
    }

    public static final class Timeout
    extends RuntimeException
    implements Product,
    EmberException {
        private final Instant started;
        private final Instant timedOut;

        public static Timeout apply(Instant instant, Instant instant2) {
            return EmberException$Timeout$.MODULE$.apply(instant, instant2);
        }

        public static Timeout fromProduct(Product product) {
            return EmberException$Timeout$.MODULE$.fromProduct(product);
        }

        public static Timeout unapply(Timeout timeout) {
            return EmberException$Timeout$.MODULE$.unapply(timeout);
        }

        public Timeout(Instant started, Instant timedOut) {
            this.started = started;
            this.timedOut = timedOut;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Timeout)) return false;
            Timeout timeout = (Timeout)object;
            Instant instant = this.started();
            Instant instant2 = timeout.started();
            if (instant == null) {
                if (instant2 != null) {
                    return false;
                }
            } else if (!((Object)instant).equals(instant2)) return false;
            Instant instant3 = this.timedOut();
            Instant instant4 = timeout.timedOut();
            if (instant3 == null) {
                if (instant4 == null) return true;
                return false;
            } else {
                if (!((Object)instant3).equals(instant4)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof Timeout;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Timeout";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "started";
            }
            if (1 == n2) {
                return "timedOut";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Instant started() {
            return this.started;
        }

        public Instant timedOut() {
            return this.timedOut;
        }

        @Override
        public String getMessage() {
            return Show.ShowInterpolator$.MODULE$.show$extension(package.all$.MODULE$.showInterpolator(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Timeout Occured - Started: ", ", Timed Out: ", ""}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Show.Shown[]{new Show.Shown(Show.Shown$.MODULE$.mat((Object)this.started().toString(), (Show.ContravariantShow)Show$.MODULE$.catsShowForString())), new Show.Shown(Show.Shown$.MODULE$.mat((Object)this.timedOut().toString(), (Show.ContravariantShow)Show$.MODULE$.catsShowForString()))}));
        }

        public Timeout copy(Instant started, Instant timedOut) {
            return new Timeout(started, timedOut);
        }

        public Instant copy$default$1() {
            return this.started();
        }

        public Instant copy$default$2() {
            return this.timedOut();
        }

        public Instant _1() {
            return this.started();
        }

        public Instant _2() {
            return this.timedOut();
        }
    }
}

