/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.unsafe;

import cats.effect.unsafe.TimerSkipListNodeBase;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.util.Right;

public final class TimerSkipList
extends AtomicLong {
    private final AtomicReference<Index> head = new AtomicReference();

    public TimerSkipList() {
        super(-9223372036854775807L);
    }

    public final Runnable insertTlr(long now, long delay, Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> callback) {
        return this.insert(now, delay, callback, ThreadLocalRandom.current());
    }

    public final Runnable insert(long now, long delay, Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> callback, ThreadLocalRandom tlr) {
        Predef$.MODULE$.require(delay >= 0L);
        long triggerTime = this.computeTriggerTime(now, delay);
        long sn = this.getAndIncrement();
        long seqNo = sn != Long.MIN_VALUE ? sn : this.getAndIncrement();
        return this.doPut(triggerTime, seqNo, callback, tlr);
    }

    public final Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> pollFirstIfTriggered(long now) {
        return this.doRemoveFirstNodeIfTriggered(now);
    }

    public final long peekFirstTriggerTime() {
        Node head = this.peekFirstNode();
        if (head != null) {
            long tt = head.triggerTime();
            if (tt != Long.MIN_VALUE) {
                return tt;
            }
            return Long.MAX_VALUE;
        }
        return Long.MIN_VALUE;
    }

    @Override
    public final String toString() {
        Node node = this.peekFirstNode();
        if (node == null) {
            return "TimerSkipList()";
        }
        return "TimerSkipList(...)";
    }

    public final Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> peekFirstQuiescent() {
        Node n = this.peekFirstNode();
        if (n != null) {
            return (Function1)n.getCb();
        }
        return null;
    }

    private final int cpr(long xTriggerTime, long xSeqNo, long yTriggerTime, long ySeqNo) {
        long d = xTriggerTime - yTriggerTime;
        if (d < 0L) {
            return -1;
        }
        if (d > 0L) {
            return 1;
        }
        if (xSeqNo < ySeqNo) {
            return -1;
        }
        if (xSeqNo == ySeqNo) {
            return 0;
        }
        return 1;
    }

    private final long computeTriggerTime(long now, long delay) {
        long safeDelay = delay < 0x3FFFFFFFFFFFFFFFL ? delay : this.overflowFree(now, delay);
        return now + safeDelay;
    }

    private final long overflowFree(long now, long delay) {
        Node head = this.peekFirstNode();
        if (head != null) {
            long headDelay = head.triggerTime() - now;
            if (headDelay < 0L && delay - headDelay < 0L) {
                return Long.MAX_VALUE + headDelay;
            }
            return delay;
        }
        return delay;
    }

    private final Node doPut(long triggerTime, long seqNo, Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> cb, ThreadLocalRandom tlr) {
        Node z;
        int levels;
        Index h;
        while (true) {
            Node b;
            Node node;
            h = this.head.get();
            levels = 0;
            if (h == null) {
                Node base = new Node(this, Long.MIN_VALUE, Long.MIN_VALUE, null, null);
                Index h2 = new Index(base, null, null);
                node = this.head.compareAndSet(null, h2) ? base : null;
            } else {
                Index q = h;
                Node foundBase = null;
                while (foundBase == null) {
                    Index d = (q = this.walkRight(q, triggerTime, seqNo)).down();
                    if (d != null) {
                        ++levels;
                        q = d;
                        continue;
                    }
                    foundBase = q.node();
                }
                node = foundBase;
            }
            if ((b = node) == null) continue;
            z = null;
            Node n = null;
            boolean go = true;
            while (go) {
                Node p;
                int c = 0;
                n = (Node)b.getNext();
                if (n == null) {
                    c = -1;
                } else if (n.isMarker()) {
                    go = false;
                } else if (n.isDeleted()) {
                    this.unlinkNode(b, n);
                    c = 1;
                } else {
                    c = this.cpr(triggerTime, seqNo, n.triggerTime(), n.sequenceNum());
                    if (c > 0) {
                        b = n;
                    }
                }
                if (c >= 0 || !b.casNext(n, p = new Node(this, triggerTime, seqNo, cb, n))) continue;
                z = p;
                go = false;
            }
            if (z != null) break;
        }
        long rnd = tlr.nextLong();
        if ((rnd & 3L) == 0L) {
            int skips = levels;
            Index x = null;
            boolean go = true;
            while (go) {
                x = new Index(z, x, null);
                if (rnd >= 0L) {
                    go = false;
                    continue;
                }
                if (--skips < 0) {
                    go = false;
                    continue;
                }
                rnd <<= 1;
            }
            if (this.addIndices(h, skips, x) && skips < 0 && this.head.get() == h) {
                Index hx = new Index(z, x, null);
                Index nh = new Index(h.node(), h, hx);
                this.head.compareAndSet(h, nh);
            }
            if (z.isDeleted()) {
                this.findPredecessor(triggerTime, seqNo);
            }
        }
        return z;
    }

    private final Index walkRight(Index q, long triggerTime, long seqNo) {
        Index r;
        while ((r = q.getRight()) != null) {
            Node p = r.node();
            if (p.isMarker() || p.isDeleted()) {
                q.casRight(r, r.getRight());
                continue;
            }
            if (this.cpr(triggerTime, seqNo, p.triggerTime(), p.sequenceNum()) > 0) {
                q = r;
                continue;
            }
            return q;
        }
        return q;
    }

    public final boolean cats$effect$unsafe$TimerSkipList$$doRemove(long triggerTime, long seqNo) {
        Node b = this.findPredecessor(triggerTime, seqNo);
        while (b != null) {
            boolean inner = true;
            while (inner) {
                Node n = (Node)b.getNext();
                if (n == null) {
                    return false;
                }
                if (n.isMarker()) {
                    inner = false;
                    b = this.findPredecessor(triggerTime, seqNo);
                    continue;
                }
                Function1 ncb = (Function1)n.getCb();
                if (ncb == null) {
                    this.unlinkNode(b, n);
                    continue;
                }
                int c = this.cpr(triggerTime, seqNo, n.triggerTime(), n.sequenceNum());
                if (c > 0) {
                    b = n;
                    continue;
                }
                if (c < 0) {
                    return false;
                }
                if (!n.casCb(ncb, null)) continue;
                this.unlinkNode(b, n);
                this.findPredecessor(triggerTime, seqNo);
                this.tryReduceLevel();
                return true;
            }
        }
        return false;
    }

    private final Node peekFirstNode() {
        Node b = this.baseHead();
        if (b != null) {
            Node n = null;
            while ((n = (Node)b.getNext()) != null && n.isDeleted()) {
                b = n;
            }
            return n;
        }
        return null;
    }

    private final Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> doRemoveFirstNodeIfTriggered(long now) {
        Node b = this.baseHead();
        if (b != null) {
            return this.go$1(now, b);
        }
        return null;
    }

    private final Node baseHead() {
        Index h = this.head.get();
        if (h != null) {
            return h.node();
        }
        return null;
    }

    private final boolean addIndices(Index _q, int _skips, Index x) {
        if (x != null) {
            Index q = _q;
            int skips = _skips;
            Node z = x.node();
            if (z != null && !z.isMarker() && q != null) {
                boolean retrying = false;
                while (true) {
                    Index r = q.getRight();
                    int c = 0;
                    if (r != null) {
                        Node p = r.node();
                        if (p.isMarker() || p.isDeleted()) {
                            q.casRight(r, r.getRight());
                            c = 0;
                        } else {
                            c = this.cpr(z.triggerTime(), z.sequenceNum(), p.triggerTime(), p.sequenceNum());
                        }
                        if (c > 0) {
                            q = r;
                        } else if (c == 0) {
                            return false;
                        }
                    } else {
                        c = -1;
                    }
                    if (c >= 0) continue;
                    Index d = q.down();
                    if (d != null && skips > 0) {
                        --skips;
                        q = d;
                        continue;
                    }
                    if (d != null && !retrying && !this.addIndices(d, 0, x.down())) {
                        return false;
                    }
                    x.setRight(r);
                    if (q.casRight(r, x)) {
                        return true;
                    }
                    retrying = true;
                }
            }
        }
        return false;
    }

    private final Node findPredecessor(long triggerTime, long seqNo) {
        Index q = this.head.get();
        if (q == null || seqNo == Long.MIN_VALUE) {
            return null;
        }
        while (true) {
            Index d = (q = this.walkRight(q, triggerTime, seqNo)).down();
            if (d != null) {
                q = d;
                continue;
            }
            return q.node();
        }
        return null;
    }

    private final void unlinkNode(Node b, Node n) {
        if (b != null && n != null) {
            Node p = this.mark$1(n);
            b.casNext(n, p);
            return;
        }
    }

    private final void tryReduceLevel() {
        Index lv1 = this.head.get();
        if (lv1 != null && lv1.getRight() == null) {
            Index lv2 = lv1.down();
            if (lv2 != null && lv2.getRight() == null) {
                Index lv3 = lv2.down();
                if (lv3 != null && lv3.getRight() == null) {
                    if (this.head.compareAndSet(lv1, lv2)) {
                        if (lv1.getRight() != null) {
                            this.head.compareAndSet(lv2, lv1);
                            return;
                        }
                        return;
                    }
                    return;
                }
                return;
            }
            return;
        }
    }

    private final Function1 go$1(long now$1, Node b$1) {
        Node n;
        while ((n = (Node)b$1.getNext()) != null) {
            long tt = n.triggerTime();
            if (now$1 - tt >= 0L) {
                Function1 cb = (Function1)n.getCb();
                if (cb == null) {
                    this.unlinkNode(b$1, n);
                    continue;
                }
                if (!n.casCb(cb, null)) continue;
                this.unlinkNode(b$1, n);
                this.tryReduceLevel();
                this.findPredecessor(tt, n.sequenceNum());
                return cb;
            }
            return null;
        }
        return null;
    }

    private final Node mark$1(Node n$1) {
        Node f;
        do {
            if ((f = (Node)n$1.getNext()) == null || !f.isMarker()) continue;
            return (Node)f.getNext();
        } while (!n$1.casNext(f, new Node(this, Long.MIN_VALUE, Long.MIN_VALUE, null, f)));
        return f;
    }

    public final class Index
    extends AtomicReference<Index> {
        private final Node node;
        private final Index down;

        public Index(Node node, Index down, Index r) {
            this.node = node;
            this.down = down;
            super(r);
            Predef$.MODULE$.require(node != null);
        }

        public Node node() {
            return this.node;
        }

        public Index down() {
            return this.down;
        }

        public final Index getRight() {
            return (Index)this.get();
        }

        public final void setRight(Index nv) {
            this.set(nv);
        }

        public final boolean casRight(Index ov, Index nv) {
            return this.compareAndSet(ov, nv);
        }

        @Override
        public final String toString() {
            return "Index(...)";
        }
    }

    public final class Node
    extends TimerSkipListNodeBase<Function1<Right<Nothing$, BoxedUnit>, BoxedUnit>, Node>
    implements Function0<BoxedUnit>,
    Runnable {
        private final long triggerTime;
        private final long sequenceNum;
        private final /* synthetic */ TimerSkipList $outer;

        public Node(TimerSkipList $outer, long triggerTime, long sequenceNum, Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> cb, Node next) {
            this.triggerTime = triggerTime;
            this.sequenceNum = sequenceNum;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(cb, next);
        }

        public long triggerTime() {
            return this.triggerTime;
        }

        public long sequenceNum() {
            return this.sequenceNum;
        }

        public final void apply() {
            this.apply$mcV$sp();
        }

        public final void apply$mcV$sp() {
            this.$outer.cats$effect$unsafe$TimerSkipList$$doRemove(this.triggerTime(), this.sequenceNum());
        }

        @Override
        public final void run() {
            this.apply$mcV$sp();
        }

        public final boolean isMarker() {
            return this.sequenceNum() == Long.MIN_VALUE;
        }

        public final boolean isDeleted() {
            return this.getCb() == null;
        }

        @Override
        public final String toString() {
            return "<function>";
        }

        public final /* synthetic */ TimerSkipList cats$effect$unsafe$TimerSkipList$Node$$$outer() {
            return this.$outer;
        }
    }
}

