/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.staticcontent;

import cats.Applicative;
import cats.ApplicativeError;
import cats.FlatMap;
import cats.Functor;
import cats.Monad;
import cats.MonadError;
import cats.data.Kleisli;
import cats.data.Kleisli$;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.OptionT;
import cats.data.OptionT$;
import cats.effect.SyncIO;
import cats.effect.kernel.Async;
import cats.effect.kernel.Sync;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.FlattenOps$;
import cats.syntax.package;
import fs2.Stream;
import fs2.io.file.BasicFileAttributes;
import fs2.io.file.Files;
import fs2.io.file.Files$;
import fs2.io.file.Path;
import fs2.io.file.Path$;
import java.io.File;
import java.io.Serializable;
import java.nio.file.NoSuchFileException;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.HttpRoutes$;
import org.http4s.HttpVersion;
import org.http4s.Platform$;
import org.http4s.RangeUnit;
import org.http4s.RangeUnit$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.StaticFile$;
import org.http4s.Status;
import org.http4s.Status$;
import org.http4s.headers.Accept$minusRanges$;
import org.http4s.headers.Content$minusRange$;
import org.http4s.headers.Range;
import org.http4s.headers.Range$;
import org.http4s.server.middleware.TranslateUri$;
import org.http4s.server.staticcontent.CacheStrategy;
import org.http4s.server.staticcontent.FileService;
import org.http4s.server.staticcontent.FileService$BadTraversal$2$;
import org.http4s.server.staticcontent.FileService$Config$;
import org.http4s.server.staticcontent.package$;
import org.typelevel.log4cats.SelfAwareStructuredLogger;
import org.typelevel.vault.Vault;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Some$;
import scala.StringContext$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class FileService$
implements Serializable {
    private static final SelfAwareStructuredLogger<SyncIO> logger;
    public static final FileService$Config$ Config;
    public static final FileService$ MODULE$;

    private FileService$() {
    }

    static {
        MODULE$ = new FileService$();
        logger = (SelfAwareStructuredLogger)Platform$.MODULE$.loggerFactory().getLogger("org.http4s.server.staticcontent.FileService");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FileService$.class);
    }

    public <F> Function3<Path, FileService.Config<F>, Request<F>, OptionT<F, Response<F>>> org$http4s$server$staticcontent$FileService$$$Config$superArg$1(String systemPath, Function3<File, FileService.Config<F>, Request<F>, OptionT<F, Response<F>>> pathCollector, String pathPrefix, int bufferSize, CacheStrategy<F> cacheStrategy) {
        return (Function3 & Serializable)(path, config, request) -> (OptionT)pathCollector.apply((Object)path.toNioPath().toFile(), config, request);
    }

    public <F> Kleisli<?, Request<F>, Response<F>> apply(FileService.Config<F> config, Async<F> F) {
        return this.apply(config, Files$.MODULE$.forAsync(F), F);
    }

    public <F> Kleisli<?, Request<F>, Response<F>> apply(FileService.Config<F> config, Files<F> evidence$1, Async<F> F) {
        LazyRef lazyRef = new LazyRef();
        Object readPath = Files$.MODULE$.apply(evidence$1).realPath(Path$.MODULE$.apply(config.systemPath()));
        Object object = package.all$.MODULE$.catsSyntaxApplicativeError(readPath, F);
        Object inner = package.all$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object, F), F).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                Path rootPath = (Path)((Right)either).value();
                Kleisli kleisli = (Kleisli)package.all$.MODULE$.catsSyntaxApplicativeId(TranslateUri$.MODULE$.apply(config.pathPrefix(), Kleisli$.MODULE$.apply((Function1 & Serializable)request -> this.withPath$1(F, evidence$1, config, lazyRef, rootPath, (Request)request)), OptionT$.MODULE$.catsDataMonoidKForOptionT((Monad)F)));
                return ApplicativeIdOps$.MODULE$.pure$extension((Object)kleisli, (Applicative)F);
            }
            if (either instanceof Left) {
                Throwable throwable = (Throwable)((Left)either).value();
                if (throwable instanceof NoSuchFileException) {
                    return package.all$.MODULE$.toFunctorOps(((SyncIO)logger.error(() -> this.$anonfun$5$$anonfun$2(config))).to((Sync)F), (Functor)F).as((Object)HttpRoutes$.MODULE$.empty((Applicative)F));
                }
                Throwable e = throwable;
                return package.all$.MODULE$.toFunctorOps(((SyncIO)logger.error(e, () -> this.$anonfun$5$$anonfun$3(config))).to((Sync)F), (Functor)F).as((Object)HttpRoutes$.MODULE$.pure(Response$.MODULE$.apply(Status$.MODULE$.InternalServerError(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()), (Applicative)OptionT$.MODULE$.catsDataMonadErrorForOptionT((MonadError)F)));
            }
            throw new MatchError((Object)either);
        });
        Kleisli kleisli = (Kleisli)package.all$.MODULE$.catsSyntaxFlatten((Object)Kleisli$.MODULE$.apply((Function1 & Serializable)_$13 -> OptionT$.MODULE$.liftF(inner, (Functor)F)), (FlatMap)Kleisli$.MODULE$.catsDataMonadErrorForKleisli(OptionT$.MODULE$.catsDataMonadErrorForOptionT(F)));
        return (Kleisli)FlattenOps$.MODULE$.flatten$extension((Object)kleisli, (FlatMap)Kleisli$.MODULE$.catsDataMonadErrorForKleisli(OptionT$.MODULE$.catsDataMonadErrorForOptionT(F)));
    }

    public <F> OptionT<F, Response<F>> org$http4s$server$staticcontent$FileService$$$filesOnly(Path path, FileService.Config<F> config, Request<F> req, Files<F> evidence$1, MonadError<F, Throwable> F) {
        return OptionT$.MODULE$.apply(package.all$.MODULE$.toFlatMapOps(Files$.MODULE$.apply(evidence$1).getBasicFileAttributes(path), F).flatMap((Function1 & Serializable)attr -> {
            if (attr.isDirectory()) {
                return StaticFile$.MODULE$.fromPath(path.$div("index.html"), (Option)Some$.MODULE$.apply((Object)req), evidence$1, F).value();
            }
            if (!attr.isRegularFile()) {
                return F.pure((Object)None$.MODULE$);
            }
            return OptionT$.MODULE$.apply(this.getPartialContentFile(path, config, req, evidence$1, F)).orElse(() -> this.filesOnly$$anonfun$1$$anonfun$1(path, config, req, evidence$1, F), (Monad)F).value();
        }));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validRange(long start, Option<Object> end, long fileLength) {
        if (start >= fileLength) return false;
        Option<Object> option = end;
        if (option instanceof Some) {
            long end2 = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            if (start < 0L) return false;
            if (start > end2) return false;
            return true;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        if (start >= 0L) return true;
        if (fileLength + start - 1L < 0L) return false;
        return true;
    }

    private <F> Object getPartialContentFile(Path file, FileService.Config<F> config, Request<F> req, Files<F> evidence$1, MonadError<F, Throwable> F) {
        return package.all$.MODULE$.toFlatMapOps(Files$.MODULE$.apply(evidence$1).getBasicFileAttributes(file), F).flatMap((Function1 & Serializable)attr -> {
            Option option;
            Range range;
            Option option2 = Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.singleHeaders(Range$.MODULE$.headerInstance()));
            if (option2 instanceof Some && (range = (Range)((Some)option2).value()) != null) {
                Range range2 = Range$.MODULE$.unapply(range);
                RangeUnit rangeUnit = range2._1();
                NonEmptyList nonEmptyList = range2._2();
                RangeUnit rangeUnit2 = RangeUnit$.MODULE$.Bytes();
                RangeUnit rangeUnit3 = rangeUnit;
                if (!(rangeUnit2 != null ? !rangeUnit2.equals(rangeUnit3) : rangeUnit3 != null) && nonEmptyList != null) {
                    NonEmptyList nonEmptyList2 = NonEmptyList$.MODULE$.unapply(nonEmptyList);
                    Range.SubRange subRange = (Range.SubRange)nonEmptyList2._1();
                    List list = nonEmptyList2._2();
                    if (subRange != null) {
                        Range.SubRange subRange2 = Range.SubRange$.MODULE$.unapply(subRange);
                        long l = subRange2._1();
                        Option option3 = subRange2._2();
                        long s = l;
                        Option e = option3;
                        Nil$ nil$ = scala.package$.MODULE$.Nil();
                        List list2 = list;
                        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                            if (this.validRange(s, (Option<Object>)e, attr.size())) {
                                long size = attr.size();
                                long start = s >= 0L ? s : scala.math.package$.MODULE$.max(0L, size + s);
                                long end = scala.math.package$.MODULE$.min(size - 1L, BoxesRunTime.unboxToLong((Object)e.getOrElse(() -> this.$anonfun$6(size))));
                                return StaticFile$.MODULE$.fromPath(file, start, end + 1L, config.bufferSize(), (Option)Some$.MODULE$.apply((Object)req), StaticFile$.MODULE$.calculateETag(evidence$1, (ApplicativeError)F), evidence$1, F).map((Function1 & Serializable)resp -> {
                                    List hs = Headers$.MODULE$.put$extension(resp.headers(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)package$.MODULE$.AcceptRangeHeader(), Accept$minusRanges$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Content$minusRange$.MODULE$.apply(Range.SubRange$.MODULE$.apply(start, end), (Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)size))), Content$minusRange$.MODULE$.headerInstance())}));
                                    Status status = Status$.MODULE$.PartialContent();
                                    HttpVersion httpVersion = resp.copy$default$2();
                                    Stream stream = resp.copy$default$4();
                                    Vault vault = resp.copy$default$5();
                                    return resp.copy(status, httpVersion, hs, stream, vault);
                                }, (Functor)F).value();
                            }
                            return this.nope$1((BasicFileAttributes)attr, F);
                        }
                    }
                }
            }
            if ((option = Headers$.MODULE$.get$extension(req.headers(), org.typelevel.ci.package$.MODULE$.CIStringSyntax(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Range"}))).ci((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])))) instanceof Some) {
                return this.nope$1((BasicFileAttributes)attr, F);
            }
            if (None$.MODULE$.equals(option)) {
                return F.pure((Object)None$.MODULE$);
            }
            throw new MatchError((Object)option);
        });
    }

    private final FileService$BadTraversal$2$ BadTraversal$lzyINIT1$1(LazyRef BadTraversal$lzy1$1) {
        FileService$BadTraversal$2$ fileService$BadTraversal$2$;
        LazyRef lazyRef = BadTraversal$lzy1$1;
        synchronized (lazyRef) {
            fileService$BadTraversal$2$ = (FileService$BadTraversal$2$)(BadTraversal$lzy1$1.initialized() ? BadTraversal$lzy1$1.value() : BadTraversal$lzy1$1.initialize((Object)new FileService$BadTraversal$2$()));
        }
        return fileService$BadTraversal$2$;
    }

    public final FileService$BadTraversal$2$ org$http4s$server$staticcontent$FileService$$$_$BadTraversal$1(LazyRef BadTraversal$lzy1$2) {
        return (FileService$BadTraversal$2$)(BadTraversal$lzy1$2.initialized() ? BadTraversal$lzy1$2.value() : this.BadTraversal$lzyINIT1$1(BadTraversal$lzy1$2));
    }

    private final Path $anonfun$3(Vector segments$1, Path rootPath$1, LazyRef BadTraversal$lzy1$4) {
        return (Path)segments$1.foldLeft((Object)rootPath$1, (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            String string = (String)tuple2._2();
            switch (string == null ? 0 : string.hashCode()) {
                case 0: {
                    if ("".equals(string)) throw this.org$http4s$server$staticcontent$FileService$$$_$BadTraversal$1(BadTraversal$lzy1$4);
                    break;
                }
                case 46: {
                    if (".".equals(string)) throw this.org$http4s$server$staticcontent$FileService$$$_$BadTraversal$1(BadTraversal$lzy1$4);
                    break;
                }
                case 1472: {
                    if (!"..".equals(string)) break;
                    throw this.org$http4s$server$staticcontent$FileService$$$_$BadTraversal$1(BadTraversal$lzy1$4);
                }
            }
            Path path = (Path)tuple2._1();
            String segment = string;
            return path.resolve(segment);
        });
    }

    private final /* synthetic */ Option $anonfun$4$$anonfun$1(Path path$1, Path rootPath$3, boolean existsPath) {
        if (existsPath && path$1.startsWith(rootPath$3)) {
            return Some$.MODULE$.apply((Object)path$1.absolute().normalize());
        }
        return None$.MODULE$;
    }

    private final OptionT withPath$1(Async F$3, Files evidence$1$2, FileService.Config config$1, LazyRef BadTraversal$lzy1$3, Path rootPath, Request request) {
        Object object;
        if (request.pathInfo().isEmpty()) {
            object = F$3.pure((Object)rootPath);
        } else {
            Vector segments = (Vector)request.pathInfo().segments().map((Function1 & Serializable)_$11 -> _$11.decoded(_$11.decoded$default$1(), true, _$11.decoded$default$3()));
            object = F$3.catchNonFatal(() -> this.$anonfun$3(segments, rootPath, BadTraversal$lzy1$3), (.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        Object resolvePath = object;
        Object matchingPath = package.all$.MODULE$.toFlatMapOps(resolvePath, (FlatMap)F$3).flatMap((Function1 & Serializable)path -> package.all$.MODULE$.toFunctorOps(Files$.MODULE$.apply(evidence$1$2).exists(path, false), (Functor)F$3).map((Function1 & Serializable)existsPath -> this.$anonfun$4$$anonfun$1((Path)path, rootPath, BoxesRunTime.unboxToBoolean((Object)existsPath))));
        OptionT optionT = (OptionT)package.all$.MODULE$.catsSyntaxApplicativeError((Object)OptionT$.MODULE$.apply(matchingPath).flatMap((Function1 & Serializable)path -> (OptionT)config$1.fs2PathCollector().apply(path, (Object)config$1, (Object)request), (Monad)F$3).semiflatMap((Function1 & Serializable)_$12 -> config$1.cacheStrategy().cache(request.pathInfo(), _$12, F$3), (Monad)F$3), (ApplicativeError)OptionT$.MODULE$.catsDataMonadErrorForOptionT((MonadError)F$3));
        return (OptionT)ApplicativeErrorOps$.MODULE$.recoverWith$extension((Object)optionT, (PartialFunction)new Serializable(F$3, BadTraversal$lzy1$3){
            private final Async F$6;
            private final LazyRef BadTraversal$lzy1$5;
            {
                this.F$6 = F$14;
                this.BadTraversal$lzy1$5 = BadTraversal$lzy1$9;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                FileService$BadTraversal$2$ fileService$BadTraversal$2$ = FileService$.MODULE$.org$http4s$server$staticcontent$FileService$$$_$BadTraversal$1(this.BadTraversal$lzy1$5);
                Throwable throwable2 = throwable;
                return !(fileService$BadTraversal$2$ != null ? !fileService$BadTraversal$2$.equals(throwable2) : throwable2 != null);
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                FileService$BadTraversal$2$ fileService$BadTraversal$2$ = FileService$.MODULE$.org$http4s$server$staticcontent$FileService$$$_$BadTraversal$1(this.BadTraversal$lzy1$5);
                Throwable throwable2 = throwable;
                if (!(fileService$BadTraversal$2$ != null ? !fileService$BadTraversal$2$.equals(throwable2) : throwable2 != null)) {
                    boolean bl = OptionT$.MODULE$.some();
                    return OptionT.PurePartiallyApplied$.MODULE$.apply$extension(bl, (Object)Response$.MODULE$.apply(Status$.MODULE$.BadRequest(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()), (Applicative)this.F$6);
                }
                return function1.apply((Object)x);
            }
        }, (ApplicativeError)OptionT$.MODULE$.catsDataMonadErrorForOptionT((MonadError)F$3));
    }

    private final String $anonfun$5$$anonfun$2(FileService.Config config$6) {
        return new StringBuilder(110).append("Could not find root path from FileService config: systemPath = ").append(config$6.systemPath()).append(", pathPrefix = ").append(config$6.pathPrefix()).append(". All requests will return none.").toString();
    }

    private final String $anonfun$5$$anonfun$3(FileService.Config config$7) {
        return new StringBuilder(117).append("Could not resolve root path from FileService config: systemPath = ").append(config$7.systemPath()).append(", pathPrefix = ").append(config$7.pathPrefix()).append(". All requests will fail with a 500.").toString();
    }

    private final OptionT filesOnly$$anonfun$1$$anonfun$1(Path path$3, FileService.Config config$9, Request req$2, Files evidence$1$7, MonadError F$11) {
        return StaticFile$.MODULE$.fromPath(path$3, config$9.bufferSize(), (Option)Some$.MODULE$.apply((Object)req$2), StaticFile$.MODULE$.calculateETag(evidence$1$7, (ApplicativeError)F$11), evidence$1$7, F$11).map((Function1 & Serializable)_$15 -> (Response)_$15.putHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)package$.MODULE$.AcceptRangeHeader(), Accept$minusRanges$.MODULE$.headerInstance())})), (Functor)F$11);
    }

    private final Object nope$1(BasicFileAttributes attr$1, MonadError F$12) {
        Status status = Status$.MODULE$.RangeNotSatisfiable();
        List list = Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)package$.MODULE$.AcceptRangeHeader(), Accept$minusRanges$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Content$minusRange$.MODULE$.apply(Range.SubRange$.MODULE$.apply(0L, attr$1.size() - 1L), (Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)attr$1.size()))), Content$minusRange$.MODULE$.headerInstance())}));
        HttpVersion httpVersion = Response$.MODULE$.apply$default$2();
        Stream stream = Response$.MODULE$.apply$default$4();
        Vault vault = Response$.MODULE$.apply$default$5();
        Some some = (Some)package.all$.MODULE$.catsSyntaxApplicativeId((Object)Some$.MODULE$.apply((Object)Response$.MODULE$.apply(status, httpVersion, list, stream, vault)));
        return package.all$.MODULE$.toFunctorOps(ApplicativeIdOps$.MODULE$.pure$extension((Object)some, (Applicative)F$12), (Functor)F$12).widen();
    }

    private final long $anonfun$6(long size$1) {
        return size$1 - 1L;
    }
}

