/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.middleware;

import cats.Applicative;
import cats.ApplicativeError;
import cats.FlatMap;
import cats.Functor;
import cats.arrow.FunctionK;
import cats.data.EitherT;
import cats.data.EitherT$;
import cats.data.Kleisli;
import cats.data.Kleisli$;
import cats.effect.SyncIO;
import cats.effect.SyncIO$;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.Sync;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.package;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import javax.crypto.SecretKey;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.Request;
import org.http4s.RequestCookie;
import org.http4s.RequestCookie$;
import org.http4s.Response;
import org.http4s.ResponseCookie;
import org.http4s.ResponseCookie$;
import org.http4s.SameSite;
import org.http4s.Uri;
import org.http4s.crypto.Hmac$;
import org.http4s.crypto.HmacAlgorithm;
import org.http4s.crypto.SecureEq$;
import org.http4s.headers.Host;
import org.http4s.headers.X;
import org.http4s.server.middleware.CSRF$;
import org.http4s.server.middleware.CSRF$CSRFCheckFailed$;
import org.http4s.server.middleware.CSRF$CookieSettings$;
import org.typelevel.ci.CIString;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scodec.bits.Bases;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public final class CSRF<F, G> {
    private final CIString headerName;
    private final CookieSettings cookieSettings;
    private final Clock clock;
    public final Response<G> org$http4s$server$middleware$CSRF$$onFailure;
    private final boolean createIfNotFound;
    private final org.http4s.crypto.SecretKey<HmacAlgorithm> key;
    private final Function1<Request<G>, Object> headerCheck;
    private final Sync<F> F;
    private final Function2<Request<G>, F, F> csrfChecker;

    public static int CSRFTokenLength() {
        return CSRF$.MODULE$.CSRFTokenLength();
    }

    public static int SHA1ByteLen() {
        return CSRF$.MODULE$.SHA1ByteLen();
    }

    public static String SigningAlgo() {
        return CSRF$.MODULE$.SigningAlgo();
    }

    public static <F, G> CSRFBuilder<F, G> apply(SecretKey secretKey, Function1<Request<G>, Object> function1, Sync<F> sync, Applicative<G> applicative) {
        return CSRF$.MODULE$.apply(secretKey, function1, sync, applicative);
    }

    public static <F> Object buildSigningKey(byte[] byArray, Sync<F> sync) {
        return CSRF$.MODULE$.buildSigningKey(byArray, sync);
    }

    public static <F, G> Function1<CSRF<F, G>, Function2<Request<G>, Object, Object>> checkCSRFDefault(Sync<F> sync) {
        return CSRF$.MODULE$.checkCSRFDefault(sync);
    }

    public static <F, G> Function1<CSRF<F, G>, Function2<Request<G>, Object, Object>> checkCSRFinHeaderAndForm(String string, FunctionK<G, F> functionK, GenConcurrent<G, Throwable> genConcurrent, Sync<F> sync) {
        return CSRF$.MODULE$.checkCSRFinHeaderAndForm(string, functionK, genConcurrent, sync);
    }

    public static <F> Option<RequestCookie> cookieFromHeaders(Request<F> request, String string) {
        return CSRF$.MODULE$.cookieFromHeaders(request, string);
    }

    public static <F, G> Object cookieFromHeadersF(Request<G> request, String string, Sync<F> sync) {
        return CSRF$.MODULE$.cookieFromHeadersF(request, string, sync);
    }

    public static <F> boolean defaultOriginCheck(Request<F> request, String string, Uri.Scheme scheme, Option<Object> option) {
        return CSRF$.MODULE$.defaultOriginCheck(request, string, scheme, option);
    }

    public static <F> Object genTokenString(Sync<F> sync) {
        return CSRF$.MODULE$.genTokenString(sync);
    }

    public static <F> Object generateSigningKey(Sync<F> sync) {
        return CSRF$.MODULE$.generateSigningKey(sync);
    }

    public static boolean isEqual(String string, String string2) {
        return CSRF$.MODULE$.isEqual(string, string2);
    }

    public static Object lift(String string) {
        return CSRF$.MODULE$.lift(string);
    }

    public static <F> boolean proxyOriginCheck(Request<F> request, Host host, X.minusForwarded.minusFor minusFor2) {
        return CSRF$.MODULE$.proxyOriginCheck(request, host, minusFor2);
    }

    public static boolean tokensEqual(Object object, Object object2) {
        return CSRF$.MODULE$.tokensEqual(object, object2);
    }

    public static String unlift(Object object) {
        return CSRF$.MODULE$.unlift(object);
    }

    public static <F, G> CSRFBuilder<F, G> withDefaultOriginCheck(SecretKey secretKey, String string, Uri.Scheme scheme, Option<Object> option, Sync<F> sync, Applicative<G> applicative) {
        return CSRF$.MODULE$.withDefaultOriginCheck(secretKey, string, scheme, option, sync, applicative);
    }

    public static <F, G> CSRFBuilder<F, G> withDefaultOriginCheckFormAware(String string, FunctionK<G, F> functionK, SecretKey secretKey, String string2, Uri.Scheme scheme, Option<Object> option, Sync<F> sync, GenConcurrent<G, Throwable> genConcurrent) {
        return CSRF$.MODULE$.withDefaultOriginCheckFormAware(string, functionK, secretKey, string2, scheme, option, sync, genConcurrent);
    }

    public static <F, G> Object withGeneratedKey(Function1<Request<G>, Object> function1, Sync<F> sync, Applicative<G> applicative) {
        return CSRF$.MODULE$.withGeneratedKey(function1, sync, applicative);
    }

    public static <F, G> Object withKeyBytes(byte[] byArray, Function1<Request<G>, Object> function1, Sync<F> sync, Applicative<G> applicative) {
        return CSRF$.MODULE$.withKeyBytes(byArray, function1, sync, applicative);
    }

    public CSRF(CIString headerName, CookieSettings cookieSettings, Clock clock, Response<G> onFailure, boolean createIfNotFound, org.http4s.crypto.SecretKey<HmacAlgorithm> key, Function1<Request<G>, Object> headerCheck, Function1<CSRF<F, G>, Function2<Request<G>, Object, Object>> csrfCheck, Sync<F> F) {
        this.headerName = headerName;
        this.cookieSettings = cookieSettings;
        this.clock = clock;
        this.org$http4s$server$middleware$CSRF$$onFailure = onFailure;
        this.createIfNotFound = createIfNotFound;
        this.key = key;
        this.headerCheck = headerCheck;
        this.F = F;
        this.csrfChecker = (Function2)csrfCheck.apply((Object)this);
    }

    public <M> Object signToken(String rawToken, Sync<M> F) {
        return package.all$.MODULE$.toFlatMapOps(F.delay(() -> this.signToken$$anonfun$1(rawToken)), F).flatMap((Function1 & Serializable)joined -> package.all$.MODULE$.toFlatMapOps(F.fromEither(ByteVector$.MODULE$.encodeUtf8(joined)), (FlatMap)F).flatMap((Function1 & Serializable)data -> package.all$.MODULE$.toFunctorOps(Hmac$.MODULE$.apply(Hmac$.MODULE$.forApplicativeThrow((ApplicativeError)F)).digest(this.key, data), (Functor)F).map((Function1 & Serializable)out -> CSRF$.MODULE$.lift(new StringBuilder(1).append((String)joined).append("-").append(out.toHex((Bases.HexAlphabet)Bases.Alphabets$.HexUppercase$.MODULE$)).toString()))));
    }

    public <M> Object generateToken(Sync<M> F) {
        return package.all$.MODULE$.toFlatMapOps(CSRF$.MODULE$.genTokenString(F), F).flatMap((Function1 & Serializable)rawToken -> this.signToken((String)rawToken, F));
    }

    public ResponseCookie createResponseCookie(Object token) {
        return ResponseCookie$.MODULE$.apply(this.cookieSettings.cookieName(), CSRF$.MODULE$.unlift(token), (Option)None$.MODULE$, (Option)None$.MODULE$, this.cookieSettings.domain(), this.cookieSettings.path(), this.cookieSettings.sameSite(), this.cookieSettings.secure(), this.cookieSettings.httpOnly(), this.cookieSettings.extension());
    }

    public RequestCookie createRequestCookie(Object token) {
        return RequestCookie$.MODULE$.apply(this.cookieSettings.cookieName(), CSRF$.MODULE$.unlift(token));
    }

    public <M> EitherT<M, CSRF$CSRFCheckFailed$, Object> refreshedToken(Request<G> r, Sync<M> F) {
        Option<RequestCookie> option = CSRF$.MODULE$.cookieFromHeaders(r, this.cookieSettings.cookieName());
        if (option instanceof Some) {
            RequestCookie c = (RequestCookie)((Some)option).value();
            return EitherT$.MODULE$.apply(F.pure(this.extractRaw(c.content()))).semiflatMap((Function1 & Serializable)rawToken -> this.signToken((String)rawToken, F), F);
        }
        if (None$.MODULE$.equals(option)) {
            return EitherT$.MODULE$.apply(F.pure((Object)package$.MODULE$.Left().apply((Object)CSRF$CSRFCheckFailed$.MODULE$)));
        }
        throw new MatchError(option);
    }

    public <M> EitherT<M, CSRF$CSRFCheckFailed$, Object> refreshOrCreate(Request<G> r, Sync<M> F) {
        Option<RequestCookie> option = CSRF$.MODULE$.cookieFromHeaders(r, this.cookieSettings.cookieName());
        if (option instanceof Some) {
            RequestCookie c = (RequestCookie)((Some)option).value();
            return EitherT$.MODULE$.apply(F.pure(this.extractRaw(c.content()))).semiflatMap((Function1 & Serializable)rawToken -> this.signToken((String)rawToken, F), F);
        }
        if (None$.MODULE$.equals(option)) {
            return EitherT$.MODULE$.liftF(this.generateToken(F), F);
        }
        throw new MatchError(option);
    }

    public Either<CSRF$CSRFCheckFailed$, String> extractRaw(String rawToken) {
        Object object;
        String[] stringArray = rawToken.split("-");
        if (stringArray != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray), 3) == 0) {
            String string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
            String string2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
            String string3 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 2);
            String raw = string;
            String nonce = string2;
            String signed = string3;
            ByteVector out = (ByteVector)((SyncIO)Hmac$.MODULE$.apply(Hmac$.MODULE$.forApplicativeThrow((ApplicativeError)SyncIO$.MODULE$.syncForSyncIO())).digest(this.key, ByteVector$.MODULE$.view(new StringBuilder(1).append(raw).append("-").append(nonce).toString().getBytes(StandardCharsets.UTF_8)))).unsafeRunSync();
            Option option = ByteVector$.MODULE$.fromHex(signed, (Bases.HexAlphabet)Bases.Alphabets$.HexUppercase$.MODULE$);
            if (option instanceof Some) {
                ByteVector decoded = (ByteVector)((Some)option).value();
                if (SecureEq$.MODULE$.apply(SecureEq$.MODULE$.secureEqForByteVector()).eqv((Object)out, (Object)decoded)) {
                    return package$.MODULE$.Right().apply((Object)raw);
                }
                return package$.MODULE$.Left().apply((Object)CSRF$CSRFCheckFailed$.MODULE$);
            }
            if (None$.MODULE$.equals(option)) {
                return package$.MODULE$.Left().apply((Object)CSRF$CSRFCheckFailed$.MODULE$);
            }
            throw new MatchError((Object)option);
        }
        return package$.MODULE$.Left().apply((Object)CSRF$CSRFCheckFailed$.MODULE$);
    }

    public F validate(Request<G> r2, F response, Sync<F> F) {
        Option<RequestCookie> option = CSRF$.MODULE$.cookieFromHeaders(r2, this.cookieSettings.cookieName());
        if (option instanceof Some) {
            RequestCookie c = (RequestCookie)((Some)option).value();
            Object object = package.all$.MODULE$.catsSyntaxApplicativeError(package.all$.MODULE$.toFlatMapOps(F.fromEither(this.extractRaw(c.content())), F).flatMap((Function1 & Serializable)raw -> package.all$.MODULE$.toFlatMapOps(response, (FlatMap)F).flatMap((Function1 & Serializable)res -> package.all$.MODULE$.toFunctorOps(this.signToken((String)raw, (Sync)F), (Functor)F).map((Function1 & Serializable)newToken -> res.addCookie(this.createResponseCookie(newToken))))), F);
            return (F)ApplicativeErrorOps$.MODULE$.recover$extension(object, (PartialFunction)new Serializable(this){
                private final /* synthetic */ CSRF $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable = x;
                    return CSRF$CSRFCheckFailed$.MODULE$.equals(throwable);
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable = x;
                    if (CSRF$CSRFCheckFailed$.MODULE$.equals(throwable)) {
                        return this.$outer.org$http4s$server$middleware$CSRF$$onFailure;
                    }
                    return function1.apply((Object)x);
                }
            }, F);
        }
        if (None$.MODULE$.equals(option)) {
            if (this.createIfNotFound) {
                return (F)package.all$.MODULE$.toFlatMapOps(response, F).flatMap((Function1 & Serializable)r -> this.embedNewInResponseCookie((Response<G>)r, (Sync)F));
            }
            return response;
        }
        throw new MatchError(option);
    }

    public F checkCSRFToken(Request<G> r, F respAction, String rawToken, Sync<F> F) {
        if (!BoxesRunTime.unboxToBoolean((Object)this.headerCheck.apply(r))) {
            return (F)F.pure(this.org$http4s$server$middleware$CSRF$$onFailure);
        }
        Object object = package.all$.MODULE$.catsSyntaxApplicativeError(package.all$.MODULE$.toFlatMapOps(CSRF$.MODULE$.cookieFromHeadersF(r, this.cookieSettings.cookieName(), F), F).flatMap((Function1 & Serializable)c1 -> package.all$.MODULE$.toFlatMapOps(F.fromEither(this.extractRaw(c1.content())), (FlatMap)F).flatMap((Function1 & Serializable)raw1 -> package.all$.MODULE$.toFlatMapOps(F.fromEither(this.extractRaw(rawToken)), (FlatMap)F).flatMap((Function1 & Serializable)raw2 -> package.all$.MODULE$.toFlatMapOps(CSRF$.MODULE$.isEqual((String)raw1, (String)raw2) ? respAction : F.raiseError((Object)CSRF$CSRFCheckFailed$.MODULE$), (FlatMap)F).flatMap((Function1 & Serializable)response -> package.all$.MODULE$.toFunctorOps(this.signToken((String)raw1, (Sync)F), (Functor)F).map((Function1 & Serializable)newToken -> response.addCookie(this.createResponseCookie(newToken))))))), F);
        return (F)ApplicativeErrorOps$.MODULE$.recover$extension(object, (PartialFunction)new Serializable(this){
            private final /* synthetic */ CSRF $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return CSRF$CSRFCheckFailed$.MODULE$.equals(throwable);
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (CSRF$CSRFCheckFailed$.MODULE$.equals(throwable)) {
                    return this.$outer.org$http4s$server$middleware$CSRF$$onFailure;
                }
                return function1.apply((Object)x);
            }
        }, F);
    }

    public F checkCSRF(Request<G> r, F http) {
        return (F)this.csrfChecker.apply(r, http);
    }

    public Function1<Kleisli<F, Request<G>, Response<G>>, Kleisli<F, Request<G>, Response<G>>> validate(Function1<Request<G>, Object> predicate) {
        return (Function1 & Serializable)http -> Kleisli$.MODULE$.apply((Function1 & Serializable)r -> {
            if (BoxesRunTime.unboxToBoolean((Object)predicate.apply(r))) {
                return this.validate((Request<G>)r, (F)http.apply(r), this.F);
            }
            return this.checkCSRF((Request<G>)r, (F)http.apply(r));
        });
    }

    public Function1<Request<G>, Object> validate$default$1() {
        return (Function1 & Serializable)_$7 -> _$7.method().isSafe();
    }

    public F onfailureF() {
        return (F)this.F.pure(this.org$http4s$server$middleware$CSRF$$onFailure);
    }

    public Option<String> getHeaderToken(Request<G> r) {
        return Headers$.MODULE$.get$extension(r.headers(), this.headerName).map((Function1 & Serializable)_$8 -> ((Header.Raw)_$8.head()).value());
    }

    public Response<G> embedInResponseCookie(Response<G> r, Object token) {
        return r.addCookie(this.createResponseCookie(token));
    }

    public Request<G> embedInRequestCookie(Request<G> r, Object token) {
        return r.addCookie(this.createRequestCookie(token));
    }

    public <M> Object embedNewInResponseCookie(Response<G> res, Sync<M> evidence$1) {
        return package.all$.MODULE$.toFunctorOps(this.generateToken(evidence$1), evidence$1).map((Function1 & Serializable)_$10 -> this.embedInResponseCookie(res, _$10));
    }

    private final String signToken$$anonfun$1(String rawToken$1) {
        return new StringBuilder(1).append(rawToken$1).append("-").append(this.clock.millis()).toString();
    }

    public static class CSRFBuilder<F, G> {
        private final CIString headerName;
        private final CookieSettings cookieSettings;
        private final Clock clock;
        private final Response<G> onFailure;
        private final boolean createIfNotFound;
        private final org.http4s.crypto.SecretKey<HmacAlgorithm> key;
        private final Function1<Request<G>, Object> headerCheck;
        private final Function1<CSRF<F, G>, Function2<Request<G>, F, F>> csrfCheck;
        private final Sync<F> F;
        private final Applicative<G> G;

        public CSRFBuilder(CIString headerName, CookieSettings cookieSettings, Clock clock, Response<G> onFailure, boolean createIfNotFound, org.http4s.crypto.SecretKey<HmacAlgorithm> key, Function1<Request<G>, Object> headerCheck, Function1<CSRF<F, G>, Function2<Request<G>, Object, Object>> csrfCheck, Sync<F> F, Applicative<G> G) {
            this.headerName = headerName;
            this.cookieSettings = cookieSettings;
            this.clock = clock;
            this.onFailure = onFailure;
            this.createIfNotFound = createIfNotFound;
            this.key = key;
            this.headerCheck = headerCheck;
            this.csrfCheck = csrfCheck;
            this.F = F;
            this.G = G;
        }

        private CSRFBuilder<F, G> copy(CIString headerName, CookieSettings cookieSettings, Clock clock, Response<G> onFailure, boolean createIfNotFound, org.http4s.crypto.SecretKey<HmacAlgorithm> key, Function1<Request<G>, Object> headerCheck, Function1<CSRF<F, G>, Function2<Request<G>, F, F>> csrfCheck) {
            return new CSRFBuilder<F, G>(headerName, cookieSettings, clock, onFailure, createIfNotFound, key, headerCheck, csrfCheck, this.F, this.G);
        }

        private CIString copy$default$1() {
            return this.headerName;
        }

        private CookieSettings copy$default$2() {
            return this.cookieSettings;
        }

        private Clock copy$default$3() {
            return this.clock;
        }

        private Response<G> copy$default$4() {
            return this.onFailure;
        }

        private boolean copy$default$5() {
            return this.createIfNotFound;
        }

        private org.http4s.crypto.SecretKey<HmacAlgorithm> copy$default$6() {
            return this.key;
        }

        private Function1<Request<G>, Object> copy$default$7() {
            return this.headerCheck;
        }

        private Function1<CSRF<F, G>, Function2<Request<G>, F, F>> copy$default$8() {
            return this.csrfCheck;
        }

        public CSRFBuilder<F, G> withHeaderName(CIString headerName) {
            return this.copy(headerName, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8());
        }

        public CSRFBuilder<F, G> withClock(Clock clock) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), clock, this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8());
        }

        public CSRFBuilder<F, G> withOnFailure(Response<G> onFailure) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), onFailure, this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8());
        }

        public CSRFBuilder<F, G> withCreateIfNotFound(boolean createIfNotFound) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), createIfNotFound, this.copy$default$6(), this.copy$default$7(), this.copy$default$8());
        }

        public CSRFBuilder<F, G> withKey(SecretKey key) {
            org.http4s.crypto.SecretKey secretKey = (org.http4s.crypto.SecretKey)((SyncIO)Hmac$.MODULE$.apply(Hmac$.MODULE$.forApplicativeThrow((ApplicativeError)SyncIO$.MODULE$.syncForSyncIO())).importJavaKey(key)).unsafeRunSync();
            CIString cIString = this.copy$default$1();
            CookieSettings cookieSettings = this.copy$default$2();
            Clock clock = this.copy$default$3();
            Response<G> response = this.copy$default$4();
            boolean bl = this.copy$default$5();
            Function1<Request<G>, Object> function1 = this.copy$default$7();
            Function1<CSRF<F, G>, Function2<Request<G>, F, F>> function12 = this.copy$default$8();
            return this.copy(cIString, cookieSettings, clock, response, bl, (org.http4s.crypto.SecretKey<HmacAlgorithm>)secretKey, function1, function12);
        }

        public CSRFBuilder<F, G> withHeaderCheck(Function1<Request<G>, Object> headerCheck) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), headerCheck, this.copy$default$8());
        }

        public CSRFBuilder<F, G> withCSRFCheck(Function1<CSRF<F, G>, Function2<Request<G>, F, F>> csrfCheck) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), csrfCheck);
        }

        private CSRFBuilder<F, G> cookieMod(Function1<CookieSettings, CookieSettings> f) {
            CookieSettings cookieSettings = (CookieSettings)f.apply((Object)this.cookieSettings);
            CIString cIString = this.copy$default$1();
            Clock clock = this.copy$default$3();
            Response<G> response = this.copy$default$4();
            boolean bl = this.copy$default$5();
            org.http4s.crypto.SecretKey<HmacAlgorithm> secretKey = this.copy$default$6();
            Function1<Request<G>, Object> function1 = this.copy$default$7();
            Function1<CSRF<F, G>, Function2<Request<G>, F, F>> function12 = this.copy$default$8();
            return this.copy(cIString, cookieSettings, clock, response, bl, secretKey, function1, function12);
        }

        public CSRFBuilder<F, G> withCookieName(String cookieName) {
            return this.cookieMod((Function1<CookieSettings, CookieSettings>)(Function1 & Serializable)_$24 -> _$24.copy(cookieName, _$24.copy$default$2(), _$24.copy$default$3(), _$24.copy$default$4(), _$24.copy$default$5(), _$24.copy$default$6(), _$24.copy$default$7()));
        }

        public CSRFBuilder<F, G> withCookieSecure(boolean secure) {
            return this.cookieMod((Function1<CookieSettings, CookieSettings>)(Function1 & Serializable)_$25 -> _$25.copy(_$25.copy$default$1(), secure, _$25.copy$default$3(), _$25.copy$default$4(), _$25.copy$default$5(), _$25.copy$default$6(), _$25.copy$default$7()));
        }

        public CSRFBuilder<F, G> withCookieHttpOnly(boolean httpOnly) {
            return this.cookieMod((Function1<CookieSettings, CookieSettings>)(Function1 & Serializable)_$26 -> _$26.copy(_$26.copy$default$1(), _$26.copy$default$2(), httpOnly, _$26.copy$default$4(), _$26.copy$default$5(), _$26.copy$default$6(), _$26.copy$default$7()));
        }

        public CSRFBuilder<F, G> withCookieDomain(Option<String> domain) {
            return this.cookieMod((Function1<CookieSettings, CookieSettings>)(Function1 & Serializable)_$27 -> _$27.copy(_$27.copy$default$1(), _$27.copy$default$2(), _$27.copy$default$3(), domain, _$27.copy$default$5(), _$27.copy$default$6(), _$27.copy$default$7()));
        }

        public CSRFBuilder<F, G> withCookiePath(Option<String> path) {
            return this.cookieMod((Function1<CookieSettings, CookieSettings>)(Function1 & Serializable)_$28 -> _$28.copy(_$28.copy$default$1(), _$28.copy$default$2(), _$28.copy$default$3(), _$28.copy$default$4(), path, _$28.copy$default$6(), _$28.copy$default$7()));
        }

        public CSRFBuilder<F, G> withCookieExtension(Option<String> extension) {
            return this.cookieMod((Function1<CookieSettings, CookieSettings>)(Function1 & Serializable)_$29 -> _$29.copy(_$29.copy$default$1(), _$29.copy$default$2(), _$29.copy$default$3(), _$29.copy$default$4(), _$29.copy$default$5(), _$29.copy$default$6(), extension));
        }

        public CSRF<F, G> build() {
            return new CSRF<F, G>(this.headerName, this.cookieSettings, this.clock, this.onFailure, this.createIfNotFound, this.key, this.headerCheck, this.csrfCheck, this.F);
        }
    }

    public static final class CookieSettings
    implements Product,
    Serializable {
        private final String cookieName;
        private final boolean secure;
        private final boolean httpOnly;
        private final Option domain;
        private final Option path;
        private final Option sameSite;
        private final Option extension;

        public static CookieSettings apply(String string, boolean bl, boolean bl2, Option<String> option, Option<String> option2, Option<SameSite> option3, Option<String> option4) {
            return CSRF$CookieSettings$.MODULE$.apply(string, bl, bl2, option, option2, option3, option4);
        }

        public static CookieSettings fromProduct(Product product) {
            return CSRF$CookieSettings$.MODULE$.fromProduct(product);
        }

        public static CookieSettings unapply(CookieSettings cookieSettings) {
            return CSRF$CookieSettings$.MODULE$.unapply(cookieSettings);
        }

        public static Option<String> $lessinit$greater$default$4() {
            return CSRF$CookieSettings$.MODULE$.$lessinit$greater$default$4();
        }

        public static Option<String> $lessinit$greater$default$5() {
            return CSRF$CookieSettings$.MODULE$.$lessinit$greater$default$5();
        }

        public static Option<SameSite> $lessinit$greater$default$6() {
            return CSRF$CookieSettings$.MODULE$.$lessinit$greater$default$6();
        }

        public static Option<String> $lessinit$greater$default$7() {
            return CSRF$CookieSettings$.MODULE$.$lessinit$greater$default$7();
        }

        public CookieSettings(String cookieName, boolean secure, boolean httpOnly, Option<String> domain, Option<String> path, Option<SameSite> sameSite, Option<String> extension) {
            this.cookieName = cookieName;
            this.secure = secure;
            this.httpOnly = httpOnly;
            this.domain = domain;
            this.path = path;
            this.sameSite = sameSite;
            this.extension = extension;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.cookieName()));
            n = Statics.mix((int)n, (int)(this.secure() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)(this.httpOnly() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.domain()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.path()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.sameSite()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.extension()));
            return Statics.finalizeHash((int)n, (int)7);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CookieSettings)) return false;
            CookieSettings cookieSettings = (CookieSettings)object;
            if (this.secure() != cookieSettings.secure()) return false;
            if (this.httpOnly() != cookieSettings.httpOnly()) return false;
            String string = this.cookieName();
            String string2 = cookieSettings.cookieName();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Option<String> option = this.domain();
            Option<String> option2 = cookieSettings.domain();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<String> option3 = this.path();
            Option<String> option4 = cookieSettings.path();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            Option<SameSite> option5 = this.sameSite();
            Option<SameSite> option6 = cookieSettings.sameSite();
            if (option5 == null) {
                if (option6 != null) {
                    return false;
                }
            } else if (!option5.equals(option6)) return false;
            Option<String> option7 = this.extension();
            Option<String> option8 = cookieSettings.extension();
            if (option7 == null) {
                if (option8 == null) return true;
                return false;
            } else {
                if (!option7.equals(option8)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CookieSettings;
        }

        public int productArity() {
            return 7;
        }

        public String productPrefix() {
            return "CookieSettings";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToBoolean((boolean)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToBoolean((boolean)this._3());
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
                case 6: {
                    return this._7();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "cookieName";
                }
                case 1: {
                    return "secure";
                }
                case 2: {
                    return "httpOnly";
                }
                case 3: {
                    return "domain";
                }
                case 4: {
                    return "path";
                }
                case 5: {
                    return "sameSite";
                }
                case 6: {
                    return "extension";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String cookieName() {
            return this.cookieName;
        }

        public boolean secure() {
            return this.secure;
        }

        public boolean httpOnly() {
            return this.httpOnly;
        }

        public Option<String> domain() {
            return this.domain;
        }

        public Option<String> path() {
            return this.path;
        }

        public Option<SameSite> sameSite() {
            return this.sameSite;
        }

        public Option<String> extension() {
            return this.extension;
        }

        public CookieSettings copy(String cookieName, boolean secure, boolean httpOnly, Option<String> domain, Option<String> path, Option<SameSite> sameSite, Option<String> extension) {
            return new CookieSettings(cookieName, secure, httpOnly, domain, path, sameSite, extension);
        }

        public String copy$default$1() {
            return this.cookieName();
        }

        public boolean copy$default$2() {
            return this.secure();
        }

        public boolean copy$default$3() {
            return this.httpOnly();
        }

        public Option<String> copy$default$4() {
            return this.domain();
        }

        public Option<String> copy$default$5() {
            return this.path();
        }

        public Option<SameSite> copy$default$6() {
            return this.sameSite();
        }

        public Option<String> copy$default$7() {
            return this.extension();
        }

        public String _1() {
            return this.cookieName();
        }

        public boolean _2() {
            return this.secure();
        }

        public boolean _3() {
            return this.httpOnly();
        }

        public Option<String> _4() {
            return this.domain();
        }

        public Option<String> _5() {
            return this.path();
        }

        public Option<SameSite> _6() {
            return this.sameSite();
        }

        public Option<String> _7() {
            return this.extension();
        }
    }
}

