/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.websocket;

import cats.ApplicativeError;
import cats.effect.SyncIO;
import cats.effect.SyncIO$;
import java.io.Serializable;
import java.util.Base64;
import org.http4s.crypto.Hash$;
import org.http4s.crypto.HashAlgorithm;
import org.http4s.websocket.WebSocketHandshake;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public final class WebSocketHandshake$
implements Serializable {
    private static final ByteVector magicString;
    public static final List<Tuple2<String, String>> org$http4s$websocket$WebSocketHandshake$$$clientBaseHeaders;
    public static final WebSocketHandshake$ MODULE$;

    private WebSocketHandshake$() {
    }

    static {
        MODULE$ = new WebSocketHandshake$();
        magicString = (ByteVector)ByteVector$.MODULE$.encodeAscii("258EAFA5-E914-47DA-95CA-C5AB0DC85B11").fold((Function1 & Serializable)_$1 -> {
            throw _$1;
        }, (Function1 & Serializable)x -> (ByteVector)Predef$.MODULE$.identity(x));
        org$http4s$websocket$WebSocketHandshake$$$clientBaseHeaders = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply((Object)"Connection", (Object)"Upgrade"), Tuple2$.MODULE$.apply((Object)"Upgrade", (Object)"websocket"), Tuple2$.MODULE$.apply((Object)"Sec-WebSocket-Version", (Object)"13")}));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(WebSocketHandshake$.class);
    }

    public WebSocketHandshake.ClientHandshaker clientHandshaker(String host) {
        return new WebSocketHandshake.ClientHandshaker(host);
    }

    public Either<Tuple2<Object, String>, Seq<Tuple2<String, String>>> serverHandshake(Iterable<Tuple2<String, String>> headers) {
        if (!headers.exists((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                return k.equalsIgnoreCase("Host");
            }
            throw new MatchError((Object)tuple2);
        })) {
            return package$.MODULE$.Left().apply((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-1), (Object)"Missing Host Header"));
        }
        if (!headers.exists((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return k.equalsIgnoreCase("Connection") && this.valueContains("Upgrade", v);
            }
            throw new MatchError((Object)tuple2);
        })) {
            return package$.MODULE$.Left().apply((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-1), (Object)"Bad Connection header"));
        }
        if (!headers.exists((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return k.equalsIgnoreCase("Upgrade") && v.equalsIgnoreCase("websocket");
            }
            throw new MatchError((Object)tuple2);
        })) {
            return package$.MODULE$.Left().apply((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-1), (Object)"Bad Upgrade header"));
        }
        if (!headers.exists((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return k.equalsIgnoreCase("Sec-WebSocket-Version") && this.valueContains("13", v);
            }
            throw new MatchError((Object)tuple2);
        })) {
            return package$.MODULE$.Left().apply((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-1), (Object)"Bad Websocket Version header"));
        }
        return (Either)headers.find((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return k.equalsIgnoreCase("Sec-WebSocket-Key") && this.decodeLen(v) == 16;
            }
            throw new MatchError((Object)tuple2);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String v = (String)tuple2._2();
                Seq respHeaders = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply((Object)"Upgrade", (Object)"websocket"), Tuple2$.MODULE$.apply((Object)"Connection", (Object)"Upgrade"), Tuple2$.MODULE$.apply((Object)"Sec-WebSocket-Accept", (Object)this.org$http4s$websocket$WebSocketHandshake$$$genAcceptKey(v))}));
                return package$.MODULE$.Right().apply((Object)respHeaders);
            }
            throw new MatchError((Object)tuple2);
        }).getOrElse(this::serverHandshake$$anonfun$7);
    }

    public boolean isWebSocketRequest(Iterable<Tuple2<String, String>> headers) {
        return headers.exists((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return k.equalsIgnoreCase("Upgrade") && v.equalsIgnoreCase("websocket");
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private int decodeLen(String key) {
        return Base64.getDecoder().decode(key).length;
    }

    public String org$http4s$websocket$WebSocketHandshake$$$genAcceptKey(String str) {
        return (String)SyncIO$.MODULE$.fromEither(ByteVector$.MODULE$.encodeAscii(str)).flatMap((Function1 & Serializable)data -> ((SyncIO)Hash$.MODULE$.apply(Hash$.MODULE$.forApplicativeThrow((ApplicativeError)SyncIO$.MODULE$.syncForSyncIO())).digest((HashAlgorithm)HashAlgorithm.SHA1$.MODULE$, data.$plus$plus(magicString))).map((Function1 & Serializable)digest -> digest.toBase64())).unsafeRunSync();
    }

    public boolean valueContains(String key, String value) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])value.split(","));
        Object[] parts = (String[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$1 -> _$1.trim(), ClassTag$.MODULE$.apply(String.class));
        Object object2 = Predef$.MODULE$.refArrayOps(parts);
        return BoxesRunTime.unboxToBoolean((Object)ArrayOps$.MODULE$.foldLeft$extension(object2, (Object)BoxesRunTime.boxToBoolean((boolean)false), (Function2 & Serializable)(b, s2) -> this.valueContains$$anonfun$1(key, BoxesRunTime.unboxToBoolean((Object)b), (String)s2)));
    }

    private final Either serverHandshake$$anonfun$7() {
        return package$.MODULE$.Left().apply((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-1), (Object)"Bad Sec-WebSocket-Key header"));
    }

    private final /* synthetic */ boolean valueContains$$anonfun$1(String key$1, boolean b, String s2) {
        return b || s2.equalsIgnoreCase(key$1) || s2.length() > 1 && s2.startsWith("\"") && s2.endsWith("\"") && s2.substring(1, s2.length() - 1).equalsIgnoreCase(key$1);
    }
}

