/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.util;

import cats.data.NonEmptyList;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.http4s.Header;
import org.http4s.Header$Raw$;
import org.http4s.util.Renderer;
import org.http4s.util.StringWriter;
import org.http4s.util.StringWriter$;
import org.http4s.util.Writer;
import org.typelevel.ci.CIString;
import scala.MatchError;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Renderer$
implements Serializable {
    private volatile Object RFC7231InstantRenderer$lzy1;
    private static final Renderer stringRenderer;
    private static final Renderer finiteDurationRenderer;
    private static final Renderer longRenderer;
    private static final Renderer ciStringRenderer;
    public static final Renderer$ MODULE$;

    private Renderer$() {
    }

    static {
        MODULE$ = new Renderer$();
        stringRenderer = new Renderer<String>(){

            public Writer render(Writer writer, String string) {
                return writer.$less$less(string);
            }
        };
        finiteDurationRenderer = new Renderer<FiniteDuration>(){

            public Writer render(Writer writer, FiniteDuration d) {
                return writer.$less$less(BoxesRunTime.boxToLong((long)d.toSeconds()).toString());
            }
        };
        longRenderer = new Renderer<Object>(){

            public Writer render(Writer writer, long d) {
                return writer.$less$less(BoxesRunTime.boxToLong((long)d).toString());
            }
        };
        ciStringRenderer = new Renderer<CIString>(){

            public Writer render(Writer writer, CIString ciString) {
                return writer.$less$less(ciString);
            }
        };
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Renderer$.class);
    }

    public <A> Renderer<A> apply(Renderer<A> ev) {
        return ev;
    }

    public <T> String renderString(T t, Renderer<T> evidence$1) {
        return ((StringWriter)new StringWriter(StringWriter$.MODULE$.$lessinit$greater$default$1()).append((Object)t, (Renderer)evidence$1)).result();
    }

    public Renderer<Instant> RFC7231InstantRenderer() {
        Object object = this.RFC7231InstantRenderer$lzy1;
        if (object instanceof Renderer) {
            return (Renderer)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Renderer)this.RFC7231InstantRenderer$lzyINIT1();
    }

    private Object RFC7231InstantRenderer$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.RFC7231InstantRenderer$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, Renderer.OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Renderer<Instant> renderer = null;
                    try {
                        renderer = new Renderer<Instant>(this){
                            private final DateTimeFormatter dateFormat;
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.dateFormat = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss zzz").withLocale(Locale.US).withZone(ZoneId.of("GMT"));
                            }

                            public Writer render(Writer writer, Instant t) {
                                return writer.$less$less(this.dateFormat.format(t));
                            }
                        };
                        object2 = renderer == null ? LazyVals.NullValue$.MODULE$ : renderer;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, Renderer.OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.RFC7231InstantRenderer$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, Renderer.OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return renderer;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, Renderer.OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Renderer<String> stringRenderer() {
        return stringRenderer;
    }

    public Renderer<FiniteDuration> finiteDurationRenderer() {
        return finiteDurationRenderer;
    }

    public Renderer<Object> longRenderer() {
        return longRenderer;
    }

    public <A, B> Renderer<Either<A, B>> eitherRenderer(Renderer<A> ra, Renderer<B> rb) {
        return new Renderer<Either<A, B>>(ra, rb, this){
            private final Renderer ra$1;
            private final Renderer rb$1;
            {
                this.ra$1 = ra$2;
                this.rb$1 = rb$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public Writer render(Writer writer, Either e) {
                Either either = e;
                if (either instanceof Left) {
                    Object a = ((Left)either).value();
                    return this.ra$1.render(writer, a);
                }
                if (either instanceof Right) {
                    Object b = ((Right)either).value();
                    return this.rb$1.render(writer, b);
                }
                throw new MatchError((Object)either);
            }
        };
    }

    public Renderer<CIString> ciStringRenderer() {
        return ciStringRenderer;
    }

    public <T> Renderer<NonEmptyList<T>> nelRenderer(Renderer<T> evidence$1) {
        return new Renderer<NonEmptyList<T>>(evidence$1, this){
            private final Renderer evidence$1$1;
            {
                this.evidence$1$1 = evidence$1$7;
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public Writer render(Writer writer, NonEmptyList values) {
                return writer.addNel(values, writer.addNel$default$2(), writer.addNel$default$3(), writer.addNel$default$4(), this.evidence$1$1);
            }
        };
    }

    public <T> Renderer<List<T>> listRenderer(Renderer<T> evidence$1) {
        return new Renderer<List<T>>(evidence$1, this){
            private final Renderer evidence$1$2;
            {
                this.evidence$1$2 = evidence$1$8;
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public Writer render(Writer writer, List values) {
                return writer.addList(values, writer.addList$default$2(), writer.addList$default$3(), writer.addList$default$4(), this.evidence$1$2);
            }
        };
    }

    public <T> Renderer<Set<T>> setRenderer(Renderer<T> evidence$1) {
        return new Renderer<Set<T>>(evidence$1, this){
            private final Renderer evidence$1$3;
            {
                this.evidence$1$3 = evidence$1$9;
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public Writer render(Writer writer, Set values) {
                return writer.addSet(values, writer.addSet$default$2(), writer.addSet$default$3(), writer.addSet$default$4(), this.evidence$1$3);
            }
        };
    }

    public <A> Renderer<A> headerSelectRenderer(Header.Select<A> select) {
        return new Renderer<A>(select, this){
            private final Header.Select select$1;
            {
                this.select$1 = select$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public Writer render(Writer writer, Object t) {
                return writer.$less$less(this.select$1.toRaw1(t), (Renderer)Header$Raw$.MODULE$.catsInstancesForHttp4sHeaderRaw());
            }
        };
    }
}

