/*
 * Decompiled with CFR 0.152.
 */
package org.http4s;

import cats.Applicative;
import cats.ApplicativeError;
import cats.FlatMap;
import cats.Foldable;
import cats.Functor;
import cats.Invariant$;
import cats.Monad;
import cats.MonadError;
import cats.Semigroupal$;
import cats.UnorderedFoldable$;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.OptionT;
import cats.data.OptionT$;
import cats.effect.SyncIO;
import cats.effect.SyncIO$;
import cats.effect.kernel.Sync;
import cats.effect.kernel.Unique;
import cats.effect.package$;
import cats.kernel.Eq;
import cats.kernel.Eq$;
import cats.kernel.Semigroup;
import cats.kernel.Semigroup$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import fs2.Stream;
import fs2.Stream$;
import fs2.io.file.BasicFileAttributes;
import fs2.io.file.Files;
import fs2.io.file.Files$;
import fs2.io.file.Path;
import fs2.io.file.Path$;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.NoSuchFileException;
import org.http4s.ContentCoding$;
import org.http4s.EntityTag;
import org.http4s.Header;
import org.http4s.Header$Select$;
import org.http4s.Header$ToRaw$;
import org.http4s.Headers$;
import org.http4s.HttpDate;
import org.http4s.HttpDate$;
import org.http4s.HttpVersion;
import org.http4s.MediaType;
import org.http4s.MediaType$;
import org.http4s.Platform$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.Status;
import org.http4s.Status$;
import org.http4s.TransferCoding;
import org.http4s.TransferCoding$;
import org.http4s.headers.Accept$minusEncoding$;
import org.http4s.headers.Content$minusEncoding$;
import org.http4s.headers.Content$minusLength$;
import org.http4s.headers.Content$minusType;
import org.http4s.headers.Content$minusType$;
import org.http4s.headers.ETag;
import org.http4s.headers.ETag$;
import org.http4s.headers.If$minusModified$minusSince;
import org.http4s.headers.If$minusModified$minusSince$;
import org.http4s.headers.If$minusNone$minusMatch;
import org.http4s.headers.If$minusNone$minusMatch$;
import org.http4s.headers.Last$minusModified$;
import org.http4s.headers.Transfer$minusEncoding$;
import org.http4s.syntax.package$header$;
import org.typelevel.log4cats.SelfAwareStructuredLogger;
import org.typelevel.vault.Key;
import org.typelevel.vault.Key$;
import org.typelevel.vault.Vault;
import org.typelevel.vault.Vault$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class StaticFile$
implements Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(StaticFile$.class.getDeclaredField("staticFileKey$lzy1"));
    private static final SelfAwareStructuredLogger<SyncIO> logger;
    private static final int DefaultBufferSize;
    private static final Key staticPathKey;
    private volatile Object staticFileKey$lzy1;
    public static final StaticFile$ MODULE$;

    private StaticFile$() {
    }

    static {
        MODULE$ = new StaticFile$();
        logger = (SelfAwareStructuredLogger)Platform$.MODULE$.loggerFactory().getLogger("org.http4s.StaticFile");
        DefaultBufferSize = 10240;
        staticPathKey = (Key)((SyncIO)Key$.MODULE$.newKey((Functor)SyncIO$.MODULE$.syncForSyncIO(), (Unique)SyncIO$.MODULE$.syncForSyncIO())).unsafeRunSync();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(StaticFile$.class);
    }

    public int DefaultBufferSize() {
        return DefaultBufferSize;
    }

    public <F> OptionT<F, Response<F>> fromString(String url, Option<Request<F>> req, Files<F> evidence$1, MonadError<F, Throwable> evidence$2) {
        return this.fromPath(Path$.MODULE$.apply(url), req, evidence$1, evidence$2);
    }

    public <F> None$ fromString$default$2() {
        return None$.MODULE$;
    }

    public <F> OptionT<F, Response<F>> fromResource(String name, Option<Request<F>> req, boolean preferGzipped, Option<ClassLoader> classloader, Sync<F> evidence$1) {
        ClassLoader loader = (ClassLoader)classloader.getOrElse(this::$anonfun$1);
        Option acceptEncodingHeader = req.flatMap((Function1 & Serializable)_$3 -> Headers$.MODULE$.get$extension(_$3.headers(), Header$Select$.MODULE$.recurringHeadersWithMerge(Accept$minusEncoding$.MODULE$.headerSemigroupInstance(), Accept$minusEncoding$.MODULE$.headerInstance())));
        boolean tryGzipped = preferGzipped && acceptEncodingHeader.exists((Function1 & Serializable)acceptEncoding -> acceptEncoding.satisfiedBy(ContentCoding$.MODULE$.gzip()) || acceptEncoding.satisfiedBy(ContentCoding$.MODULE$.x$minusgzip()));
        Object object = Predef$.MODULE$.refArrayOps((Object[])name.split("/"));
        String normalizedName = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)_$4 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$4)))).mkString("/");
        OptionT gzUrl = tryGzipped ? this.getResource$1(evidence$1, loader, new StringBuilder(3).append(normalizedName).append(".gz").toString()) : OptionT$.MODULE$.none(evidence$1);
        return gzUrl.flatMap((Function1 & Serializable)url -> this.fromURL((URL)url, req, evidence$1).map((Function1 & Serializable)_$5 -> (Response)_$5.removeHeader(Content$minusType$.MODULE$.headerInstance()).putHeaders((Seq<Header.ToRaw>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header$ToRaw$.MODULE$.modelledHeadersToRaw(Content$minusEncoding$.MODULE$.apply(ContentCoding$.MODULE$.gzip()), Content$minusEncoding$.MODULE$.headerInstance()), Header$ToRaw$.MODULE$.foldablesToRaw(this.nameToContentType(normalizedName), UnorderedFoldable$.MODULE$.catsTraverseForOption(), (Function1 & Serializable)h -> Header$ToRaw$.MODULE$.modelledHeadersToRaw(h, Content$minusType$.MODULE$.headerInstance()))})), (Functor)evidence$1), evidence$1).orElse(() -> this.fromResource$$anonfun$2(normalizedName, req, evidence$1, loader), evidence$1);
    }

    public <F> None$ fromResource$default$2() {
        return None$.MODULE$;
    }

    public boolean fromResource$default$3() {
        return false;
    }

    public <F> Option<ClassLoader> fromResource$default$4() {
        return None$.MODULE$;
    }

    public <F> OptionT<F, Response<F>> fromURL(URL url, Option<Request<F>> req, Sync<F> F) {
        String fileUrl = url.getFile();
        File file = new File(fileUrl);
        return OptionT$.MODULE$.apply(F.defer(() -> this.fromURL$$anonfun$1(url, file, F, req)));
    }

    public <F> None$ fromURL$default$2() {
        return None$.MODULE$;
    }

    public <F> Function1<File, Object> calcETag(Files<F> evidence$1, Functor<F> evidence$2) {
        return (Function1 & Serializable)f -> package.all$.MODULE$.toFunctorOps(Files$.MODULE$.apply(evidence$1).isRegularFile(Path$.MODULE$.fromNioPath(f.toPath())), evidence$2).map((Function1 & Serializable)isFile -> this.calcETag$$anonfun$1$$anonfun$1((File)f, BoxesRunTime.unboxToBoolean((Object)isFile)));
    }

    public <F> Function1<Path, Object> calculateETag(Files<F> evidence$1, ApplicativeError<F, Throwable> evidence$2) {
        return (Function1 & Serializable)f -> package.all$.MODULE$.toFunctorOps(Files$.MODULE$.apply(evidence$1).getBasicFileAttributes(f, true), (Functor)evidence$2).map((Function1 & Serializable)attr -> {
            if (attr.isRegularFile()) {
                return new StringBuilder(1).append(RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(attr.lastModifiedTime().toMillis()))).append("-").append(RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(attr.size()))).toString();
            }
            return "";
        });
    }

    public <F> OptionT<F, Response<F>> fromFile(File f, Option<Request<F>> req, Files<F> evidence$1, MonadError<F, Throwable> evidence$2) {
        return this.fromPath(Path$.MODULE$.fromNioPath(f.toPath()), this.DefaultBufferSize(), req, this.calculateETag(evidence$1, (ApplicativeError<F, Throwable>)evidence$2), evidence$1, evidence$2);
    }

    public <F> None$ fromFile$default$2() {
        return None$.MODULE$;
    }

    public <F> OptionT<F, Response<F>> fromPath(Path f, Option<Request<F>> req, Files<F> evidence$1, MonadError<F, Throwable> evidence$2) {
        return this.fromPath(f, this.DefaultBufferSize(), req, this.calculateETag(evidence$1, (ApplicativeError<F, Throwable>)evidence$2), evidence$1, evidence$2);
    }

    public <F> None$ fromPath$default$2() {
        return None$.MODULE$;
    }

    public <F> OptionT<F, Response<F>> fromFile(File f, Option<Request<F>> req, Function1<File, Object> etagCalculator, Files<F> evidence$1, MonadError<F, Throwable> evidence$2) {
        return this.fromPath(Path$.MODULE$.fromNioPath(f.toPath()), this.DefaultBufferSize(), req, (Function1<Path, Object>)etagCalculator.compose((Function1 & Serializable)_$18 -> _$18.toNioPath().toFile()), evidence$1, evidence$2);
    }

    public <F> OptionT<F, Response<F>> fromPath(Path f, Option<Request<F>> req, Function1<Path, Object> etagCalculator, Files<F> evidence$1, MonadError<F, Throwable> evidence$2) {
        return this.fromPath(f, this.DefaultBufferSize(), req, etagCalculator, evidence$1, evidence$2);
    }

    public <F> OptionT<F, Response<F>> fromFile(File f, int buffsize, Option<Request<F>> req, Function1<File, Object> etagCalculator, Files<F> evidence$1, MonadError<F, Throwable> evidence$2) {
        return this.fromPath(Path$.MODULE$.fromNioPath(f.toPath()), 0L, f.length(), buffsize, req, (Function1<Path, Object>)etagCalculator.compose((Function1 & Serializable)_$21 -> _$21.toNioPath().toFile()), evidence$1, evidence$2);
    }

    public <F> OptionT<F, Response<F>> fromPath(Path f, int buffsize, Option<Request<F>> req, Function1<Path, Object> etagCalculator, Files<F> evidence$1, MonadError<F, Throwable> evidence$2) {
        OptionT optionT = (OptionT)package.all$.MODULE$.catsSyntaxApplicativeError((Object)OptionT$.MODULE$.liftF(package.all$.MODULE$.toFunctorOps(Files$.MODULE$.apply(evidence$1).getBasicFileAttributes(f, true), evidence$2).map((Function1 & Serializable)_$23 -> _$23.size()), evidence$2).flatMap((Function1 & Serializable)size -> this.fromPath$$anonfun$2(f, buffsize, req, etagCalculator, evidence$1, evidence$2, BoxesRunTime.unboxToLong((Object)size)), evidence$2), (ApplicativeError)OptionT$.MODULE$.catsDataMonadErrorForOptionT(evidence$2));
        return (OptionT)ApplicativeErrorOps$.MODULE$.recoverWith$extension((Object)optionT, (PartialFunction)new Serializable(evidence$2, this){
            private final MonadError evidence$2$4;
            {
                this.evidence$2$4 = evidence$2$6;
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return throwable instanceof NoSuchFileException;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof NoSuchFileException) {
                    return OptionT$.MODULE$.none((Applicative)this.evidence$2$4);
                }
                return function1.apply((Object)x);
            }
        }, (ApplicativeError)OptionT$.MODULE$.catsDataMonadErrorForOptionT(evidence$2));
    }

    public <F> OptionT<F, Response<F>> fromFile(File f, long start, long end, int buffsize, Option<Request<F>> req, Function1<File, Object> etagCalculator, Files<F> evidence$1, MonadError<F, Throwable> F) {
        return this.fromPath(Path$.MODULE$.fromNioPath(f.toPath()), start, end, buffsize, req, (Function1<Path, Object>)etagCalculator.compose((Function1 & Serializable)_$25 -> _$25.toNioPath().toFile()), evidence$1, F);
    }

    public <F> OptionT<F, Response<F>> fromPath(Path f, long start, long end, int buffsize, Option<Request<F>> req, Function1<Path, Object> etagCalculator, Files<F> evidence$1, MonadError<F, Throwable> F) {
        return OptionT$.MODULE$.apply(package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(etagCalculator.apply((Object)f), F).map((Function1 & Serializable)et -> ETag$.MODULE$.apply((String)et, ETag$.MODULE$.apply$default$2())), F).flatMap((Function1 & Serializable)etagCalc -> package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(Files$.MODULE$.apply(evidence$1).isRegularFile(f), (FlatMap)F).flatMap((Function1 & Serializable)isFile -> this.fromPath$$anonfun$4$$anonfun$1(start, end, buffsize, evidence$1, f, F, req, (ETag)etagCalc, BoxesRunTime.unboxToBoolean((Object)isFile))), (Functor)F).map((Function1 & Serializable)res -> res)));
    }

    private <F> Option<Response<F>> notModified(Option<Request<F>> req, ETag etagCalc, Option<HttpDate> lastModified) {
        Semigroup conjunction = (Semigroup)new Semigroup<Object>(){

            public boolean combine(boolean x, boolean y) {
                return x && y;
            }
        };
        return ((Option)package.all$.MODULE$.toFoldableOps(scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{this.etagMatch(req, etagCalc), this.notModifiedSince(req, lastModified)})), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForList()).combineAll(Semigroup$.MODULE$.catsKernelMonoidForOption(conjunction))).filter((Function1 & Serializable)x -> this.notModified$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)x))).map((Function1 & Serializable)_$29 -> this.notModified$$anonfun$2(BoxesRunTime.unboxToBoolean((Object)_$29)));
    }

    private <F> Option<Object> etagMatch(Option<Request<F>> req, ETag etagCalc) {
        return req.flatMap((Function1 & Serializable)r -> Headers$.MODULE$.get$extension(r.headers(), Header$Select$.MODULE$.singleHeaders(If$minusNone$minusMatch$.MODULE$.headerInstance())).map((Function1 & Serializable)etagHeader -> {
            SyncIO syncIO;
            SyncIO $2$;
            boolean etagMatch = etagHeader.tags().exists((Function1 & Serializable)_$31 -> _$31.exists((Function1 & Serializable)_$32 -> {
                EntityTag entityTag = _$32;
                EntityTag entityTag2 = etagCalc.tag();
                return !(entityTag != null ? !((Object)entityTag).equals(entityTag2) : entityTag2 != null);
            }));
            SyncIO $2$2 = $2$ = (syncIO = (SyncIO)logger.trace(() -> this.$anonfun$16(etagMatch, etagHeader, etagCalc)));
            return Tuple3$.MODULE$.apply(etagHeader, (Object)BoxesRunTime.boxToBoolean((boolean)etagMatch), (Object)$2$2);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                If$minusNone$minusMatch etagHeader = (If$minusNone$minusMatch)tuple3._1();
                boolean etagMatch = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
                return etagMatch;
            }
            throw new MatchError((Object)tuple3);
        }));
    }

    private <F> Option<Object> notModifiedSince(Option<Request<F>> req, Option<HttpDate> lastModified) {
        return req.flatMap((Function1 & Serializable)r -> Headers$.MODULE$.get$extension(r.headers(), Header$Select$.MODULE$.singleHeaders(If$minusModified$minusSince$.MODULE$.headerInstance())).flatMap((Function1 & Serializable)h -> lastModified.map((Function1 & Serializable)lm -> {
            SyncIO syncIO;
            SyncIO $3$;
            boolean notModified = h.date().$greater$eq(lm);
            SyncIO $3$2 = $3$ = (syncIO = (SyncIO)logger.trace(() -> this.$anonfun$17(notModified, h, lm)));
            return Tuple3$.MODULE$.apply(lm, (Object)BoxesRunTime.boxToBoolean((boolean)notModified), (Object)$3$2);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                HttpDate lm = (HttpDate)tuple3._1();
                boolean notModified = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
                return notModified;
            }
            throw new MatchError((Object)tuple3);
        })));
    }

    private <F> Stream<F, Object> fileToBody(Path f, long start, long end, Files<F> evidence$1) {
        return Files$.MODULE$.apply(evidence$1).readRange(f, this.DefaultBufferSize(), start, end);
    }

    private Option<Content$minusType> nameToContentType(String name) {
        int n = name.lastIndexOf(46);
        if (-1 == n) {
            return None$.MODULE$;
        }
        int i = n;
        return MediaType$.MODULE$.forExtension(name.substring(i + 1)).map((Function1 & Serializable)_$35 -> Content$minusType$.MODULE$.apply((MediaType)_$35));
    }

    public Key<Path> staticPathKey() {
        return staticPathKey;
    }

    public Key<File> staticFileKey() {
        Object object = this.staticFileKey$lzy1;
        if (object instanceof Key) {
            return (Key)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Key)this.staticFileKey$lzyINIT1();
    }

    private Object staticFileKey$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.staticFileKey$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Key key = null;
                    try {
                        key = this.staticPathKey().imap((Function1 & Serializable)_$36 -> _$36.toNioPath().toFile(), (Function1 & Serializable)f -> Path$.MODULE$.fromNioPath(f.toPath()));
                        object2 = key == null ? LazyVals.NullValue$.MODULE$ : key;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.staticFileKey$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return key;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private final ClassLoader $anonfun$1() {
        return this.getClass().getClassLoader();
    }

    private final Option getResource$1$$anonfun$1(ClassLoader loader$2, String name$1) {
        return Option$.MODULE$.apply((Object)loader$2.getResource(name$1));
    }

    private final OptionT getResource$1(Sync evidence$1$1, ClassLoader loader$1, String name) {
        return OptionT$.MODULE$.apply(package$.MODULE$.Sync().apply(evidence$1$1).blocking(() -> this.getResource$1$$anonfun$1(loader$1, name)));
    }

    private final OptionT fromResource$$anonfun$2(String normalizedName$3, Option req$2, Sync evidence$1$3, ClassLoader loader$3) {
        return this.getResource$1(evidence$1$3, loader$3, normalizedName$3).flatMap((Function1 & Serializable)_$6 -> this.fromURL((URL)_$6, (Option)req$2, (Sync)evidence$1$3), (Monad)evidence$1$3);
    }

    private final boolean $anonfun$7() {
        return true;
    }

    private final InputStream fromURL$$anonfun$1$$anonfun$1(URLConnection urlConn$1) {
        return urlConn$1.getInputStream();
    }

    private final void fromURL$$anonfun$1$$anonfun$4(URLConnection urlConn$2) {
        urlConn$2.getInputStream().close();
    }

    private final Object fromURL$$anonfun$1(URL url$1, File file$1, Sync F$1, Option req$4) {
        if (package.all$.MODULE$.catsSyntaxEq((Object)url$1.getProtocol(), (Eq)Eq$.MODULE$.catsKernelInstancesForString()).$eq$eq$eq((Object)"file") && file$1.isDirectory()) {
            return F$1.pure((Object)package.all$.MODULE$.none());
        }
        URLConnection urlConn = url$1.openConnection();
        Option lastmod = HttpDate$.MODULE$.fromEpochSecond(urlConn.getLastModified() / 1000L).toOption();
        Option ifModifiedSince = req$4.flatMap((Function1 & Serializable)_$8 -> Headers$.MODULE$.get$extension(_$8.headers(), Header$Select$.MODULE$.singleHeaders(If$minusModified$minusSince$.MODULE$.headerInstance())));
        boolean expired = BoxesRunTime.unboxToBoolean((Object)((Option)package.all$.MODULE$.catsSyntaxTuple2Semigroupal(Tuple2$.MODULE$.apply((Object)ifModifiedSince, (Object)lastmod)).mapN((Function2 & Serializable)(_$9, _$10) -> _$9.date().$less(_$10), (Functor)Invariant$.MODULE$.catsInstancesForOption(), Semigroupal$.MODULE$.catsSemigroupalForOption())).getOrElse(this::$anonfun$7));
        if (expired) {
            Header.ToRaw toRaw;
            long len = urlConn.getContentLengthLong();
            Object[] objectArray = new Header.ToRaw[3];
            objectArray[0] = Header$ToRaw$.MODULE$.foldablesToRaw(lastmod.map((Function1 & Serializable)_$11 -> Last$minusModified$.MODULE$.apply((HttpDate)_$11)), UnorderedFoldable$.MODULE$.catsTraverseForOption(), (Function1 & Serializable)h -> Header$ToRaw$.MODULE$.modelledHeadersToRaw(h, Last$minusModified$.MODULE$.headerInstance()));
            objectArray[1] = Header$ToRaw$.MODULE$.foldablesToRaw(this.nameToContentType(url$1.getPath()), UnorderedFoldable$.MODULE$.catsTraverseForOption(), (Function1 & Serializable)h -> Header$ToRaw$.MODULE$.modelledHeadersToRaw(h, Content$minusType$.MODULE$.headerInstance()));
            if (len >= 0L) {
                toRaw = Header$ToRaw$.MODULE$.modelledHeadersToRaw(Content$minusLength$.MODULE$.unsafeFromLong(len), Content$minusLength$.MODULE$.headerInstance());
            } else {
                TransferCoding transferCoding = (TransferCoding)package.all$.MODULE$.catsSyntaxApplicativeId((Object)TransferCoding$.MODULE$.chunked());
                toRaw = Header$ToRaw$.MODULE$.modelledHeadersToRaw(Transfer$minusEncoding$.MODULE$.apply((NonEmptyList<TransferCoding>)((NonEmptyList)ApplicativeIdOps$.MODULE$.pure$extension((Object)transferCoding, (Applicative)NonEmptyList$.MODULE$.catsDataInstancesForNonEmptyListBinCompat1()))), Transfer$minusEncoding$.MODULE$.headerInstance());
            }
            objectArray[2] = toRaw;
            List headers = Headers$.MODULE$.apply((Seq<Header.ToRaw>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            Object object = package.all$.MODULE$.catsSyntaxApplicativeError(F$1.blocking(() -> this.fromURL$$anonfun$1$$anonfun$1(urlConn)), (ApplicativeError)F$1);
            return ApplicativeErrorOps$.MODULE$.redeem$extension(object, (Function1 & Serializable)x$1 -> {
                Throwable throwable = x$1;
                if (throwable instanceof FileNotFoundException) {
                    return None$.MODULE$;
                }
                Throwable other = throwable;
                throw other;
            }, (Function1 & Serializable)inputStream -> {
                Stream stream = fs2.io.package$.MODULE$.readInputStream(F$1.pure(inputStream), this.DefaultBufferSize(), fs2.io.package$.MODULE$.readInputStream$default$3(), F$1);
                Status status = Response$.MODULE$.apply$default$1();
                HttpVersion httpVersion = Response$.MODULE$.apply$default$2();
                Vault vault = Response$.MODULE$.apply$default$5();
                return Some$.MODULE$.apply(Response$.MODULE$.apply(status, httpVersion, headers, stream, vault));
            }, (ApplicativeError)F$1);
        }
        Object object = package.all$.MODULE$.catsSyntaxApplicativeError(F$1.blocking((Function0 & Serializable)() -> {
            this.fromURL$$anonfun$1$$anonfun$4(urlConn);
            return BoxedUnit.UNIT;
        }), (ApplicativeError)F$1);
        return package.all$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.handleError$extension(object, (Function1)(JProcedure1 & Serializable)_$12 -> {}, (ApplicativeError)F$1), (Functor)F$1).as((Object)Some$.MODULE$.apply(Response$.MODULE$.apply(Status$.MODULE$.NotModified(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5())));
    }

    private final /* synthetic */ String calcETag$$anonfun$1$$anonfun$1(File f$1, boolean isFile) {
        if (isFile) {
            return new StringBuilder(1).append(RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(f$1.lastModified()))).append("-").append(RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(f$1.length()))).toString();
        }
        return "";
    }

    private final /* synthetic */ OptionT fromPath$$anonfun$2(Path f$2, int buffsize$1, Option req$5, Function1 etagCalculator$1, Files evidence$1$7, MonadError evidence$2$3, long size) {
        return this.fromPath(f$2, 0L, size, buffsize$1, req$5, (Function1<Path, Object>)etagCalculator$1, evidence$1$7, evidence$2$3);
    }

    private final String fromPath$$anonfun$4$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(Response r$1) {
        return new StringBuilder(32).append("Static file generated response: ").append(r$1).toString();
    }

    private final Option fromPath$$anonfun$4$$anonfun$1$$anonfun$1$$anonfun$1(BasicFileAttributes attr$1, long end$4, Path f$6, long start$4, Files evidence$1$11, Option lastModified$1, ETag etagCalc$3) {
        Tuple2 tuple2 = attr$1.size() < end$4 ? Tuple2$.MODULE$.apply((Object)Stream$.MODULE$.empty(), (Object)BoxesRunTime.boxToLong((long)0L)) : Tuple2$.MODULE$.apply(this.fileToBody(f$6, start$4, end$4, evidence$1$11), (Object)BoxesRunTime.boxToLong((long)(end$4 - start$4)));
        Stream body = (Stream)tuple2._1();
        long contentLength = BoxesRunTime.unboxToLong((Object)tuple2._2());
        Option<Content$minusType> contentType = this.nameToContentType(f$6.fileName().toString());
        List hs = Headers$.MODULE$.apply((Seq<Header.ToRaw>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header$ToRaw$.MODULE$.foldablesToRaw(lastModified$1.map((Function1 & Serializable)_$27 -> Last$minusModified$.MODULE$.apply((HttpDate)_$27)), UnorderedFoldable$.MODULE$.catsTraverseForOption(), (Function1 & Serializable)h -> Header$ToRaw$.MODULE$.modelledHeadersToRaw(h, Last$minusModified$.MODULE$.headerInstance())), Header$ToRaw$.MODULE$.foldablesToRaw(Content$minusLength$.MODULE$.fromLong(contentLength).toOption(), UnorderedFoldable$.MODULE$.catsTraverseForOption(), (Function1 & Serializable)h -> Header$ToRaw$.MODULE$.modelledHeadersToRaw(h, Content$minusLength$.MODULE$.headerInstance())), Header$ToRaw$.MODULE$.foldablesToRaw(contentType, UnorderedFoldable$.MODULE$.catsTraverseForOption(), (Function1 & Serializable)h -> Header$ToRaw$.MODULE$.modelledHeadersToRaw(h, Content$minusType$.MODULE$.headerInstance())), Header$ToRaw$.MODULE$.modelledHeadersToRaw(etagCalc$3, ETag$.MODULE$.headerInstance())}));
        Vault vault = Vault$.MODULE$.empty().insert(this.staticPathKey(), (Object)f$6);
        Status status = Response$.MODULE$.apply$default$1();
        HttpVersion httpVersion = Response$.MODULE$.apply$default$2();
        Response r = Response$.MODULE$.apply(status, httpVersion, hs, body, vault);
        ((SyncIO)logger.trace(() -> this.fromPath$$anonfun$4$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(r))).unsafeRunSync();
        Response response = (Response)package.all$.MODULE$.catsSyntaxOptionId(r);
        return OptionIdOps$.MODULE$.some$extension((Object)response);
    }

    private final /* synthetic */ Object fromPath$$anonfun$4$$anonfun$1(long start$2, long end$2, int buffsize$3, Files evidence$1$9, Path f$4, MonadError F$4, Option req$7, ETag etagCalc$1, boolean isFile) {
        if (isFile) {
            if (start$2 >= 0L && end$2 >= start$2 && buffsize$3 > 0) {
                return package.all$.MODULE$.toFlatMapOps(Files$.MODULE$.apply(evidence$1$9).getBasicFileAttributes(f$4, true), (FlatMap)F$4).flatMap((Function1 & Serializable)attr -> {
                    Option lastModified = HttpDate$.MODULE$.fromEpochSecond(attr.lastModifiedTime().toSeconds()).toOption();
                    return F$4.pure((Object)this.notModified(req$7, etagCalc$1, (Option<HttpDate>)lastModified).orElse(() -> this.fromPath$$anonfun$4$$anonfun$1$$anonfun$1$$anonfun$1(attr, end$2, f$4, start$2, evidence$1$9, lastModified, etagCalc$1)));
                });
            }
            return F$4.raiseError((Object)new IllegalArgumentException(new StringBuilder(46).append("requirement failed: start: ").append(start$2).append(", end: ").append(end$2).append(", buffsize: ").append(buffsize$3).toString()));
        }
        return F$4.pure((Object)package.all$.MODULE$.none());
    }

    private final /* synthetic */ boolean notModified$$anonfun$1(boolean x) {
        return BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToBoolean((boolean)x)));
    }

    private final /* synthetic */ Response notModified$$anonfun$2(boolean _$29) {
        return Response$.MODULE$.apply(Status$.MODULE$.NotModified(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5());
    }

    private final String $anonfun$16(boolean etagMatch$1, If$minusNone$minusMatch etagHeader$1, ETag etagCalc$8) {
        return new StringBuilder(53).append("Matches `If-None-Match`: ").append(etagMatch$1).append(" Previous ETag: ").append(package$header$.MODULE$.http4sHeaderSyntax(etagHeader$1, If$minusNone$minusMatch$.MODULE$.headerInstance()).value()).append(", New ETag: ").append(etagCalc$8).toString();
    }

    private final String $anonfun$17(boolean notModified$1, If$minusModified$minusSince h$2, HttpDate lm$1) {
        return new StringBuilder(56).append("Matches `If-Modified-Since`: ").append(notModified$1).append(". Request age: ").append(h$2.date()).append(", Modified: ").append(lm$1).toString();
    }
}

