/*
 * Decompiled with CFR 0.152.
 */
package sharry.common.util;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import scala.Function2;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public final class SignUtil$
implements Serializable {
    private static final Charset utf8;
    private static final String macAlgo;
    public static final SignUtil$ MODULE$;

    private SignUtil$() {
    }

    static {
        MODULE$ = new SignUtil$();
        utf8 = StandardCharsets.UTF_8;
        macAlgo = "HmacSHA1";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SignUtil$.class);
    }

    private Mac getMac(ByteVector key) {
        Mac mac = Mac.getInstance(macAlgo);
        mac.init(new SecretKeySpec(key.toArray(), macAlgo));
        return mac;
    }

    public ByteVector signString(String data, ByteVector key) {
        Mac mac = this.getMac(key);
        return ByteVector$.MODULE$.view(mac.doFinal(data.getBytes(utf8)));
    }

    public ByteVector signBytes(ByteVector data, ByteVector key) {
        Mac mac = this.getMac(key);
        return ByteVector$.MODULE$.view(mac.doFinal(data.toArray()));
    }

    public boolean isEqual(ByteVector sig1, ByteVector sig2) {
        return BoxesRunTime.unboxToBoolean((Object)sig1.zipWith(sig2, (Function2 & Serializable)(b1, b2) -> SignUtil$.isEqual$$anonfun$1(BoxesRunTime.unboxToByte((Object)b1), BoxesRunTime.unboxToByte((Object)b2))).foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2 & Serializable)(_$1, _$2) -> SignUtil$.isEqual$$anonfun$2(BoxesRunTime.unboxToBoolean((Object)_$1), BoxesRunTime.unboxToByte((Object)_$2)))) && sig1.length() == sig2.length();
    }

    private static final /* synthetic */ byte isEqual$$anonfun$1(byte b1, byte b2) {
        return (byte)(b1 - b2);
    }

    private static final /* synthetic */ boolean isEqual$$anonfun$2(boolean _$1, byte _$2) {
        return _$1 && _$2 == 0;
    }
}

