/*
 * Decompiled with CFR 0.152.
 */
package sharry.common;

import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.Encoder;
import io.circe.Encoder$;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.deriving.Mirror;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import sharry.common.ByteSize;

public final class ByteSize$
implements Mirror.Product,
Serializable {
    private static final ByteSize zero;
    private static final Decoder<ByteSize> jsonDecoder;
    private static final Encoder<ByteSize> jsonEncoder;
    public static final ByteSize$ MODULE$;

    private ByteSize$() {
    }

    static {
        MODULE$ = new ByteSize$();
        zero = MODULE$.apply(0L);
        jsonDecoder = Decoder$.MODULE$.decodeLong().map((Function1 & Serializable)bytes -> this.$init$$$anonfun$1(BoxesRunTime.unboxToLong((Object)bytes)));
        jsonEncoder = Encoder$.MODULE$.encodeLong().contramap((Function1 & Serializable)_$1 -> _$1.bytes());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ByteSize$.class);
    }

    public ByteSize apply(long bytes) {
        return new ByteSize(bytes);
    }

    public ByteSize unapply(ByteSize x$1) {
        return x$1;
    }

    public ByteSize zero() {
        return zero;
    }

    public String bytesToHuman(long bytes) {
        if (package$.MODULE$.abs(bytes) < 1024L && bytes != Long.MIN_VALUE) {
            return new StringBuilder(1).append(bytes).append("B").toString();
        }
        double k = (double)bytes / 1024.0;
        if (package$.MODULE$.abs(k) < (double)1024) {
            return StringOps$.MODULE$.format$extension("%.02fK", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)k)}));
        }
        double m = k / 1024.0;
        if (package$.MODULE$.abs(m) < (double)1024) {
            return StringOps$.MODULE$.format$extension("%.02fM", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)m)}));
        }
        return StringOps$.MODULE$.format$extension("%.02fG", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(m / 1024.0))}));
    }

    public Either<String, ByteSize> parse(String str) {
        return StringOps$.MODULE$.toLongOption$extension(Predef$.MODULE$.augmentString(str)).map((Function1 & Serializable)bytes -> ByteSize$.MODULE$.apply(BoxesRunTime.unboxToLong((Object)bytes))).toRight(() -> ByteSize$.parse$$anonfun$2(str)).orElse(() -> ByteSize$.parse$$anonfun$3(str));
    }

    private Tuple2<String, String> span(String str) {
        if (str.isEmpty()) {
            return Tuple2$.MODULE$.apply((Object)"", (Object)"");
        }
        return Tuple2$.MODULE$.apply((Object)StringOps$.MODULE$.init$extension(Predef$.MODULE$.augmentString(str)), (Object)BoxesRunTime.boxToCharacter((char)StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(str))).toString());
    }

    public ByteSize unsafe(String str) {
        return (ByteSize)this.parse(str).fold((Function1 & Serializable)message -> {
            throw scala.sys.package$.MODULE$.error(message);
        }, (Function1 & Serializable)x -> (ByteSize)Predef$.MODULE$.identity(x));
    }

    public Decoder<ByteSize> jsonDecoder() {
        return jsonDecoder;
    }

    public Encoder<ByteSize> jsonEncoder() {
        return jsonEncoder;
    }

    public ByteSize fromProduct(Product x$0) {
        return new ByteSize(BoxesRunTime.unboxToLong((Object)x$0.productElement(0)));
    }

    private final /* synthetic */ ByteSize $init$$$anonfun$1(long bytes) {
        return this.apply(bytes);
    }

    private static final String parse$$anonfun$2(String str$1) {
        return new StringBuilder(25).append("Not a valid size string: ").append(str$1).toString();
    }

    private static final Either parse$$anonfun$3(String str$2) {
        Tuple2<String, String> tuple2 = MODULE$.span(str$2.toLowerCase());
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            String string2 = (String)tuple2._2();
            String num = string;
            if ("k".equals(string2)) {
                return scala.package$.MODULE$.Right().apply((Object)MODULE$.apply(package$.MODULE$.round(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(num)) * (double)1024)));
            }
            String num2 = string;
            if ("m".equals(string2)) {
                return scala.package$.MODULE$.Right().apply((Object)MODULE$.apply(package$.MODULE$.round(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(num2)) * (double)1024 * (double)1024)));
            }
            String num3 = string;
            if ("g".equals(string2)) {
                return scala.package$.MODULE$.Right().apply((Object)MODULE$.apply(package$.MODULE$.round(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(num3)) * (double)1024 * (double)1024 * (double)1024)));
            }
        }
        return scala.package$.MODULE$.Left().apply((Object)new StringBuilder(21).append("Invalid byte string: ").append(str$2).toString());
    }
}

