/*
 * Decompiled with CFR 0.152.
 */
package binny.minio;

import binny.AttributeName;
import binny.BinaryAttributes;
import binny.BinaryAttributes$;
import binny.BinaryId;
import binny.BinaryId$;
import binny.ByteRange;
import binny.ChunkDef;
import binny.ChunkedBinaryStore;
import binny.Hint;
import binny.InsertChunkResult;
import binny.InsertChunkResult$;
import binny.SimpleContentType;
import binny.minio.Minio;
import binny.minio.MinioBinaryStore;
import binny.minio.MinioBinaryStore$;
import binny.minio.MinioChunkedBinaryStore$;
import binny.minio.MinioConfig;
import binny.minio.S3Key;
import binny.minio.S3Key$;
import binny.minio.S3KeyMapping;
import binny.minio.S3KeyMapping$;
import binny.package;
import binny.util.Logger;
import binny.util.RangeCalc;
import binny.util.RangeCalc$;
import binny.util.StreamUtil$;
import cats.Apply;
import cats.data.Kleisli;
import cats.data.Kleisli$;
import cats.data.OptionT;
import cats.data.OptionT$;
import cats.effect.kernel.Async;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.ApplyOps$;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Stream;
import fs2.Stream$;
import io.minio.MinioAsyncClient;
import io.minio.ObjectWriteResponse;
import io.minio.StatObjectResponse;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.NotGiven$;
import scodec.bits.ByteVector;

public final class MinioChunkedBinaryStore<F>
implements ChunkedBinaryStore<F> {
    private final MinioConfig config;
    private final MinioAsyncClient client;
    private final Logger<F> logger;
    private final Async<F> evidence$1;
    private final Minio<F> minio;
    private final S3KeyMapping keyMapping;
    private final MinioBinaryStore<F> minioStore;

    public static <F> MinioChunkedBinaryStore<F> apply(MinioConfig minioConfig, Logger<F> logger, Async<F> async) {
        return MinioChunkedBinaryStore$.MODULE$.apply(minioConfig, logger, async);
    }

    public static <F> MinioChunkedBinaryStore<F> apply(MinioConfig minioConfig, MinioAsyncClient minioAsyncClient, Logger<F> logger, Async<F> async) {
        return MinioChunkedBinaryStore$.MODULE$.apply(minioConfig, minioAsyncClient, logger, async);
    }

    public MinioChunkedBinaryStore(MinioConfig config, MinioAsyncClient client, Logger<F> logger, Async<F> evidence$1) {
        this.config = config;
        this.client = client;
        this.logger = logger;
        this.evidence$1 = evidence$1;
        this.minio = new Minio<F>(client, evidence$1);
        this.keyMapping = S3KeyMapping$.MODULE$.apply((Function1<String, S3Key>)(Function1 & Serializable)id -> this.$init$$$anonfun$1(config, id == null ? null : ((BinaryId)id).id()), (Function1<String, Object>)(Function1 & Serializable)bucket -> config.keyMapping().bucketFilter((String)bucket));
        this.minioStore = MinioBinaryStore$.MODULE$.apply(config.withKeyMapping(this.keyMapping()), client, logger, evidence$1);
    }

    public MinioConfig config() {
        return this.config;
    }

    public MinioAsyncClient client() {
        return this.client;
    }

    public S3KeyMapping keyMapping() {
        return this.keyMapping;
    }

    public F insertChunk(String id, ChunkDef chunkDef, Hint hint, ByteVector data) {
        Option option = InsertChunkResult$.MODULE$.validateChunk(chunkDef, this.config().chunkSize(), (int)data.length());
        if (option instanceof Some) {
            InsertChunkResult bad = (InsertChunkResult)((Some)option).value();
            InsertChunkResult insertChunkResult = (InsertChunkResult)package.all$.MODULE$.catsSyntaxApplicativeId((Object)bad);
            return (F)ApplicativeIdOps$.MODULE$.pure$extension((Object)insertChunkResult, this.evidence$1);
        }
        if (None$.MODULE$.equals(option)) {
            ChunkDef.Total ch = (ChunkDef.Total)chunkDef.fold((Function1 & Serializable)x -> (ChunkDef.Total)Predef$.MODULE$.identity(x), (Function1 & Serializable)_$2 -> _$2.toTotal(this.config().chunkSize()));
            S3Key s3Key = this.config().keyMapping().makeS3Key(id).changeObjectName((Function1<String, String>)(Function1 & Serializable)n -> this.objectName((String)n, ch.index()));
            F insert = this.minio.uploadObject(s3Key, this.config().partSize(), this.config().detect(), data);
            Object checkComplete = package.all$.MODULE$.toFunctorOps(this.listChunks(id, 100).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.evidence$1))).count(), this.evidence$1).map((Function1 & Serializable)chunks -> MinioChunkedBinaryStore.$anonfun$4(ch, BoxesRunTime.unboxToLong((Object)chunks)));
            return (F)package.all$.MODULE$.toFlatMapOps(this.logger.trace(() -> MinioChunkedBinaryStore.insertChunk$$anonfun$1(data, ch)), this.evidence$1).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return package.all$.MODULE$.toFlatMapOps(insert, this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
                    ObjectWriteResponse objectWriteResponse = x$1;
                    return package.all$.MODULE$.toFunctorOps(checkComplete, this.evidence$1).map((Function1 & Serializable)r -> r);
                });
            });
        }
        throw new MatchError((Object)option);
    }

    public Kleisli<?, Object, BinaryAttributes> computeAttr(String id, Hint hint) {
        return Kleisli$.MODULE$.apply((Function1 & Serializable)select -> {
            S3Key first = this.keyMapping().makeS3Key(id);
            Object object = package.all$.MODULE$.catsSyntaxApplicativeError(this.minio.statObject(first), this.evidence$1);
            return OptionT$.MODULE$.apply(package.all$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object, this.evidence$1), this.evidence$1).map((Function1 & Serializable)_$3 -> _$3.toOption())).semiflatMap((Function1 & Serializable)stat -> {
                Object object = select;
                if (object != null) {
                    Option option = AttributeName.ContainsSha256$.MODULE$.unapply(object);
                    if (!option.isEmpty()) {
                        AttributeName.Sha256$ sha256$ = (AttributeName.Sha256$)option.get();
                        return package.all$.MODULE$.toFunctorOps(this.generateS3Keys(id, RangeCalc.Offsets$.MODULE$.none()).map((Function1 & Serializable)_$4 -> (S3Key)_$4._1()).through(this.loadChunkFiles()).through(package.ComputeAttr$.MODULE$.computeAll(this.config().detect(), hint)).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.evidence$1))).last(), this.evidence$1).map((Function1 & Serializable)_$5 -> (BinaryAttributes)_$5.getOrElse(MinioChunkedBinaryStore::computeAttr$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1));
                    }
                    Option option2 = AttributeName.ContainsLength$.MODULE$.unapply(object);
                    if (!option2.isEmpty()) {
                        AttributeName.Length$ length$ = (AttributeName.Length$)option2.get();
                        Stream stream = Stream$.MODULE$.OptionStreamOps(this.generateS3Keys(id, RangeCalc.Offsets$.MODULE$.none()).map((Function1 & Serializable)_$6 -> (S3Key)_$6._1()).evalMap((Function1 & Serializable)key -> {
                            Object object = package.all$.MODULE$.catsSyntaxApplicativeError(this.minio.statObject((S3Key)key), this.evidence$1);
                            return package.all$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object, this.evidence$1), this.evidence$1).map((Function1 & Serializable)_$7 -> _$7.toOption());
                        }));
                        Object len = Stream.OptionStreamOps$.MODULE$.unNoneTerminate$extension(stream).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.evidence$1))).fold((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable)(_$8, _$9) -> MinioChunkedBinaryStore.$anonfun$7(BoxesRunTime.unboxToLong((Object)_$8), (StatObjectResponse)_$9));
                        StatObjectResponse statObjectResponse = (StatObjectResponse)package.all$.MODULE$.catsSyntaxOptionId(stat);
                        return package.all$.MODULE$.catsSyntaxTuple2Semigroupal(Tuple2$.MODULE$.apply(this.minio.detectContentType(first, (Option<StatObjectResponse>)OptionIdOps$.MODULE$.some$extension((Object)statObjectResponse), this.config().detect(), hint), len)).mapN((Function2 & Serializable)(contentType, length) -> BinaryAttributes$.MODULE$.apply(contentType == null ? null : ((SimpleContentType)contentType).contentType(), BoxesRunTime.unboxToLong((Object)length)), this.evidence$1, this.evidence$1);
                    }
                }
                StatObjectResponse statObjectResponse = (StatObjectResponse)package.all$.MODULE$.catsSyntaxOptionId(stat);
                return package.all$.MODULE$.toFunctorOps(this.minio.detectContentType(first, (Option<StatObjectResponse>)OptionIdOps$.MODULE$.some$extension((Object)statObjectResponse), this.config().detect(), hint), this.evidence$1).map((Function1 & Serializable)c -> BinaryAttributes$.MODULE$.apply(c == null ? null : ((SimpleContentType)c).contentType(), -1L));
            }, this.evidence$1);
        });
    }

    public Stream<F, String> listIds(Option<String> prefix, int chunkSize) {
        Stream stream = (Stream)package.all$.MODULE$.catsSyntaxApplyOps((Object)Stream$.MODULE$.eval(this.logger.info(() -> MinioChunkedBinaryStore.listIds$$anonfun$1(prefix))));
        return (Stream)ApplyOps$.MODULE$.$times$greater$extension((Object)stream, (Object)this.minio.listBuckets().filter((Function1 & Serializable)bucket -> this.config().keyMapping().bucketFilter((String)bucket)).flatMap((Function1 & Serializable)bucket -> this.minio.listObjects((String)bucket, (Option<String>)None$.MODULE$, 100, prefix), NotGiven$.MODULE$.value()).map((Function1 & Serializable)name -> new BinaryId(this.listIds$$anonfun$4((String)name))), (Apply)Stream$.MODULE$.monadErrorInstance(this.evidence$1));
    }

    public Function1<Stream<F, Object>, Stream<F, String>> insert() {
        return this.minioStore.insert();
    }

    public Function1<Stream<F, Object>, Stream<F, Nothing$>> insertWith(String id) {
        return this.minioStore.insertWith(id);
    }

    public OptionT<F, Stream<F, Object>> findBinary(String id, ByteRange range) {
        Object list = this.listChunks(id, 2).take(2L).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.evidence$1))).toList();
        return OptionT$.MODULE$.liftF(list, this.evidence$1).flatMap((Function1 & Serializable)x$12 -> {
            List list = x$12;
            Nil$ nil$ = package$.MODULE$.Nil();
            List list2 = list;
            if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                return OptionT$.MODULE$.none(this.evidence$1);
            }
            if (list instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list;
                List list3 = colon2.next$access$1();
                String name = (String)colon2.head();
                Nil$ nil$2 = package$.MODULE$.Nil();
                List list4 = list3;
                if (!(nil$2 != null ? !nil$2.equals(list4) : list4 != null)) {
                    S3Key key = S3Key$.MODULE$.apply(this.keyMapping().makeS3Key(id).bucket(), name);
                    boolean bl = OptionT$.MODULE$.pure();
                    return OptionT.PurePartiallyApplied$.MODULE$.apply$extension(bl, this.minio.getObjectAsStream(key, this.config().chunkSize(), range), this.evidence$1);
                }
            }
            RangeCalc.Offsets offsets = RangeCalc$.MODULE$.calcOffset(range, this.config().chunkSize());
            Stream<F, Tuple2<S3Key, Object>> allChunks = this.generateS3Keys(id, offsets);
            if (offsets.isNone()) {
                boolean bl = OptionT$.MODULE$.pure();
                return OptionT.PurePartiallyApplied$.MODULE$.apply$extension(bl, (Object)allChunks.map((Function1 & Serializable)_$10 -> (S3Key)_$10._1()).through(this.loadChunkFiles()), this.evidence$1);
            }
            boolean bl = OptionT$.MODULE$.pure();
            Stream stream = Stream$.MODULE$.OptionStreamOps(allChunks.flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    S3Key s3Key = (S3Key)tuple2._1();
                    long index = BoxesRunTime.unboxToLong((Object)tuple2._2());
                    Tuple2 tuple22 = RangeCalc$.MODULE$.chopOffsets(offsets, (int)index);
                    if (tuple22 != null) {
                        Option option = (Option)tuple22._1();
                        Option option2 = (Option)tuple22._2();
                        if (option instanceof Some) {
                            int n;
                            int start = n = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                            if (option2 instanceof Some) {
                                int end = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                                ByteRange.Chunk br = ByteRange.Chunk$.MODULE$.apply(Int$.MODULE$.int2long(start), start + end);
                                return Stream$.MODULE$.eval(this.minio.getObjectAsStreamOption(s3Key, this.config().chunkSize(), (ByteRange)br));
                            }
                            int start2 = n;
                            if (None$.MODULE$.equals(option2)) {
                                ByteRange.Chunk br = ByteRange.Chunk$.MODULE$.apply(Int$.MODULE$.int2long(start2), Integer.MAX_VALUE);
                                return Stream$.MODULE$.eval(this.minio.getObjectAsStreamOption(s3Key, this.config().chunkSize(), (ByteRange)br));
                            }
                        }
                        if (None$.MODULE$.equals(option)) {
                            if (option2 instanceof Some) {
                                int end = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                                ByteRange.Chunk br = ByteRange.Chunk$.MODULE$.apply(0L, end);
                                return Stream$.MODULE$.eval(this.minio.getObjectAsStreamOption(s3Key, this.config().chunkSize(), (ByteRange)br));
                            }
                            if (None$.MODULE$.equals(option2)) {
                                ByteRange.All$ br = ByteRange.All$.MODULE$;
                                return Stream$.MODULE$.eval(this.minio.getObjectAsStreamOption(s3Key, this.config().chunkSize(), (ByteRange)br));
                            }
                        }
                    }
                    throw new MatchError((Object)tuple22);
                }
                throw new MatchError((Object)tuple2);
            }, NotGiven$.MODULE$.value()));
            return OptionT.PurePartiallyApplied$.MODULE$.apply$extension(bl, (Object)Stream.OptionStreamOps$.MODULE$.unNoneTerminate$extension(stream).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl()), this.evidence$1);
        }, this.evidence$1);
    }

    public F exists(String id) {
        S3Key key = this.keyMapping().makeS3Key(id);
        return this.minio.exists(key);
    }

    public F delete(String id) {
        String bucket = this.keyMapping().makeS3Key(id).bucket();
        return (F)this.listChunks(id, 100).parEvalMap(2, (Function1 & Serializable)key -> this.minio.deleteObject(S3Key$.MODULE$.apply(bucket, (String)key)), this.evidence$1).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.evidence$1))).drain();
    }

    private Stream<F, String> listChunks(String id, int max) {
        S3Key templateKey = this.config().keyMapping().makeS3Key(id);
        String bucket = templateKey.bucket();
        String prefix = new StringBuilder(7).append(templateKey.objectName()).append("/chunk_").toString();
        return this.minio.listObjects(bucket, (Option<String>)None$.MODULE$, max, (Option<String>)Some$.MODULE$.apply((Object)prefix));
    }

    private Function1<Stream<F, Object>, Stream<F, S3Key>> makeS3Key(String id) {
        S3Key templateKey = this.config().keyMapping().makeS3Key(id);
        return (Function1 & Serializable)_$11 -> _$11.map((Function1 & Serializable)n -> this.makeS3Key$$anonfun$1$$anonfun$1(templateKey, BoxesRunTime.unboxToInt((Object)n)));
    }

    private Stream<F, Tuple2<S3Key, Object>> generateS3Keys(String id, RangeCalc.Offsets offsets) {
        if (offsets.isNone()) {
            return Stream$.MODULE$.iterate((Object)BoxesRunTime.boxToInteger((int)0), (Function1)(JFunction1.mcII.sp & Serializable)_$12 -> _$12 + 1).through(this.makeS3Key(id)).zipWithIndex();
        }
        return Stream$.MODULE$.iterate((Object)BoxesRunTime.boxToInteger((int)offsets.firstChunk()), (Function1)(JFunction1.mcII.sp & Serializable)_$13 -> _$13 + 1).take(Int$.MODULE$.int2long(offsets.takeChunks())).through(this.makeS3Key(id)).through(StreamUtil$.MODULE$.zipWithIndexFrom(offsets.firstChunk()));
    }

    private Function1<Stream<F, S3Key>, Stream<F, Object>> loadChunkFiles() {
        return (Function1 & Serializable)_$14 -> {
            Stream stream = Stream$.MODULE$.OptionStreamOps(_$14.flatMap((Function1 & Serializable)s3Key -> Stream$.MODULE$.eval(this.minio.getObjectAsStreamOption((S3Key)s3Key, this.config().chunkSize(), (ByteRange)ByteRange.All$.MODULE$)), NotGiven$.MODULE$.value()));
            return Stream.OptionStreamOps$.MODULE$.unNoneTerminate$extension(stream).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
        };
    }

    private String objectName(String key, int n) {
        return StringOps$.MODULE$.format$extension("%s/chunk_%08d", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{key, BoxesRunTime.boxToInteger((int)n)}));
    }

    private String idFromObjectName(String name) {
        int idx = name.lastIndexOf(47);
        if (idx > 0) {
            return BinaryId$.MODULE$.apply(name.substring(0, idx));
        }
        return BinaryId$.MODULE$.apply(name);
    }

    private final /* synthetic */ S3Key $init$$$anonfun$1(MinioConfig config$1, String id) {
        return config$1.keyMapping().makeS3Key(id).changeObjectName((Function1<String, String>)(Function1 & Serializable)n -> this.objectName((String)n, 0));
    }

    private static final /* synthetic */ InsertChunkResult $anonfun$4(ChunkDef.Total ch$2, long chunks) {
        if (chunks >= (long)ch$2.total()) {
            return InsertChunkResult$.MODULE$.complete();
        }
        return InsertChunkResult$.MODULE$.incomplete();
    }

    private static final String insertChunk$$anonfun$1(ByteVector data$1, ChunkDef.Total ch$3) {
        return new StringBuilder(23).append("Insert chunk ").append(ch$3.index() + 1).append("/").append(ch$3.total()).append(" of size ").append(data$1.length()).toString();
    }

    private static final BinaryAttributes computeAttr$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1() {
        return BinaryAttributes$.MODULE$.empty();
    }

    private static final /* synthetic */ long $anonfun$7(long _$8, StatObjectResponse _$9) {
        return _$8 + _$9.size();
    }

    private static final String listIds$$anonfun$1(Option prefix$1) {
        return new StringBuilder(22).append("List ids with filter: ").append(prefix$1).toString();
    }

    private final /* synthetic */ String listIds$$anonfun$4(String name) {
        return this.idFromObjectName(name);
    }

    private final /* synthetic */ S3Key makeS3Key$$anonfun$1$$anonfun$1(S3Key templateKey$2, int n) {
        return templateKey$2.changeObjectName((Function1<String, String>)(Function1 & Serializable)name -> this.objectName((String)name, n));
    }
}

