/*
 * Decompiled with CFR 0.152.
 */
package binny.minio;

import binny.AttributeName;
import binny.BinaryAttributes;
import binny.BinaryAttributes$;
import binny.BinaryId;
import binny.BinaryId$;
import binny.BinaryStore;
import binny.ByteRange;
import binny.Hint;
import binny.SimpleContentType;
import binny.minio.Minio;
import binny.minio.MinioBinaryStore$;
import binny.minio.MinioConfig;
import binny.minio.S3Key;
import binny.util.Logger;
import binny.util.Stopwatch$;
import cats.Apply;
import cats.data.Kleisli;
import cats.data.Kleisli$;
import cats.data.OptionT;
import cats.data.OptionT$;
import cats.effect.kernel.Async;
import cats.implicits$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplyOps$;
import cats.syntax.OptionIdOps$;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Stream;
import fs2.Stream$;
import fs2.io.package$;
import io.minio.MinioAsyncClient;
import io.minio.StatObjectResponse;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.function.JProcedure1;
import scala.util.NotGiven$;

public final class MinioBinaryStore<F>
implements BinaryStore<F> {
    private final MinioConfig config;
    private final MinioAsyncClient client;
    private final Logger<F> logger;
    private final Async<F> evidence$1;
    private final Minio<F> minio;

    public static <F> MinioBinaryStore<F> apply(MinioConfig minioConfig, Logger<F> logger, Async<F> async) {
        return MinioBinaryStore$.MODULE$.apply(minioConfig, logger, async);
    }

    public static <F> MinioBinaryStore<F> apply(MinioConfig minioConfig, MinioAsyncClient minioAsyncClient, Logger<F> logger, Async<F> async) {
        return MinioBinaryStore$.MODULE$.apply(minioConfig, minioAsyncClient, logger, async);
    }

    public MinioBinaryStore(MinioConfig config, MinioAsyncClient client, Logger<F> logger, Async<F> evidence$1) {
        this.config = config;
        this.client = client;
        this.logger = logger;
        this.evidence$1 = evidence$1;
        this.minio = new Minio<F>(client, evidence$1);
    }

    public MinioConfig config() {
        return this.config;
    }

    public MinioAsyncClient client() {
        return this.client;
    }

    public Stream<F, String> listIds(Option<String> prefix, int chunkSize) {
        Stream stream = (Stream)implicits$.MODULE$.catsSyntaxApplyOps((Object)Stream$.MODULE$.eval(this.logger.info(() -> MinioBinaryStore.listIds$$anonfun$1(prefix))));
        return (Stream)ApplyOps$.MODULE$.$times$greater$extension((Object)stream, (Object)this.minio.listBuckets().filter((Function1 & Serializable)bucket -> this.config().keyMapping().bucketFilter((String)bucket)).flatMap((Function1 & Serializable)bucket -> this.listBucket$1((Option)prefix, chunkSize, (String)bucket), NotGiven$.MODULE$.value()), (Apply)Stream$.MODULE$.monadErrorInstance(this.evidence$1));
    }

    public Function1<Stream<F, Object>, Stream<F, String>> insert() {
        return (Function1 & Serializable)in -> Stream$.MODULE$.eval(BinaryId$.MODULE$.random(this.evidence$1)).flatMap((Function1 & Serializable)id -> this.insert$$anonfun$1$$anonfun$1((Stream)in, id == null ? null : ((BinaryId)id).id()), NotGiven$.MODULE$.value());
    }

    public Function1<Stream<F, Object>, Stream<F, Nothing$>> insertWith(String id) {
        return (Function1 & Serializable)bytes -> {
            S3Key key = this.config().makeS3Key(id);
            Stream inStream = bytes.through(package$.MODULE$.toInputStream(this.evidence$1)).map((Function1 & Serializable)_$2 -> new BufferedInputStream((InputStream)_$2));
            Stream upload = Stream$.MODULE$.eval(this.minio.makeBucketIfMissing(key.bucket())).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this.minio.uploadObject(key, this.config().partSize(), this.config().detect(), inStream).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                });
            }, NotGiven$.MODULE$.value());
            return Stream$.MODULE$.eval(Stopwatch$.MODULE$.wrap((Function1 & Serializable)d -> this.logger.trace(() -> MinioBinaryStore.insertWith$$anonfun$1$$anonfun$1$$anonfun$1(d)), upload.compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.evidence$1))).drain(), this.evidence$1)).drain();
        };
    }

    public F delete(String id) {
        S3Key key = this.config().makeS3Key(id);
        return this.minio.deleteObject(key);
    }

    public OptionT<F, Stream<F, Object>> findBinary(String id, ByteRange range) {
        S3Key key = this.config().makeS3Key(id);
        return OptionT$.MODULE$.apply(implicits$.MODULE$.toFunctorOps(this.minio.exists(key), this.evidence$1).map((Function1 & Serializable)x$1 -> this.findBinary$$anonfun$1(range, key, BoxesRunTime.unboxToBoolean((Object)x$1))));
    }

    public Kleisli<?, Object, BinaryAttributes> computeAttr(String id, Hint hint) {
        return Kleisli$.MODULE$.apply((Function1 & Serializable)select -> {
            S3Key key = this.config().makeS3Key(id);
            Object object = implicits$.MODULE$.catsSyntaxApplicativeError(this.minio.statObject(key), this.evidence$1);
            return OptionT$.MODULE$.apply(implicits$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object, this.evidence$1), this.evidence$1).map((Function1 & Serializable)_$3 -> _$3.toOption())).semiflatMap((Function1 & Serializable)stat -> {
                Object object = select;
                if (object != null) {
                    Option option = AttributeName.ContainsSha256$.MODULE$.unapply(object);
                    if (!option.isEmpty()) {
                        AttributeName.Sha256$ sha256$ = (AttributeName.Sha256$)option.get();
                        return this.minio.computeAttr(key, this.config().detect(), hint, this.config().chunkSize());
                    }
                    Option option2 = AttributeName.ContainsLength$.MODULE$.unapply(object);
                    if (!option2.isEmpty()) {
                        AttributeName.Length$ length$ = (AttributeName.Length$)option2.get();
                        long len = stat.size();
                        StatObjectResponse statObjectResponse = (StatObjectResponse)implicits$.MODULE$.catsSyntaxOptionId(stat);
                        return implicits$.MODULE$.toFunctorOps(this.minio.detectContentType(key, (Option<StatObjectResponse>)OptionIdOps$.MODULE$.some$extension((Object)statObjectResponse), this.config().detect(), hint), this.evidence$1).map((Function1 & Serializable)c -> BinaryAttributes$.MODULE$.apply(c == null ? null : ((SimpleContentType)c).contentType(), len));
                    }
                }
                StatObjectResponse statObjectResponse = (StatObjectResponse)implicits$.MODULE$.catsSyntaxOptionId(stat);
                return implicits$.MODULE$.toFunctorOps(this.minio.detectContentType(key, (Option<StatObjectResponse>)OptionIdOps$.MODULE$.some$extension((Object)statObjectResponse), this.config().detect(), hint), this.evidence$1).map((Function1 & Serializable)c -> BinaryAttributes$.MODULE$.apply(c == null ? null : ((SimpleContentType)c).contentType(), -1L));
            }, this.evidence$1);
        });
    }

    public F exists(String id) {
        S3Key key = this.config().makeS3Key(id);
        return this.minio.exists(key);
    }

    private final Stream listBucket$1(Option prefix$1, int chunkSize$1, String bucket) {
        return this.minio.listObjects(bucket, (Option<String>)None$.MODULE$, chunkSize$1, (Option<String>)prefix$1).map((Function1 & Serializable)id -> new BinaryId(BinaryId$.MODULE$.apply(id)));
    }

    private static final String listIds$$anonfun$1(Option prefix$2) {
        return new StringBuilder(22).append("List ids with filter: ").append(prefix$2).toString();
    }

    private static final Stream insert$$anonfun$1$$anonfun$1$$anonfun$1(String id$1) {
        return Stream$.MODULE$.emit((Object)new BinaryId(id$1));
    }

    private final /* synthetic */ Stream insert$$anonfun$1$$anonfun$1(Stream in$1, String id) {
        return in$1.through(this.insertWith(id)).$plus$plus(() -> MinioBinaryStore.insert$$anonfun$1$$anonfun$1$$anonfun$1(id));
    }

    private static final String insertWith$$anonfun$1$$anonfun$1$$anonfun$1(String d$1) {
        return new StringBuilder(13).append("Upload took: ").append(d$1).toString();
    }

    private final /* synthetic */ Option findBinary$$anonfun$1(ByteRange range$1, S3Key key$2, boolean x$1) {
        boolean bl = x$1;
        if (bl) {
            Stream stream = (Stream)implicits$.MODULE$.catsSyntaxOptionId(this.minio.getObjectAsStream(key$2, this.config().chunkSize(), range$1));
            return OptionIdOps$.MODULE$.some$extension((Object)stream);
        }
        if (!bl) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }
}

