/*
 * Decompiled with CFR 0.152.
 */
package binny.minio;

import binny.BinaryAttributes;
import binny.BinaryAttributes$;
import binny.ByteRange;
import binny.ContentTypeDetect;
import binny.Hint;
import binny.Hint$;
import binny.SimpleContentType;
import binny.SimpleContentType$;
import binny.minio.S3Key;
import cats.effect.kernel.Async;
import cats.effect.package$;
import cats.implicits$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.MonadErrorOps$;
import cats.syntax.OptionIdOps$;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Stream;
import fs2.Stream$;
import io.minio.BucketExistsArgs;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.ListObjectsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioAsyncClient;
import io.minio.ObjectArgs;
import io.minio.ObjectWriteResponse;
import io.minio.PutObjectArgs;
import io.minio.RemoveBucketArgs;
import io.minio.RemoveObjectArgs;
import io.minio.StatObjectArgs;
import io.minio.StatObjectResponse;
import io.minio.errors.ErrorResponseException;
import io.minio.messages.Item;
import java.io.InputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.NotGiven$;
import scala.util.Right;
import scala.util.Using;
import scala.util.Using$;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public final class Minio<F> {
    private final MinioAsyncClient client;
    private final Async<F> evidence$1;
    private final Async async;

    public Minio(MinioAsyncClient client, Async<F> evidence$1) {
        this.client = client;
        this.evidence$1 = evidence$1;
        this.async = package$.MODULE$.Async().apply(evidence$1);
    }

    public Async<F> async() {
        return this.async;
    }

    private <A> F future(Function0<CompletableFuture<A>> f) {
        return (F)this.async().fromCompletableFuture(package$.MODULE$.Async().apply(this.evidence$1).delay(f));
    }

    public Stream<F, String> listBuckets() {
        return Stream$.MODULE$.eval(this.future(this::listBuckets$$anonfun$1)).flatMap((Function1 & Serializable)jl -> Stream$.MODULE$.chunk(Chunk$.MODULE$.from((Iterable)CollectionConverters$.MODULE$.ListHasAsScala(jl).asScala())), NotGiven$.MODULE$.value()).map((Function1 & Serializable)_$2 -> _$2.name());
    }

    public Stream<F, String> listObjects(String bucket, Option<String> startAfter, int maxKeys, Option<String> prefix) {
        Object chunk = package$.MODULE$.Sync().apply(this.evidence$1).blocking(() -> this.$anonfun$1(bucket, startAfter, maxKeys, prefix));
        return Stream$.MODULE$.eval(chunk).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Stream ch = (Stream)tuple2._1();
                Option last = (Option)tuple2._2();
                Option option = last;
                if (option instanceof Some) {
                    String el = (String)((Some)option).value();
                    return ch.$plus$plus(() -> this.listObjects$$anonfun$1$$anonfun$1(bucket, maxKeys, prefix, el));
                }
                if (None$.MODULE$.equals(option)) {
                    return ch;
                }
                throw new MatchError((Object)option);
            }
            throw new MatchError((Object)tuple2);
        }, NotGiven$.MODULE$.value());
    }

    private F bucketExists(String name) {
        BucketExistsArgs args = (BucketExistsArgs)BucketExistsArgs.builder().bucket(name).build();
        return (F)implicits$.MODULE$.toFunctorOps(this.future(() -> this.bucketExists$$anonfun$1(args)), this.evidence$1).map((Function1 & Serializable)_$5 -> _$5);
    }

    private F makeBucket(String name) {
        MakeBucketArgs args = (MakeBucketArgs)MakeBucketArgs.builder().bucket(name).build();
        return (F)implicits$.MODULE$.toFunctorOps(this.future(() -> this.makeBucket$$anonfun$1(args)), this.evidence$1).void();
    }

    public F makeBucketIfMissing(String name) {
        return (F)implicits$.MODULE$.toFlatMapOps(this.bucketExists(name), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> this.makeBucketIfMissing$$anonfun$1(name, BoxesRunTime.unboxToBoolean((Object)x$1)));
    }

    public Stream<F, BoxedUnit> uploadObject(S3Key key, int partSize, ContentTypeDetect detect, Stream<F, InputStream> in) {
        return in.evalMap((Function1 & Serializable)javaStream -> implicits$.MODULE$.toFlatMapOps(implicits$.MODULE$.toFunctorOps(package$.MODULE$.Sync().apply(this.evidence$1).blocking((Function0 & Serializable)() -> new SimpleContentType(Minio.uploadObject$$anonfun$1$$anonfun$1(key, detect, javaStream))), this.evidence$1).map((Function1 & Serializable)ct -> Minio.uploadObject$$anonfun$1$$anonfun$2(key, partSize, javaStream, ct == null ? null : ((SimpleContentType)ct).contentType())), this.evidence$1).flatMap((Function1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                String ct = tuple2._1() == null ? null : ((SimpleContentType)tuple2._1()).contentType();
                PutObjectArgs args = (PutObjectArgs)tuple2._2();
                return implicits$.MODULE$.toFunctorOps(this.future(() -> this.uploadObject$$anonfun$1$$anonfun$3$$anonfun$1(args)), this.evidence$1).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    ObjectWriteResponse objectWriteResponse = x$1;
                });
            }
            throw new MatchError((Object)tuple2);
        }));
    }

    public F uploadObject(S3Key key, int partSize, ContentTypeDetect detect, ByteVector in) {
        String ct = detect.detect(in, Hint$.MODULE$.filename(key.asPath()));
        PutObjectArgs args = (PutObjectArgs)((PutObjectArgs.Builder)((ObjectArgs.Builder)new PutObjectArgs.Builder().bucket(key.bucket())).object(key.objectName())).contentType(ct).stream(in.toInputStream(), in.length(), Int$.MODULE$.int2long(partSize)).build();
        return this.future(() -> this.uploadObject$$anonfun$2(args));
    }

    public F deleteObject(S3Key key) {
        RemoveObjectArgs args = (RemoveObjectArgs)((ObjectArgs.Builder)RemoveObjectArgs.builder().bucket(key.bucket())).object(key.objectName()).build();
        return (F)implicits$.MODULE$.toFunctorOps(this.future(() -> this.deleteObject$$anonfun$1(args)), this.evidence$1).void();
    }

    public F deleteBucket(String name) {
        RemoveBucketArgs args = (RemoveBucketArgs)RemoveBucketArgs.builder().bucket(name).build();
        return (F)implicits$.MODULE$.toFunctorOps(this.future(() -> this.deleteBucket$$anonfun$1(args)), this.evidence$1).void();
    }

    public F statObject(S3Key key) {
        StatObjectArgs args = (StatObjectArgs)((ObjectArgs.Builder)StatObjectArgs.builder().bucket(key.bucket())).object(key.objectName()).build();
        return this.future(() -> this.statObject$$anonfun$1(args));
    }

    public F exists(S3Key key) {
        Object object = implicits$.MODULE$.catsSyntaxMonadError(this.statObject(key), this.evidence$1);
        return (F)MonadErrorOps$.MODULE$.redeemWith$extension(object, (Function1 & Serializable)ex -> this.decodeNotFoundAs(Minio::exists$$anonfun$1$$anonfun$1, (Throwable)ex), (Function1 & Serializable)_$6 -> {
            Boolean bl = (Boolean)implicits$.MODULE$.catsSyntaxApplicativeId((Object)BoxesRunTime.boxToBoolean((boolean)true));
            return ApplicativeIdOps$.MODULE$.pure$extension((Object)bl, this.evidence$1);
        }, this.evidence$1);
    }

    public F getObject(S3Key key, ByteRange range) {
        GetObjectArgs getObjectArgs;
        GetObjectArgs.Builder aargs = (GetObjectArgs.Builder)((ObjectArgs.Builder)GetObjectArgs.builder().bucket(key.bucket())).object(key.objectName());
        ByteRange byteRange = range;
        if (ByteRange.All$.MODULE$.equals(byteRange)) {
            getObjectArgs = (GetObjectArgs)aargs.build();
        } else if (byteRange instanceof ByteRange.Chunk) {
            ByteRange.Chunk chunk = ByteRange.Chunk$.MODULE$.unapply((ByteRange.Chunk)byteRange);
            long l = chunk._1();
            int n = chunk._2();
            long offset = l;
            int length = n;
            GetObjectArgs.Builder ao = offset > 0L ? (GetObjectArgs.Builder)aargs.offset(Predef$.MODULE$.long2Long(offset)) : aargs;
            GetObjectArgs.Builder lo = length >= 0 && length < Integer.MAX_VALUE ? (GetObjectArgs.Builder)ao.length(Predef$.MODULE$.long2Long((long)length)) : ao;
            getObjectArgs = (GetObjectArgs)lo.build();
        } else {
            throw new MatchError((Object)byteRange);
        }
        GetObjectArgs args = getObjectArgs;
        return this.future(() -> this.getObject$$anonfun$1(args));
    }

    public F getObjectOption(S3Key key, ByteRange range) {
        Object object = implicits$.MODULE$.catsSyntaxMonadError(this.getObject(key, range), this.evidence$1);
        return (F)MonadErrorOps$.MODULE$.redeemWith$extension(object, (Function1 & Serializable)ex -> this.decodeNotFoundAs(Minio::getObjectOption$$anonfun$1$$anonfun$1, (Throwable)ex), (Function1 & Serializable)_$7 -> {
            GetObjectResponse getObjectResponse = (GetObjectResponse)implicits$.MODULE$.catsSyntaxOptionId(_$7);
            Option option = (Option)implicits$.MODULE$.catsSyntaxApplicativeId((Object)OptionIdOps$.MODULE$.some$extension((Object)getObjectResponse));
            return ApplicativeIdOps$.MODULE$.pure$extension((Object)option, this.evidence$1);
        }, this.evidence$1);
    }

    private boolean isNotFound(Throwable ex) {
        while (true) {
            ErrorResponseException e;
            Throwable throwable;
            if ((throwable = ex) instanceof ErrorResponseException && (e = (ErrorResponseException)throwable).response().code() == 404) {
                return true;
            }
            if (!(throwable instanceof CompletionException)) break;
            CompletionException e2 = (CompletionException)throwable;
            ex = e2.getCause();
        }
        return false;
    }

    private <A> F decodeNotFoundAs(Function0<A> defaultValue, Throwable ex) {
        if (this.isNotFound(ex)) {
            return (F)package$.MODULE$.Sync().apply(this.evidence$1).pure(defaultValue.apply());
        }
        return (F)package$.MODULE$.Sync().apply(this.evidence$1).raiseError((Object)ex);
    }

    public Stream<F, Object> getObjectAsStream(S3Key key, int chunkSize, ByteRange range) {
        Object input = implicits$.MODULE$.toFunctorOps(this.getObject(key, range), this.evidence$1).map((Function1 & Serializable)a -> a);
        return fs2.io.package$.MODULE$.readInputStream(input, chunkSize, true, this.evidence$1);
    }

    public F getObjectAsStreamOption(S3Key key, int chunkSize, ByteRange range) {
        Object object = implicits$.MODULE$.catsSyntaxMonadError(this.getObject(key, range), this.evidence$1);
        return (F)implicits$.MODULE$.toFunctorOps(MonadErrorOps$.MODULE$.redeemWith$extension(object, (Function1 & Serializable)ex -> this.decodeNotFoundAs(Minio::getObjectAsStreamOption$$anonfun$1$$anonfun$1, (Throwable)ex), (Function1 & Serializable)_$8 -> {
            GetObjectResponse getObjectResponse = (GetObjectResponse)implicits$.MODULE$.catsSyntaxOptionId(_$8);
            Option option = (Option)implicits$.MODULE$.catsSyntaxApplicativeId((Object)OptionIdOps$.MODULE$.some$extension((Object)getObjectResponse));
            return ApplicativeIdOps$.MODULE$.pure$extension((Object)option, this.evidence$1);
        }, this.evidence$1), this.evidence$1).map((Function1 & Serializable)_$9 -> _$9.map((Function1 & Serializable)resp -> {
            InputStream inputStream = (InputStream)implicits$.MODULE$.catsSyntaxApplicativeId(resp);
            return fs2.io.package$.MODULE$.readInputStream(ApplicativeIdOps$.MODULE$.pure$extension((Object)inputStream, this.evidence$1), chunkSize, true, this.evidence$1);
        }));
    }

    public F computeAttr(S3Key key, ContentTypeDetect detect, Hint hint, int chunkSize) {
        GetObjectArgs args = (GetObjectArgs)((ObjectArgs.Builder)GetObjectArgs.builder().bucket(key.bucket())).object(key.objectName()).build();
        return (F)implicits$.MODULE$.toFlatMapOps(this.future(() -> this.computeAttr$$anonfun$1(args)), this.evidence$1).flatMap((Function1 & Serializable)resp -> package$.MODULE$.Sync().apply(this.evidence$1).blocking(() -> Minio.computeAttr$$anonfun$2$$anonfun$1(detect, hint, chunkSize, resp)));
    }

    public F detectContentType(S3Key key, Option<StatObjectResponse> stat, ContentTypeDetect detect, Hint hint) {
        Object readCt = this.getObjectAsStream(key, 50, (ByteRange)ByteRange.Chunk$.MODULE$.apply(0L, 50)).through(detect.detectStream(hint)).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.evidence$1))).lastOrError(this.evidence$1);
        return (F)stat.flatMap((Function1 & Serializable)s -> Option$.MODULE$.apply((Object)s.contentType())).map((Function1 & Serializable)_$10 -> new SimpleContentType(SimpleContentType$.MODULE$.apply(_$10))).filter((Function1 & Serializable)c -> Minio.detectContentType$$anonfun$3(c == null ? null : ((SimpleContentType)c).contentType())).map((Function1 & Serializable)_$11 -> this.detectContentType$$anonfun$4(_$11 == null ? null : ((SimpleContentType)_$11).contentType())).getOrElse(() -> Minio.detectContentType$$anonfun$5(readCt));
    }

    private final CompletableFuture listBuckets$$anonfun$1() {
        return this.client.listBuckets();
    }

    private final Tuple2 $anonfun$1(String bucket$1, Option startAfter$1, int maxKeys$1, Option prefix$1) {
        ListObjectsArgs.Builder args = ((ListObjectsArgs.Builder)ListObjectsArgs.builder().recursive(true).bucket(bucket$1)).maxKeys(maxKeys$1);
        startAfter$1.foreach((Function1 & Serializable)x$0 -> args.startAfter(x$0));
        prefix$1.foreach((Function1 & Serializable)x$0 -> args.prefix(x$0));
        java.lang.Iterable result = this.client.listObjects((ListObjectsArgs)args.build());
        Chunk ch = Chunk$.MODULE$.from((Iterable)CollectionConverters$.MODULE$.IterableHasAsScala(result).asScala().map((Function1 & Serializable)_$3 -> ((Item)_$3.get()).objectName()));
        return Tuple2$.MODULE$.apply((Object)(ch.isEmpty() ? Stream$.MODULE$.empty() : Stream$.MODULE$.chunk(ch)), (Object)ch.last().filter((Function1 & Serializable)_$4 -> ch.size() == maxKeys$1));
    }

    private final Stream listObjects$$anonfun$1$$anonfun$1(String bucket$3, int maxKeys$4, Option prefix$3, String el$1) {
        return this.listObjects(bucket$3, (Option<String>)Some$.MODULE$.apply((Object)el$1), maxKeys$4, (Option<String>)prefix$3);
    }

    private final CompletableFuture bucketExists$$anonfun$1(BucketExistsArgs args$3) {
        return this.client.bucketExists(args$3);
    }

    private final CompletableFuture makeBucket$$anonfun$1(MakeBucketArgs args$4) {
        return this.client.makeBucket(args$4);
    }

    private final /* synthetic */ Object makeBucketIfMissing$$anonfun$1$$anonfun$1$$anonfun$1(Throwable ex$1, boolean x$1) {
        boolean bl = x$1;
        if (bl) {
            BoxedUnit boxedUnit = (BoxedUnit)implicits$.MODULE$.catsSyntaxApplicativeId((Object)BoxedUnit.UNIT);
            return ApplicativeIdOps$.MODULE$.pure$extension((Object)boxedUnit, this.evidence$1);
        }
        if (!bl) {
            return package$.MODULE$.Sync().apply(this.evidence$1).raiseError((Object)ex$1);
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    private final /* synthetic */ Object makeBucketIfMissing$$anonfun$1(String name$1, boolean x$1) {
        boolean bl = x$1;
        if (bl) {
            BoxedUnit boxedUnit = (BoxedUnit)implicits$.MODULE$.catsSyntaxApplicativeId((Object)BoxedUnit.UNIT);
            return ApplicativeIdOps$.MODULE$.pure$extension((Object)boxedUnit, this.evidence$1);
        }
        if (!bl) {
            Object object = implicits$.MODULE$.catsSyntaxApplicativeError(this.makeBucket(name$1), this.evidence$1);
            return implicits$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object, this.evidence$1), this.evidence$1).flatMap((Function1 & Serializable)x$12 -> {
                Either either = x$12;
                if (either instanceof Right) {
                    BoxedUnit n = (BoxedUnit)((Right)either).value();
                    BoxedUnit boxedUnit = (BoxedUnit)implicits$.MODULE$.catsSyntaxApplicativeId((Object)n);
                    return ApplicativeIdOps$.MODULE$.pure$extension((Object)boxedUnit, this.evidence$1);
                }
                if (either instanceof Left) {
                    Throwable ex = (Throwable)((Left)either).value();
                    return implicits$.MODULE$.toFlatMapOps(this.bucketExists(name$1), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> this.makeBucketIfMissing$$anonfun$1$$anonfun$1$$anonfun$1(ex, BoxesRunTime.unboxToBoolean((Object)x$1)));
                }
                throw new MatchError((Object)either);
            });
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    private static final String uploadObject$$anonfun$1$$anonfun$1(S3Key key$1, ContentTypeDetect detect$1, InputStream javaStream$1) {
        if (javaStream$1.markSupported()) {
            byte[] buffer = new byte[32];
            javaStream$1.mark(65);
            int read = javaStream$1.read(buffer);
            String ret = detect$1.detect(ByteVector$.MODULE$.view(buffer, 0, read), Hint$.MODULE$.filename(key$1.asPath()));
            javaStream$1.reset();
            return ret;
        }
        return SimpleContentType$.MODULE$.octetStream();
    }

    private static final /* synthetic */ Tuple2 uploadObject$$anonfun$1$$anonfun$2(S3Key key$3, int partSize$2, InputStream javaStream$2, String ct) {
        PutObjectArgs args = (PutObjectArgs)((PutObjectArgs.Builder)((ObjectArgs.Builder)new PutObjectArgs.Builder().bucket(key$3.bucket())).object(key$3.objectName())).contentType(ct).stream(javaStream$2, -1L, Int$.MODULE$.int2long(partSize$2)).build();
        return Tuple2$.MODULE$.apply((Object)new SimpleContentType(ct), (Object)args);
    }

    private final CompletableFuture uploadObject$$anonfun$1$$anonfun$3$$anonfun$1(PutObjectArgs args$5) {
        return this.client.putObject(args$5);
    }

    private final CompletableFuture uploadObject$$anonfun$2(PutObjectArgs args$6) {
        return this.client.putObject(args$6);
    }

    private final CompletableFuture deleteObject$$anonfun$1(RemoveObjectArgs args$7) {
        return this.client.removeObject(args$7);
    }

    private final CompletableFuture deleteBucket$$anonfun$1(RemoveBucketArgs args$8) {
        return this.client.removeBucket(args$8);
    }

    private final CompletableFuture statObject$$anonfun$1(StatObjectArgs args$9) {
        return this.client.statObject(args$9);
    }

    private static final boolean exists$$anonfun$1$$anonfun$1() {
        return false;
    }

    private final CompletableFuture getObject$$anonfun$1(GetObjectArgs args$10) {
        return this.client.getObject(args$10);
    }

    private static final Option getObjectOption$$anonfun$1$$anonfun$1() {
        return Option$.MODULE$.empty();
    }

    private static final Option getObjectAsStreamOption$$anonfun$1$$anonfun$1() {
        return Option$.MODULE$.empty();
    }

    private final CompletableFuture computeAttr$$anonfun$1(GetObjectArgs args$11) {
        return this.client.getObject(args$11);
    }

    private static final String computeAttr$$anonfun$2$$anonfun$1$$anonfun$2() {
        return SimpleContentType$.MODULE$.octetStream();
    }

    private static final BinaryAttributes computeAttr$$anonfun$2$$anonfun$1(ContentTypeDetect detect$4, Hint hint$2, int chunkSize$4, GetObjectResponse resp$1) {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        LongRef len = LongRef.create((long)0L);
        ObjectRef ct = ObjectRef.create((Object)None$.MODULE$);
        byte[] buf = new byte[chunkSize$4];
        IntRef read = IntRef.create((int)-1);
        Using$.MODULE$.resource((Object)resp$1, (Function1)(JProcedure1 & Serializable)rr -> {
            while (true) {
                long l;
                int n;
                read$1.elem = n = rr.read(buf);
                if (read$1.elem <= 0) break;
                md.update(buf, 0, read$1.elem);
                len$1.elem = l = len$1.elem + (long)read$1.elem;
                if (!((Option)ct$1.elem).isEmpty()) continue;
                Some some = Some$.MODULE$.apply((Object)new SimpleContentType(detect$4.detect(ByteVector$.MODULE$.view(buf, 0, read$1.elem), hint$2)));
                ct$1.elem = some;
                some = null;
            }
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        Object object = ((Option)ct.elem).getOrElse((Function0 & Serializable)() -> new SimpleContentType(Minio.computeAttr$$anonfun$2$$anonfun$1$$anonfun$2()));
        return BinaryAttributes$.MODULE$.apply(ByteVector$.MODULE$.view(md.digest()), object == null ? null : ((SimpleContentType)object).contentType(), len.elem);
    }

    private static final /* synthetic */ boolean detectContentType$$anonfun$3(String c) {
        return !SimpleContentType$.MODULE$.isOctetStream$extension(c);
    }

    private final /* synthetic */ Object detectContentType$$anonfun$4(String _$11) {
        SimpleContentType simpleContentType = (SimpleContentType)implicits$.MODULE$.catsSyntaxApplicativeId((Object)new SimpleContentType(_$11));
        return ApplicativeIdOps$.MODULE$.pure$extension((Object)simpleContentType, this.evidence$1);
    }

    private static final Object detectContentType$$anonfun$5(Object readCt$1) {
        return readCt$1;
    }
}

