/*
 * Decompiled with CFR 0.152.
 */
package ciris.internal.digest;

public abstract class GeneralDigest {
    private final byte[] xBuf = new byte[4];
    private int xBufOff = 0;
    private long byteCount = 0L;

    public void update(byte in) {
        this.xBuf[this.xBufOff] = in;
        ++this.xBufOff;
        if (this.xBufOff == this.xBuf.length) {
            this.processWord(this.xBuf, 0);
            this.xBufOff = 0;
        }
        ++this.byteCount;
    }

    public void update(byte[] in, int inOff, int len) {
        int i;
        int length = Math.max(0, len);
        boolean done = false;
        if (this.xBufOff != 0) {
            for (i = 0; !done && i < length; ++i) {
                this.xBuf[this.xBufOff] = in[inOff + i];
                ++this.xBufOff;
                if (this.xBufOff != 4) continue;
                this.processWord(this.xBuf, 0);
                this.xBufOff = 0;
                done = true;
            }
        }
        int limit = (length - i & 0xFFFFFFFC) + i;
        while (i < limit) {
            this.processWord(in, inOff + i);
            i += 4;
        }
        while (i < length) {
            this.xBuf[this.xBufOff] = in[inOff + i];
            ++this.xBufOff;
            ++i;
        }
        this.byteCount += (long)length;
    }

    public void finish() {
        long bitLength = this.byteCount << 3;
        this.update((byte)128);
        while (this.xBufOff != 0) {
            this.update((byte)0);
        }
        this.processLength(bitLength);
        this.processBlock();
    }

    public void reset() {
        this.byteCount = 0L;
        this.xBufOff = 0;
        for (int i = 0; i < this.xBuf.length; ++i) {
            this.xBuf[i] = 0;
        }
    }

    public abstract void processWord(byte[] var1, int var2);

    public abstract void processLength(long var1);

    public abstract void processBlock();
}

