/*
 * Decompiled with CFR 0.152.
 */
package sharry.store;

import java.io.Serializable;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;
import sharry.common.LenientUri;
import sharry.store.JdbcConfig$;

public class JdbcConfig
implements Product,
Serializable {
    private final LenientUri url;
    private final String user;
    private final String password;
    private final Option<String> dbmsName;

    public static JdbcConfig apply(LenientUri lenientUri, String string, String string2) {
        return JdbcConfig$.MODULE$.apply(lenientUri, string, string2);
    }

    public static Option<String> extractDbmsName(LenientUri lenientUri) {
        return JdbcConfig$.MODULE$.extractDbmsName(lenientUri);
    }

    public static JdbcConfig fromProduct(Product product) {
        return JdbcConfig$.MODULE$.fromProduct(product);
    }

    public static JdbcConfig unapply(JdbcConfig jdbcConfig) {
        return JdbcConfig$.MODULE$.unapply(jdbcConfig);
    }

    public JdbcConfig(LenientUri url, String user, String password) {
        this.url = url;
        this.user = user;
        this.password = password;
        this.dbmsName = JdbcConfig$.MODULE$.extractDbmsName(url);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof JdbcConfig)) return false;
        JdbcConfig jdbcConfig = (JdbcConfig)object;
        LenientUri lenientUri = this.url();
        LenientUri lenientUri2 = jdbcConfig.url();
        if (lenientUri == null) {
            if (lenientUri2 != null) {
                return false;
            }
        } else if (!lenientUri.equals(lenientUri2)) return false;
        String string = this.user();
        String string2 = jdbcConfig.user();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.password();
        String string4 = jdbcConfig.password();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        if (!jdbcConfig.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof JdbcConfig;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "JdbcConfig";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "url";
            }
            case 1: {
                return "user";
            }
            case 2: {
                return "password";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public LenientUri url() {
        return this.url;
    }

    public String user() {
        return this.user;
    }

    public String password() {
        return this.password;
    }

    public Option<String> dbmsName() {
        return this.dbmsName;
    }

    public String driverClass() {
        Option<String> option = this.dbmsName();
        if (option instanceof Some) {
            String string = (String)((Some)option).value();
            switch (string == null ? 0 : string.hashCode()) {
                case -2105481388: {
                    if (!"postgresql".equals(string)) break;
                    return "org.postgresql.Driver";
                }
                case -894935028: {
                    if (!"sqlite".equals(string)) break;
                    return "org.sqlite.JDBC";
                }
                case 3274: {
                    if (!"h2".equals(string)) break;
                    return "org.h2.Driver";
                }
                case 839186932: {
                    if (!"mariadb".equals(string)) break;
                    return "org.mariadb.jdbc.Driver";
                }
            }
            String n = string;
            throw package$.MODULE$.error(new StringBuilder(14).append("Unknown DBMS: ").append(n).toString());
        }
        if (None$.MODULE$.equals(option)) {
            throw package$.MODULE$.error("No JDBC url specified");
        }
        throw new MatchError(option);
    }

    public String toString() {
        return new StringBuilder(19).append("JdbcConfig(").append(this.url()).append(", ").append(this.user()).append(", ***)").toString();
    }

    public JdbcConfig copy(LenientUri url, String user, String password) {
        return new JdbcConfig(url, user, password);
    }

    public LenientUri copy$default$1() {
        return this.url();
    }

    public String copy$default$2() {
        return this.user();
    }

    public String copy$default$3() {
        return this.password();
    }

    public LenientUri _1() {
        return this.url();
    }

    public String _2() {
        return this.user();
    }

    public String _3() {
        return this.password();
    }
}

