# Generated by Django 4.2.13 on 2024-06-28 17:47

import django.db.models.deletion
import django.utils.timezone
from django.conf import settings
from django.db import migrations
from django.db import models


class Migration(migrations.Migration):
    replaces = [
        ("paperless_mail", "0011_remove_mailrule_assign_tag"),
        ("paperless_mail", "0012_alter_mailrule_assign_tags"),
        ("paperless_mail", "0009_alter_mailrule_action_alter_mailrule_folder"),
        ("paperless_mail", "0013_merge_20220412_1051"),
        ("paperless_mail", "0014_alter_mailrule_action"),
        ("paperless_mail", "0015_alter_mailrule_action"),
        ("paperless_mail", "0016_mailrule_consumption_scope"),
        ("paperless_mail", "0017_mailaccount_owner_mailrule_owner"),
        ("paperless_mail", "0018_processedmail"),
        ("paperless_mail", "0019_mailrule_filter_to"),
        ("paperless_mail", "0020_mailaccount_is_token"),
        ("paperless_mail", "0021_alter_mailaccount_password"),
        ("paperless_mail", "0022_mailrule_assign_owner_from_rule_and_more"),
        ("paperless_mail", "0023_remove_mailrule_filter_attachment_filename_and_more"),
        ("paperless_mail", "0024_alter_mailrule_name_and_more"),
    ]

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("paperless_mail", "0010_auto_20220311_1602"),
    ]

    operations = [
        migrations.RemoveField(
            model_name="mailrule",
            name="assign_tag",
        ),
        migrations.AlterField(
            model_name="mailrule",
            name="assign_tags",
            field=models.ManyToManyField(
                blank=True,
                to="documents.tag",
                verbose_name="assign this tag",
            ),
        ),
        migrations.AlterField(
            model_name="mailrule",
            name="action",
            field=models.PositiveIntegerField(
                choices=[
                    (1, "Mark as read, don't process read mails"),
                    (2, "Flag the mail, don't process flagged mails"),
                    (3, "Move to specified folder"),
                    (4, "Delete"),
                ],
                default=3,
                verbose_name="action",
            ),
        ),
        migrations.AlterField(
            model_name="mailrule",
            name="folder",
            field=models.CharField(
                default="INBOX",
                help_text="Subfolders must be separated by a delimiter, often a dot ('.') or slash ('/'), but it varies by mail server.",
                max_length=256,
                verbose_name="folder",
            ),
        ),
        migrations.AlterField(
            model_name="mailrule",
            name="action",
            field=models.PositiveIntegerField(
                choices=[
                    (1, "Delete"),
                    (2, "Move to specified folder"),
                    (3, "Mark as read, don't process read mails"),
                    (4, "Flag the mail, don't process flagged mails"),
                ],
                default=3,
                verbose_name="action",
            ),
        ),
        migrations.AlterField(
            model_name="mailrule",
            name="action",
            field=models.PositiveIntegerField(
                choices=[
                    (1, "Delete"),
                    (2, "Move to specified folder"),
                    (3, "Mark as read, don't process read mails"),
                    (4, "Flag the mail, don't process flagged mails"),
                    (5, "Tag the mail with specified tag, don't process tagged mails"),
                ],
                default=3,
                verbose_name="action",
            ),
        ),
        migrations.AddField(
            model_name="mailrule",
            name="consumption_scope",
            field=models.PositiveIntegerField(
                choices=[
                    (1, "Only process attachments."),
                    (
                        2,
                        "Process full Mail (with embedded attachments in file) as .eml",
                    ),
                    (
                        3,
                        "Process full Mail (with embedded attachments in file) as .eml + process attachments as separate documents",
                    ),
                ],
                default=1,
                verbose_name="consumption scope",
            ),
        ),
        migrations.AddField(
            model_name="mailaccount",
            name="owner",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to=settings.AUTH_USER_MODEL,
                verbose_name="owner",
            ),
        ),
        migrations.AddField(
            model_name="mailrule",
            name="owner",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to=settings.AUTH_USER_MODEL,
                verbose_name="owner",
            ),
        ),
        migrations.CreateModel(
            name="ProcessedMail",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "folder",
                    models.CharField(
                        editable=False,
                        max_length=256,
                        verbose_name="folder",
                    ),
                ),
                (
                    "uid",
                    models.CharField(
                        editable=False,
                        max_length=256,
                        verbose_name="uid",
                    ),
                ),
                (
                    "subject",
                    models.CharField(
                        editable=False,
                        max_length=256,
                        verbose_name="subject",
                    ),
                ),
                (
                    "received",
                    models.DateTimeField(editable=False, verbose_name="received"),
                ),
                (
                    "processed",
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="processed",
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        editable=False,
                        max_length=256,
                        verbose_name="status",
                    ),
                ),
                (
                    "error",
                    models.TextField(
                        blank=True,
                        editable=False,
                        null=True,
                        verbose_name="error",
                    ),
                ),
                (
                    "owner",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="owner",
                    ),
                ),
                (
                    "rule",
                    models.ForeignKey(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="paperless_mail.mailrule",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="mailrule",
            name="filter_to",
            field=models.CharField(
                blank=True,
                max_length=256,
                null=True,
                verbose_name="filter to",
            ),
        ),
        migrations.AddField(
            model_name="mailaccount",
            name="is_token",
            field=models.BooleanField(
                default=False,
                verbose_name="Is token authentication",
            ),
        ),
        migrations.AlterField(
            model_name="mailaccount",
            name="password",
            field=models.CharField(max_length=2048, verbose_name="password"),
        ),
        migrations.AddField(
            model_name="mailrule",
            name="assign_owner_from_rule",
            field=models.BooleanField(
                default=True,
                verbose_name="Assign the rule owner to documents",
            ),
        ),
        migrations.AlterField(
            model_name="mailrule",
            name="assign_title_from",
            field=models.PositiveIntegerField(
                choices=[
                    (1, "Use subject as title"),
                    (2, "Use attachment filename as title"),
                    (3, "Do not assign title from rule"),
                ],
                default=1,
                verbose_name="assign title from",
            ),
        ),
        migrations.RenameField(
            model_name="mailrule",
            old_name="filter_attachment_filename",
            new_name="filter_attachment_filename_include",
        ),
        migrations.AddField(
            model_name="mailrule",
            name="filter_attachment_filename_exclude",
            field=models.CharField(
                blank=True,
                help_text="Do not consume documents which entirely match this filename if specified. Wildcards such as *.pdf or *invoice* are allowed. Case insensitive.",
                max_length=256,
                null=True,
                verbose_name="filter attachment filename exclusive",
            ),
        ),
        migrations.AlterField(
            model_name="mailrule",
            name="filter_attachment_filename_include",
            field=models.CharField(
                blank=True,
                help_text="Only consume documents which entirely match this filename if specified. Wildcards such as *.pdf or *invoice* are allowed. Case insensitive.",
                max_length=256,
                null=True,
                verbose_name="filter attachment filename inclusive",
            ),
        ),
        migrations.AlterField(
            model_name="mailrule",
            name="name",
            field=models.CharField(max_length=256, verbose_name="name"),
        ),
        migrations.AddConstraint(
            model_name="mailrule",
            constraint=models.UniqueConstraint(
                fields=("name", "owner"),
                name="paperless_mail_mailrule_unique_name_owner",
            ),
        ),
        migrations.AddConstraint(
            model_name="mailrule",
            constraint=models.UniqueConstraint(
                condition=models.Q(("owner__isnull", True)),
                fields=("name",),
                name="paperless_mail_mailrule_name_unique",
            ),
        ),
    ]
