# Generated by Django 4.2.7 on 2023-12-19 17:51

import django.core.validators
from django.db import migrations
from django.db import models


def _create_singleton(apps, schema_editor):
    """
    Creates the first and only instance of the configuration model
    """
    settings_model = apps.get_model("paperless", "ApplicationConfiguration")
    settings_model.objects.create()


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="ApplicationConfiguration",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "output_type",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("pdf", "pdf"),
                            ("pdfa", "pdfa"),
                            ("pdfa-1", "pdfa-1"),
                            ("pdfa-2", "pdfa-2"),
                            ("pdfa-3", "pdfa-3"),
                        ],
                        max_length=8,
                        null=True,
                        verbose_name="Sets the output PDF type",
                    ),
                ),
                (
                    "pages",
                    models.PositiveIntegerField(
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                        ],
                        verbose_name="Do OCR from page 1 to this value",
                    ),
                ),
                (
                    "language",
                    models.CharField(
                        blank=True,
                        max_length=32,
                        null=True,
                        verbose_name="Do OCR using these languages",
                    ),
                ),
                (
                    "mode",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("skip", "skip"),
                            ("redo", "redo"),
                            ("force", "force"),
                            ("skip_noarchive", "skip_noarchive"),
                        ],
                        max_length=16,
                        null=True,
                        verbose_name="Sets the OCR mode",
                    ),
                ),
                (
                    "skip_archive_file",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("never", "never"),
                            ("with_text", "with_text"),
                            ("always", "always"),
                        ],
                        max_length=16,
                        null=True,
                        verbose_name="Controls the generation of an archive file",
                    ),
                ),
                (
                    "image_dpi",
                    models.PositiveIntegerField(
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                        ],
                        verbose_name="Sets image DPI fallback value",
                    ),
                ),
                (
                    "unpaper_clean",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("clean", "clean"),
                            ("clean-final", "clean-final"),
                            ("none", "none"),
                        ],
                        max_length=16,
                        null=True,
                        verbose_name="Controls the unpaper cleaning",
                    ),
                ),
                (
                    "deskew",
                    models.BooleanField(null=True, verbose_name="Enables deskew"),
                ),
                (
                    "rotate_pages",
                    models.BooleanField(
                        null=True,
                        verbose_name="Enables page rotation",
                    ),
                ),
                (
                    "rotate_pages_threshold",
                    models.FloatField(
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0.0)],
                        verbose_name="Sets the threshold for rotation of pages",
                    ),
                ),
                (
                    "max_image_pixels",
                    models.FloatField(
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1000000.0),
                        ],
                        verbose_name="Sets the maximum image size for decompression",
                    ),
                ),
                (
                    "color_conversion_strategy",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("LeaveColorUnchanged", "LeaveColorUnchanged"),
                            ("RGB", "RGB"),
                            ("UseDeviceIndependentColor", "UseDeviceIndependentColor"),
                            ("Gray", "Gray"),
                            ("CMYK", "CMYK"),
                        ],
                        max_length=32,
                        null=True,
                        verbose_name="Sets the Ghostscript color conversion strategy",
                    ),
                ),
                (
                    "user_args",
                    models.JSONField(
                        null=True,
                        verbose_name="Adds additional user arguments for OCRMyPDF",
                    ),
                ),
            ],
            options={
                "verbose_name": "paperless application settings",
            },
        ),
        migrations.RunPython(_create_singleton, migrations.RunPython.noop),
    ]
