# Generated by Django 4.2.13 on 2024-06-28 18:10

import django.core.validators
import django.db.models.deletion
import django.utils.timezone
from django.conf import settings
from django.db import migrations
from django.db import models


class Migration(migrations.Migration):
    replaces = [
        ("documents", "1022_paperlesstask"),
        ("documents", "1023_add_comments"),
        ("documents", "1024_document_original_filename"),
        ("documents", "1025_alter_savedviewfilterrule_rule_type"),
        ("documents", "1026_transition_to_celery"),
        ("documents", "1027_remove_paperlesstask_attempted_task_and_more"),
        ("documents", "1028_remove_paperlesstask_task_args_and_more"),
        ("documents", "1029_alter_document_archive_serial_number"),
        ("documents", "1030_alter_paperlesstask_task_file_name"),
        ("documents", "1031_remove_savedview_user_correspondent_owner_and_more"),
        ("documents", "1032_alter_correspondent_matching_algorithm_and_more"),
        ("documents", "1033_alter_documenttype_options_alter_tag_options_and_more"),
        ("documents", "1034_alter_savedviewfilterrule_rule_type"),
        ("documents", "1035_rename_comment_note"),
        ("documents", "1036_alter_savedviewfilterrule_rule_type"),
    ]

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("django_celery_results", "0011_taskresult_periodic_task_name"),
        ("documents", "1021_webp_thumbnail_conversion"),
    ]

    operations = [
        migrations.CreateModel(
            name="Comment",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "comment",
                    models.TextField(
                        blank=True,
                        help_text="Comment for the document",
                        verbose_name="content",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        db_index=True,
                        default=django.utils.timezone.now,
                        verbose_name="created",
                    ),
                ),
                (
                    "document",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="documents",
                        to="documents.document",
                        verbose_name="document",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="users",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="user",
                    ),
                ),
            ],
            options={
                "verbose_name": "comment",
                "verbose_name_plural": "comments",
                "ordering": ("created",),
            },
        ),
        migrations.AddField(
            model_name="document",
            name="original_filename",
            field=models.CharField(
                default=None,
                editable=False,
                help_text="The original name of the file when it was uploaded",
                max_length=1024,
                null=True,
                verbose_name="original filename",
            ),
        ),
        migrations.AlterField(
            model_name="savedviewfilterrule",
            name="rule_type",
            field=models.PositiveIntegerField(
                choices=[
                    (0, "title contains"),
                    (1, "content contains"),
                    (2, "ASN is"),
                    (3, "correspondent is"),
                    (4, "document type is"),
                    (5, "is in inbox"),
                    (6, "has tag"),
                    (7, "has any tag"),
                    (8, "created before"),
                    (9, "created after"),
                    (10, "created year is"),
                    (11, "created month is"),
                    (12, "created day is"),
                    (13, "added before"),
                    (14, "added after"),
                    (15, "modified before"),
                    (16, "modified after"),
                    (17, "does not have tag"),
                    (18, "does not have ASN"),
                    (19, "title or content contains"),
                    (20, "fulltext query"),
                    (21, "more like this"),
                    (22, "has tags in"),
                    (23, "ASN greater than"),
                    (24, "ASN less than"),
                    (25, "storage path is"),
                ],
                verbose_name="rule type",
            ),
        ),
        migrations.CreateModel(
            name="PaperlessTask",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("task_id", models.CharField(max_length=128)),
                ("acknowledged", models.BooleanField(default=False)),
                (
                    "attempted_task",
                    models.OneToOneField(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="attempted_task",
                        to="django_celery_results.taskresult",
                    ),
                ),
            ],
        ),
        migrations.RunSQL(
            sql="DROP TABLE IF EXISTS django_q_ormq",
            reverse_sql="",
        ),
        migrations.RunSQL(
            sql="DROP TABLE IF EXISTS django_q_schedule",
            reverse_sql="",
        ),
        migrations.RunSQL(
            sql="DROP TABLE IF EXISTS django_q_task",
            reverse_sql="",
        ),
        migrations.RemoveField(
            model_name="paperlesstask",
            name="attempted_task",
        ),
        migrations.AddField(
            model_name="paperlesstask",
            name="date_created",
            field=models.DateTimeField(
                default=django.utils.timezone.now,
                help_text="Datetime field when the task result was created in UTC",
                null=True,
                verbose_name="Created DateTime",
            ),
        ),
        migrations.AddField(
            model_name="paperlesstask",
            name="date_done",
            field=models.DateTimeField(
                default=None,
                help_text="Datetime field when the task was completed in UTC",
                null=True,
                verbose_name="Completed DateTime",
            ),
        ),
        migrations.AddField(
            model_name="paperlesstask",
            name="date_started",
            field=models.DateTimeField(
                default=None,
                help_text="Datetime field when the task was started in UTC",
                null=True,
                verbose_name="Started DateTime",
            ),
        ),
        migrations.AddField(
            model_name="paperlesstask",
            name="result",
            field=models.TextField(
                default=None,
                help_text="The data returned by the task",
                null=True,
                verbose_name="Result Data",
            ),
        ),
        migrations.AddField(
            model_name="paperlesstask",
            name="status",
            field=models.CharField(
                choices=[
                    ("FAILURE", "FAILURE"),
                    ("PENDING", "PENDING"),
                    ("RECEIVED", "RECEIVED"),
                    ("RETRY", "RETRY"),
                    ("REVOKED", "REVOKED"),
                    ("STARTED", "STARTED"),
                    ("SUCCESS", "SUCCESS"),
                ],
                default="PENDING",
                help_text="Current state of the task being run",
                max_length=30,
                verbose_name="Task State",
            ),
        ),
        migrations.AddField(
            model_name="paperlesstask",
            name="task_name",
            field=models.CharField(
                help_text="Name of the Task which was run",
                max_length=255,
                null=True,
                verbose_name="Task Name",
            ),
        ),
        migrations.AlterField(
            model_name="paperlesstask",
            name="acknowledged",
            field=models.BooleanField(
                default=False,
                help_text="If the task is acknowledged via the frontend or API",
                verbose_name="Acknowledged",
            ),
        ),
        migrations.AlterField(
            model_name="paperlesstask",
            name="task_id",
            field=models.CharField(
                help_text="Celery ID for the Task that was run",
                max_length=255,
                unique=True,
                verbose_name="Task ID",
            ),
        ),
        migrations.AlterField(
            model_name="document",
            name="archive_serial_number",
            field=models.PositiveIntegerField(
                blank=True,
                db_index=True,
                help_text="The position of this document in your physical document archive.",
                null=True,
                unique=True,
                validators=[
                    django.core.validators.MaxValueValidator(4294967295),
                    django.core.validators.MinValueValidator(0),
                ],
                verbose_name="archive serial number",
            ),
        ),
        migrations.AddField(
            model_name="paperlesstask",
            name="task_file_name",
            field=models.CharField(
                help_text="Name of the file which the Task was run for",
                max_length=255,
                null=True,
                verbose_name="Task Filename",
            ),
        ),
        migrations.RenameField(
            model_name="savedview",
            old_name="user",
            new_name="owner",
        ),
        migrations.AlterField(
            model_name="savedview",
            name="owner",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to=settings.AUTH_USER_MODEL,
                verbose_name="owner",
            ),
        ),
        migrations.AddField(
            model_name="correspondent",
            name="owner",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to=settings.AUTH_USER_MODEL,
                verbose_name="owner",
            ),
        ),
        migrations.AddField(
            model_name="document",
            name="owner",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to=settings.AUTH_USER_MODEL,
                verbose_name="owner",
            ),
        ),
        migrations.AddField(
            model_name="documenttype",
            name="owner",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to=settings.AUTH_USER_MODEL,
                verbose_name="owner",
            ),
        ),
        migrations.AddField(
            model_name="storagepath",
            name="owner",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to=settings.AUTH_USER_MODEL,
                verbose_name="owner",
            ),
        ),
        migrations.AddField(
            model_name="tag",
            name="owner",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to=settings.AUTH_USER_MODEL,
                verbose_name="owner",
            ),
        ),
        migrations.AlterField(
            model_name="correspondent",
            name="matching_algorithm",
            field=models.PositiveIntegerField(
                choices=[
                    (0, "None"),
                    (1, "Any word"),
                    (2, "All words"),
                    (3, "Exact match"),
                    (4, "Regular expression"),
                    (5, "Fuzzy word"),
                    (6, "Automatic"),
                ],
                default=1,
                verbose_name="matching algorithm",
            ),
        ),
        migrations.AlterField(
            model_name="documenttype",
            name="matching_algorithm",
            field=models.PositiveIntegerField(
                choices=[
                    (0, "None"),
                    (1, "Any word"),
                    (2, "All words"),
                    (3, "Exact match"),
                    (4, "Regular expression"),
                    (5, "Fuzzy word"),
                    (6, "Automatic"),
                ],
                default=1,
                verbose_name="matching algorithm",
            ),
        ),
        migrations.AlterField(
            model_name="storagepath",
            name="matching_algorithm",
            field=models.PositiveIntegerField(
                choices=[
                    (0, "None"),
                    (1, "Any word"),
                    (2, "All words"),
                    (3, "Exact match"),
                    (4, "Regular expression"),
                    (5, "Fuzzy word"),
                    (6, "Automatic"),
                ],
                default=1,
                verbose_name="matching algorithm",
            ),
        ),
        migrations.AlterField(
            model_name="tag",
            name="matching_algorithm",
            field=models.PositiveIntegerField(
                choices=[
                    (0, "None"),
                    (1, "Any word"),
                    (2, "All words"),
                    (3, "Exact match"),
                    (4, "Regular expression"),
                    (5, "Fuzzy word"),
                    (6, "Automatic"),
                ],
                default=1,
                verbose_name="matching algorithm",
            ),
        ),
        migrations.AlterModelOptions(
            name="documenttype",
            options={
                "ordering": ("name",),
                "verbose_name": "document type",
                "verbose_name_plural": "document types",
            },
        ),
        migrations.AlterModelOptions(
            name="tag",
            options={
                "ordering": ("name",),
                "verbose_name": "tag",
                "verbose_name_plural": "tags",
            },
        ),
        migrations.AlterField(
            model_name="correspondent",
            name="name",
            field=models.CharField(max_length=128, verbose_name="name"),
        ),
        migrations.AlterField(
            model_name="documenttype",
            name="name",
            field=models.CharField(max_length=128, verbose_name="name"),
        ),
        migrations.AlterField(
            model_name="storagepath",
            name="name",
            field=models.CharField(max_length=128, verbose_name="name"),
        ),
        migrations.AlterField(
            model_name="tag",
            name="name",
            field=models.CharField(max_length=128, verbose_name="name"),
        ),
        migrations.AddConstraint(
            model_name="correspondent",
            constraint=models.UniqueConstraint(
                fields=("name", "owner"),
                name="documents_correspondent_unique_name_owner",
            ),
        ),
        migrations.AddConstraint(
            model_name="correspondent",
            constraint=models.UniqueConstraint(
                condition=models.Q(("owner__isnull", True)),
                fields=("name",),
                name="documents_correspondent_name_uniq",
            ),
        ),
        migrations.AddConstraint(
            model_name="documenttype",
            constraint=models.UniqueConstraint(
                fields=("name", "owner"),
                name="documents_documenttype_unique_name_owner",
            ),
        ),
        migrations.AddConstraint(
            model_name="documenttype",
            constraint=models.UniqueConstraint(
                condition=models.Q(("owner__isnull", True)),
                fields=("name",),
                name="documents_documenttype_name_uniq",
            ),
        ),
        migrations.AddConstraint(
            model_name="storagepath",
            constraint=models.UniqueConstraint(
                fields=("name", "owner"),
                name="documents_storagepath_unique_name_owner",
            ),
        ),
        migrations.AddConstraint(
            model_name="storagepath",
            constraint=models.UniqueConstraint(
                condition=models.Q(("owner__isnull", True)),
                fields=("name",),
                name="documents_storagepath_name_uniq",
            ),
        ),
        migrations.AddConstraint(
            model_name="tag",
            constraint=models.UniqueConstraint(
                fields=("name", "owner"),
                name="documents_tag_unique_name_owner",
            ),
        ),
        migrations.AddConstraint(
            model_name="tag",
            constraint=models.UniqueConstraint(
                condition=models.Q(("owner__isnull", True)),
                fields=("name",),
                name="documents_tag_name_uniq",
            ),
        ),
        migrations.AlterField(
            model_name="savedviewfilterrule",
            name="rule_type",
            field=models.PositiveIntegerField(
                choices=[
                    (0, "title contains"),
                    (1, "content contains"),
                    (2, "ASN is"),
                    (3, "correspondent is"),
                    (4, "document type is"),
                    (5, "is in inbox"),
                    (6, "has tag"),
                    (7, "has any tag"),
                    (8, "created before"),
                    (9, "created after"),
                    (10, "created year is"),
                    (11, "created month is"),
                    (12, "created day is"),
                    (13, "added before"),
                    (14, "added after"),
                    (15, "modified before"),
                    (16, "modified after"),
                    (17, "does not have tag"),
                    (18, "does not have ASN"),
                    (19, "title or content contains"),
                    (20, "fulltext query"),
                    (21, "more like this"),
                    (22, "has tags in"),
                    (23, "ASN greater than"),
                    (24, "ASN less than"),
                    (25, "storage path is"),
                    (26, "has correspondent in"),
                    (27, "does not have correspondent in"),
                    (28, "has document type in"),
                    (29, "does not have document type in"),
                    (30, "has storage path in"),
                    (31, "does not have storage path in"),
                ],
                verbose_name="rule type",
            ),
        ),
        migrations.RenameModel(
            old_name="Comment",
            new_name="Note",
        ),
        migrations.RenameField(
            model_name="note",
            old_name="comment",
            new_name="note",
        ),
        migrations.AlterModelOptions(
            name="note",
            options={
                "ordering": ("created",),
                "verbose_name": "note",
                "verbose_name_plural": "notes",
            },
        ),
        migrations.AlterField(
            model_name="note",
            name="document",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="notes",
                to="documents.document",
                verbose_name="document",
            ),
        ),
        migrations.AlterField(
            model_name="note",
            name="note",
            field=models.TextField(
                blank=True,
                help_text="Note for the document",
                verbose_name="content",
            ),
        ),
        migrations.AlterField(
            model_name="note",
            name="user",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="notes",
                to=settings.AUTH_USER_MODEL,
                verbose_name="user",
            ),
        ),
        migrations.AlterField(
            model_name="savedviewfilterrule",
            name="rule_type",
            field=models.PositiveIntegerField(
                choices=[
                    (0, "title contains"),
                    (1, "content contains"),
                    (2, "ASN is"),
                    (3, "correspondent is"),
                    (4, "document type is"),
                    (5, "is in inbox"),
                    (6, "has tag"),
                    (7, "has any tag"),
                    (8, "created before"),
                    (9, "created after"),
                    (10, "created year is"),
                    (11, "created month is"),
                    (12, "created day is"),
                    (13, "added before"),
                    (14, "added after"),
                    (15, "modified before"),
                    (16, "modified after"),
                    (17, "does not have tag"),
                    (18, "does not have ASN"),
                    (19, "title or content contains"),
                    (20, "fulltext query"),
                    (21, "more like this"),
                    (22, "has tags in"),
                    (23, "ASN greater than"),
                    (24, "ASN less than"),
                    (25, "storage path is"),
                    (26, "has correspondent in"),
                    (27, "does not have correspondent in"),
                    (28, "has document type in"),
                    (29, "does not have document type in"),
                    (30, "has storage path in"),
                    (31, "does not have storage path in"),
                    (32, "owner is"),
                    (33, "has owner in"),
                    (34, "does not have owner"),
                    (35, "does not have owner in"),
                ],
                verbose_name="rule type",
            ),
        ),
    ]
