# Generated by Django 2.0.8 on 2018-10-07 14:20

from django.db import migrations
from django.db import models
from django.utils.text import slugify


def re_slug_all_the_things(apps, schema_editor):
    """
    Rewrite all slug values to make sure they're actually slugs before we brand
    them as uneditable.
    """

    Tag = apps.get_model("documents", "Tag")
    Correspondent = apps.get_model("documents", "Correspondent")

    for klass in (Tag, Correspondent):
        for instance in klass.objects.all():
            klass.objects.filter(pk=instance.pk).update(slug=slugify(instance.slug))


class Migration(migrations.Migration):
    dependencies = [
        ("documents", "0021_document_storage_type"),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="tag",
            options={"ordering": ("name",)},
        ),
        migrations.AlterField(
            model_name="correspondent",
            name="slug",
            field=models.SlugField(blank=True, editable=False),
        ),
        migrations.AlterField(
            model_name="document",
            name="file_type",
            field=models.CharField(
                choices=[
                    ("pdf", "PDF"),
                    ("png", "PNG"),
                    ("jpg", "JPG"),
                    ("gif", "GIF"),
                    ("tiff", "TIFF"),
                    ("txt", "TXT"),
                    ("csv", "CSV"),
                    ("md", "MD"),
                ],
                editable=False,
                max_length=4,
            ),
        ),
        migrations.AlterField(
            model_name="tag",
            name="slug",
            field=models.SlugField(blank=True, editable=False),
        ),
        migrations.RunPython(re_slug_all_the_things, migrations.RunPython.noop),
    ]
