# Generated by Django 4.2.13 on 2024-06-28 17:57

import django.db.models.deletion
from django.conf import settings
from django.db import migrations
from django.db import models


class Migration(migrations.Migration):
    replaces = [
        ("documents", "0015_add_insensitive_to_match"),
        ("documents", "0016_auto_20170325_1558"),
        ("documents", "0017_auto_20170512_0507"),
        ("documents", "0018_auto_20170715_1712"),
    ]

    dependencies = [
        ("documents", "0014_document_checksum"),
    ]

    operations = [
        migrations.AlterField(
            model_name="document",
            name="checksum",
            field=models.CharField(
                editable=False,
                help_text="The checksum of the original document (before it was encrypted).  We use this to prevent duplicate document imports.",
                max_length=32,
                unique=True,
            ),
        ),
        migrations.AddField(
            model_name="correspondent",
            name="is_insensitive",
            field=models.BooleanField(default=True),
        ),
        migrations.AddField(
            model_name="tag",
            name="is_insensitive",
            field=models.BooleanField(default=True),
        ),
        migrations.AlterField(
            model_name="document",
            name="content",
            field=models.TextField(
                blank=True,
                db_index=("mysql" not in settings.DATABASES["default"]["ENGINE"]),
                help_text="The raw, text-only data of the document.  This field is primarily used for searching.",
            ),
        ),
        migrations.AlterField(
            model_name="correspondent",
            name="matching_algorithm",
            field=models.PositiveIntegerField(
                choices=[
                    (1, "Any"),
                    (2, "All"),
                    (3, "Literal"),
                    (4, "Regular Expression"),
                    (5, "Fuzzy Match"),
                ],
                default=1,
                help_text='Which algorithm you want to use when matching text to the OCR\'d PDF.  Here, "any" looks for any occurrence of any word provided in the PDF, while "all" requires that every word provided appear in the PDF, albeit not in the order provided.  A "literal" match means that the text you enter must appear in the PDF exactly as you\'ve entered it, and "regular expression" uses a regex to match the PDF.  (If you don\'t know what a regex is, you probably don\'t want this option.)  Finally, a "fuzzy match" looks for words or phrases that are mostly—but not exactly—the same, which can be useful for matching against documents containing imperfections that foil accurate OCR.',
            ),
        ),
        migrations.AlterField(
            model_name="tag",
            name="matching_algorithm",
            field=models.PositiveIntegerField(
                choices=[
                    (1, "Any"),
                    (2, "All"),
                    (3, "Literal"),
                    (4, "Regular Expression"),
                    (5, "Fuzzy Match"),
                ],
                default=1,
                help_text='Which algorithm you want to use when matching text to the OCR\'d PDF.  Here, "any" looks for any occurrence of any word provided in the PDF, while "all" requires that every word provided appear in the PDF, albeit not in the order provided.  A "literal" match means that the text you enter must appear in the PDF exactly as you\'ve entered it, and "regular expression" uses a regex to match the PDF.  (If you don\'t know what a regex is, you probably don\'t want this option.)  Finally, a "fuzzy match" looks for words or phrases that are mostly—but not exactly—the same, which can be useful for matching against documents containing imperfections that foil accurate OCR.',
            ),
        ),
        migrations.AlterField(
            model_name="document",
            name="correspondent",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="documents",
                to="documents.correspondent",
            ),
        ),
    ]
