import { AlbumUserRole, AssetOrder } from 'src/enum';
import { assetStub } from 'test/fixtures/asset.stub';
import { authStub } from 'test/fixtures/auth.stub';
import { userStub } from 'test/fixtures/user.stub';

export const albumStub = {
  empty: Object.freeze({
    id: 'album-1',
    albumName: 'Empty album',
    description: '',
    ownerId: authStub.admin.user.id,
    owner: userStub.admin,
    assets: [],
    albumThumbnailAsset: null,
    albumThumbnailAssetId: null,
    createdAt: new Date(),
    updatedAt: new Date(),
    deletedAt: null,
    sharedLinks: [],
    albumUsers: [],
    isActivityEnabled: true,
    order: AssetOrder.Desc,
    updateId: '42',
  }),
  sharedWithUser: Object.freeze({
    id: 'album-2',
    albumName: 'Empty album shared with user',
    description: '',
    ownerId: authStub.admin.user.id,
    owner: userStub.admin,
    assets: [],
    albumThumbnailAsset: null,
    albumThumbnailAssetId: null,
    createdAt: new Date(),
    updatedAt: new Date(),
    deletedAt: null,
    sharedLinks: [],
    albumUsers: [
      {
        user: userStub.user1,
        role: AlbumUserRole.Editor,
      },
    ],
    isActivityEnabled: true,
    order: AssetOrder.Desc,
    updateId: '42',
  }),
  sharedWithMultiple: Object.freeze({
    id: 'album-3',
    albumName: 'Empty album shared with users',
    description: '',
    ownerId: authStub.admin.user.id,
    owner: userStub.admin,
    assets: [],
    albumThumbnailAsset: null,
    albumThumbnailAssetId: null,
    createdAt: new Date(),
    updatedAt: new Date(),
    deletedAt: null,
    sharedLinks: [],
    albumUsers: [
      {
        user: userStub.user1,
        role: AlbumUserRole.Editor,
      },
      {
        user: userStub.user2,
        role: AlbumUserRole.Editor,
      },
    ],
    isActivityEnabled: true,
    order: AssetOrder.Desc,
    updateId: '42',
  }),
  sharedWithAdmin: Object.freeze({
    id: 'album-3',
    albumName: 'Empty album shared with admin',
    description: '',
    ownerId: authStub.user1.user.id,
    owner: userStub.user1,
    assets: [],
    albumThumbnailAsset: null,
    albumThumbnailAssetId: null,
    createdAt: new Date(),
    updatedAt: new Date(),
    deletedAt: null,
    sharedLinks: [],
    albumUsers: [
      {
        user: userStub.admin,
        role: AlbumUserRole.Editor,
      },
    ],
    isActivityEnabled: true,
    order: AssetOrder.Desc,
    updateId: '42',
  }),
  oneAsset: Object.freeze({
    id: 'album-4',
    albumName: 'Album with one asset',
    description: '',
    ownerId: authStub.admin.user.id,
    owner: userStub.admin,
    assets: [assetStub.image],
    albumThumbnailAsset: null,
    albumThumbnailAssetId: null,
    createdAt: new Date(),
    updatedAt: new Date(),
    deletedAt: null,
    sharedLinks: [],
    albumUsers: [],
    isActivityEnabled: true,
    order: AssetOrder.Desc,
    updateId: '42',
  }),
  twoAssets: Object.freeze({
    id: 'album-4a',
    albumName: 'Album with two assets',
    description: '',
    ownerId: authStub.admin.user.id,
    owner: userStub.admin,
    assets: [assetStub.image, assetStub.withLocation],
    albumThumbnailAsset: assetStub.image,
    albumThumbnailAssetId: assetStub.image.id,
    createdAt: new Date(),
    updatedAt: new Date(),
    deletedAt: null,
    sharedLinks: [],
    albumUsers: [],
    isActivityEnabled: true,
    order: AssetOrder.Desc,
    updateId: '42',
  }),
  emptyWithValidThumbnail: Object.freeze({
    id: 'album-5',
    albumName: 'Empty album with valid thumbnail',
    description: '',
    ownerId: authStub.admin.user.id,
    owner: userStub.admin,
    assets: [],
    albumThumbnailAsset: assetStub.image,
    albumThumbnailAssetId: assetStub.image.id,
    createdAt: new Date(),
    updatedAt: new Date(),
    deletedAt: null,
    sharedLinks: [],
    albumUsers: [],
    isActivityEnabled: true,
    order: AssetOrder.Desc,
    updateId: '42',
  }),
};
