import { Abstract, DynamicModule, ModuleMetadata, Type } from "@nestjs/common";
import { KyselyConfig } from "kysely";

//#region src/constants/kysely.constants.d.ts
declare const KYSELY_MODULE_CONNECTION_TOKEN: (namespace?: string) => string;
declare const KYSELY_MODULE_OPTIONS_TOKEN = "KyselyModuleOptionsToken";
//#endregion
//#region src/decorators/kysely.decorator.d.ts
declare const InjectKysely: (namespace?: string) => any;
//#endregion
//#region src/kysely.interfaces.d.ts
type InjectType = (string | symbol | Type<any> | Abstract<any> | (() => void))[];
interface KyselyModuleOptionsFactory {
  createKyselyModuleOptions(): Promise<KyselyConfig> | KyselyConfig;
}
interface KyselyModuleAsyncOptions extends Pick<ModuleMetadata, "imports"> {
  namespace?: string;
  inject?: InjectType;
  useClass?: Type<KyselyConfig>;
  useExisting?: Type<KyselyModuleOptionsFactory>;
  useFactory?: (...args: any[]) => Promise<KyselyConfig> | KyselyConfig;
}
interface KyselyConfigWithNamespace extends KyselyConfig {
  namespace: string;
}
//#endregion
//#region src/kysely.module.d.ts
declare class KyselyModule {
  static forRoot(config: KyselyConfig | KyselyConfigWithNamespace[]): DynamicModule;
  static forRootAsync(options: KyselyModuleAsyncOptions): DynamicModule;
}
//#endregion
export { InjectKysely, KYSELY_MODULE_CONNECTION_TOKEN, KYSELY_MODULE_OPTIONS_TOKEN, KyselyConfigWithNamespace, KyselyModule, KyselyModuleAsyncOptions, KyselyModuleOptionsFactory };
//# sourceMappingURL=index.d.cts.map