"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getProxyProviderSymbol = getProxyProviderSymbol;
/**
 * Returns a symbol under which the given proxy provider is stored in the CLS.
 */
function getProxyProviderSymbol(proxyToken) {
    if (typeof proxyToken === 'symbol')
        return proxyToken;
    if (typeof proxyToken === 'string')
        return Symbol.for(proxyToken);
    if (proxyToken.name)
        return Symbol.for(proxyToken.name);
    return Symbol.for(proxyToken.toString());
}
//# sourceMappingURL=get-proxy-provider-symbol.js.map