/**
 * Symbol for the Request object stored in the CLS context.
 *
 * Only available in the CLS if the `saveReq` option of `middleware` (`ClsMiddleware`) options
 * is set to `true` (default).
 */
export declare const CLS_REQ: unique symbol;
/**
 * Symbol for the Response object stored in the CLS context.
 *
 * Only available in the CLS if the `saveRes` option of `middleware` (`ClsMiddleware`) options
 * is set to `true` (default is `false`).
 */
export declare const CLS_RES: unique symbol;
/**
 * Symbol for the CLS ExecutionContext object stored in the CLS context.
 *
 * Only available if the `saveCtx` options of either `interceptor` (ClsInterceptor) or
 * `guard` (ClsGuard) options is set to `true` (default).
 */
export declare const CLS_CTX: unique symbol;
/**
 * Symbol for the ID of the CLS context stored in the CLS context.
 *
 * Only available in the CLS if the `generateId` option is set to `true` (default is `false`)
 *
 * Also available via `cls.getId()`
 */
export declare const CLS_ID: unique symbol;
//# sourceMappingURL=cls.constants.d.ts.map