"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClsMiddleware = void 0;
const common_1 = require("@nestjs/common");
const cls_service_manager_1 = require("../cls-service-manager");
const cls_constants_1 = require("../cls.constants");
const cls_options_1 = require("../cls.options");
const context_cls_store_map_1 = require("./utils/context-cls-store-map");
const cls_internal_constants_1 = require("../cls.internal-constants");
let ClsMiddleware = class ClsMiddleware {
    constructor(options) {
        this.use = async (req, res, next) => {
            const cls = cls_service_manager_1.ClsServiceManager.getClsService();
            const callback = async () => {
                try {
                    this.options.useEnterWith && cls.enter();
                    context_cls_store_map_1.ContextClsStoreMap.setByRaw(req, cls.get());
                    if (this.options.generateId) {
                        const id = await this.options.idGenerator?.(req);
                        cls.setIfUndefined(cls_constants_1.CLS_ID, id);
                    }
                    if (this.options.saveReq)
                        cls.set(cls_constants_1.CLS_REQ, req);
                    if (this.options.saveRes)
                        cls.set(cls_constants_1.CLS_RES, res);
                    if (this.options.setup) {
                        await this.options.setup(cls, req, res);
                    }
                    if (this.options.initializePlugins) {
                        await cls.initializePlugins();
                    }
                    if (this.options.resolveProxyProviders) {
                        await cls.resolveProxyProviders();
                    }
                    next();
                }
                catch (e) {
                    next(e);
                }
            };
            const runner = this.options.useEnterWith
                ? cls.exit.bind(cls)
                : cls.run.bind(cls);
            runner(callback);
        };
        this.options = { ...new cls_options_1.ClsMiddlewareOptions(), ...options };
    }
};
exports.ClsMiddleware = ClsMiddleware;
exports.ClsMiddleware = ClsMiddleware = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)(cls_internal_constants_1.CLS_MIDDLEWARE_OPTIONS)),
    __metadata("design:paramtypes", [Object])
], ClsMiddleware);
//# sourceMappingURL=cls.middleware.js.map