"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JSONPathLegNode = void 0;
const object_utils_js_1 = require("../util/object-utils.js");
/**
 * @internal
 */
exports.JSONPathLegNode = (0, object_utils_js_1.freeze)({
    is(node) {
        return node.kind === 'JSONPathLegNode';
    },
    create(type, value) {
        return (0, object_utils_js_1.freeze)({
            kind: 'JSONPathLegNode',
            type,
            value,
        });
    },
});
