import { DateTime, Zone, ZoneOptions } from "luxon";
import { Maybe } from "./Maybe";
import { TzSrc } from "./Timezones";
export interface TimeFormatMeta {
    fmt: string;
    zone?: Maybe<string | Zone>;
    unsetMilliseconds?: boolean;
    inferredZone?: boolean;
    extractedZone?: Maybe<TzSrc>;
}
export declare function timeFormats(args: {
    formatPrefixes?: Maybe<string[]>;
    defaultZone: Maybe<string>;
}): Iterable<TimeFormatMeta>;
export interface TimeParseResult {
    dt: DateTime;
    fmt: string;
    unsetZone: boolean;
    inferredZone: boolean;
    input: string;
    unsetMilliseconds: boolean;
}
export declare function parseDateTime(text: string, fmts: Iterable<TimeFormatMeta>): Maybe<TimeParseResult>;
export declare function setZone(args: {
    zone: string | Zone;
    src: DateTime;
    srcHasZone: boolean;
    opts?: Maybe<ZoneOptions>;
}): DateTime;
