"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseJSON = parseJSON;
const BinaryField_1 = require("./BinaryField");
const ExifDate_1 = require("./ExifDate");
const ExifDateTime_1 = require("./ExifDateTime");
const ExifTime_1 = require("./ExifTime");
const Revivers = {
    BinaryField: (ea) => BinaryField_1.BinaryField.fromJSON(ea),
    ExifDateTime: (ea) => ExifDateTime_1.ExifDateTime.fromJSON(ea),
    ExifDate: (ea) => ExifDate_1.ExifDate.fromJSON(ea),
    ExifTime: (ea) => ExifTime_1.ExifTime.fromJSON(ea),
};
/**
 * Parses a JSON string into an object, reviving the custom types defined in the Revivers map.
 *
 * - {@link BinaryField} is revived using {@link BinaryField.fromJSON}
 * - {@link ExifDateTime} is revived using {@link ExifDateTime.fromJSON}
 * - {@link ExifDate} is revived using {@link ExifDate.fromJSON}
 * - {@link ExifTime} is revived using {@link ExifTime.fromJSON}
 */
function parseJSON(s) {
    return JSON.parse(s, (_key, value) => {
        if (typeof value === "object" &&
            value !== null &&
            "_ctor" in value &&
            typeof value._ctor === "string") {
            return Revivers[value._ctor]?.(value) ?? value;
        }
        return value;
    });
}
//# sourceMappingURL=JSON.js.map