import { BatchClusterOptions, WithObserver } from "./BatchClusterOptions";
import { BatchProcessOptions } from "./BatchProcessOptions";
import { ChildProcessFactory } from "./ChildProcessFactory";
import { CombinedBatchProcessOptions } from "./CombinedBatchProcessOptions";
/**
 * Verifies and sanitizes the provided options for BatchCluster.
 *
 * It merges partial options with default BatchClusterOptions,
 * converts pass/fail strings to RegExp, and validates various constraints.
 *
 * @param opts - The partial options to verify. These are merged with default
 *   BatchClusterOptions.
 * @returns The fully verified and sanitized options.
 * @throws Error if any options are invalid.
 */
export declare function verifyOptions(opts: Partial<BatchClusterOptions> & BatchProcessOptions & ChildProcessFactory & WithObserver): CombinedBatchProcessOptions;
