import { ArgumentMetadata, FileValidator, ParseUUIDPipe } from '@nestjs/common';
import { ApiPropertyOptions } from '@nestjs/swagger';
import { ValidationOptions } from 'class-validator';
import { DateTime } from 'luxon';
export declare class ParseMeUUIDPipe extends ParseUUIDPipe {
    transform(value: string, metadata: ArgumentMetadata): Promise<string>;
}
export declare class FileNotEmptyValidator extends FileValidator {
    private requiredFields;
    constructor(requiredFields: string[]);
    isValid(files?: any): boolean;
    buildErrorMessage(): string;
}
type UUIDOptions = {
    optional?: boolean;
    each?: boolean;
    nullable?: boolean;
};
export declare const ValidateUUID: (options?: UUIDOptions & ApiPropertyOptions) => <TFunction extends Function, Y>(target: TFunction | object, propertyKey?: string | symbol, descriptor?: TypedPropertyDescriptor<Y>) => void;
export declare class UUIDParamDto {
    id: string;
}
export declare class UUIDAssetIDParamDto {
    id: string;
    assetId: string;
}
type PinCodeOptions = {
    optional?: boolean;
} & OptionalOptions;
export declare const PinCode: (options?: PinCodeOptions & ApiPropertyOptions) => <TFunction extends Function, Y>(target: TFunction | object, propertyKey?: string | symbol, descriptor?: TypedPropertyDescriptor<Y>) => void;
export interface OptionalOptions {
    nullable?: boolean;
    emptyToNull?: boolean;
}
export declare function Optional({ nullable, emptyToNull, ...validationOptions }?: OptionalOptions): <TFunction extends Function, Y>(target: TFunction | object, propertyKey?: string | symbol, descriptor?: TypedPropertyDescriptor<Y>) => void;
export declare function IsNotSiblingOf(siblings: string[], validationOptions?: ValidationOptions): PropertyDecorator;
export declare const ValidateHexColor: () => <TFunction extends Function, Y>(target: TFunction | object, propertyKey?: string | symbol, descriptor?: TypedPropertyDescriptor<Y>) => void;
type DateOptions = {
    optional?: boolean;
    nullable?: boolean;
    format?: 'date' | 'date-time';
};
export declare const ValidateDate: (options?: DateOptions & ApiPropertyOptions) => <TFunction extends Function, Y>(target: TFunction | object, propertyKey?: string | symbol, descriptor?: TypedPropertyDescriptor<Y>) => void;
type StringOptions = {
    optional?: boolean;
    nullable?: boolean;
    trim?: boolean;
};
export declare const ValidateString: (options?: StringOptions & ApiPropertyOptions) => <TFunction extends Function, Y>(target: TFunction | object, propertyKey?: string | symbol, descriptor?: TypedPropertyDescriptor<Y>) => void;
type BooleanOptions = {
    optional?: boolean;
    nullable?: boolean;
};
export declare const ValidateBoolean: (options?: BooleanOptions & ApiPropertyOptions) => <TFunction extends Function, Y>(target: TFunction | object, propertyKey?: string | symbol, descriptor?: TypedPropertyDescriptor<Y>) => void;
type EnumOptions<T> = {
    enum: T;
    name: string;
    each?: boolean;
    optional?: boolean;
    nullable?: boolean;
    default?: T[keyof T];
    description?: string;
};
export declare const ValidateEnum: <T extends object>({ name, enum: value, each, optional, nullable, default: defaultValue, description, }: EnumOptions<T>) => <TFunction extends Function, Y>(target: TFunction | object, propertyKey?: string | symbol, descriptor?: TypedPropertyDescriptor<Y>) => void;
export declare const IsCronExpression: () => PropertyDecorator;
type IValue = {
    value: unknown;
};
export declare const toEmail: ({ value }: IValue) => unknown;
export declare const toSanitized: ({ value }: IValue) => string;
export declare const isValidInteger: (value: number, options: {
    min?: number;
    max?: number;
}) => value is number;
export declare function isDateStringFormat(value: unknown, format: string): boolean;
export declare function IsDateStringFormat(format: string, validationOptions?: ValidationOptions): PropertyDecorator;
export declare function MaxDateString(date: DateTime | (() => DateTime), validationOptions?: ValidationOptions): PropertyDecorator;
type IsIPRangeOptions = {
    requireCIDR?: boolean;
};
export declare function IsIPRange(options: IsIPRangeOptions, validationOptions?: ValidationOptions): PropertyDecorator;
export {};
