"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.registerFunction = void 0;
const register_1 = require("./register");
const registerFunction = (options) => {
    const name = options.name;
    const expression = asFunctionExpression(options);
    const item = {
        name,
        expression,
        synchronize: options.synchronize ?? true,
    };
    (0, register_1.register)({ type: 'function', item });
    return item;
};
exports.registerFunction = registerFunction;
const asFunctionExpression = (options) => {
    const name = options.name;
    const sql = [
        `CREATE OR REPLACE FUNCTION ${name}(${(options.arguments || []).join(', ')})`,
        `RETURNS ${options.returnType}`,
    ];
    const flags = [
        options.parallel ? `PARALLEL ${options.parallel.toUpperCase()}` : undefined,
        options.strict ? 'STRICT' : undefined,
        options.behavior ? options.behavior.toUpperCase() : undefined,
        `LANGUAGE ${options.language ?? 'SQL'}`,
    ].filter((x) => x !== undefined);
    if (flags.length > 0) {
        sql.push(flags.join(' '));
    }
    if ('return' in options) {
        sql.push(`  RETURN ${options.return}`);
    }
    if ('body' in options) {
        const body = options.body;
        sql.push(...(body.includes('\n') ? [`AS $$`, '  ' + body.trim(), `$$;`] : [`AS $$${body}$$;`]));
    }
    return sql.join('\n  ').trim();
};
//# sourceMappingURL=register-function.js.map