"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.readParameters = void 0;
const kysely_1 = require("kysely");
const readParameters = async (ctx, db) => {
    const parameters = await db
        .selectFrom('pg_settings')
        .where('source', 'in', [kysely_1.sql.lit('database'), kysely_1.sql.lit('user')])
        .select(['name', 'setting as value', 'source as scope'])
        .execute();
    for (const parameter of parameters) {
        ctx.parameters.push({
            name: parameter.name,
            value: parameter.value,
            databaseName: ctx.databaseName,
            scope: parameter.scope,
            synchronize: true,
        });
    }
};
exports.readParameters = readParameters;
//# sourceMappingURL=parameter.reader.js.map