import { NamingItem } from 'src/sql-tools/naming/naming.interface';
import { BaseContextOptions, DatabaseEnum, DatabaseExtension, DatabaseFunction, DatabaseOverride, DatabaseParameter, DatabaseSchema, DatabaseTable } from 'src/sql-tools/types';
export declare class BaseContext {
    databaseName: string;
    schemaName: string;
    overrideTableName: string;
    tables: DatabaseTable[];
    functions: DatabaseFunction[];
    enums: DatabaseEnum[];
    extensions: DatabaseExtension[];
    parameters: DatabaseParameter[];
    overrides: DatabaseOverride[];
    warnings: string[];
    private namingStrategy;
    constructor(options: BaseContextOptions);
    getNameFor(item: NamingItem): string;
    getTableByName(name: string): DatabaseTable | undefined;
    warn(context: string, message: string): void;
    build(): DatabaseSchema;
}
