"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.compareParameters = void 0;
const types_1 = require("../types");
exports.compareParameters = {
    onMissing: (source) => [
        {
            type: 'ParameterSet',
            parameter: source,
            reason: types_1.Reason.MissingInTarget,
        },
    ],
    onExtra: (target) => [
        {
            type: 'ParameterReset',
            databaseName: target.databaseName,
            parameterName: target.name,
            reason: types_1.Reason.MissingInSource,
        },
    ],
    onCompare: () => {
        return [];
    },
};
//# sourceMappingURL=parameter.comparer.js.map