"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlbumTable = void 0;
const decorators_1 = require("../../decorators");
const enum_1 = require("../../enum");
const functions_1 = require("../functions");
const asset_table_1 = require("./asset.table");
const user_table_1 = require("./user.table");
const sql_tools_1 = require("../../sql-tools");
let AlbumTable = class AlbumTable {
    id;
    ownerId;
    albumName;
    createdAt;
    albumThumbnailAssetId;
    updatedAt;
    description;
    deletedAt;
    isActivityEnabled;
    order;
    updateId;
};
exports.AlbumTable = AlbumTable;
__decorate([
    (0, sql_tools_1.PrimaryGeneratedColumn)(),
    __metadata("design:type", Object)
], AlbumTable.prototype, "id", void 0);
__decorate([
    (0, sql_tools_1.ForeignKeyColumn)(() => user_table_1.UserTable, { onDelete: 'CASCADE', onUpdate: 'CASCADE', nullable: false }),
    __metadata("design:type", String)
], AlbumTable.prototype, "ownerId", void 0);
__decorate([
    (0, sql_tools_1.Column)({ default: 'Untitled Album' }),
    __metadata("design:type", Object)
], AlbumTable.prototype, "albumName", void 0);
__decorate([
    (0, sql_tools_1.CreateDateColumn)(),
    __metadata("design:type", Object)
], AlbumTable.prototype, "createdAt", void 0);
__decorate([
    (0, sql_tools_1.ForeignKeyColumn)(() => asset_table_1.AssetTable, {
        nullable: true,
        onDelete: 'SET NULL',
        onUpdate: 'CASCADE',
        comment: 'Asset ID to be used as thumbnail',
    }),
    __metadata("design:type", Object)
], AlbumTable.prototype, "albumThumbnailAssetId", void 0);
__decorate([
    (0, sql_tools_1.UpdateDateColumn)(),
    __metadata("design:type", Object)
], AlbumTable.prototype, "updatedAt", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'text', default: '' }),
    __metadata("design:type", Object)
], AlbumTable.prototype, "description", void 0);
__decorate([
    (0, sql_tools_1.DeleteDateColumn)(),
    __metadata("design:type", Object)
], AlbumTable.prototype, "deletedAt", void 0);
__decorate([
    (0, sql_tools_1.Column)({ type: 'boolean', default: true }),
    __metadata("design:type", Object)
], AlbumTable.prototype, "isActivityEnabled", void 0);
__decorate([
    (0, sql_tools_1.Column)({ default: enum_1.AssetOrder.Desc }),
    __metadata("design:type", Object)
], AlbumTable.prototype, "order", void 0);
__decorate([
    (0, decorators_1.UpdateIdColumn)({ index: true }),
    __metadata("design:type", Object)
], AlbumTable.prototype, "updateId", void 0);
exports.AlbumTable = AlbumTable = __decorate([
    (0, sql_tools_1.Table)({ name: 'album' }),
    (0, decorators_1.UpdatedAtTrigger)('album_updatedAt'),
    (0, sql_tools_1.AfterDeleteTrigger)({
        scope: 'statement',
        function: functions_1.album_delete_audit,
        referencingOldTableAs: 'old',
        when: 'pg_trigger_depth() = 0',
    })
], AlbumTable);
//# sourceMappingURL=album.table.js.map