"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.up = up;
exports.down = down;
const kysely_1 = require("kysely");
const database_1 = require("../../utils/database");
async function up(db) {
    await (0, kysely_1.sql) `truncate ${kysely_1.sql.table('ocr_search')}`.execute(db);
    let lastAssetId;
    while (true) {
        const rows = await db
            .selectFrom('asset_ocr')
            .select(['assetId', (0, kysely_1.sql) `string_agg(text, ' ')`.as('text')])
            .$if(lastAssetId !== undefined, (qb) => qb.where('assetId', '>', lastAssetId))
            .groupBy('assetId')
            .orderBy('assetId')
            .limit(5000)
            .execute();
        if (rows.length === 0) {
            break;
        }
        await db
            .insertInto('ocr_search')
            .values(rows.map(({ assetId, text }) => ({ assetId, text: (0, database_1.tokenizeForSearch)(text).join(' ') })))
            .execute();
        lastAssetId = rows.at(-1).assetId;
    }
}
async function down() { }
//# sourceMappingURL=1764483051488-OCRBigramsForCJK.js.map